/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import com.android.internal.telephony.uicc.IccCardApplicationStatus;

public class IccCardStatus {
    public static final int CARD_MAX_APPS = 8;
    public CardState mCardState;
    public PinState mUniversalPinState;
    public int mGsmUmtsSubscriptionAppIndex;
    public int mCdmaSubscriptionAppIndex;
    public int mImsSubscriptionAppIndex;
    public IccCardApplicationStatus[] mApplications;

    public void setCardState(int state) {
        switch (state) {
            case 0: {
                this.mCardState = CardState.CARDSTATE_ABSENT;
                break;
            }
            case 1: {
                this.mCardState = CardState.CARDSTATE_PRESENT;
                break;
            }
            case 2: {
                this.mCardState = CardState.CARDSTATE_ERROR;
                break;
            }
            case 3: {
                this.mCardState = CardState.CARDSTATE_RESTRICTED;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RIL_CardState: " + state);
            }
        }
    }

    public void setUniversalPinState(int state) {
        switch (state) {
            case 0: {
                this.mUniversalPinState = PinState.PINSTATE_UNKNOWN;
                break;
            }
            case 1: {
                this.mUniversalPinState = PinState.PINSTATE_ENABLED_NOT_VERIFIED;
                break;
            }
            case 2: {
                this.mUniversalPinState = PinState.PINSTATE_ENABLED_VERIFIED;
                break;
            }
            case 3: {
                this.mUniversalPinState = PinState.PINSTATE_DISABLED;
                break;
            }
            case 4: {
                this.mUniversalPinState = PinState.PINSTATE_ENABLED_BLOCKED;
                break;
            }
            case 5: {
                this.mUniversalPinState = PinState.PINSTATE_ENABLED_PERM_BLOCKED;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RIL_PinState: " + state);
            }
        }
    }

    public String toString() {
        IccCardApplicationStatus app;
        StringBuilder sb = new StringBuilder();
        sb.append("IccCardState {").append((Object)this.mCardState).append(",").append((Object)this.mUniversalPinState).append(",num_apps=").append(this.mApplications.length);
        sb.append(",gsm_id=").append(this.mGsmUmtsSubscriptionAppIndex);
        if (this.mApplications != null && this.mGsmUmtsSubscriptionAppIndex >= 0 && this.mGsmUmtsSubscriptionAppIndex < this.mApplications.length) {
            app = this.mApplications[this.mGsmUmtsSubscriptionAppIndex];
            sb.append(app == null ? "null" : app);
        }
        sb.append(",cdma_id=").append(this.mCdmaSubscriptionAppIndex);
        if (this.mApplications != null && this.mCdmaSubscriptionAppIndex >= 0 && this.mCdmaSubscriptionAppIndex < this.mApplications.length) {
            app = this.mApplications[this.mCdmaSubscriptionAppIndex];
            sb.append(app == null ? "null" : app);
        }
        sb.append(",ims_id=").append(this.mImsSubscriptionAppIndex);
        if (this.mApplications != null && this.mImsSubscriptionAppIndex >= 0 && this.mImsSubscriptionAppIndex < this.mApplications.length) {
            app = this.mApplications[this.mImsSubscriptionAppIndex];
            sb.append(app == null ? "null" : app);
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum PinState {
        PINSTATE_UNKNOWN,
        PINSTATE_ENABLED_NOT_VERIFIED,
        PINSTATE_ENABLED_VERIFIED,
        PINSTATE_DISABLED,
        PINSTATE_ENABLED_BLOCKED,
        PINSTATE_ENABLED_PERM_BLOCKED;


        boolean isPermBlocked() {
            return this == PINSTATE_ENABLED_PERM_BLOCKED;
        }

        boolean isPinRequired() {
            return this == PINSTATE_ENABLED_NOT_VERIFIED;
        }

        boolean isPukRequired() {
            return this == PINSTATE_ENABLED_BLOCKED;
        }
    }

    public static enum CardState {
        CARDSTATE_ABSENT,
        CARDSTATE_PRESENT,
        CARDSTATE_ERROR,
        CARDSTATE_RESTRICTED;


        boolean isCardPresent() {
            return this == CARDSTATE_PRESENT || this == CARDSTATE_RESTRICTED;
        }
    }
}

