/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccPkcs15;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class UiccCarrierPrivilegeRules
extends Handler {
    private static final String LOG_TAG = "UiccCarrierPrivilegeRules";
    private static final boolean DBG = false;
    private static final String AID = "A00000015141434C00";
    private static final int CLA = 128;
    private static final int COMMAND = 202;
    private static final int P1 = 255;
    private static final int P2 = 64;
    private static final int P2_EXTENDED_DATA = 96;
    private static final int P3 = 0;
    private static final String DATA = "";
    private static final String TAG_ALL_REF_AR_DO = "FF40";
    private static final String TAG_REF_AR_DO = "E2";
    private static final String TAG_REF_DO = "E1";
    private static final String TAG_DEVICE_APP_ID_REF_DO = "C1";
    private static final String TAG_PKG_REF_DO = "CA";
    private static final String TAG_AR_DO = "E3";
    private static final String TAG_PERM_AR_DO = "DB";
    private static final String TAG_AID_REF_DO = "4F";
    private static final String CARRIER_PRIVILEGE_AID = "FFFFFFFFFFFF";
    private static final int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 1;
    private static final int EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE = 2;
    private static final int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 3;
    private static final int EVENT_PKCS15_READ_DONE = 4;
    private static final int STATE_LOADING = 0;
    private static final int STATE_LOADED = 1;
    private static final int STATE_ERROR = 2;
    private static final int MAX_RETRY = 1;
    private static final int RETRY_INTERVAL_MS = 10000;
    private UiccCard mUiccCard;
    private UiccPkcs15 mUiccPkcs15;
    private AtomicInteger mState;
    private List<UiccAccessRule> mAccessRules;
    private String mRules;
    private Message mLoadedCallback;
    private String mStatusMessage;
    private int mChannelId;
    private int mRetryCount;
    private final Runnable mRetryRunnable = new Runnable(){

        @Override
        public void run() {
            UiccCarrierPrivilegeRules.this.openChannel();
        }
    };

    private void openChannel() {
        int p2 = 0;
        this.mUiccCard.iccOpenLogicalChannel(AID, p2, this.obtainMessage(1, null));
    }

    public UiccCarrierPrivilegeRules(UiccCard uiccCard, Message loadedCallback) {
        UiccCarrierPrivilegeRules.log("Creating UiccCarrierPrivilegeRules");
        this.mUiccCard = uiccCard;
        this.mState = new AtomicInteger(0);
        this.mStatusMessage = "Not loaded.";
        this.mLoadedCallback = loadedCallback;
        this.mRules = DATA;
        this.mAccessRules = new ArrayList<UiccAccessRule>();
        this.openChannel();
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        return this.mState.get() != 0;
    }

    public boolean hasCarrierPrivilegeRules() {
        return this.mState.get() != 0 && this.mAccessRules != null && this.mAccessRules.size() > 0;
    }

    public List<String> getPackageNames() {
        ArrayList<String> pkgNames = new ArrayList<String>();
        if (this.mAccessRules != null) {
            for (UiccAccessRule ar : this.mAccessRules) {
                if (TextUtils.isEmpty(ar.getPackageName())) continue;
                pkgNames.add(ar.getPackageName());
            }
        }
        return pkgNames;
    }

    public int getCarrierPrivilegeStatus(Signature signature, String packageName) {
        int state = this.mState.get();
        if (state == 0) {
            return -1;
        }
        if (state == 2) {
            return -2;
        }
        for (UiccAccessRule ar : this.mAccessRules) {
            int accessStatus = ar.getCarrierPrivilegeStatus(signature, packageName);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        try {
            if (!this.hasCarrierPrivilegeRules()) {
                int state = this.mState.get();
                if (state == 0) {
                    return -1;
                }
                if (state == 2) {
                    return -2;
                }
                return 0;
            }
            PackageInfo pInfo = packageManager.getPackageInfo(packageName, 32832);
            return this.getCarrierPrivilegeStatus(pInfo);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Rlog.e(LOG_TAG, "NameNotFoundException", ex);
            return 0;
        }
    }

    public int getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        int state = this.mState.get();
        if (state == 0) {
            return -1;
        }
        if (state == 2) {
            return -2;
        }
        for (UiccAccessRule ar : this.mAccessRules) {
            int accessStatus = ar.getCarrierPrivilegeStatus(packageInfo);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        String[] packages;
        for (String pkg : packages = packageManager.getPackagesForUid(Binder.getCallingUid())) {
            int accessStatus = this.getCarrierPrivilegeStatus(packageManager, pkg);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        ArrayList<String> packages = new ArrayList<String>();
        ArrayList<ResolveInfo> receivers = new ArrayList<ResolveInfo>();
        receivers.addAll(packageManager.queryBroadcastReceivers(intent, 0));
        receivers.addAll(packageManager.queryIntentContentProviders(intent, 0));
        receivers.addAll(packageManager.queryIntentActivities(intent, 0));
        receivers.addAll(packageManager.queryIntentServices(intent, 0));
        for (ResolveInfo resolveInfo : receivers) {
            String packageName = this.getPackageName(resolveInfo);
            if (packageName == null) continue;
            int status = this.getCarrierPrivilegeStatus(packageManager, packageName);
            if (status == 1) {
                packages.add(packageName);
                continue;
            }
            if (status == 0) continue;
            return null;
        }
        return packages;
    }

    private String getPackageName(ResolveInfo resolveInfo) {
        if (resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo.packageName;
        }
        if (resolveInfo.serviceInfo != null) {
            return resolveInfo.serviceInfo.packageName;
        }
        if (resolveInfo.providerInfo != null) {
            return resolveInfo.providerInfo.packageName;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                UiccCarrierPrivilegeRules.log("EVENT_OPEN_LOGICAL_CHANNEL_DONE");
                ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    this.mChannelId = ((int[])ar.result)[0];
                    this.mUiccCard.iccTransmitApduLogicalChannel(this.mChannelId, 128, 202, 255, 64, 0, "", this.obtainMessage(2, this.mChannelId));
                    break;
                }
                if (ar.exception instanceof CommandException && this.mRetryCount < 1 && ((CommandException)ar.exception).getCommandError() == CommandException.Error.MISSING_RESOURCE) {
                    ++this.mRetryCount;
                    this.removeCallbacks(this.mRetryRunnable);
                    this.postDelayed(this.mRetryRunnable, 10000L);
                    break;
                }
                UiccCarrierPrivilegeRules.log("No ARA, try ARF next.");
                this.mUiccPkcs15 = new UiccPkcs15(this.mUiccCard, this.obtainMessage(4));
                break;
            }
            case 2: {
                UiccCarrierPrivilegeRules.log("EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE");
                ar = (AsyncResult)msg.obj;
                if (ar.exception != null || ar.result == null) ** GOTO lbl38
                response = (IccIoResult)ar.result;
                if (response.sw1 != 144 || response.sw2 != 0 || response.payload == null || response.payload.length <= 0) ** GOTO lbl35
                try {
                    this.mRules = this.mRules + IccUtils.bytesToHexString(response.payload).toUpperCase(Locale.US);
                    if (!this.isDataComplete()) ** GOTO lbl30
                    this.mAccessRules = UiccCarrierPrivilegeRules.parseRules(this.mRules);
                    this.updateState(1, "Success!");
                    ** GOTO lbl39
lbl30:
                    // 1 sources

                    this.mUiccCard.iccTransmitApduLogicalChannel(this.mChannelId, 128, 202, 255, 96, 0, "", this.obtainMessage(2, this.mChannelId));
                    break;
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                    this.updateState(2, "Error parsing rules: " + ex);
                    ** GOTO lbl39
                }
lbl35:
                // 1 sources

                errorMsg = "Invalid response: payload=" + response.payload + " sw1=" + response.sw1 + " sw2=" + response.sw2;
                this.updateState(2, errorMsg);
                ** GOTO lbl39
lbl38:
                // 1 sources

                this.updateState(2, "Error reading value from SIM.");
lbl39:
                // 4 sources

                this.mUiccCard.iccCloseLogicalChannel(this.mChannelId, this.obtainMessage(3));
                this.mChannelId = -1;
                break;
            }
            case 3: {
                UiccCarrierPrivilegeRules.log("EVENT_CLOSE_LOGICAL_CHANNEL_DONE");
                break;
            }
            case 4: {
                UiccCarrierPrivilegeRules.log("EVENT_PKCS15_READ_DONE");
                if (this.mUiccPkcs15 == null || this.mUiccPkcs15.getRules() == null) {
                    this.updateState(2, "No ARA or ARF.");
                    break;
                }
                for (String cert : this.mUiccPkcs15.getRules()) {
                    accessRule = new UiccAccessRule(IccUtils.hexStringToBytes(cert), "", 0L);
                    this.mAccessRules.add(accessRule);
                }
                this.updateState(1, "Success!");
                break;
            }
            default: {
                Rlog.e("UiccCarrierPrivilegeRules", "Unknown event " + msg.what);
            }
        }
    }

    private boolean isDataComplete() {
        UiccCarrierPrivilegeRules.log("isDataComplete mRules:" + this.mRules);
        if (this.mRules.startsWith(TAG_ALL_REF_AR_DO)) {
            TLV allRules = new TLV(TAG_ALL_REF_AR_DO);
            String lengthBytes = allRules.parseLength(this.mRules);
            UiccCarrierPrivilegeRules.log("isDataComplete lengthBytes: " + lengthBytes);
            if (this.mRules.length() == TAG_ALL_REF_AR_DO.length() + lengthBytes.length() + allRules.length) {
                UiccCarrierPrivilegeRules.log("isDataComplete yes");
                return true;
            }
            UiccCarrierPrivilegeRules.log("isDataComplete no");
            return false;
        }
        throw new IllegalArgumentException("Tags don't match.");
    }

    private static List<UiccAccessRule> parseRules(String rules) {
        UiccCarrierPrivilegeRules.log("Got rules: " + rules);
        TLV allRefArDo = new TLV(TAG_ALL_REF_AR_DO);
        allRefArDo.parse(rules, true);
        String arDos = allRefArDo.value;
        ArrayList<UiccAccessRule> accessRules = new ArrayList<UiccAccessRule>();
        while (!arDos.isEmpty()) {
            TLV refArDo = new TLV(TAG_REF_AR_DO);
            arDos = refArDo.parse(arDos, false);
            UiccAccessRule accessRule = UiccCarrierPrivilegeRules.parseRefArdo(refArDo.value);
            if (accessRule != null) {
                accessRules.add(accessRule);
                continue;
            }
            Rlog.e(LOG_TAG, "Skip unrecognized rule." + refArDo.value);
        }
        return accessRules;
    }

    private static UiccAccessRule parseRefArdo(String rule) {
        UiccCarrierPrivilegeRules.log("Got rule: " + rule);
        String certificateHash = null;
        String packageName = null;
        String tmp = null;
        long accessType = 0L;
        while (!rule.isEmpty()) {
            if (rule.startsWith(TAG_REF_DO)) {
                TLV refDo = new TLV(TAG_REF_DO);
                rule = refDo.parse(rule, false);
                TLV deviceDo = new TLV(TAG_DEVICE_APP_ID_REF_DO);
                if (refDo.value.startsWith(TAG_AID_REF_DO)) {
                    TLV cpDo = new TLV(TAG_AID_REF_DO);
                    String remain = cpDo.parse(refDo.value, false);
                    if (!cpDo.lengthBytes.equals("06") || !cpDo.value.equals(CARRIER_PRIVILEGE_AID) || remain.isEmpty() || !remain.startsWith(TAG_DEVICE_APP_ID_REF_DO)) {
                        return null;
                    }
                    tmp = deviceDo.parse(remain, false);
                    certificateHash = deviceDo.value;
                } else if (refDo.value.startsWith(TAG_DEVICE_APP_ID_REF_DO)) {
                    tmp = deviceDo.parse(refDo.value, false);
                    certificateHash = deviceDo.value;
                } else {
                    return null;
                }
                if (!tmp.isEmpty()) {
                    if (!tmp.startsWith(TAG_PKG_REF_DO)) {
                        return null;
                    }
                    TLV pkgDo = new TLV(TAG_PKG_REF_DO);
                    pkgDo.parse(tmp, true);
                    packageName = new String(IccUtils.hexStringToBytes(pkgDo.value));
                    continue;
                }
                packageName = null;
                continue;
            }
            if (rule.startsWith(TAG_AR_DO)) {
                TLV arDo = new TLV(TAG_AR_DO);
                rule = arDo.parse(rule, false);
                String remain = arDo.value;
                while (!remain.isEmpty() && !remain.startsWith(TAG_PERM_AR_DO)) {
                    TLV tmpDo = new TLV(remain.substring(0, 2));
                    remain = tmpDo.parse(remain, false);
                }
                if (remain.isEmpty()) {
                    return null;
                }
                TLV permDo = new TLV(TAG_PERM_AR_DO);
                permDo.parse(remain, true);
                continue;
            }
            throw new RuntimeException("Invalid Rule type");
        }
        UiccAccessRule accessRule = new UiccAccessRule(IccUtils.hexStringToBytes(certificateHash), packageName, accessType);
        return accessRule;
    }

    private void updateState(int newState, String statusMessage) {
        this.mState.set(newState);
        if (this.mLoadedCallback != null) {
            this.mLoadedCallback.sendToTarget();
        }
        this.mStatusMessage = statusMessage;
    }

    private static void log(String msg) {
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccCarrierPrivilegeRules: " + this);
        pw.println(" mState=" + this.getStateString(this.mState.get()));
        pw.println(" mStatusMessage='" + this.mStatusMessage + "'");
        if (this.mAccessRules != null) {
            pw.println(" mAccessRules: ");
            for (UiccAccessRule ar : this.mAccessRules) {
                pw.println("  rule='" + ar + "'");
            }
        } else {
            pw.println(" mAccessRules: null");
        }
        if (this.mUiccPkcs15 != null) {
            pw.println(" mUiccPkcs15: " + this.mUiccPkcs15);
            this.mUiccPkcs15.dump(fd, pw, args);
        } else {
            pw.println(" mUiccPkcs15: null");
        }
        pw.flush();
    }

    private String getStateString(int state) {
        switch (state) {
            case 0: {
                return "STATE_LOADING";
            }
            case 1: {
                return "STATE_LOADED";
            }
            case 2: {
                return "STATE_ERROR";
            }
        }
        return "UNKNOWN";
    }

    public static class TLV {
        private static final int SINGLE_BYTE_MAX_LENGTH = 128;
        private String tag;
        private String lengthBytes;
        private Integer length;
        private String value;

        public TLV(String tag) {
            this.tag = tag;
        }

        public String getValue() {
            if (this.value == null) {
                return UiccCarrierPrivilegeRules.DATA;
            }
            return this.value;
        }

        public String parseLength(String data) {
            int offset = this.tag.length();
            int firstByte = Integer.parseInt(data.substring(offset, offset + 2), 16);
            if (firstByte < 128) {
                this.length = firstByte * 2;
                this.lengthBytes = data.substring(offset, offset + 2);
            } else {
                int numBytes = firstByte - 128;
                this.length = Integer.parseInt(data.substring(offset + 2, offset + 2 + numBytes * 2), 16) * 2;
                this.lengthBytes = data.substring(offset, offset + 2 + numBytes * 2);
            }
            UiccCarrierPrivilegeRules.log("TLV parseLength length=" + this.length + "lenghtBytes: " + this.lengthBytes);
            return this.lengthBytes;
        }

        public String parse(String data, boolean shouldConsumeAll) {
            UiccCarrierPrivilegeRules.log("Parse TLV: " + this.tag);
            if (!data.startsWith(this.tag)) {
                throw new IllegalArgumentException("Tags don't match.");
            }
            int index = this.tag.length();
            if (index + 2 > data.length()) {
                throw new IllegalArgumentException("No length.");
            }
            this.parseLength(data);
            UiccCarrierPrivilegeRules.log("index=" + (index += this.lengthBytes.length()) + " length=" + this.length + "data.length=" + data.length());
            int remainingLength = data.length() - (index + this.length);
            if (remainingLength < 0) {
                throw new IllegalArgumentException("Not enough data.");
            }
            if (shouldConsumeAll && remainingLength != 0) {
                throw new IllegalArgumentException("Did not consume all.");
            }
            this.value = data.substring(index, index + this.length);
            UiccCarrierPrivilegeRules.log("Got TLV: " + this.tag + "," + this.length + "," + this.value);
            return data.substring(index + this.length);
        }
    }
}

