/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.util;

import android.app.NotificationChannel;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.util.NotificationChannelController;

public class VoicemailNotificationSettingsUtil {
    private static final String VOICEMAIL_NOTIFICATION_RINGTONE_SHARED_PREFS_KEY_PREFIX = "voicemail_notification_ringtone_";
    private static final String VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY_PREFIX = "voicemail_notification_vibrate_";
    private static final String OLD_VOICEMAIL_NOTIFICATION_RINGTONE_SHARED_PREFS_KEY = "button_voicemail_notification_ringtone_key";
    private static final String OLD_VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY = "button_voicemail_notification_vibrate_key";
    private static final String OLD_VOICEMAIL_VIBRATE_WHEN_SHARED_PREFS_KEY = "button_voicemail_notification_vibrate_when_key";
    private static final String OLD_VOICEMAIL_RINGTONE_SHARED_PREFS_KEY = "button_voicemail_notification_ringtone_key";
    private static final String OLD_VOICEMAIL_VIBRATION_ALWAYS = "always";
    private static final String OLD_VOICEMAIL_VIBRATION_NEVER = "never";

    public static void setVibrationEnabled(Context context, boolean isEnabled) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(VoicemailNotificationSettingsUtil.getVoicemailVibrationSharedPrefsKey(), isEnabled);
        editor.commit();
    }

    public static boolean isVibrationEnabled(Context context) {
        NotificationChannel channel = NotificationChannelController.getChannel("voiceMail", context);
        return channel != null ? channel.shouldVibrate() : VoicemailNotificationSettingsUtil.getVibrationPreference(context);
    }

    public static boolean getVibrationPreference(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        VoicemailNotificationSettingsUtil.migrateVoicemailVibrationSettingsIfNeeded(context, prefs);
        return prefs.getBoolean(VoicemailNotificationSettingsUtil.getVoicemailVibrationSharedPrefsKey(), false);
    }

    public static void setRingtoneUri(Context context, Uri ringtoneUri) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        String ringtoneUriStr = ringtoneUri != null ? ringtoneUri.toString() : "";
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(VoicemailNotificationSettingsUtil.getVoicemailRingtoneSharedPrefsKey(), ringtoneUriStr);
        editor.commit();
    }

    public static Uri getRingtoneUri(Context context) {
        NotificationChannel channel = NotificationChannelController.getChannel("voiceMail", context);
        return channel != null ? channel.getSound() : VoicemailNotificationSettingsUtil.getRingTonePreference(context);
    }

    public static Uri getRingTonePreference(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        VoicemailNotificationSettingsUtil.migrateVoicemailRingtoneSettingsIfNeeded(context, prefs);
        String uriString = prefs.getString(VoicemailNotificationSettingsUtil.getVoicemailRingtoneSharedPrefsKey(), Settings.System.DEFAULT_NOTIFICATION_URI.toString());
        return !TextUtils.isEmpty(uriString) ? Uri.parse(uriString) : null;
    }

    private static void migrateVoicemailVibrationSettingsIfNeeded(Context context, SharedPreferences prefs) {
        String key = VoicemailNotificationSettingsUtil.getVoicemailVibrationSharedPrefsKey();
        TelephonyManager telephonyManager = TelephonyManager.from(context);
        if (prefs.contains(key) || telephonyManager.getPhoneCount() != 1) {
            return;
        }
        if (prefs.contains(OLD_VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY)) {
            boolean voicemailVibrate = prefs.getBoolean(OLD_VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY, false);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putBoolean(key, voicemailVibrate).remove(OLD_VOICEMAIL_VIBRATE_WHEN_SHARED_PREFS_KEY).commit();
        }
        if (prefs.contains(OLD_VOICEMAIL_VIBRATE_WHEN_SHARED_PREFS_KEY)) {
            String vibrateWhen = prefs.getString(OLD_VOICEMAIL_VIBRATE_WHEN_SHARED_PREFS_KEY, OLD_VOICEMAIL_VIBRATION_NEVER);
            boolean voicemailVibrate = vibrateWhen.equals(OLD_VOICEMAIL_VIBRATION_ALWAYS);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putBoolean(key, voicemailVibrate).remove(OLD_VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY).commit();
        }
    }

    private static void migrateVoicemailRingtoneSettingsIfNeeded(Context context, SharedPreferences prefs) {
        String key = VoicemailNotificationSettingsUtil.getVoicemailRingtoneSharedPrefsKey();
        TelephonyManager telephonyManager = TelephonyManager.from(context);
        if (prefs.contains(key) || telephonyManager.getPhoneCount() != 1) {
            return;
        }
        if (prefs.contains("button_voicemail_notification_ringtone_key")) {
            String uriString = prefs.getString("button_voicemail_notification_ringtone_key", null);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(key, uriString).remove("button_voicemail_notification_ringtone_key").commit();
        }
    }

    private static String getVoicemailVibrationSharedPrefsKey() {
        return VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY_PREFIX + SubscriptionManager.getDefaultSubscriptionId();
    }

    private static String getVoicemailRingtoneSharedPrefsKey() {
        return VOICEMAIL_NOTIFICATION_RINGTONE_SHARED_PREFS_KEY_PREFIX + SubscriptionManager.getDefaultSubscriptionId();
    }
}

