/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.helper;

import android.graphics.Canvas;
import android.view.View;
import com.android.internal.widget.RecyclerView;
import com.android.internal.widget.helper.ItemTouchUIUtil;

class ItemTouchUIUtilImpl
implements ItemTouchUIUtil {
    ItemTouchUIUtilImpl() {
    }

    @Override
    public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Object originalElevation;
        if (isCurrentlyActive && (originalElevation = view.getTag(16908987)) == null) {
            originalElevation = Float.valueOf(view.getElevation());
            float newElevation = 1.0f + this.findMaxElevation(recyclerView, view);
            view.setElevation(newElevation);
            view.setTag(16908987, originalElevation);
        }
        view.setTranslationX(dX);
        view.setTranslationY(dY);
    }

    private float findMaxElevation(RecyclerView recyclerView, View itemView) {
        int childCount = recyclerView.getChildCount();
        float max = 0.0f;
        for (int i = 0; i < childCount; ++i) {
            float elevation;
            View child = recyclerView.getChildAt(i);
            if (child == itemView || !((elevation = child.getElevation()) > max)) continue;
            max = elevation;
        }
        return max;
    }

    @Override
    public void clearView(View view) {
        Object tag = view.getTag(16908987);
        if (tag != null && tag instanceof Float) {
            view.setElevation(((Float)tag).floatValue());
        }
        view.setTag(16908987, null);
        view.setTranslationX(0.0f);
        view.setTranslationY(0.0f);
    }

    @Override
    public void onSelected(View view) {
    }

    @Override
    public void onDrawOver(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
    }
}

