/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.EmptyArray;
import com.android.org.conscrypt.KeyManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;

public class KeyManagerFactoryImpl
extends KeyManagerFactorySpi {
    private KeyStore keyStore;
    private char[] pwd;

    @Override
    protected void engineInit(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (ks != null) {
            this.keyStore = ks;
            this.pwd = password != null ? (char[])password.clone() : EmptyArray.CHAR;
        } else {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String keyStoreName = System.getProperty("javax.net.ssl.keyStore");
            String keyStorePwd = null;
            if (keyStoreName == null || keyStoreName.equalsIgnoreCase("NONE") || keyStoreName.isEmpty()) {
                try {
                    this.keyStore.load(null, null);
                }
                catch (IOException e) {
                    throw new KeyStoreException(e);
                }
                catch (CertificateException e) {
                    throw new KeyStoreException(e);
                }
            }
            keyStorePwd = System.getProperty("javax.net.ssl.keyStorePassword");
            this.pwd = keyStorePwd == null ? EmptyArray.CHAR : keyStorePwd.toCharArray();
            try {
                this.keyStore.load(new FileInputStream(new File(keyStoreName)), this.pwd);
            }
            catch (FileNotFoundException e) {
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                throw new KeyStoreException(e);
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("ManagerFactoryParameters not supported");
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (this.keyStore == null) {
            throw new IllegalStateException("KeyManagerFactory is not initialized");
        }
        return new KeyManager[]{new KeyManagerImpl(this.keyStore, this.pwd)};
    }
}

