/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.Dialog;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Switch;
import com.android.server.am.ActivityManagerService;

public final class CompatModeDialog
extends Dialog {
    final ActivityManagerService mService;
    final ApplicationInfo mAppInfo;
    final Switch mCompatEnabled;
    final CheckBox mAlwaysShow;
    final View mHint;

    public CompatModeDialog(ActivityManagerService service, Context context, ApplicationInfo appInfo) {
        super(context, 16973936);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.getWindow().requestFeature(1);
        this.getWindow().setType(2002);
        this.getWindow().setGravity(81);
        this.mService = service;
        this.mAppInfo = appInfo;
        this.setContentView(17367091);
        this.mCompatEnabled = (Switch)this.findViewById(16908799);
        this.mCompatEnabled.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ActivityManagerService activityManagerService = CompatModeDialog.this.mService;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        CompatModeDialog.this.mService.mCompatModePackages.setPackageScreenCompatModeLocked(CompatModeDialog.this.mAppInfo.packageName, CompatModeDialog.this.mCompatEnabled.isChecked() ? 1 : 0);
                        CompatModeDialog.this.updateControls();
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                        ActivityManagerService.resetPriorityAfterLockedSection();
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
            }
        });
        this.mAlwaysShow = (CheckBox)this.findViewById(16908718);
        this.mAlwaysShow.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ActivityManagerService activityManagerService = CompatModeDialog.this.mService;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        CompatModeDialog.this.mService.mCompatModePackages.setPackageAskCompatModeLocked(CompatModeDialog.this.mAppInfo.packageName, CompatModeDialog.this.mAlwaysShow.isChecked());
                        CompatModeDialog.this.updateControls();
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                        ActivityManagerService.resetPriorityAfterLockedSection();
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
            }
        });
        this.mHint = this.findViewById(16909189);
        this.updateControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateControls() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                int mode = this.mService.mCompatModePackages.computeCompatModeLocked(this.mAppInfo);
                this.mCompatEnabled.setChecked(mode == 1);
                boolean ask = this.mService.mCompatModePackages.getPackageAskCompatModeLocked(this.mAppInfo.packageName);
                this.mAlwaysShow.setChecked(ask);
                this.mHint.setVisibility(ask ? 4 : 0);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }
}

