/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.os.Binder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.IProcessStats;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.app.procstats.ServiceState;
import com.android.internal.os.BackgroundThread;
import com.android.server.am.ActivityManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class ProcessStatsService
extends IProcessStats.Stub {
    static final String TAG = "ProcessStatsService";
    static final boolean DEBUG = false;
    static final int MAX_HISTORIC_STATES = 8;
    static final String STATE_FILE_PREFIX = "state-";
    static final String STATE_FILE_SUFFIX = ".bin";
    static final String STATE_FILE_CHECKIN_SUFFIX = ".ci";
    static long WRITE_PERIOD = 1800000L;
    final ActivityManagerService mAm;
    final File mBaseDir;
    ProcessStats mProcessStats;
    AtomicFile mFile;
    boolean mCommitPending;
    boolean mShuttingDown;
    int mLastMemOnlyState = -1;
    boolean mMemFactorLowered;
    final ReentrantLock mWriteLock = new ReentrantLock();
    final Object mPendingWriteLock = new Object();
    AtomicFile mPendingWriteFile;
    Parcel mPendingWrite;
    boolean mPendingWriteCommitted;
    long mLastWriteTime;
    @GuardedBy(value="mAm")
    Boolean mInjectedScreenState;

    public ProcessStatsService(ActivityManagerService am, File file) {
        this.mAm = am;
        this.mBaseDir = file;
        this.mBaseDir.mkdirs();
        this.mProcessStats = new ProcessStats(true);
        this.updateFile();
        SystemProperties.addChangeCallback(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ActivityManagerService activityManagerService = ProcessStatsService.this.mAm;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        if (ProcessStatsService.this.mProcessStats.evaluateSystemProperties(false)) {
                            ProcessStatsService.this.mProcessStats.mFlags |= 4;
                            ProcessStatsService.this.writeStateLocked(true, true);
                            ProcessStatsService.this.mProcessStats.evaluateSystemProperties(true);
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                        ActivityManagerService.resetPriorityAfterLockedSection();
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
            }
        });
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Process Stats Crash", e);
            }
            throw e;
        }
    }

    public ProcessState getProcessStateLocked(String packageName, int uid, int versionCode, String processName) {
        return this.mProcessStats.getProcessStateLocked(packageName, uid, versionCode, processName);
    }

    public ServiceState getServiceStateLocked(String packageName, int uid, int versionCode, String processName, String className) {
        return this.mProcessStats.getServiceStateLocked(packageName, uid, versionCode, processName, className);
    }

    public boolean isMemFactorLowered() {
        return this.mMemFactorLowered;
    }

    public boolean setMemFactorLocked(int memFactor, boolean screenOn, long now) {
        this.mMemFactorLowered = memFactor < this.mLastMemOnlyState;
        this.mLastMemOnlyState = memFactor;
        if (this.mInjectedScreenState != null) {
            screenOn = this.mInjectedScreenState;
        }
        if (screenOn) {
            memFactor += 4;
        }
        if (memFactor != this.mProcessStats.mMemFactor) {
            if (this.mProcessStats.mMemFactor != -1) {
                int n = this.mProcessStats.mMemFactor;
                this.mProcessStats.mMemFactorDurations[n] = this.mProcessStats.mMemFactorDurations[n] + (now - this.mProcessStats.mStartTime);
            }
            this.mProcessStats.mMemFactor = memFactor;
            this.mProcessStats.mStartTime = now;
            ArrayMap<String, SparseArray<SparseArray<ProcessStats.PackageState>>> pmap = this.mProcessStats.mPackages.getMap();
            for (int ipkg = pmap.size() - 1; ipkg >= 0; --ipkg) {
                SparseArray<SparseArray<ProcessStats.PackageState>> uids = pmap.valueAt(ipkg);
                for (int iuid = uids.size() - 1; iuid >= 0; --iuid) {
                    SparseArray<ProcessStats.PackageState> vers = uids.valueAt(iuid);
                    for (int iver = vers.size() - 1; iver >= 0; --iver) {
                        ProcessStats.PackageState pkg = vers.valueAt(iver);
                        ArrayMap<String, ServiceState> services = pkg.mServices;
                        for (int isvc = services.size() - 1; isvc >= 0; --isvc) {
                            ServiceState service = services.valueAt(isvc);
                            service.setMemFactor(memFactor, now);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public int getMemFactorLocked() {
        return this.mProcessStats.mMemFactor != -1 ? this.mProcessStats.mMemFactor : 0;
    }

    public void addSysMemUsageLocked(long cachedMem, long freeMem, long zramMem, long kernelMem, long nativeMem) {
        this.mProcessStats.addSysMemUsage(cachedMem, freeMem, zramMem, kernelMem, nativeMem);
    }

    public boolean shouldWriteNowLocked(long now) {
        if (now > this.mLastWriteTime + WRITE_PERIOD) {
            if (SystemClock.elapsedRealtime() > this.mProcessStats.mTimePeriodStartRealtime + ProcessStats.COMMIT_PERIOD && SystemClock.uptimeMillis() > this.mProcessStats.mTimePeriodStartUptime + ProcessStats.COMMIT_UPTIME_PERIOD) {
                this.mCommitPending = true;
            }
            return true;
        }
        return false;
    }

    public void shutdownLocked() {
        Slog.w(TAG, "Writing process stats before shutdown...");
        this.mProcessStats.mFlags |= 2;
        this.writeStateSyncLocked();
        this.mShuttingDown = true;
    }

    public void writeStateAsyncLocked() {
        this.writeStateLocked(false);
    }

    public void writeStateSyncLocked() {
        this.writeStateLocked(true);
    }

    private void writeStateLocked(boolean sync) {
        if (this.mShuttingDown) {
            return;
        }
        boolean commitPending = this.mCommitPending;
        this.mCommitPending = false;
        this.writeStateLocked(sync, commitPending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStateLocked(boolean sync, boolean commit) {
        Object object = this.mPendingWriteLock;
        synchronized (object) {
            long now = SystemClock.uptimeMillis();
            if (this.mPendingWrite == null || !this.mPendingWriteCommitted) {
                this.mPendingWrite = Parcel.obtain();
                this.mProcessStats.mTimePeriodEndRealtime = SystemClock.elapsedRealtime();
                this.mProcessStats.mTimePeriodEndUptime = now;
                if (commit) {
                    this.mProcessStats.mFlags |= 1;
                }
                this.mProcessStats.writeToParcel(this.mPendingWrite, 0);
                this.mPendingWriteFile = new AtomicFile(this.mFile.getBaseFile());
                this.mPendingWriteCommitted = commit;
            }
            if (commit) {
                this.mProcessStats.resetSafely();
                this.updateFile();
            }
            this.mLastWriteTime = SystemClock.uptimeMillis();
            if (!sync) {
                BackgroundThread.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ProcessStatsService.this.performWriteState();
                    }
                });
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl24 : MonitorExitStatement: MONITOREXIT : var3_3
            this.performWriteState();
            return;
        }
    }

    private void updateFile() {
        this.mFile = new AtomicFile(new File(this.mBaseDir, STATE_FILE_PREFIX + this.mProcessStats.mTimePeriodStartClockStr + STATE_FILE_SUFFIX));
        this.mLastWriteTime = SystemClock.uptimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performWriteState() {
        AtomicFile file;
        Parcel data;
        Object object = this.mPendingWriteLock;
        synchronized (object) {
            data = this.mPendingWrite;
            file = this.mPendingWriteFile;
            this.mPendingWriteCommitted = false;
            if (data == null) {
                return;
            }
            this.mPendingWrite = null;
            this.mPendingWriteFile = null;
            this.mWriteLock.lock();
        }
        FileOutputStream stream = null;
        try {
            stream = file.startWrite();
            stream.write(data.marshall());
            stream.flush();
            file.finishWrite(stream);
        }
        catch (IOException e) {
            Slog.w(TAG, "Error writing process statistics", e);
            file.failWrite(stream);
        }
        finally {
            data.recycle();
            this.trimHistoricStatesWriteLocked();
            this.mWriteLock.unlock();
        }
    }

    boolean readLocked(ProcessStats stats, AtomicFile file) {
        try {
            FileInputStream stream = file.openRead();
            stats.read(stream);
            stream.close();
            if (stats.mReadError != null) {
                Slog.w(TAG, "Ignoring existing stats; " + stats.mReadError);
                return false;
            }
        }
        catch (Throwable e) {
            stats.mReadError = "caught exception: " + e;
            Slog.e(TAG, "Error reading process statistics", e);
            return false;
        }
        return true;
    }

    private ArrayList<String> getCommittedFiles(int minNum, boolean inclCurrent, boolean inclCheckedIn) {
        File[] files = this.mBaseDir.listFiles();
        if (files == null || files.length <= minNum) {
            return null;
        }
        ArrayList<String> filesArray = new ArrayList<String>(files.length);
        String currentFile = this.mFile.getBaseFile().getPath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String fileStr = file.getPath();
            if (!inclCheckedIn && fileStr.endsWith(STATE_FILE_CHECKIN_SUFFIX) || !inclCurrent && fileStr.equals(currentFile)) continue;
            filesArray.add(fileStr);
        }
        Collections.sort(filesArray);
        return filesArray;
    }

    public void trimHistoricStatesWriteLocked() {
        ArrayList<String> filesArray = this.getCommittedFiles(8, false, true);
        if (filesArray == null) {
            return;
        }
        while (filesArray.size() > 8) {
            String file = filesArray.remove(0);
            Slog.i(TAG, "Pruning old procstats: " + file);
            new File(file).delete();
        }
    }

    boolean dumpFilteredProcessesCsvLocked(PrintWriter pw, String header, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now, String reqPackage) {
        ArrayList<ProcessState> procs = this.mProcessStats.collectProcessesLocked(screenStates, memStates, procStates, procStates, now, reqPackage, false);
        if (procs.size() > 0) {
            if (header != null) {
                pw.println(header);
            }
            DumpUtils.dumpProcessListCsv(pw, procs, sepScreenStates, screenStates, sepMemStates, memStates, sepProcStates, procStates, now);
            return true;
        }
        return false;
    }

    static int[] parseStateList(String[] states, int mult, String arg, boolean[] outSep, String[] outError) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int lastPos = 0;
        for (int i = 0; i <= arg.length(); ++i) {
            boolean isSep;
            char c;
            char c2 = c = i < arg.length() ? arg.charAt(i) : (char)'\u0000';
            if (c != ',' && c != '+' && c != ' ' && c != '\u0000') continue;
            boolean bl = isSep = c == ',';
            if (lastPos == 0) {
                outSep[0] = isSep;
            } else if (c != '\u0000' && outSep[0] != isSep) {
                outError[0] = "inconsistent separators (can't mix ',' with '+')";
                return null;
            }
            if (lastPos < i - 1) {
                String str = arg.substring(lastPos, i);
                for (int j = 0; j < states.length; ++j) {
                    if (!str.equals(states[j])) continue;
                    res.add(j);
                    str = null;
                    break;
                }
                if (str != null) {
                    outError[0] = "invalid word \"" + str + "\"";
                    return null;
                }
            }
            lastPos = i + 1;
        }
        int[] finalRes = new int[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            finalRes[i] = (Integer)res.get(i) * mult;
        }
        return finalRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getCurrentStats(List<ParcelFileDescriptor> historic) {
        this.mAm.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", null);
        Parcel current = Parcel.obtain();
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long now = SystemClock.uptimeMillis();
                this.mProcessStats.mTimePeriodEndRealtime = SystemClock.elapsedRealtime();
                this.mProcessStats.mTimePeriodEndUptime = now;
                this.mProcessStats.writeToParcel(current, now, 0);
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        this.mWriteLock.lock();
        try {
            ArrayList<String> files;
            if (historic != null && (files = this.getCommittedFiles(0, false, true)) != null) {
                for (int i = files.size() - 1; i >= 0; --i) {
                    try {
                        ParcelFileDescriptor pfd = ParcelFileDescriptor.open(new File(files.get(i)), 0x10000000);
                        historic.add(pfd);
                        continue;
                    }
                    catch (IOException e) {
                        Slog.w(TAG, "Failure opening procstat file " + files.get(i), e);
                    }
                }
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
        return current.marshall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getStatsOverTime(long minTime) {
        long curTime;
        this.mAm.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", null);
        Parcel current = Parcel.obtain();
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long now = SystemClock.uptimeMillis();
                this.mProcessStats.mTimePeriodEndRealtime = SystemClock.elapsedRealtime();
                this.mProcessStats.mTimePeriodEndUptime = now;
                this.mProcessStats.writeToParcel(current, now, 0);
                curTime = this.mProcessStats.mTimePeriodEndRealtime - this.mProcessStats.mTimePeriodStartRealtime;
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var4_3
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var4_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        this.mWriteLock.lock();
        try {
            ArrayList<String> files;
            if (curTime < minTime && (files = this.getCommittedFiles(0, false, true)) != null && files.size() > 0) {
                current.setDataPosition(0);
                ProcessStats stats = ProcessStats.CREATOR.createFromParcel(current);
                current.recycle();
                for (int i = files.size() - 1; i >= 0 && stats.mTimePeriodEndRealtime - stats.mTimePeriodStartRealtime < minTime; --i) {
                    AtomicFile file = new AtomicFile(new File(files.get(i)));
                    ProcessStats moreStats = new ProcessStats(false);
                    this.readLocked(moreStats, file);
                    if (moreStats.mReadError == null) {
                        stats.add(moreStats);
                        StringBuilder sb = new StringBuilder();
                        sb.append("Added stats: ");
                        sb.append(moreStats.mTimePeriodStartClockStr);
                        sb.append(", over ");
                        TimeUtils.formatDuration(moreStats.mTimePeriodEndRealtime - moreStats.mTimePeriodStartRealtime, sb);
                        Slog.i(TAG, sb.toString());
                        continue;
                    }
                    Slog.w(TAG, "Failure reading " + files.get(i + 1) + "; " + moreStats.mReadError);
                }
                current = Parcel.obtain();
                stats.writeToParcel(current, 0);
            }
            final byte[] outData = current.marshall();
            current.recycle();
            final ParcelFileDescriptor[] fds = ParcelFileDescriptor.createPipe();
            Thread thr = new Thread("ProcessStats pipe output"){

                @Override
                public void run() {
                    ParcelFileDescriptor.AutoCloseOutputStream fout = new ParcelFileDescriptor.AutoCloseOutputStream(fds[1]);
                    try {
                        fout.write(outData);
                        ((FileOutputStream)fout).close();
                    }
                    catch (IOException e) {
                        Slog.w(ProcessStatsService.TAG, "Failure writing pipe", e);
                    }
                }
            };
            thr.start();
            ParcelFileDescriptor parcelFileDescriptor = fds[0];
            return parcelFileDescriptor;
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed building output pipe", e);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentMemoryState() {
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                return this.mLastMemOnlyState;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    private void dumpAggregatedStats(PrintWriter pw, long aggregateHours, long now, String reqPackage, boolean isCompact, boolean dumpDetails, boolean dumpFullDetails, boolean dumpAll, boolean activeOnly) {
        ParcelFileDescriptor pfd = this.getStatsOverTime(aggregateHours * 60L * 60L * 1000L - ProcessStats.COMMIT_PERIOD / 2L);
        if (pfd == null) {
            pw.println("Unable to build stats!");
            return;
        }
        ProcessStats stats = new ProcessStats(false);
        ParcelFileDescriptor.AutoCloseInputStream stream = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
        stats.read(stream);
        if (stats.mReadError != null) {
            pw.print("Failure reading: ");
            pw.println(stats.mReadError);
            return;
        }
        if (isCompact) {
            stats.dumpCheckinLocked(pw, reqPackage);
        } else if (dumpDetails || dumpFullDetails) {
            stats.dumpLocked(pw, reqPackage, now, !dumpFullDetails, dumpAll, activeOnly);
        } else {
            stats.dumpSummaryLocked(pw, reqPackage, now, activeOnly);
        }
    }

    private static void dumpHelp(PrintWriter pw) {
        pw.println("Process stats (procstats) dump options:");
        pw.println("    [--checkin|-c|--csv] [--csv-screen] [--csv-proc] [--csv-mem]");
        pw.println("    [--details] [--full-details] [--current] [--hours N] [--last N]");
        pw.println("    [--max N] --active] [--commit] [--reset] [--clear] [--write] [-h]");
        pw.println("    [--start-testing] [--stop-testing] ");
        pw.println("    [--pretend-screen-on] [--pretend-screen-off] [--stop-pretend-screen]");
        pw.println("    [<package.name>]");
        pw.println("  --checkin: perform a checkin: print and delete old committed states.");
        pw.println("  -c: print only state in checkin format.");
        pw.println("  --csv: output data suitable for putting in a spreadsheet.");
        pw.println("  --csv-screen: on, off.");
        pw.println("  --csv-mem: norm, mod, low, crit.");
        pw.println("  --csv-proc: pers, top, fore, vis, precept, backup,");
        pw.println("    service, home, prev, cached");
        pw.println("  --details: dump per-package details, not just summary.");
        pw.println("  --full-details: dump all timing and active state details.");
        pw.println("  --current: only dump current state.");
        pw.println("  --hours: aggregate over about N last hours.");
        pw.println("  --last: only show the last committed stats at index N (starting at 1).");
        pw.println("  --max: for -a, max num of historical batches to print.");
        pw.println("  --active: only show currently active processes/services.");
        pw.println("  --commit: commit current stats to disk and reset to start new stats.");
        pw.println("  --reset: reset current stats, without committing.");
        pw.println("  --clear: clear all stats; does both --reset and deletes old stats.");
        pw.println("  --write: write current in-memory stats to disk.");
        pw.println("  --read: replace current stats with last-written stats.");
        pw.println("  --start-testing: clear all stats and starting high frequency pss sampling.");
        pw.println("  --stop-testing: stop high frequency pss sampling.");
        pw.println("  --pretend-screen-on: pretend screen is on.");
        pw.println("  --pretend-screen-off: pretend screen is off.");
        pw.println("  --stop-pretend-screen: forget \"pretend screen\" and use the real state.");
        pw.println("  -a: print everything.");
        pw.println("  -h: print this help text.");
        pw.println("  <package.name>: optional name of package to filter output by.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!com.android.internal.util.DumpUtils.checkDumpAndUsageStatsPermission(this.mAm.mContext, TAG, pw)) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.dumpInner(fd, pw, args);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInner(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        long now = SystemClock.uptimeMillis();
        boolean isCheckin = false;
        boolean isCompact = false;
        boolean isCsv = false;
        boolean currentOnly = false;
        boolean dumpDetails = false;
        boolean dumpFullDetails = false;
        boolean dumpAll = false;
        boolean quit = false;
        int aggregateHours = 0;
        int lastIndex = 0;
        int maxNum = 2;
        boolean activeOnly = false;
        String reqPackage = null;
        boolean csvSepScreenStats = false;
        int[] csvScreenStats = new int[]{0, 4};
        boolean csvSepMemStats = false;
        int[] csvMemStats = new int[]{3};
        boolean csvSepProcStats = true;
        int[] csvProcStats = ProcessStats.ALL_PROC_STATES;
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                ActivityManagerService e4;
                String[] error;
                boolean[] sep;
                String arg = args[i];
                if ("--checkin".equals(arg)) {
                    isCheckin = true;
                    continue;
                }
                if ("-c".equals(arg)) {
                    isCompact = true;
                    continue;
                }
                if ("--csv".equals(arg)) {
                    isCsv = true;
                    continue;
                }
                if ("--csv-screen".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("Error: argument required for --csv-screen");
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    sep = new boolean[1];
                    error = new String[1];
                    csvScreenStats = ProcessStatsService.parseStateList(DumpUtils.ADJ_SCREEN_NAMES_CSV, 4, args[i], sep, error);
                    if (csvScreenStats == null) {
                        pw.println("Error in \"" + args[i] + "\": " + error[0]);
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    csvSepScreenStats = sep[0];
                    continue;
                }
                if ("--csv-mem".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("Error: argument required for --csv-mem");
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    sep = new boolean[1];
                    error = new String[1];
                    csvMemStats = ProcessStatsService.parseStateList(DumpUtils.ADJ_MEM_NAMES_CSV, 1, args[i], sep, error);
                    if (csvMemStats == null) {
                        pw.println("Error in \"" + args[i] + "\": " + error[0]);
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    csvSepMemStats = sep[0];
                    continue;
                }
                if ("--csv-proc".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("Error: argument required for --csv-proc");
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    sep = new boolean[1];
                    error = new String[1];
                    csvProcStats = ProcessStatsService.parseStateList(DumpUtils.STATE_NAMES_CSV, 1, args[i], sep, error);
                    if (csvProcStats == null) {
                        pw.println("Error in \"" + args[i] + "\": " + error[0]);
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    csvSepProcStats = sep[0];
                    continue;
                }
                if ("--details".equals(arg)) {
                    dumpDetails = true;
                    continue;
                }
                if ("--full-details".equals(arg)) {
                    dumpFullDetails = true;
                    continue;
                }
                if ("--hours".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("Error: argument required for --hours");
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    try {
                        aggregateHours = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        pw.println("Error: --hours argument not an int -- " + args[i]);
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                }
                if ("--last".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("Error: argument required for --last");
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    try {
                        lastIndex = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e3) {
                        pw.println("Error: --last argument not an int -- " + args[i]);
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                }
                if ("--max".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("Error: argument required for --max");
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                    try {
                        maxNum = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e4) {
                        pw.println("Error: --max argument not an int -- " + args[i]);
                        ProcessStatsService.dumpHelp(pw);
                        return;
                    }
                }
                if ("--active".equals(arg)) {
                    activeOnly = true;
                    currentOnly = true;
                    continue;
                }
                if ("--current".equals(arg)) {
                    currentOnly = true;
                    continue;
                }
                if ("--commit".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mProcessStats.mFlags |= 1;
                            this.writeStateLocked(true, true);
                            pw.println("Process stats committed.");
                            quit = true;
                            // MONITOREXIT @DISABLED, blocks:[19, 3, 85, 126, 47] lbl133 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[32, 19, 85, 126, 47] lbl137 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                if ("--reset".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mProcessStats.resetSafely();
                            pw.println("Process stats reset.");
                            quit = true;
                            // MONITOREXIT @DISABLED, blocks:[84, 20, 4, 126, 47] lbl148 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[33, 84, 20, 126, 47] lbl152 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                if ("--clear".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mProcessStats.resetSafely();
                            ArrayList<String> files = this.getCommittedFiles(0, true, true);
                            if (files != null) {
                                for (int fi = 0; fi < files.size(); ++fi) {
                                    new File(files.get(fi)).delete();
                                }
                            }
                            pw.println("All process stats cleared.");
                            quit = true;
                            // MONITOREXIT @DISABLED, blocks:[83, 5, 21, 126, 47] lbl169 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[34, 83, 21, 126, 47] lbl173 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                if ("--write".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.writeStateSyncLocked();
                            pw.println("Process stats written.");
                            quit = true;
                            // MONITOREXIT @DISABLED, blocks:[81, 22, 6, 126, 47] lbl184 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[81, 35, 22, 126, 47] lbl188 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                if ("--read".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.readLocked(this.mProcessStats, this.mFile);
                            pw.println("Process stats read.");
                            quit = true;
                            // MONITOREXIT @DISABLED, blocks:[80, 23, 7, 126, 47] lbl200 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[80, 36, 23, 126, 47] lbl204 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                if ("--start-testing".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mAm.setTestPssMode(true);
                            pw.println("Started high frequency sampling.");
                            quit = true;
                            // MONITOREXIT @DISABLED, blocks:[24, 8, 126, 79, 47] lbl215 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[37, 24, 126, 79, 47] lbl219 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                if ("--stop-testing".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mAm.setTestPssMode(false);
                            pw.println("Stopped high frequency sampling.");
                            quit = true;
                            // MONITOREXIT @DISABLED, blocks:[25, 9, 126, 78, 47] lbl230 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[38, 25, 126, 78, 47] lbl234 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                if ("--pretend-screen-on".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mInjectedScreenState = true;
                            // MONITOREXIT @DISABLED, blocks:[26, 10, 125, 126, 47] lbl243 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[39, 26, 125, 126, 47] lbl247 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    quit = true;
                    continue;
                }
                if ("--pretend-screen-off".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mInjectedScreenState = false;
                            // MONITOREXIT @DISABLED, blocks:[27, 11, 124, 126, 47] lbl258 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[40, 27, 124, 126, 47] lbl262 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    quit = true;
                    continue;
                }
                if ("--stop-pretend-screen".equals(arg)) {
                    e4 = this.mAm;
                    synchronized (e4) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mInjectedScreenState = null;
                            // MONITOREXIT @DISABLED, blocks:[123, 12, 28, 126, 47] lbl273 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[41, 123, 28, 126, 47] lbl277 : MonitorExitStatement: MONITOREXIT : e
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    quit = true;
                    continue;
                }
                if ("-h".equals(arg)) {
                    ProcessStatsService.dumpHelp(pw);
                    return;
                }
                if ("-a".equals(arg)) {
                    dumpDetails = true;
                    dumpAll = true;
                    continue;
                }
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    ProcessStatsService.dumpHelp(pw);
                    return;
                }
                reqPackage = arg;
                dumpDetails = true;
            }
        }
        if (quit) {
            return;
        }
        if (isCsv) {
            pw.print("Processes running summed over");
            if (!csvSepScreenStats) {
                for (i = 0; i < csvScreenStats.length; ++i) {
                    pw.print(" ");
                    DumpUtils.printScreenLabelCsv(pw, csvScreenStats[i]);
                }
            }
            if (!csvSepMemStats) {
                for (i = 0; i < csvMemStats.length; ++i) {
                    pw.print(" ");
                    DumpUtils.printMemLabelCsv(pw, csvMemStats[i]);
                }
            }
            if (!csvSepProcStats) {
                for (i = 0; i < csvProcStats.length; ++i) {
                    pw.print(" ");
                    pw.print(DumpUtils.STATE_NAMES_CSV[csvProcStats[i]]);
                }
            }
            pw.println();
            ActivityManagerService i2 = this.mAm;
            synchronized (i2) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.dumpFilteredProcessesCsvLocked(pw, null, csvSepScreenStats, csvScreenStats, csvSepMemStats, csvMemStats, csvSepProcStats, csvProcStats, now, reqPackage);
                    // MONITOREXIT @DISABLED, blocks:[17, 122, 13] lbl322 : MonitorExitStatement: MONITOREXIT : i
                    ActivityManagerService.resetPriorityAfterLockedSection();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[17, 42, 122] lbl326 : MonitorExitStatement: MONITOREXIT : i
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            return;
        }
        if (aggregateHours != 0) {
            pw.print("AGGREGATED OVER LAST ");
            pw.print(aggregateHours);
            pw.println(" HOURS:");
            this.dumpAggregatedStats(pw, aggregateHours, now, reqPackage, isCompact, dumpDetails, dumpFullDetails, dumpAll, activeOnly);
            return;
        }
        if (lastIndex > 0) {
            pw.print("LAST STATS AT INDEX ");
            pw.print(lastIndex);
            pw.println(":");
            ArrayList<String> files = this.getCommittedFiles(0, false, true);
            if (lastIndex >= files.size()) {
                pw.print("Only have ");
                pw.print(files.size());
                pw.println(" data sets");
                return;
            }
            AtomicFile file = new AtomicFile(new File(files.get(lastIndex)));
            ProcessStats processStats = new ProcessStats(false);
            this.readLocked(processStats, file);
            if (processStats.mReadError != null) {
                if (isCheckin || isCompact) {
                    pw.print("err,");
                }
                pw.print("Failure reading ");
                pw.print(files.get(lastIndex));
                pw.print("; ");
                pw.println(processStats.mReadError);
                return;
            }
            String fileStr = file.getBaseFile().getPath();
            boolean checkedIn = fileStr.endsWith(STATE_FILE_CHECKIN_SUFFIX);
            if (isCheckin || isCompact) {
                processStats.dumpCheckinLocked(pw, reqPackage);
            } else {
                pw.print("COMMITTED STATS FROM ");
                pw.print(processStats.mTimePeriodStartClockStr);
                if (checkedIn) {
                    pw.print(" (checked in)");
                }
                pw.println(":");
                if (dumpDetails || dumpFullDetails) {
                    processStats.dumpLocked(pw, reqPackage, now, !dumpFullDetails, dumpAll, activeOnly);
                    if (dumpAll) {
                        pw.print("  mFile=");
                        pw.println(this.mFile.getBaseFile());
                    }
                } else {
                    processStats.dumpSummaryLocked(pw, reqPackage, now, activeOnly);
                }
            }
            return;
        }
        boolean sepNeeded = false;
        if (dumpAll || isCheckin) {
            this.mWriteLock.lock();
            try {
                ArrayList<String> files = this.getCommittedFiles(0, false, !isCheckin);
                if (files != null) {
                    int start;
                    int n = start = isCheckin ? 0 : files.size() - maxNum;
                    if (start < 0) {
                        start = 0;
                    }
                    for (int i3 = start; i3 < files.size(); ++i3) {
                        try {
                            AtomicFile file = new AtomicFile(new File(files.get(i3)));
                            ProcessStats processStats = new ProcessStats(false);
                            this.readLocked(processStats, file);
                            if (processStats.mReadError != null) {
                                if (isCheckin || isCompact) {
                                    pw.print("err,");
                                }
                                pw.print("Failure reading ");
                                pw.print(files.get(i3));
                                pw.print("; ");
                                pw.println(processStats.mReadError);
                                new File(files.get(i3)).delete();
                                continue;
                            }
                            String fileStr = file.getBaseFile().getPath();
                            boolean checkedIn = fileStr.endsWith(STATE_FILE_CHECKIN_SUFFIX);
                            if (isCheckin || isCompact) {
                                processStats.dumpCheckinLocked(pw, reqPackage);
                            } else {
                                if (sepNeeded) {
                                    pw.println();
                                } else {
                                    sepNeeded = true;
                                }
                                pw.print("COMMITTED STATS FROM ");
                                pw.print(processStats.mTimePeriodStartClockStr);
                                if (checkedIn) {
                                    pw.print(" (checked in)");
                                }
                                pw.println(":");
                                if (dumpFullDetails) {
                                    processStats.dumpLocked(pw, reqPackage, now, false, false, activeOnly);
                                } else {
                                    processStats.dumpSummaryLocked(pw, reqPackage, now, activeOnly);
                                }
                            }
                            if (!isCheckin) continue;
                            file.getBaseFile().renameTo(new File(fileStr + STATE_FILE_CHECKIN_SUFFIX));
                            continue;
                        }
                        catch (Throwable e) {
                            pw.print("**** FAILURE DUMPING STATE: ");
                            pw.println(files.get(i3));
                            e.printStackTrace(pw);
                        }
                    }
                }
            }
            finally {
                this.mWriteLock.unlock();
            }
        }
        if (!isCheckin) {
            ActivityManagerService activityManagerService = this.mAm;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (isCompact) {
                        this.mProcessStats.dumpCheckinLocked(pw, reqPackage);
                    } else {
                        if (sepNeeded) {
                            pw.println();
                        }
                        pw.println("CURRENT STATS:");
                        if (dumpDetails || dumpFullDetails) {
                            this.mProcessStats.dumpLocked(pw, reqPackage, now, !dumpFullDetails, dumpAll, activeOnly);
                            if (dumpAll) {
                                pw.print("  mFile=");
                                pw.println(this.mFile.getBaseFile());
                            }
                        } else {
                            this.mProcessStats.dumpSummaryLocked(pw, reqPackage, now, activeOnly);
                        }
                        sepNeeded = true;
                    }
                    // MONITOREXIT @DISABLED, blocks:[16, 18, 121] lbl454 : MonitorExitStatement: MONITOREXIT : var26_27
                    ActivityManagerService.resetPriorityAfterLockedSection();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[18, 121, 45] lbl458 : MonitorExitStatement: MONITOREXIT : var26_27
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            if (!currentOnly) {
                if (sepNeeded) {
                    pw.println();
                }
                pw.println("AGGREGATED OVER LAST 24 HOURS:");
                this.dumpAggregatedStats(pw, 24L, now, reqPackage, isCompact, dumpDetails, dumpFullDetails, dumpAll, activeOnly);
                pw.println();
                pw.println("AGGREGATED OVER LAST 3 HOURS:");
                this.dumpAggregatedStats(pw, 3L, now, reqPackage, isCompact, dumpDetails, dumpFullDetails, dumpAll, activeOnly);
            }
        }
    }
}

