/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.service.autofill.AutofillServiceInfo;
import android.service.autofill.FillEventHistory;
import android.service.autofill.FillResponse;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.LocalLog;
import android.util.Slog;
import android.util.SparseArray;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.HandlerCaller;
import com.android.server.autofill.Helper;
import com.android.server.autofill.RemoteFillService;
import com.android.server.autofill.Session;
import com.android.server.autofill.ui.AutoFillUI;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;

final class AutofillManagerServiceImpl {
    private static final String TAG = "AutofillManagerServiceImpl";
    private static final int MAX_SESSION_ID_CREATE_TRIES = 2048;
    private static final int MAX_ABANDONED_SESSION_MILLIS = 30000;
    static final int MSG_SERVICE_SAVE = 1;
    private final int mUserId;
    private final Context mContext;
    private final Object mLock;
    private final AutoFillUI mUi;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private RemoteCallbackList<IAutoFillManagerClient> mClients;
    private AutofillServiceInfo mInfo;
    private static final Random sRandom = new Random();
    private final LocalLog mRequestsHistory;
    private final LocalLog mUiLatencyHistory;
    private boolean mDisabled;
    @GuardedBy(value="mLock")
    private boolean mSetupComplete;
    private final HandlerCaller.Callback mHandlerCallback = msg -> {
        switch (msg.what) {
            case 1: {
                this.handleSessionSave(msg.arg1);
                break;
            }
            default: {
                Slog.w(TAG, "invalid msg on handler: " + msg);
            }
        }
    };
    private final HandlerCaller mHandlerCaller = new HandlerCaller(null, Looper.getMainLooper(), this.mHandlerCallback, true);
    @GuardedBy(value="mLock")
    private final SparseArray<Session> mSessions = new SparseArray();
    @GuardedBy(value="mLock")
    private FillEventHistory mEventHistory;
    private long mLastPrune = 0L;

    AutofillManagerServiceImpl(Context context, Object lock, LocalLog requestsHistory, LocalLog uiLatencyHistory, int userId, AutoFillUI ui, boolean disabled) {
        this.mContext = context;
        this.mLock = lock;
        this.mRequestsHistory = requestsHistory;
        this.mUiLatencyHistory = uiLatencyHistory;
        this.mUserId = userId;
        this.mUi = ui;
        this.updateLocked(disabled);
    }

    CharSequence getServiceName() {
        String packageName = this.getServicePackageName();
        if (packageName == null) {
            return null;
        }
        try {
            PackageManager pm = this.mContext.getPackageManager();
            ApplicationInfo info = pm.getApplicationInfo(packageName, 0);
            return pm.getApplicationLabel(info);
        }
        catch (Exception e) {
            Slog.e(TAG, "Could not get label for " + packageName + ": " + e);
            return packageName;
        }
    }

    String getServicePackageName() {
        ComponentName serviceComponent = this.getServiceComponentName();
        if (serviceComponent != null) {
            return serviceComponent.getPackageName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName getServiceComponentName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInfo == null) {
                return null;
            }
            return this.mInfo.getServiceInfo().getComponentName();
        }
    }

    private boolean isSetupCompletedLocked() {
        String setupComplete = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "user_setup_complete", this.mUserId);
        return "1".equals(setupComplete);
    }

    private String getComponentNameFromSettings() {
        return Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "autofill_service", this.mUserId);
    }

    void updateLocked(boolean disabled) {
        boolean wasEnabled = this.isEnabled();
        if (Helper.sVerbose) {
            Slog.v(TAG, "updateLocked(u=" + this.mUserId + "): wasEnabled=" + wasEnabled + ", mSetupComplete= " + this.mSetupComplete + ", disabled=" + disabled + ", mDisabled=" + this.mDisabled);
        }
        this.mSetupComplete = this.isSetupCompletedLocked();
        this.mDisabled = disabled;
        ComponentName serviceComponent = null;
        ServiceInfo serviceInfo = null;
        String componentName = this.getComponentNameFromSettings();
        if (!TextUtils.isEmpty(componentName)) {
            try {
                serviceComponent = ComponentName.unflattenFromString(componentName);
                serviceInfo = AppGlobals.getPackageManager().getServiceInfo(serviceComponent, 0, this.mUserId);
            }
            catch (RemoteException | RuntimeException e) {
                Slog.e(TAG, "Bad autofill service name " + componentName + ": " + e);
                return;
            }
        }
        try {
            boolean isEnabled;
            if (serviceInfo != null) {
                this.mInfo = new AutofillServiceInfo(this.mContext.getPackageManager(), serviceComponent, this.mUserId);
                if (Helper.sDebug) {
                    Slog.d(TAG, "Set component for user " + this.mUserId + " as " + this.mInfo);
                }
            } else {
                this.mInfo = null;
                if (Helper.sDebug) {
                    Slog.d(TAG, "Reset component for user " + this.mUserId);
                }
            }
            if (wasEnabled != (isEnabled = this.isEnabled())) {
                if (!isEnabled) {
                    int sessionCount = this.mSessions.size();
                    for (int i = sessionCount - 1; i >= 0; --i) {
                        Session session = this.mSessions.valueAt(i);
                        session.removeSelfLocked();
                    }
                }
                this.sendStateToClients(false);
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Bad AutofillService '" + componentName + "': " + e);
        }
    }

    boolean addClientLocked(IAutoFillManagerClient client) {
        if (this.mClients == null) {
            this.mClients = new RemoteCallbackList();
        }
        this.mClients.register(client);
        return this.isEnabled();
    }

    void setAuthenticationResultLocked(Bundle data, int sessionId, int authenticationId, int uid) {
        if (!this.isEnabled()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session != null && uid == session.uid) {
            session.setAuthenticationResultLocked(data, authenticationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHasCallback(int sessionId, int uid, boolean hasIt) {
        if (!this.isEnabled()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session != null && uid == session.uid) {
            Object object = this.mLock;
            synchronized (object) {
                session.setHasCallbackLocked(hasIt);
            }
        }
    }

    int startSessionLocked(IBinder activityToken, int uid, IBinder appCallbackToken, AutofillId autofillId, Rect virtualBounds, AutofillValue value, boolean hasCallback, int flags, String packageName) {
        if (!this.isEnabled()) {
            return 0;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "startSession(): token=" + activityToken + ", flags=" + flags);
        }
        this.pruneAbandonedSessionsLocked();
        Session newSession = this.createSessionByTokenLocked(activityToken, uid, appCallbackToken, hasCallback, packageName);
        if (newSession == null) {
            return Integer.MIN_VALUE;
        }
        String historyItem = "id=" + newSession.id + " uid=" + uid + " s=" + this.mInfo.getServiceInfo().packageName + " u=" + this.mUserId + " i=" + autofillId + " b=" + virtualBounds + " hc=" + hasCallback + " f=" + flags;
        this.mRequestsHistory.log(historyItem);
        newSession.updateLocked(autofillId, virtualBounds, value, 1, flags);
        return newSession.id;
    }

    private void pruneAbandonedSessionsLocked() {
        long now = System.currentTimeMillis();
        if (this.mLastPrune < now - 30000L) {
            this.mLastPrune = now;
            if (this.mSessions.size() > 0) {
                new PruneTask().execute(new Void[0]);
            }
        }
    }

    void finishSessionLocked(int sessionId, int uid) {
        if (!this.isEnabled()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session == null || uid != session.uid) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "finishSessionLocked(): no session for " + sessionId + "(" + uid + ")");
            }
            return;
        }
        boolean finished = session.showSaveLocked();
        if (Helper.sVerbose) {
            Slog.v(TAG, "finishSessionLocked(): session finished on save? " + finished);
        }
        if (finished) {
            session.removeSelfLocked();
        }
    }

    void cancelSessionLocked(int sessionId, int uid) {
        if (!this.isEnabled()) {
            return;
        }
        Session session = this.mSessions.get(sessionId);
        if (session == null || uid != session.uid) {
            Slog.w(TAG, "cancelSessionLocked(): no session for " + sessionId + "(" + uid + ")");
            return;
        }
        session.removeSelfLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableOwnedAutofillServicesLocked(int uid) {
        Slog.i(TAG, "disableOwnedServices(" + uid + "): " + this.mInfo);
        if (this.mInfo == null) {
            return;
        }
        ServiceInfo serviceInfo = this.mInfo.getServiceInfo();
        if (serviceInfo.applicationInfo.uid != uid) {
            Slog.w(TAG, "disableOwnedServices(): ignored when called by UID " + uid + " instead of " + serviceInfo.applicationInfo.uid + " for service " + this.mInfo);
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            String autoFillService = this.getComponentNameFromSettings();
            ComponentName componentName = serviceInfo.getComponentName();
            if (componentName.equals(ComponentName.unflattenFromString(autoFillService))) {
                this.mMetricsLogger.action(1135, componentName.getPackageName());
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "autofill_service", null, this.mUserId);
                this.destroySessionsLocked();
            } else {
                Slog.w(TAG, "disableOwnedServices(): ignored because current service (" + serviceInfo + ") does not match Settings (" + autoFillService + ")");
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private Session createSessionByTokenLocked(IBinder activityToken, int uid, IBinder appCallbackToken, boolean hasCallback, String packageName) {
        int sessionId;
        int tries = 0;
        do {
            if (++tries <= 2048) continue;
            Slog.w(TAG, "Cannot create session in 2048 tries");
            return null;
        } while ((sessionId = sRandom.nextInt()) == Integer.MIN_VALUE || this.mSessions.indexOfKey(sessionId) >= 0);
        Session newSession = new Session(this, this.mUi, this.mContext, this.mHandlerCaller, this.mUserId, this.mLock, sessionId, uid, activityToken, appCallbackToken, hasCallback, this.mUiLatencyHistory, this.mInfo.getServiceInfo().getComponentName(), packageName);
        this.mSessions.put(newSession.id, newSession);
        return newSession;
    }

    boolean restoreSession(int sessionId, int uid, IBinder activityToken, IBinder appCallback) {
        Session session = this.mSessions.get(sessionId);
        if (session == null || uid != session.uid) {
            return false;
        }
        session.switchActivity(activityToken, appCallback);
        return true;
    }

    boolean updateSessionLocked(int sessionId, int uid, AutofillId autofillId, Rect virtualBounds, AutofillValue value, int action, int flags) {
        Session session = this.mSessions.get(sessionId);
        if (session == null || session.uid != uid) {
            if ((flags & 1) != 0) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "restarting session " + sessionId + " due to manual request on " + autofillId);
                }
                return true;
            }
            if (Helper.sVerbose) {
                Slog.v(TAG, "updateSessionLocked(): session gone for " + sessionId + "(" + uid + ")");
            }
            return false;
        }
        session.updateLocked(autofillId, virtualBounds, value, action, flags);
        return false;
    }

    void removeSessionLocked(int sessionId) {
        this.mSessions.remove(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSessionSave(int sessionId) {
        Object object = this.mLock;
        synchronized (object) {
            Session session = this.mSessions.get(sessionId);
            if (session == null) {
                Slog.w(TAG, "handleSessionSave(): already gone: " + sessionId);
                return;
            }
            session.callSaveLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPendingSaveUi(int operation, IBinder token) {
        if (Helper.sVerbose) {
            Slog.v(TAG, "onPendingSaveUi(" + operation + "): " + token);
        }
        Object object = this.mLock;
        synchronized (object) {
            int sessionCount = this.mSessions.size();
            for (int i = sessionCount - 1; i >= 0; --i) {
                Session session = this.mSessions.valueAt(i);
                if (!session.isSaveUiPendingForTokenLocked(token)) continue;
                session.onPendingSaveUi(operation, token);
                return;
            }
        }
        if (Helper.sDebug) {
            Slog.d(TAG, "No pending Save UI for token " + token + " and operation " + DebugUtils.flagsToString(AutofillManager.class, "PENDING_UI_OPERATION_", operation));
        }
    }

    void destroyLocked() {
        int i;
        if (Helper.sVerbose) {
            Slog.v(TAG, "destroyLocked()");
        }
        int numSessions = this.mSessions.size();
        ArraySet<RemoteFillService> remoteFillServices = new ArraySet<RemoteFillService>(numSessions);
        for (i = 0; i < numSessions; ++i) {
            RemoteFillService remoteFillService = this.mSessions.valueAt(i).destroyLocked();
            if (remoteFillService == null) continue;
            remoteFillServices.add(remoteFillService);
        }
        this.mSessions.clear();
        for (i = 0; i < remoteFillServices.size(); ++i) {
            ((RemoteFillService)remoteFillServices.valueAt(i)).destroy();
        }
        this.sendStateToClients(true);
    }

    CharSequence getServiceLabel() {
        return this.mInfo.getServiceInfo().loadLabel(this.mContext.getPackageManager());
    }

    Drawable getServiceIcon() {
        return this.mInfo.getServiceInfo().loadIcon(this.mContext.getPackageManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastResponse(int serviceUid, int sessionId, FillResponse response) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEventHistory = new FillEventHistory(serviceUid, sessionId, response.getClientState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetLastResponse() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEventHistory = null;
        }
    }

    private boolean isValidEventLocked(String method, int sessionId) {
        if (this.mEventHistory == null) {
            Slog.w(TAG, method + ": not logging event because history is null");
            return false;
        }
        if (sessionId != this.mEventHistory.getSessionId()) {
            if (Helper.sDebug) {
                Slog.d(TAG, method + ": not logging event for session " + sessionId + " because tracked session is " + this.mEventHistory.getSessionId());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAuthenticationSelected(int sessionId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("setAuthenticationSelected()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(2, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logDatasetAuthenticationSelected(String selectedDataset, int sessionId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("logDatasetAuthenticationSelected()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(1, selectedDataset));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSaveShown(int sessionId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("logSaveShown()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(3, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logDatasetSelected(String selectedDataset, int sessionId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isValidEventLocked("setDatasetSelected()", sessionId)) {
                this.mEventHistory.addEvent(new FillEventHistory.Event(0, selectedDataset));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FillEventHistory getFillEventHistory(int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEventHistory != null && this.mEventHistory.getServiceUid() == callingUid) {
                return this.mEventHistory;
            }
        }
        return null;
    }

    void dumpLocked(String prefix, PrintWriter pw) {
        String prefix2 = prefix + "  ";
        pw.print(prefix);
        pw.print("User: ");
        pw.println(this.mUserId);
        pw.print(prefix);
        pw.print("Component: ");
        pw.println(this.mInfo != null ? this.mInfo.getServiceInfo().getComponentName() : null);
        pw.print(prefix);
        pw.print("Component from settings: ");
        pw.println(this.getComponentNameFromSettings());
        pw.print(prefix);
        pw.print("Default component: ");
        pw.println(this.mContext.getString(17039637));
        pw.print(prefix);
        pw.print("Disabled: ");
        pw.println(this.mDisabled);
        pw.print(prefix);
        pw.print("Setup complete: ");
        pw.println(this.mSetupComplete);
        pw.print(prefix);
        pw.print("Last prune: ");
        pw.println(this.mLastPrune);
        int size = this.mSessions.size();
        if (size == 0) {
            pw.print(prefix);
            pw.println("No sessions");
        } else {
            pw.print(prefix);
            pw.print(size);
            pw.println(" sessions:");
            for (int i = 0; i < size; ++i) {
                pw.print(prefix);
                pw.print("#");
                pw.println(i + 1);
                this.mSessions.valueAt(i).dumpLocked(prefix2, pw);
            }
        }
        if (this.mEventHistory == null || this.mEventHistory.getEvents() == null || this.mEventHistory.getEvents().size() == 0) {
            pw.print(prefix);
            pw.println("No event on last fill response");
        } else {
            pw.print(prefix);
            pw.println("Events of last fill response:");
            pw.print(prefix);
            int numEvents = this.mEventHistory.getEvents().size();
            for (int i = 0; i < numEvents; ++i) {
                FillEventHistory.Event event = this.mEventHistory.getEvents().get(i);
                pw.println("  " + i + ": eventType=" + event.getType() + " datasetId=" + event.getDatasetId());
            }
        }
    }

    void destroySessionsLocked() {
        if (this.mSessions.size() == 0) {
            this.mUi.destroyAll(null, null, false);
            return;
        }
        while (this.mSessions.size() > 0) {
            this.mSessions.valueAt(0).forceRemoveSelfLocked();
        }
    }

    void destroyFinishedSessionsLocked() {
        int sessionCount = this.mSessions.size();
        for (int i = sessionCount - 1; i >= 0; --i) {
            Session session = this.mSessions.valueAt(i);
            if (!session.isSavingLocked()) continue;
            if (Helper.sDebug) {
                Slog.d(TAG, "destroyFinishedSessionsLocked(): " + session.id);
            }
            session.forceRemoveSelfLocked();
        }
    }

    void listSessionsLocked(ArrayList<String> output) {
        int numSessions = this.mSessions.size();
        for (int i = 0; i < numSessions; ++i) {
            output.add((this.mInfo != null ? this.mInfo.getServiceInfo().getComponentName() : null) + ":" + this.mSessions.keyAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateToClients(boolean resetClient) {
        int userClientCount;
        RemoteCallbackList<IAutoFillManagerClient> clients;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClients == null) {
                return;
            }
            clients = this.mClients;
            userClientCount = clients.beginBroadcast();
        }
        try {
            for (int i = 0; i < userClientCount; ++i) {
                IAutoFillManagerClient client = clients.getBroadcastItem(i);
                try {
                    boolean resetSession;
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        resetSession = resetClient || this.isClientSessionDestroyedLocked(client);
                    }
                    client.setState(this.isEnabled(), resetSession, resetClient);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            clients.finishBroadcast();
        }
    }

    private boolean isClientSessionDestroyedLocked(IAutoFillManagerClient client) {
        int sessionCount = this.mSessions.size();
        for (int i = 0; i < sessionCount; ++i) {
            Session session = this.mSessions.valueAt(i);
            if (!session.getClient().equals(client)) continue;
            return session.isDestroyed();
        }
        return true;
    }

    boolean isEnabled() {
        return this.mSetupComplete && this.mInfo != null && !this.mDisabled;
    }

    public String toString() {
        return "AutofillManagerServiceImpl: [userId=" + this.mUserId + ", component=" + (this.mInfo != null ? this.mInfo.getServiceInfo().getComponentName() : null) + "]";
    }

    private class PruneTask
    extends AsyncTask<Void, Void, Void> {
        private PruneTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... ignored) {
            int i;
            SparseArray<IBinder> sessionsToRemove;
            int numSessionsToRemove;
            Object object = AutofillManagerServiceImpl.this.mLock;
            synchronized (object) {
                numSessionsToRemove = AutofillManagerServiceImpl.this.mSessions.size();
                sessionsToRemove = new SparseArray<IBinder>(numSessionsToRemove);
                for (i = 0; i < numSessionsToRemove; ++i) {
                    Session session = (Session)AutofillManagerServiceImpl.this.mSessions.valueAt(i);
                    sessionsToRemove.put(session.id, session.getActivityTokenLocked());
                }
            }
            IActivityManager am = ActivityManager.getService();
            for (i = 0; i < numSessionsToRemove; ++i) {
                try {
                    if (am.getActivityClassForToken((IBinder)sessionsToRemove.valueAt(i)) == null) continue;
                    sessionsToRemove.removeAt(i);
                    --i;
                    --numSessionsToRemove;
                    continue;
                }
                catch (RemoteException e) {
                    Slog.w(AutofillManagerServiceImpl.TAG, "Cannot figure out if activity is finished", e);
                }
            }
            Object object2 = AutofillManagerServiceImpl.this.mLock;
            synchronized (object2) {
                for (int i2 = 0; i2 < numSessionsToRemove; ++i2) {
                    Session sessionToRemove = (Session)AutofillManagerServiceImpl.this.mSessions.get(sessionsToRemove.keyAt(i2));
                    if (sessionToRemove == null || sessionsToRemove.valueAt(i2) != sessionToRemove.getActivityTokenLocked()) continue;
                    if (sessionToRemove.isSavingLocked()) {
                        if (!Helper.sVerbose) continue;
                        Slog.v(AutofillManagerServiceImpl.TAG, "Session " + sessionToRemove.id + " is saving");
                        continue;
                    }
                    if (Helper.sDebug) {
                        Slog.i(AutofillManagerServiceImpl.TAG, "Prune session " + sessionToRemove.id + " (" + sessionToRemove.getActivityTokenLocked() + ")");
                    }
                    sessionToRemove.removeSelfLocked();
                }
            }
            return null;
        }
    }
}

