/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.metrics.LogMaker;
import android.os.Bundle;
import android.service.autofill.Dataset;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public final class Helper {
    public static boolean sDebug = false;
    public static boolean sVerbose = false;
    static int sPartitionMaxCount = 10;

    private Helper() {
        throw new UnsupportedOperationException("contains static members only");
    }

    static void append(StringBuilder builder, Bundle bundle) {
        if (bundle == null || !sVerbose) {
            builder.append("null");
            return;
        }
        Set<String> keySet = bundle.keySet();
        builder.append("[Bundle with ").append(keySet.size()).append(" extras:");
        for (String key : keySet) {
            Object value = bundle.get(key);
            builder.append(' ').append(key).append('=');
            builder.append(value instanceof Object[] ? Arrays.toString((Objects[])value) : value);
        }
        builder.append(']');
    }

    static String bundleToString(Bundle bundle) {
        StringBuilder builder = new StringBuilder();
        Helper.append(builder, bundle);
        return builder.toString();
    }

    static AutofillId[] toArray(ArraySet<AutofillId> set) {
        if (set == null) {
            return null;
        }
        AutofillId[] array2 = new AutofillId[set.size()];
        for (int i = 0; i < set.size(); ++i) {
            array2[i] = set.valueAt(i);
        }
        return array2;
    }

    static ArrayMap<AutofillId, AutofillValue> getFields(Dataset dataset) {
        ArrayList<AutofillId> ids = dataset.getFieldIds();
        ArrayList<AutofillValue> values = dataset.getFieldValues();
        int size = ids == null ? 0 : ids.size();
        ArrayMap<AutofillId, AutofillValue> fields = new ArrayMap<AutofillId, AutofillValue>(size);
        for (int i = 0; i < size; ++i) {
            fields.put(ids.get(i), values.get(i));
        }
        return fields;
    }

    public static LogMaker newLogMaker(int category, String packageName, String servicePackageName) {
        LogMaker log = new LogMaker(category).setPackageName(packageName);
        if (servicePackageName != null) {
            log.addTaggedData(908, servicePackageName);
        }
        return log;
    }
}

