/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.SelectBackupTransportCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.backup.IBackupTransport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransportManager {
    private static final String TAG = "BackupTransportManager";
    private static final String SERVICE_ACTION_TRANSPORT_HOST = "android.backup.TRANSPORT_HOST";
    private static final long REBINDING_TIMEOUT_UNPROVISIONED_MS = 30000L;
    private static final long REBINDING_TIMEOUT_PROVISIONED_MS = 300000L;
    private static final int REBINDING_TIMEOUT_MSG = 1;
    private final Intent mTransportServiceIntent = new Intent("android.backup.TRANSPORT_HOST");
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final Set<ComponentName> mTransportWhitelist;
    private final Handler mHandler;
    private final TransportBoundListener mTransportBoundListener;
    private String mCurrentTransportName;
    private final Object mTransportLock = new Object();
    @GuardedBy(value="mTransportLock")
    private final Map<ComponentName, TransportConnection> mValidTransports = new ArrayMap<ComponentName, TransportConnection>();
    @GuardedBy(value="mTransportLock")
    private final Map<String, ComponentName> mBoundTransports = new ArrayMap<String, ComponentName>();

    TransportManager(Context context, Set<ComponentName> whitelist, String defaultTransport, TransportBoundListener listener, Looper looper) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mTransportWhitelist = whitelist != null ? whitelist : new ArraySet();
        this.mCurrentTransportName = defaultTransport;
        this.mTransportBoundListener = listener;
        this.mHandler = new RebindOnTimeoutHandler(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageAdded(String packageName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            TransportManager.log_verbose("Package added. Binding to all transports. " + packageName);
            this.bindToAllInternal(packageName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageRemoved(String packageName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            Iterator<Map.Entry<ComponentName, TransportConnection>> iter = this.mValidTransports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<ComponentName, TransportConnection> validTransport = iter.next();
                ComponentName componentName = validTransport.getKey();
                if (!componentName.getPackageName().equals(packageName)) continue;
                TransportConnection transportConnection = validTransport.getValue();
                iter.remove();
                if (transportConnection == null) continue;
                this.mContext.unbindService(transportConnection);
                TransportManager.log_verbose("Package removed, removing transport: " + componentName.flattenToShortString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageChanged(String packageName, String[] components) {
        Object object = this.mTransportLock;
        synchronized (object) {
            for (String component : components) {
                ComponentName componentName = new ComponentName(packageName, component);
                TransportConnection removed = this.mValidTransports.remove(componentName);
                if (removed == null) continue;
                this.mContext.unbindService(removed);
                TransportManager.log_verbose("Package changed. Removing transport: " + componentName.flattenToShortString());
            }
            this.bindToAllInternal(packageName, components);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBackupTransport getTransportBinder(String transportName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            ComponentName component = this.mBoundTransports.get(transportName);
            if (component == null) {
                Slog.w(TAG, "Transport " + transportName + " not bound.");
                return null;
            }
            TransportConnection conn = this.mValidTransports.get(component);
            if (conn == null) {
                Slog.w(TAG, "Transport " + transportName + " not valid.");
                return null;
            }
            return conn.getBinder();
        }
    }

    public IBackupTransport getCurrentTransportBinder() {
        return this.getTransportBinder(this.mCurrentTransportName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransportName(IBackupTransport binder) {
        Object object = this.mTransportLock;
        synchronized (object) {
            for (TransportConnection conn : this.mValidTransports.values()) {
                if (conn.getBinder() != binder) continue;
                return conn.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getBoundTransportNames() {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.mBoundTransports.keySet().toArray(new String[this.mBoundTransports.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName[] getAllTransportCompenents() {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.mValidTransports.keySet().toArray(new ComponentName[this.mValidTransports.size()]);
        }
    }

    String getCurrentTransportName() {
        return this.mCurrentTransportName;
    }

    Set<ComponentName> getTransportWhitelist() {
        return this.mTransportWhitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String selectTransport(String transport) {
        Object object = this.mTransportLock;
        synchronized (object) {
            String prevTransport = this.mCurrentTransportName;
            this.mCurrentTransportName = transport;
            return prevTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureTransportReady(ComponentName transportComponent, SelectBackupTransportCallback listener) {
        Object object = this.mTransportLock;
        synchronized (object) {
            TransportConnection conn = this.mValidTransports.get(transportComponent);
            if (conn == null) {
                listener.onFailure(-1);
                return;
            }
            conn.bindIfUnbound();
            conn.addListener(listener);
        }
    }

    void registerAllTransports() {
        this.bindToAllInternal(null, null);
    }

    private void bindToAllInternal(String packageName, String[] components) {
        List<ResolveInfo> hosts;
        PackageInfo pkgInfo = null;
        if (packageName != null) {
            try {
                pkgInfo = this.mPackageManager.getPackageInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(TAG, "Package not found: " + packageName);
                return;
            }
        }
        Intent intent = new Intent(this.mTransportServiceIntent);
        if (packageName != null) {
            intent.setPackage(packageName);
        }
        if ((hosts = this.mPackageManager.queryIntentServicesAsUser(intent, 0, 0)) != null) {
            for (ResolveInfo host : hosts) {
                ComponentName infoComponentName = host.serviceInfo.getComponentName();
                boolean shouldBind = false;
                if (components != null && packageName != null) {
                    for (String component : components) {
                        ComponentName cn = new ComponentName(pkgInfo.packageName, component);
                        if (!infoComponentName.equals(cn)) continue;
                        shouldBind = true;
                        break;
                    }
                } else {
                    shouldBind = true;
                }
                if (!shouldBind || !this.isTransportTrusted(infoComponentName)) continue;
                this.tryBindTransport(infoComponentName);
            }
        }
    }

    private boolean isTransportTrusted(ComponentName transport) {
        if (!this.mTransportWhitelist.contains(transport)) {
            Slog.w(TAG, "BackupTransport " + transport.flattenToShortString() + " not whitelisted.");
            return false;
        }
        try {
            PackageInfo packInfo = this.mPackageManager.getPackageInfo(transport.getPackageName(), 0);
            if ((packInfo.applicationInfo.privateFlags & 8) == 0) {
                Slog.w(TAG, "Transport package " + transport.getPackageName() + " not privileged");
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Package not found.", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBindTransport(ComponentName transportComponentName) {
        Slog.d(TAG, "Binding to transport: " + transportComponentName.flattenToShortString());
        TransportConnection connection = new TransportConnection(transportComponentName);
        if (this.bindToTransport(transportComponentName, connection)) {
            Object object = this.mTransportLock;
            synchronized (object) {
                this.mValidTransports.put(transportComponentName, connection);
            }
        } else {
            Slog.w(TAG, "Couldn't bind to transport " + transportComponentName);
        }
    }

    private boolean bindToTransport(ComponentName componentName, ServiceConnection connection) {
        Intent intent = new Intent(this.mTransportServiceIntent).setComponent(componentName);
        return this.mContext.bindServiceAsUser(intent, connection, 1, UserHandle.SYSTEM);
    }

    private static void log_verbose(String message) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, message);
        }
    }

    private class RebindOnTimeoutHandler
    extends Handler {
        RebindOnTimeoutHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                String componentShortString = (String)msg.obj;
                ComponentName transportComponent = ComponentName.unflattenFromString(componentShortString);
                Object object = TransportManager.this.mTransportLock;
                synchronized (object) {
                    if (TransportManager.this.mBoundTransports.containsValue(transportComponent)) {
                        Slog.d(TransportManager.TAG, "Explicit rebinding timeout passed, but already bound to " + componentShortString + " so not attempting to rebind");
                        return;
                    }
                    Slog.d(TransportManager.TAG, "Explicit rebinding timeout passed, attempting rebinding to: " + componentShortString);
                    TransportConnection conn = (TransportConnection)TransportManager.this.mValidTransports.get(transportComponent);
                    if (conn != null) {
                        TransportManager.this.mContext.unbindService(conn);
                        Slog.d(TransportManager.TAG, "Unbinding the existing (broken) connection to transport: " + componentShortString);
                    }
                }
                TransportManager.this.tryBindTransport(transportComponent);
            } else {
                Slog.e(TransportManager.TAG, "Unknown message sent to RebindOnTimeoutHandler, msg.what: " + msg.what);
            }
        }
    }

    static interface TransportBoundListener {
        public boolean onTransportBound(IBackupTransport var1);
    }

    private class TransportConnection
    implements ServiceConnection {
        private volatile IBackupTransport mBinder;
        private final List<SelectBackupTransportCallback> mListeners = new ArrayList<SelectBackupTransportCallback>();
        private volatile String mTransportName;
        private final ComponentName mTransportComponent;

        private TransportConnection(ComponentName transportComponent) {
            this.mTransportComponent = transportComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName component, IBinder binder) {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                block17: {
                    String componentShortString;
                    block15: {
                        this.mBinder = IBackupTransport.Stub.asInterface(binder);
                        boolean success = false;
                        EventLog.writeEvent(2850, component.flattenToShortString(), 1);
                        try {
                            this.mTransportName = this.mBinder.name();
                            success = TransportManager.this.mTransportBoundListener.onTransportBound(this.mBinder);
                            componentShortString = component.flattenToShortString().intern();
                            if (!success) break block15;
                        }
                        catch (RemoteException e) {
                            block19: {
                                String componentShortString2;
                                block16: {
                                    try {
                                        success = false;
                                        Slog.e(TransportManager.TAG, "Couldn't get transport name.", e);
                                        componentShortString2 = component.flattenToShortString().intern();
                                        if (!success) break block16;
                                    }
                                    catch (Throwable throwable) {
                                        String componentShortString3 = component.flattenToShortString().intern();
                                        if (success) {
                                            Slog.d(TransportManager.TAG, "Bound to transport: " + componentShortString3);
                                            TransportManager.this.mBoundTransports.put(this.mTransportName, component);
                                            for (SelectBackupTransportCallback listener : this.mListeners) {
                                                listener.onSuccess(this.mTransportName);
                                            }
                                            TransportManager.this.mHandler.removeMessages(1, componentShortString3);
                                        } else {
                                            Slog.w(TransportManager.TAG, "Bound to transport " + componentShortString3 + " but it is invalid");
                                            EventLog.writeEvent(2850, componentShortString3, 0);
                                            TransportManager.this.mContext.unbindService(this);
                                            TransportManager.this.mValidTransports.remove(component);
                                            this.mBinder = null;
                                            for (SelectBackupTransportCallback listener : this.mListeners) {
                                                listener.onFailure(-2);
                                            }
                                        }
                                        this.mListeners.clear();
                                        throw throwable;
                                    }
                                    Slog.d(TransportManager.TAG, "Bound to transport: " + componentShortString2);
                                    TransportManager.this.mBoundTransports.put(this.mTransportName, component);
                                    for (SelectBackupTransportCallback listener : this.mListeners) {
                                        listener.onSuccess(this.mTransportName);
                                    }
                                    TransportManager.this.mHandler.removeMessages(1, componentShortString2);
                                    break block19;
                                }
                                Slog.w(TransportManager.TAG, "Bound to transport " + componentShortString2 + " but it is invalid");
                                EventLog.writeEvent(2850, componentShortString2, 0);
                                TransportManager.this.mContext.unbindService(this);
                                TransportManager.this.mValidTransports.remove(component);
                                this.mBinder = null;
                                for (SelectBackupTransportCallback listener : this.mListeners) {
                                    listener.onFailure(-2);
                                }
                            }
                            this.mListeners.clear();
                        }
                        Slog.d(TransportManager.TAG, "Bound to transport: " + componentShortString);
                        TransportManager.this.mBoundTransports.put(this.mTransportName, component);
                        for (SelectBackupTransportCallback listener : this.mListeners) {
                            listener.onSuccess(this.mTransportName);
                        }
                        TransportManager.this.mHandler.removeMessages(1, componentShortString);
                        break block17;
                    }
                    Slog.w(TransportManager.TAG, "Bound to transport " + componentShortString + " but it is invalid");
                    EventLog.writeEvent(2850, componentShortString, 0);
                    TransportManager.this.mContext.unbindService(this);
                    TransportManager.this.mValidTransports.remove(component);
                    this.mBinder = null;
                    for (SelectBackupTransportCallback listener : this.mListeners) {
                        listener.onFailure(-2);
                    }
                }
                this.mListeners.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName component) {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                this.mBinder = null;
                TransportManager.this.mBoundTransports.remove(this.mTransportName);
            }
            String componentShortString = component.flattenToShortString();
            EventLog.writeEvent(2850, componentShortString, 0);
            Slog.w(TransportManager.TAG, "Disconnected from transport " + componentShortString);
            this.scheduleRebindTimeout(component);
        }

        private void scheduleRebindTimeout(ComponentName component) {
            String componentShortString = component.flattenToShortString().intern();
            long rebindTimeout = this.getRebindTimeout();
            TransportManager.this.mHandler.removeMessages(1, componentShortString);
            Message msg = TransportManager.this.mHandler.obtainMessage(1);
            msg.obj = componentShortString;
            TransportManager.this.mHandler.sendMessageDelayed(msg, rebindTimeout);
            Slog.d(TransportManager.TAG, "Scheduled explicit rebinding for " + componentShortString + " in " + rebindTimeout + "ms");
        }

        private IBackupTransport getBinder() {
            return this.mBinder;
        }

        private String getName() {
            return this.mTransportName;
        }

        private void bindIfUnbound() {
            if (this.mBinder == null) {
                Slog.d(TransportManager.TAG, "Rebinding to transport " + this.mTransportComponent.flattenToShortString());
                TransportManager.this.bindToTransport(this.mTransportComponent, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(SelectBackupTransportCallback listener) {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                if (this.mBinder == null) {
                    this.mListeners.add(listener);
                } else {
                    listener.onSuccess(this.mTransportName);
                }
            }
        }

        private long getRebindTimeout() {
            boolean isDeviceProvisioned = Settings.Global.getInt(TransportManager.this.mContext.getContentResolver(), "device_provisioned", 0) != 0;
            return isDeviceProvisioned ? 300000L : 30000L;
        }
    }
}

