/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.fullbackup;

import android.app.backup.IBackupManager;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.backup.IObbBackupService;
import com.android.server.backup.RefactoredBackupManagerService;
import com.android.server.backup.utils.FullBackupUtils;
import java.io.IOException;
import java.io.OutputStream;

public class FullBackupObbConnection
implements ServiceConnection {
    private RefactoredBackupManagerService backupManagerService;
    volatile IObbBackupService mService;

    public FullBackupObbConnection(RefactoredBackupManagerService backupManagerService) {
        this.backupManagerService = backupManagerService;
        this.mService = null;
    }

    public void establish() {
        Intent obbIntent = new Intent().setComponent(new ComponentName("com.android.sharedstoragebackup", "com.android.sharedstoragebackup.ObbBackupService"));
        this.backupManagerService.getContext().bindServiceAsUser(obbIntent, this, 1, UserHandle.SYSTEM);
    }

    public void tearDown() {
        this.backupManagerService.getContext().unbindService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backupObbs(PackageInfo pkg, OutputStream out) {
        boolean success = false;
        this.waitForConnection();
        ParcelFileDescriptor[] pipes = null;
        try {
            pipes = ParcelFileDescriptor.createPipe();
            int token = this.backupManagerService.generateRandomIntegerToken();
            this.backupManagerService.prepareOperationTimeout(token, 300000L, null, 0);
            this.mService.backupObbs(pkg.packageName, pipes[1], token, this.backupManagerService.getBackupManagerBinder());
            FullBackupUtils.routeSocketDataToOutput(pipes[0], out);
            success = this.backupManagerService.waitUntilOperationComplete(token);
        }
        catch (Exception e) {
            Slog.w("BackupManagerService", "Unable to back up OBBs for " + pkg, e);
        }
        finally {
            try {
                out.flush();
                if (pipes != null) {
                    if (pipes[0] != null) {
                        pipes[0].close();
                    }
                    if (pipes[1] != null) {
                        pipes[1].close();
                    }
                }
            }
            catch (IOException e) {
                Slog.w("BackupManagerService", "I/O error closing down OBB backup", e);
            }
        }
        return success;
    }

    public void restoreObbFile(String pkgName, ParcelFileDescriptor data, long fileSize, int type, String path, long mode, long mtime, int token, IBackupManager callbackBinder) {
        this.waitForConnection();
        try {
            this.mService.restoreObbFile(pkgName, data, fileSize, type, path, mode, mtime, token, callbackBinder);
        }
        catch (Exception e) {
            Slog.w("BackupManagerService", "Unable to restore OBBs for " + pkgName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnection() {
        FullBackupObbConnection fullBackupObbConnection = this;
        synchronized (fullBackupObbConnection) {
            while (this.mService == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        FullBackupObbConnection fullBackupObbConnection = this;
        synchronized (fullBackupObbConnection) {
            this.mService = IObbBackupService.Stub.asInterface(service);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName name) {
        FullBackupObbConnection fullBackupObbConnection = this;
        synchronized (fullBackupObbConnection) {
            this.mService = null;
            this.notifyAll();
        }
    }
}

