/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.app.IBackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.WorkSource;
import android.system.ErrnoException;
import android.system.Os;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.backup.IBackupTransport;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.EventLogTags;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.DataChangedJournal;
import com.android.server.backup.KeyValueBackupJob;
import com.android.server.backup.PackageManagerBackupAgent;
import com.android.server.backup.RefactoredBackupManagerService;
import com.android.server.backup.fullbackup.PerformFullTransportBackupTask;
import com.android.server.backup.internal.BackupRequest;
import com.android.server.backup.internal.BackupState;
import com.android.server.backup.internal.Operation;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BackupManagerMonitorUtils;
import com.android.server.backup.utils.BackupObserverUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public class PerformBackupTask
implements BackupRestoreTask {
    private static final String TAG = "PerformBackupTask";
    private RefactoredBackupManagerService backupManagerService;
    private final Object mCancelLock = new Object();
    IBackupTransport mTransport;
    ArrayList<BackupRequest> mQueue;
    ArrayList<BackupRequest> mOriginalQueue;
    File mStateDir;
    DataChangedJournal mJournal;
    BackupState mCurrentState;
    List<String> mPendingFullBackups;
    IBackupObserver mObserver;
    IBackupManagerMonitor mMonitor;
    private final PerformFullTransportBackupTask mFullBackupTask;
    private final int mCurrentOpToken;
    private volatile int mEphemeralOpToken;
    IBackupAgent mAgentBinder;
    PackageInfo mCurrentPackage;
    File mSavedStateName;
    File mBackupDataName;
    File mNewStateName;
    ParcelFileDescriptor mSavedState;
    ParcelFileDescriptor mBackupData;
    ParcelFileDescriptor mNewState;
    int mStatus;
    boolean mFinished;
    final boolean mUserInitiated;
    final boolean mNonIncremental;
    private volatile boolean mCancelAll;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerformBackupTask(RefactoredBackupManagerService backupManagerService, IBackupTransport transport, String dirName, ArrayList<BackupRequest> queue, DataChangedJournal journal, IBackupObserver observer, IBackupManagerMonitor monitor, List<String> pendingFullBackups, boolean userInitiated, boolean nonIncremental) {
        this.backupManagerService = backupManagerService;
        this.mTransport = transport;
        this.mOriginalQueue = queue;
        this.mQueue = new ArrayList();
        this.mJournal = journal;
        this.mObserver = observer;
        this.mMonitor = monitor;
        this.mPendingFullBackups = pendingFullBackups;
        this.mUserInitiated = userInitiated;
        this.mNonIncremental = nonIncremental;
        this.mStateDir = new File(backupManagerService.getBaseStateDir(), dirName);
        this.mCurrentOpToken = backupManagerService.generateRandomIntegerToken();
        this.mFinished = false;
        Object object = backupManagerService.getCurrentOpLock();
        synchronized (object) {
            if (backupManagerService.isBackupOperationInProgress()) {
                Slog.d(TAG, "Skipping backup since one is already in progress.");
                this.mCancelAll = true;
                this.mFullBackupTask = null;
                this.mCurrentState = BackupState.FINAL;
                backupManagerService.addBackupTrace("Skipped. Backup already in progress.");
            } else {
                this.mCurrentState = BackupState.INITIAL;
                CountDownLatch latch = new CountDownLatch(1);
                String[] fullBackups = this.mPendingFullBackups.toArray(new String[this.mPendingFullBackups.size()]);
                this.mFullBackupTask = new PerformFullTransportBackupTask(backupManagerService, null, fullBackups, false, null, latch, this.mObserver, this.mMonitor, this.mUserInitiated);
                this.registerTask();
                backupManagerService.addBackupTrace("STATE => INITIAL");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTask() {
        Object object = this.backupManagerService.getCurrentOpLock();
        synchronized (object) {
            this.backupManagerService.getCurrentOperations().put(this.mCurrentOpToken, new Operation(0, this, 2));
        }
    }

    private void unregisterTask() {
        this.backupManagerService.removeOperation(this.mCurrentOpToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="mCancelLock")
    public void execute() {
        Object object = this.mCancelLock;
        synchronized (object) {
            switch (this.mCurrentState) {
                case INITIAL: {
                    this.beginBackup();
                    break;
                }
                case RUNNING_QUEUE: {
                    this.invokeNextAgent();
                    break;
                }
                case FINAL: {
                    if (!this.mFinished) {
                        this.finalizeBackup();
                    } else {
                        Slog.e(TAG, "Duplicate finish");
                    }
                    this.mFinished = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginBackup() {
        this.backupManagerService.clearBackupTrace();
        StringBuilder b = new StringBuilder(256);
        b.append("beginBackup: [");
        for (BackupRequest req : this.mOriginalQueue) {
            b.append(' ');
            b.append(req.packageName);
        }
        b.append(" ]");
        this.backupManagerService.addBackupTrace(b.toString());
        this.mAgentBinder = null;
        this.mStatus = 0;
        if (this.mOriginalQueue.isEmpty() && this.mPendingFullBackups.isEmpty()) {
            Slog.w(TAG, "Backup begun with an empty queue - nothing to do.");
            this.backupManagerService.addBackupTrace("queue empty at begin");
            BackupObserverUtils.sendBackupFinished(this.mObserver, 0);
            this.executeNextState(BackupState.FINAL);
            return;
        }
        this.mQueue = (ArrayList)this.mOriginalQueue.clone();
        boolean skipPm = this.mNonIncremental;
        for (int i = 0; i < this.mQueue.size(); ++i) {
            if (!"@pm@".equals(this.mQueue.get((int)i).packageName)) continue;
            this.mQueue.remove(i);
            skipPm = false;
            break;
        }
        Slog.v(TAG, "Beginning backup of " + this.mQueue.size() + " targets");
        File pmState = new File(this.mStateDir, "@pm@");
        try {
            String transportName = this.mTransport.transportDirName();
            EventLog.writeEvent(2821, transportName);
            if (this.mStatus == 0 && pmState.length() <= 0L) {
                Slog.i(TAG, "Initializing (wiping) backup state and transport storage");
                this.backupManagerService.addBackupTrace("initializing transport " + transportName);
                this.backupManagerService.resetBackupState(this.mStateDir);
                this.mStatus = this.mTransport.initializeDevice();
                this.backupManagerService.addBackupTrace("transport.initializeDevice() == " + this.mStatus);
                if (this.mStatus == 0) {
                    EventLog.writeEvent(2827, new Object[0]);
                } else {
                    EventLog.writeEvent(2822, "(initialize)");
                    Slog.e(TAG, "Transport error in initializeDevice()");
                }
            }
            if (skipPm) {
                Slog.d(TAG, "Skipping backup of package metadata.");
                this.executeNextState(BackupState.RUNNING_QUEUE);
            } else if (this.mStatus == 0) {
                PackageManagerBackupAgent pmAgent = new PackageManagerBackupAgent(this.backupManagerService.getPackageManager());
                this.mStatus = this.invokeAgentForBackup("@pm@", IBackupAgent.Stub.asInterface(pmAgent.onBind()), this.mTransport);
                this.backupManagerService.addBackupTrace("PMBA invoke: " + this.mStatus);
                this.backupManagerService.getBackupHandler().removeMessages(17);
            }
            if (this.mStatus == -1001) {
                EventLog.writeEvent(2826, this.mTransport.transportDirName());
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error in backup thread", e);
            this.backupManagerService.addBackupTrace("Exception in backup thread: " + e);
            this.mStatus = -1000;
        }
        finally {
            this.backupManagerService.addBackupTrace("exiting prelim: " + this.mStatus);
            if (this.mStatus != 0) {
                this.backupManagerService.resetBackupState(this.mStateDir);
                BackupObserverUtils.sendBackupFinished(this.mObserver, -1000);
                this.executeNextState(BackupState.FINAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeNextAgent() {
        block22: {
            this.mStatus = 0;
            this.backupManagerService.addBackupTrace("invoke q=" + this.mQueue.size());
            if (this.mQueue.isEmpty()) {
                this.executeNextState(BackupState.FINAL);
                return;
            }
            BackupRequest request = this.mQueue.get(0);
            this.mQueue.remove(0);
            Slog.d(TAG, "starting key/value backup of " + request);
            this.backupManagerService.addBackupTrace("launch agent for " + request.packageName);
            try {
                this.mCurrentPackage = this.backupManagerService.getPackageManager().getPackageInfo(request.packageName, 64);
                if (!AppBackupUtils.appIsEligibleForBackup(this.mCurrentPackage.applicationInfo)) {
                    Slog.i(TAG, "Package " + request.packageName + " no longer supports backup; skipping");
                    this.backupManagerService.addBackupTrace("skipping - not eligible, completion is noop");
                    BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, this.mCurrentPackage.packageName, -2001);
                    this.executeNextState(BackupState.RUNNING_QUEUE);
                    return;
                }
                if (AppBackupUtils.appGetsFullBackup(this.mCurrentPackage)) {
                    Slog.i(TAG, "Package " + request.packageName + " requests full-data rather than key/value; skipping");
                    this.backupManagerService.addBackupTrace("skipping - fullBackupOnly, completion is noop");
                    BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, this.mCurrentPackage.packageName, -2001);
                    this.executeNextState(BackupState.RUNNING_QUEUE);
                    return;
                }
                if (AppBackupUtils.appIsStopped(this.mCurrentPackage.applicationInfo)) {
                    this.backupManagerService.addBackupTrace("skipping - stopped");
                    BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, this.mCurrentPackage.packageName, -2001);
                    this.executeNextState(BackupState.RUNNING_QUEUE);
                    return;
                }
                IBackupAgent agent = null;
                try {
                    this.backupManagerService.getWakelock().setWorkSource(new WorkSource(this.mCurrentPackage.applicationInfo.uid));
                    agent = this.backupManagerService.bindToAgentSynchronous(this.mCurrentPackage.applicationInfo, 0);
                    this.backupManagerService.addBackupTrace("agent bound; a? = " + (agent != null));
                    if (agent != null) {
                        this.mAgentBinder = agent;
                        this.mStatus = this.invokeAgentForBackup(request.packageName, agent, this.mTransport);
                        break block22;
                    }
                    this.mStatus = -1003;
                }
                catch (SecurityException ex) {
                    Slog.d(TAG, "error in bind/backup", ex);
                    this.mStatus = -1003;
                    this.backupManagerService.addBackupTrace("agent SE");
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.d(TAG, "Package does not exist; skipping");
                this.backupManagerService.addBackupTrace("no such package");
                this.mStatus = -1004;
            }
            finally {
                this.backupManagerService.getWakelock().setWorkSource(null);
                if (this.mStatus != 0) {
                    BackupState nextState = BackupState.RUNNING_QUEUE;
                    this.mAgentBinder = null;
                    if (this.mStatus == -1003) {
                        this.backupManagerService.dataChangedImpl(request.packageName);
                        this.mStatus = 0;
                        if (this.mQueue.isEmpty()) {
                            nextState = BackupState.FINAL;
                        }
                        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, this.mCurrentPackage.packageName, -1003);
                    } else if (this.mStatus == -1004) {
                        this.mStatus = 0;
                        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, this.mCurrentPackage.packageName, -2002);
                    } else {
                        this.revertAndEndBackup();
                        nextState = BackupState.FINAL;
                    }
                    this.executeNextState(nextState);
                } else {
                    this.backupManagerService.addBackupTrace("expecting completion/timeout callback");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeBackup() {
        this.backupManagerService.addBackupTrace("finishing");
        for (BackupRequest req : this.mQueue) {
            this.backupManagerService.dataChangedImpl(req.packageName);
        }
        if (this.mJournal != null && !this.mJournal.delete()) {
            Slog.e(TAG, "Unable to remove backup journal file " + this.mJournal);
        }
        if (this.backupManagerService.getCurrentToken() == 0L && this.mStatus == 0) {
            this.backupManagerService.addBackupTrace("success; recording token");
            try {
                this.backupManagerService.setCurrentToken(this.mTransport.getCurrentRestoreSet());
                this.backupManagerService.writeRestoreTokens();
            }
            catch (Exception e) {
                Slog.e(TAG, "Transport threw reporting restore set: " + e.getMessage());
                this.backupManagerService.addBackupTrace("transport threw returning token");
            }
        }
        Object object = this.backupManagerService.getQueueLock();
        synchronized (object) {
            this.backupManagerService.setBackupRunning(false);
            if (this.mStatus == -1001) {
                this.backupManagerService.addBackupTrace("init required; rerunning");
                try {
                    String name = this.backupManagerService.getTransportManager().getTransportName(this.mTransport);
                    if (name != null) {
                        this.backupManagerService.getPendingInits().add(name);
                    } else {
                        Slog.w(TAG, "Couldn't find name of transport " + this.mTransport + " for init");
                    }
                }
                catch (Exception e) {
                    Slog.w(TAG, "Failed to query transport name for init: " + e.getMessage());
                }
                this.clearMetadata();
                this.backupManagerService.backupNow();
            }
        }
        this.backupManagerService.clearBackupTrace();
        this.unregisterTask();
        if (!this.mCancelAll && this.mStatus == 0 && this.mPendingFullBackups != null && !this.mPendingFullBackups.isEmpty()) {
            Slog.d(TAG, "Starting full backups for: " + this.mPendingFullBackups);
            this.backupManagerService.getWakelock().acquire();
            new Thread((Runnable)this.mFullBackupTask, "full-transport-requested").start();
        } else if (this.mCancelAll) {
            if (this.mFullBackupTask != null) {
                this.mFullBackupTask.unregisterTask();
            }
            BackupObserverUtils.sendBackupFinished(this.mObserver, -2003);
        } else {
            this.mFullBackupTask.unregisterTask();
            switch (this.mStatus) {
                case 0: {
                    BackupObserverUtils.sendBackupFinished(this.mObserver, 0);
                    break;
                }
                case -1001: {
                    BackupObserverUtils.sendBackupFinished(this.mObserver, -1000);
                    break;
                }
                default: {
                    BackupObserverUtils.sendBackupFinished(this.mObserver, -1000);
                }
            }
        }
        Slog.i(TAG, "K/V backup pass finished.");
        this.backupManagerService.getWakelock().release();
    }

    void clearMetadata() {
        File pmState = new File(this.mStateDir, "@pm@");
        if (pmState.exists()) {
            pmState.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int invokeAgentForBackup(String packageName, IBackupAgent agent, IBackupTransport transport) {
        Slog.d(TAG, "invokeAgentForBackup on " + packageName);
        this.backupManagerService.addBackupTrace("invoking " + packageName);
        File blankStateName = new File(this.mStateDir, "blank_state");
        this.mSavedStateName = new File(this.mStateDir, packageName);
        this.mBackupDataName = new File(this.backupManagerService.getDataDir(), packageName + ".data");
        this.mNewStateName = new File(this.mStateDir, packageName + ".new");
        this.mSavedState = null;
        this.mBackupData = null;
        this.mNewState = null;
        boolean callingAgent = false;
        this.mEphemeralOpToken = this.backupManagerService.generateRandomIntegerToken();
        try {
            if (packageName.equals("@pm@")) {
                this.mCurrentPackage = new PackageInfo();
                this.mCurrentPackage.packageName = packageName;
            }
            this.mSavedState = ParcelFileDescriptor.open(this.mNonIncremental ? blankStateName : this.mSavedStateName, 0x18000000);
            this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x3C000000);
            if (!SELinux.restorecon(this.mBackupDataName)) {
                Slog.e(TAG, "SELinux restorecon failed on " + this.mBackupDataName);
            }
            this.mNewState = ParcelFileDescriptor.open(this.mNewStateName, 0x3C000000);
            long quota = this.mTransport.getBackupQuota(packageName, false);
            callingAgent = true;
            this.backupManagerService.addBackupTrace("setting timeout");
            this.backupManagerService.prepareOperationTimeout(this.mEphemeralOpToken, 30000L, this, 0);
            this.backupManagerService.addBackupTrace("calling agent doBackup()");
            agent.doBackup(this.mSavedState, this.mBackupData, this.mNewState, quota, this.mEphemeralOpToken, this.backupManagerService.getBackupManagerBinder());
        }
        catch (Exception e) {
            Slog.e(TAG, "Error invoking for backup on " + packageName + ". " + e);
            this.backupManagerService.addBackupTrace("exception: " + e);
            EventLog.writeEvent(2823, packageName, e.toString());
            this.errorCleanup();
            int n = callingAgent ? -1003 : -1000;
            return n;
        }
        finally {
            if (this.mNonIncremental) {
                blankStateName.delete();
            }
        }
        this.backupManagerService.addBackupTrace("invoke success");
        return 0;
    }

    public void failAgent(IBackupAgent agent, String message) {
        try {
            agent.fail(message);
        }
        catch (Exception e) {
            Slog.w(TAG, "Error conveying failure to " + this.mCurrentPackage.packageName);
        }
    }

    private String SHA1Checksum(byte[] input) {
        byte[] checksum;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            checksum = md.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.e(TAG, "Unable to use SHA-1!");
            return "00";
        }
        StringBuffer sb = new StringBuffer(checksum.length * 2);
        for (int i = 0; i < checksum.length; ++i) {
            sb.append(Integer.toHexString(checksum[i]));
        }
        return sb.toString();
    }

    private void writeWidgetPayloadIfAppropriate(FileDescriptor fd, String pkgName) throws IOException {
        Throwable throwable;
        Throwable throwable2;
        byte[] widgetState = AppWidgetBackupBridge.getWidgetState(pkgName, 0);
        File widgetFile = new File(this.mStateDir, pkgName + "_widget");
        boolean priorStateExists = widgetFile.exists();
        if (!priorStateExists && widgetState == null) {
            return;
        }
        String newChecksum = null;
        if (widgetState != null) {
            newChecksum = this.SHA1Checksum(widgetState);
            if (priorStateExists) {
                String priorChecksum;
                throwable2 = null;
                try (FileInputStream fin = new FileInputStream(widgetFile);){
                    throwable = null;
                    try (DataInputStream in = new DataInputStream(fin);){
                        priorChecksum = in.readUTF();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable in) {
                    throwable2 = in;
                    throw in;
                }
                if (Objects.equals(newChecksum, priorChecksum)) {
                    return;
                }
            }
        }
        BackupDataOutput out = new BackupDataOutput(fd);
        if (widgetState != null) {
            throwable2 = null;
            try (FileOutputStream fout = new FileOutputStream(widgetFile);){
                throwable = null;
                try (DataOutputStream stateOut = new DataOutputStream(fout);){
                    stateOut.writeUTF(newChecksum);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            out.writeEntityHeader("\uffed\uffedwidget", widgetState.length);
            out.writeEntityData(widgetState, widgetState.length);
        } else {
            out.writeEntityHeader("\uffed\uffedwidget", -1);
            widgetFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="mCancelLock")
    public void operationComplete(long unusedResult) {
        this.backupManagerService.removeOperation(this.mEphemeralOpToken);
        Object object = this.mCancelLock;
        synchronized (object) {
            BackupState nextState;
            if (this.mFinished) {
                Slog.d(TAG, "operationComplete received after task finished.");
                return;
            }
            if (this.mBackupData == null) {
                String pkg = this.mCurrentPackage != null ? this.mCurrentPackage.packageName : "[none]";
                this.backupManagerService.addBackupTrace("late opComplete; curPkg = " + pkg);
                return;
            }
            String pkgName = this.mCurrentPackage.packageName;
            long filepos = this.mBackupDataName.length();
            FileDescriptor fd = this.mBackupData.getFileDescriptor();
            try {
                if (this.mCurrentPackage.applicationInfo != null && (this.mCurrentPackage.applicationInfo.flags & 1) == 0) {
                    ParcelFileDescriptor readFd = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
                    BackupDataInput in = new BackupDataInput(readFd.getFileDescriptor());
                    try {
                        while (in.readNextHeader()) {
                            String key = in.getKey();
                            if (key != null && key.charAt(0) >= '\uff00') {
                                this.failAgent(this.mAgentBinder, "Illegal backup key: " + key);
                                this.backupManagerService.addBackupTrace("illegal key " + key + " from " + pkgName);
                                EventLog.writeEvent(2823, pkgName, "bad key");
                                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 5, this.mCurrentPackage, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_ILLEGAL_KEY", key));
                                this.backupManagerService.getBackupHandler().removeMessages(17);
                                BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, pkgName, -1003);
                                this.errorCleanup();
                                return;
                            }
                            in.skipEntityData();
                        }
                    }
                    finally {
                        if (readFd != null) {
                            readFd.close();
                        }
                    }
                }
                this.writeWidgetPayloadIfAppropriate(fd, pkgName);
            }
            catch (IOException e) {
                Slog.w(TAG, "Unable to save widget state for " + pkgName);
                try {
                    Os.ftruncate(fd, filepos);
                }
                catch (ErrnoException ee) {
                    Slog.w(TAG, "Unable to roll back!");
                }
            }
            this.backupManagerService.getBackupHandler().removeMessages(17);
            this.clearAgentState();
            this.backupManagerService.addBackupTrace("operation complete");
            ParcelFileDescriptor backupData = null;
            this.mStatus = 0;
            long size = 0L;
            try {
                size = this.mBackupDataName.length();
                if (size > 0L) {
                    if (this.mStatus == 0) {
                        backupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
                        this.backupManagerService.addBackupTrace("sending data to transport");
                        int flags = this.mUserInitiated ? 1 : 0;
                        this.mStatus = this.mTransport.performBackup(this.mCurrentPackage, backupData, flags);
                    }
                    this.backupManagerService.addBackupTrace("data delivered: " + this.mStatus);
                    if (this.mStatus == 0) {
                        this.backupManagerService.addBackupTrace("finishing op on transport");
                        this.mStatus = this.mTransport.finishBackup();
                        this.backupManagerService.addBackupTrace("finished: " + this.mStatus);
                    } else if (this.mStatus == -1002) {
                        this.backupManagerService.addBackupTrace("transport rejected package");
                    }
                } else {
                    this.backupManagerService.addBackupTrace("no data to send");
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 7, this.mCurrentPackage, 3, null);
                }
                if (this.mStatus == 0) {
                    this.mBackupDataName.delete();
                    this.mNewStateName.renameTo(this.mSavedStateName);
                    BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, pkgName, 0);
                    EventLog.writeEvent(2824, pkgName, size);
                    this.backupManagerService.logBackupComplete(pkgName);
                } else if (this.mStatus == -1002) {
                    this.mBackupDataName.delete();
                    this.mNewStateName.delete();
                    BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, pkgName, -1002);
                    EventLogTags.writeBackupAgentFailure(pkgName, "Transport rejected");
                } else if (this.mStatus == -1005) {
                    BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, pkgName, -1005);
                    EventLog.writeEvent(2829, pkgName);
                } else {
                    BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, pkgName, -1000);
                    EventLog.writeEvent(2822, pkgName);
                }
            }
            catch (Exception e) {
                BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, pkgName, -1000);
                Slog.e(TAG, "Transport error backing up " + pkgName, e);
                EventLog.writeEvent(2822, pkgName);
                this.mStatus = -1000;
            }
            finally {
                try {
                    if (backupData != null) {
                        backupData.close();
                    }
                }
                catch (IOException e) {}
            }
            if (this.mStatus == 0 || this.mStatus == -1002) {
                nextState = this.mQueue.isEmpty() ? BackupState.FINAL : BackupState.RUNNING_QUEUE;
            } else if (this.mStatus == -1005) {
                if (this.mAgentBinder != null) {
                    try {
                        long quota = this.mTransport.getBackupQuota(this.mCurrentPackage.packageName, false);
                        this.mAgentBinder.doQuotaExceeded(size, quota);
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Unable to notify about quota exceeded: " + e.getMessage());
                    }
                }
                nextState = this.mQueue.isEmpty() ? BackupState.FINAL : BackupState.RUNNING_QUEUE;
            } else {
                this.revertAndEndBackup();
                nextState = BackupState.FINAL;
            }
            this.executeNextState(nextState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="mCancelLock")
    public void handleCancel(boolean cancelAll) {
        this.backupManagerService.removeOperation(this.mEphemeralOpToken);
        Object object = this.mCancelLock;
        synchronized (object) {
            if (this.mFinished) {
                return;
            }
            this.mCancelAll = cancelAll;
            String logPackageName = this.mCurrentPackage != null ? this.mCurrentPackage.packageName : "no_package_yet";
            Slog.i(TAG, "Cancel backing up " + logPackageName);
            EventLog.writeEvent(2823, logPackageName);
            this.backupManagerService.addBackupTrace("cancel of " + logPackageName + ", cancelAll=" + cancelAll);
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 21, this.mCurrentPackage, 2, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_CANCEL_ALL", this.mCancelAll));
            this.errorCleanup();
            if (!cancelAll) {
                this.executeNextState(this.mQueue.isEmpty() ? BackupState.FINAL : BackupState.RUNNING_QUEUE);
                this.backupManagerService.dataChangedImpl(this.mCurrentPackage.packageName);
            } else {
                this.finalizeBackup();
            }
        }
    }

    void revertAndEndBackup() {
        long delay;
        this.backupManagerService.addBackupTrace("transport error; reverting");
        try {
            delay = this.mTransport.requestBackupTime();
        }
        catch (Exception e) {
            Slog.w(TAG, "Unable to contact transport for recommended backoff: " + e.getMessage());
            delay = 0L;
        }
        KeyValueBackupJob.schedule(this.backupManagerService.getContext(), delay);
        for (BackupRequest request : this.mOriginalQueue) {
            this.backupManagerService.dataChangedImpl(request.packageName);
        }
    }

    void errorCleanup() {
        this.mBackupDataName.delete();
        this.mNewStateName.delete();
        this.clearAgentState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAgentState() {
        try {
            if (this.mSavedState != null) {
                this.mSavedState.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mBackupData != null) {
                this.mBackupData.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mNewState != null) {
                this.mNewState.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object object = this.backupManagerService.getCurrentOpLock();
        synchronized (object) {
            this.backupManagerService.getCurrentOperations().remove(this.mEphemeralOpToken);
            this.mNewState = null;
            this.mBackupData = null;
            this.mSavedState = null;
        }
        if (this.mCurrentPackage.applicationInfo != null) {
            this.backupManagerService.addBackupTrace("unbinding " + this.mCurrentPackage.packageName);
            try {
                this.backupManagerService.getActivityManager().unbindBackupAgent(this.mCurrentPackage.applicationInfo);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void executeNextState(BackupState nextState) {
        this.backupManagerService.addBackupTrace("executeNextState => " + (Object)((Object)nextState));
        this.mCurrentState = nextState;
        Message msg = this.backupManagerService.getBackupHandler().obtainMessage(20, this);
        this.backupManagerService.getBackupHandler().sendMessage(msg);
    }
}

