/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RestoreEngine {
    private static final String TAG = "RestoreEngine";
    public static final int SUCCESS = 0;
    public static final int TARGET_FAILURE = -2;
    public static final int TRANSPORT_FAILURE = -3;
    private AtomicBoolean mRunning = new AtomicBoolean(false);
    private AtomicInteger mResult = new AtomicInteger(0);

    public boolean isRunning() {
        return this.mRunning.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean stillRunning) {
        AtomicBoolean atomicBoolean = this.mRunning;
        synchronized (atomicBoolean) {
            this.mRunning.set(stillRunning);
            this.mRunning.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForResult() {
        AtomicBoolean atomicBoolean = this.mRunning;
        synchronized (atomicBoolean) {
            while (this.isRunning()) {
                try {
                    this.mRunning.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.getResult();
    }

    public int getResult() {
        return this.mResult.get();
    }

    public void setResult(int result) {
        this.mResult.set(result);
    }
}

