/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio;

import android.hardware.radio.ITunerCallback;
import android.hardware.radio.RadioManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.broadcastradio.Tuner;

class TunerCallback
implements ITunerCallback {
    private static final String TAG = "BroadcastRadioService.TunerCallback";
    private final long mNativeContext;
    private final Tuner mTuner;
    private final ITunerCallback mClientCallback;

    TunerCallback(Tuner tuner, ITunerCallback clientCallback, int halRev) {
        this.mTuner = tuner;
        this.mClientCallback = clientCallback;
        this.mNativeContext = this.nativeInit(tuner, halRev);
    }

    protected void finalize() throws Throwable {
        this.nativeFinalize(this.mNativeContext);
        super.finalize();
    }

    private native long nativeInit(Tuner var1, int var2);

    private native void nativeFinalize(long var1);

    private native void nativeDetach(long var1);

    public void detach() {
        this.nativeDetach(this.mNativeContext);
    }

    private void dispatch(RunnableThrowingRemoteException func) {
        try {
            func.run();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "client died", e);
        }
    }

    private void handleHwFailure() {
        this.onError(0);
        this.mTuner.close();
    }

    @Override
    public void onError(int status) {
        this.dispatch(() -> this.mClientCallback.onError(status));
    }

    @Override
    public void onConfigurationChanged(RadioManager.BandConfig config) {
        this.dispatch(() -> this.mClientCallback.onConfigurationChanged(config));
    }

    @Override
    public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) {
        this.dispatch(() -> this.mClientCallback.onCurrentProgramInfoChanged(info));
    }

    @Override
    public void onTrafficAnnouncement(boolean active) {
        this.dispatch(() -> this.mClientCallback.onTrafficAnnouncement(active));
    }

    @Override
    public void onEmergencyAnnouncement(boolean active) {
        this.dispatch(() -> this.mClientCallback.onEmergencyAnnouncement(active));
    }

    @Override
    public void onAntennaState(boolean connected) {
        this.dispatch(() -> this.mClientCallback.onAntennaState(connected));
    }

    @Override
    public void onBackgroundScanAvailabilityChange(boolean isAvailable) {
        this.dispatch(() -> this.mClientCallback.onBackgroundScanAvailabilityChange(isAvailable));
    }

    @Override
    public void onBackgroundScanComplete() {
        this.dispatch(() -> this.mClientCallback.onBackgroundScanComplete());
    }

    @Override
    public void onProgramListChanged() {
        this.dispatch(() -> this.mClientCallback.onProgramListChanged());
    }

    @Override
    public IBinder asBinder() {
        throw new RuntimeException("Not a binder");
    }

    private static interface RunnableThrowingRemoteException {
        public void run() throws RemoteException;
    }
}

