/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.hardware.usb.UsbManager;
import android.net.ConnectivityManager;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkState;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.util.PrefixUtils;
import android.net.util.SharedLog;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.MockableSystemProperties;
import com.android.server.connectivity.tethering.IControlsTethering;
import com.android.server.connectivity.tethering.IPv6TetheringCoordinator;
import com.android.server.connectivity.tethering.OffloadController;
import com.android.server.connectivity.tethering.SimChangeListener;
import com.android.server.connectivity.tethering.TetherInterfaceStateMachine;
import com.android.server.connectivity.tethering.TetheringConfiguration;
import com.android.server.connectivity.tethering.TetheringDependencies;
import com.android.server.connectivity.tethering.UpstreamNetworkMonitor;
import com.android.server.net.BaseNetworkObserver;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Tethering
extends BaseNetworkObserver {
    private static final String TAG = Tethering.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    protected static final String DISABLE_PROVISIONING_SYSPROP_KEY = "net.tethering.noprovisioning";
    private static final Class[] messageClasses = new Class[]{Tethering.class, TetherMasterSM.class, TetherInterfaceStateMachine.class};
    private static final SparseArray<String> sMagicDecoderRing = MessageUtils.findMessageNames(messageClasses);
    private static final ComponentName TETHER_SERVICE = ComponentName.unflattenFromString(Resources.getSystem().getString(17039695));
    private final SharedLog mLog = new SharedLog(TAG);
    private final Object mPublicSync;
    private final Context mContext;
    private final ArrayMap<String, TetherState> mTetherStates;
    private final BroadcastReceiver mStateReceiver;
    private final INetworkManagementService mNMService;
    private final INetworkStatsService mStatsService;
    private final INetworkPolicyManager mPolicyManager;
    private final Looper mLooper;
    private final MockableSystemProperties mSystemProperties;
    private final StateMachine mTetherMasterSM;
    private final OffloadController mOffloadController;
    private final UpstreamNetworkMonitor mUpstreamNetworkMonitor;
    private final HashSet<TetherInterfaceStateMachine> mForwardedDownstreams;
    private final SimChangeListener mSimChange;
    private volatile TetheringConfiguration mConfig;
    private String mCurrentUpstreamIface;
    private Notification.Builder mTetheredNotificationBuilder;
    private int mLastNotificationId;
    private boolean mRndisEnabled;
    private boolean mUsbTetherRequested;
    private boolean mWifiTetherRequested;

    public Tethering(Context context, INetworkManagementService nmService, INetworkStatsService statsService, INetworkPolicyManager policyManager, Looper looper, MockableSystemProperties systemProperties, TetheringDependencies deps) {
        this.mLog.mark("constructed");
        this.mContext = context;
        this.mNMService = nmService;
        this.mStatsService = statsService;
        this.mPolicyManager = policyManager;
        this.mLooper = looper;
        this.mSystemProperties = systemProperties;
        this.mPublicSync = new Object();
        this.mTetherStates = new ArrayMap();
        this.mTetherMasterSM = new TetherMasterSM("TetherMaster", this.mLooper);
        this.mTetherMasterSM.start();
        Handler smHandler = this.mTetherMasterSM.getHandler();
        this.mOffloadController = new OffloadController(smHandler, deps.getOffloadHardwareInterface(smHandler, this.mLog), this.mContext.getContentResolver(), this.mNMService, this.mLog);
        this.mUpstreamNetworkMonitor = new UpstreamNetworkMonitor(this.mContext, this.mTetherMasterSM, this.mLog, 327685);
        this.mForwardedDownstreams = new HashSet();
        this.mSimChange = new SimChangeListener(this.mContext, smHandler, () -> this.reevaluateSimCardProvisioning());
        this.mStateReceiver = new StateReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_STATE");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.net.wifi.WIFI_AP_STATE_CHANGED");
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mContext.registerReceiver(this.mStateReceiver, filter, null, smHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_SHARED");
        filter.addAction("android.intent.action.MEDIA_UNSHARED");
        filter.addDataScheme("file");
        this.mContext.registerReceiver(this.mStateReceiver, filter, null, smHandler);
        this.updateConfiguration();
    }

    private ConnectivityManager getConnectivityManager() {
        return (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    private WifiManager getWifiManager() {
        return (WifiManager)this.mContext.getSystemService("wifi");
    }

    private void updateConfiguration() {
        this.mConfig = new TetheringConfiguration(this.mContext, this.mLog);
        this.mUpstreamNetworkMonitor.updateMobileRequiresDun(this.mConfig.isDunRequired);
    }

    private void maybeUpdateConfiguration() {
        int dunCheck = TetheringConfiguration.checkDunRequired(this.mContext);
        if (dunCheck == this.mConfig.dunCheck) {
            return;
        }
        this.updateConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceStatusChanged(String iface, boolean up) {
        Object object = this.mPublicSync;
        synchronized (object) {
            if (up) {
                this.maybeTrackNewInterfaceLocked(iface);
            } else if (this.ifaceNameToType(iface) == 2) {
                this.stopTrackingInterfaceLocked(iface);
            }
        }
    }

    @Override
    public void interfaceLinkStateChanged(String iface, boolean up) {
        this.interfaceStatusChanged(iface, up);
    }

    private int ifaceNameToType(String iface) {
        TetheringConfiguration cfg = this.mConfig;
        if (cfg.isWifi(iface)) {
            return 0;
        }
        if (cfg.isUsb(iface)) {
            return 1;
        }
        if (cfg.isBluetooth(iface)) {
            return 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceAdded(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            this.maybeTrackNewInterfaceLocked(iface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceRemoved(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            this.stopTrackingInterfaceLocked(iface);
        }
    }

    public void startTethering(int type, ResultReceiver receiver, boolean showProvisioningUi) {
        if (!this.isTetherProvisioningRequired()) {
            this.enableTetheringInternal(type, true, receiver);
            return;
        }
        if (showProvisioningUi) {
            this.runUiTetherProvisioningAndEnable(type, receiver);
        } else {
            this.runSilentTetherProvisioningAndEnable(type, receiver);
        }
    }

    public void stopTethering(int type) {
        this.enableTetheringInternal(type, false, null);
        if (this.isTetherProvisioningRequired()) {
            this.cancelTetherProvisioningRechecks(type);
        }
    }

    protected boolean isTetherProvisioningRequired() {
        boolean isEntitlementCheckRequired;
        String[] provisionApp = this.mContext.getResources().getStringArray(17236012);
        if (this.mSystemProperties.getBoolean(DISABLE_PROVISIONING_SYSPROP_KEY, false) || provisionApp == null) {
            return false;
        }
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configManager != null && configManager.getConfig() != null && !(isEntitlementCheckRequired = configManager.getConfig().getBoolean("require_entitlement_checks_bool"))) {
            return false;
        }
        return provisionApp.length == 2;
    }

    private boolean hasMobileHotspotProvisionApp() {
        try {
            if (!this.mContext.getResources().getString(17039677).isEmpty()) {
                Log.d(TAG, "re-evaluate provisioning");
                return true;
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        Log.d(TAG, "no prov-check needed for new SIM");
        return false;
    }

    private void enableTetheringInternal(int type, boolean enable, ResultReceiver receiver) {
        boolean isProvisioningRequired = enable && this.isTetherProvisioningRequired();
        switch (type) {
            case 0: {
                int result = this.setWifiTethering(enable);
                if (isProvisioningRequired && result == 0) {
                    this.scheduleProvisioningRechecks(type);
                }
                this.sendTetherResult(receiver, result);
                break;
            }
            case 1: {
                int result = this.setUsbTethering(enable);
                if (isProvisioningRequired && result == 0) {
                    this.scheduleProvisioningRechecks(type);
                }
                this.sendTetherResult(receiver, result);
                break;
            }
            case 2: {
                this.setBluetoothTethering(enable, receiver);
                break;
            }
            default: {
                Log.w(TAG, "Invalid tether type.");
                this.sendTetherResult(receiver, 1);
            }
        }
    }

    private void sendTetherResult(ResultReceiver receiver, int result) {
        if (receiver != null) {
            receiver.send(result, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setWifiTethering(boolean enable) {
        int rval = 5;
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mPublicSync;
            synchronized (object) {
                this.mWifiTetherRequested = enable;
                WifiManager mgr = this.getWifiManager();
                if (enable && mgr.startSoftAp(null) || !enable && mgr.stopSoftAp()) {
                    rval = 0;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return rval;
    }

    private void setBluetoothTethering(final boolean enable, final ResultReceiver receiver) {
        final BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || !adapter.isEnabled()) {
            Log.w(TAG, "Tried to enable bluetooth tethering with null or disabled adapter. null: " + (adapter == null));
            this.sendTetherResult(receiver, 2);
            return;
        }
        adapter.getProfileProxy(this.mContext, new BluetoothProfile.ServiceListener(){

            @Override
            public void onServiceDisconnected(int profile) {
            }

            @Override
            public void onServiceConnected(int profile, BluetoothProfile proxy) {
                ((BluetoothPan)proxy).setBluetoothTethering(enable);
                int result = ((BluetoothPan)proxy).isTetheringOn() == enable ? 0 : 5;
                Tethering.this.sendTetherResult(receiver, result);
                if (enable && Tethering.this.isTetherProvisioningRequired()) {
                    Tethering.this.scheduleProvisioningRechecks(2);
                }
                adapter.closeProfileProxy(5, proxy);
            }
        }, 5);
    }

    private void runUiTetherProvisioningAndEnable(int type, ResultReceiver receiver) {
        ResultReceiver proxyReceiver = this.getProxyReceiver(type, receiver);
        this.sendUiTetherProvisionIntent(type, proxyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUiTetherProvisionIntent(int type, ResultReceiver receiver) {
        Intent intent = new Intent("android.settings.TETHER_PROVISIONING_UI");
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraProvisionCallback", receiver);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private ResultReceiver getProxyReceiver(final int type, final ResultReceiver receiver) {
        ResultReceiver rr = new ResultReceiver(null){

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 0) {
                    Tethering.this.enableTetheringInternal(type, true, receiver);
                } else {
                    Tethering.this.sendTetherResult(receiver, resultCode);
                }
            }
        };
        Parcel parcel = Parcel.obtain();
        rr.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        ResultReceiver receiverForSending = ResultReceiver.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return receiverForSending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProvisioningRechecks(int type) {
        Intent intent = new Intent();
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraSetAlarm", true);
        intent.setComponent(TETHER_SERVICE);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void runSilentTetherProvisioningAndEnable(int type, ResultReceiver receiver) {
        ResultReceiver proxyReceiver = this.getProxyReceiver(type, receiver);
        this.sendSilentTetherProvisionIntent(type, proxyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSilentTetherProvisionIntent(int type, ResultReceiver receiver) {
        Intent intent = new Intent();
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraRunProvision", true);
        intent.putExtra("extraProvisionCallback", receiver);
        intent.setComponent(TETHER_SERVICE);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTetherProvisioningRechecks(int type) {
        if (this.getConnectivityManager().isTetheringSupported()) {
            Intent intent = new Intent();
            intent.putExtra("extraRemTetherType", type);
            intent.setComponent(TETHER_SERVICE);
            long ident = Binder.clearCallingIdentity();
            try {
                this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private void startProvisionIntent(int tetherType) {
        Intent startProvIntent = new Intent();
        startProvIntent.putExtra("extraAddTetherType", tetherType);
        startProvIntent.putExtra("extraRunProvision", true);
        startProvIntent.setComponent(TETHER_SERVICE);
        this.mContext.startServiceAsUser(startProvIntent, UserHandle.CURRENT);
    }

    public int tether(String iface) {
        return this.tether(iface, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tether(String iface, int requestedState) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                Log.e(TAG, "Tried to Tether an unknown iface: " + iface + ", ignoring");
                return 1;
            }
            if (tetherState.lastState != 1) {
                Log.e(TAG, "Tried to Tether an unavailable iface: " + iface + ", ignoring");
                return 4;
            }
            tetherState.stateMachine.sendMessage(327782, requestedState);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int untether(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                Log.e(TAG, "Tried to Untether an unknown iface :" + iface + ", ignoring");
                return 1;
            }
            if (!tetherState.isCurrentlyServing()) {
                Log.e(TAG, "Tried to untether an inactive iface :" + iface + ", ignoring");
                return 4;
            }
            tetherState.stateMachine.sendMessage(327783);
            return 0;
        }
    }

    public void untetherAll() {
        this.stopTethering(0);
        this.stopTethering(1);
        this.stopTethering(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastTetherError(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                Log.e(TAG, "Tried to getLastTetherError on an unknown iface :" + iface + ", ignoring");
                return 1;
            }
            return tetherState.lastError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTetherStateChangedBroadcast() {
        if (!this.getConnectivityManager().isTetheringSupported()) {
            return;
        }
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> tetherList = new ArrayList<String>();
        ArrayList<String> localOnlyList = new ArrayList<String>();
        ArrayList<String> erroredList = new ArrayList<String>();
        boolean wifiTethered = false;
        boolean usbTethered = false;
        boolean bluetoothTethered = false;
        TetheringConfiguration cfg = this.mConfig;
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                String iface = this.mTetherStates.keyAt(i);
                if (tetherState.lastError != 0) {
                    erroredList.add(iface);
                    continue;
                }
                if (tetherState.lastState == 1) {
                    availableList.add(iface);
                    continue;
                }
                if (tetherState.lastState == 3) {
                    localOnlyList.add(iface);
                    continue;
                }
                if (tetherState.lastState != 2) continue;
                if (cfg.isUsb(iface)) {
                    usbTethered = true;
                } else if (cfg.isWifi(iface)) {
                    wifiTethered = true;
                } else if (cfg.isBluetooth(iface)) {
                    bluetoothTethered = true;
                }
                tetherList.add(iface);
            }
        }
        Intent bcast = new Intent("android.net.conn.TETHER_STATE_CHANGED");
        bcast.addFlags(0x24000000);
        bcast.putStringArrayListExtra("availableArray", availableList);
        bcast.putStringArrayListExtra("localOnlyArray", localOnlyList);
        bcast.putStringArrayListExtra("tetherArray", tetherList);
        bcast.putStringArrayListExtra("erroredArray", erroredList);
        this.mContext.sendStickyBroadcastAsUser(bcast, UserHandle.ALL);
        if (usbTethered) {
            if (wifiTethered || bluetoothTethered) {
                this.showTetheredNotification(14);
            } else {
                this.showTetheredNotification(15);
            }
        } else if (wifiTethered) {
            if (bluetoothTethered) {
                this.showTetheredNotification(14);
            } else {
                this.clearTetheredNotification();
            }
        } else if (bluetoothTethered) {
            this.showTetheredNotification(16);
        } else {
            this.clearTetheredNotification();
        }
    }

    private void showTetheredNotification(int id2) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        int icon = 0;
        switch (id2) {
            case 15: {
                icon = 17303492;
                break;
            }
            case 16: {
                icon = 17303490;
                break;
            }
            default: {
                icon = 17303491;
            }
        }
        if (this.mLastNotificationId != 0) {
            if (this.mLastNotificationId == icon) {
                return;
            }
            notificationManager.cancelAsUser(null, this.mLastNotificationId, UserHandle.ALL);
            this.mLastNotificationId = 0;
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.settings", "com.android.settings.TetherSettings");
        intent.setFlags(0x40000000);
        PendingIntent pi = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
        Resources r = Resources.getSystem();
        CharSequence title = r.getText(17040861);
        CharSequence message = r.getText(17040860);
        if (this.mTetheredNotificationBuilder == null) {
            this.mTetheredNotificationBuilder = new Notification.Builder(this.mContext, SystemNotificationChannels.NETWORK_STATUS);
            this.mTetheredNotificationBuilder.setWhen(0L).setOngoing(true).setColor(this.mContext.getColor(17170763)).setVisibility(1).setCategory("status");
        }
        this.mTetheredNotificationBuilder.setSmallIcon(icon).setContentTitle(title).setContentText(message).setContentIntent(pi);
        this.mLastNotificationId = id2;
        notificationManager.notifyAsUser(null, this.mLastNotificationId, this.mTetheredNotificationBuilder.buildInto(new Notification()), UserHandle.ALL);
    }

    private void clearTetheredNotification() {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager != null && this.mLastNotificationId != 0) {
            notificationManager.cancelAsUser(null, this.mLastNotificationId, UserHandle.ALL);
            this.mLastNotificationId = 0;
        }
    }

    private void disableWifiIpServingLocked(String ifname, int apState) {
        TetherState ts;
        this.mLog.log("Canceling WiFi tethering request - AP_STATE=" + apState);
        this.mWifiTetherRequested = false;
        if (!TextUtils.isEmpty(ifname) && (ts = this.mTetherStates.get(ifname)) != null) {
            ts.stateMachine.unwanted();
            return;
        }
        for (int i = 0; i < this.mTetherStates.size(); ++i) {
            TetherInterfaceStateMachine tism = this.mTetherStates.valueAt((int)i).stateMachine;
            if (tism.interfaceType() != 0) continue;
            tism.unwanted();
            return;
        }
        this.mLog.log("Error disabling Wi-Fi IP serving; " + (TextUtils.isEmpty(ifname) ? "no interface name specified" : "specified interface: " + ifname));
    }

    private void enableWifiIpServingLocked(String ifname, int wifiIpMode) {
        int ipServingMode;
        switch (wifiIpMode) {
            case 1: {
                ipServingMode = 2;
                break;
            }
            case 2: {
                ipServingMode = 3;
                break;
            }
            default: {
                this.mLog.e("Cannot enable IP serving in unknown WiFi mode: " + wifiIpMode);
                return;
            }
        }
        if (!TextUtils.isEmpty(ifname)) {
            this.maybeTrackNewInterfaceLocked(ifname, 0);
            this.changeInterfaceState(ifname, ipServingMode);
        } else {
            this.mLog.e(String.format("Cannot enable IP serving in mode %s on missing interface name", ipServingMode));
        }
    }

    private void tetherMatchingInterfaces(int requestedState, int interfaceType) {
        String[] ifaces = null;
        try {
            ifaces = this.mNMService.listInterfaces();
        }
        catch (Exception e) {
            Log.e(TAG, "Error listing Interfaces", e);
            return;
        }
        String chosenIface = null;
        if (ifaces != null) {
            for (String iface : ifaces) {
                if (this.ifaceNameToType(iface) != interfaceType) continue;
                chosenIface = iface;
                break;
            }
        }
        if (chosenIface == null) {
            Log.e(TAG, "could not find iface of type " + interfaceType);
            return;
        }
        this.changeInterfaceState(chosenIface, requestedState);
    }

    private void changeInterfaceState(String ifname, int requestedState) {
        int result;
        switch (requestedState) {
            case 0: 
            case 1: {
                result = this.untether(ifname);
                break;
            }
            case 2: 
            case 3: {
                result = this.tether(ifname, requestedState);
                break;
            }
            default: {
                Log.wtf(TAG, "Unknown interface state: " + requestedState);
                return;
            }
        }
        if (result != 0) {
            Log.e(TAG, "unable start or stop tethering on iface " + ifname);
            return;
        }
    }

    public TetheringConfiguration getTetheringConfiguration() {
        return this.mConfig;
    }

    public boolean hasTetherableConfiguration() {
        TetheringConfiguration cfg = this.mConfig;
        boolean hasDownstreamConfiguration = cfg.tetherableUsbRegexs.length != 0 || cfg.tetherableWifiRegexs.length != 0 || cfg.tetherableBluetoothRegexs.length != 0;
        boolean hasUpstreamConfiguration = !cfg.preferredUpstreamIfaceTypes.isEmpty();
        return hasDownstreamConfiguration && hasUpstreamConfiguration;
    }

    public String[] getTetherableUsbRegexs() {
        return Tethering.copy(this.mConfig.tetherableUsbRegexs);
    }

    public String[] getTetherableWifiRegexs() {
        return Tethering.copy(this.mConfig.tetherableWifiRegexs);
    }

    public String[] getTetherableBluetoothRegexs() {
        return Tethering.copy(this.mConfig.tetherableBluetoothRegexs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setUsbTethering(boolean enable) {
        UsbManager usbManager = (UsbManager)this.mContext.getSystemService("usb");
        Object object = this.mPublicSync;
        synchronized (object) {
            if (enable) {
                if (this.mRndisEnabled) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.tetherMatchingInterfaces(2, 1);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                } else {
                    this.mUsbTetherRequested = true;
                    usbManager.setCurrentFunction("rndis", false);
                }
            } else {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.tetherMatchingInterfaces(1, 1);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                if (this.mRndisEnabled) {
                    usbManager.setCurrentFunction(null, false);
                }
                this.mUsbTetherRequested = false;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetheredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                if (tetherState.lastState != 2) continue;
                list.add(this.mTetherStates.keyAt(i));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetherableIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                if (tetherState.lastState != 1) continue;
                list.add(this.mTetherStates.keyAt(i));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getTetheredDhcpRanges() {
        return this.mConfig.dhcpRanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getErroredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                if (tetherState.lastError == 0) continue;
                list.add(this.mTetherStates.keyAt(i));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void logMessage(State state, int what) {
        this.mLog.log(state.getName() + " got " + sMagicDecoderRing.get(what, Integer.toString(what)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upstreamWanted() {
        if (!this.mForwardedDownstreams.isEmpty()) {
            return true;
        }
        Object object = this.mPublicSync;
        synchronized (object) {
            return this.mUsbTetherRequested || this.mWifiTetherRequested;
        }
    }

    private boolean pertainsToCurrentUpstream(NetworkState ns) {
        if (ns != null && ns.linkProperties != null && this.mCurrentUpstreamIface != null) {
            for (String ifname : ns.linkProperties.getAllInterfaceNames()) {
                if (!this.mCurrentUpstreamIface.equals(ifname)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reevaluateSimCardProvisioning() {
        if (!this.hasMobileHotspotProvisionApp()) {
            return;
        }
        ArrayList<Integer> tethered = new ArrayList<Integer>();
        Iterator iterator = this.mPublicSync;
        synchronized (iterator) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                String iface;
                int interfaceType;
                TetherState tetherState = this.mTetherStates.valueAt(i);
                if (tetherState.lastState != 2 || (interfaceType = this.ifaceNameToType(iface = this.mTetherStates.keyAt(i))) == -1) continue;
                tethered.add(interfaceType);
            }
        }
        iterator = tethered.iterator();
        while (iterator.hasNext()) {
            int tetherType = (Integer)iterator.next();
            this.startProvisionIntent(tetherType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("Tethering:");
        pw.increaseIndent();
        pw.println("Configuration:");
        pw.increaseIndent();
        TetheringConfiguration cfg = this.mConfig;
        cfg.dump(pw);
        pw.decreaseIndent();
        Object object = this.mPublicSync;
        synchronized (object) {
            pw.println("Tether state:");
            pw.increaseIndent();
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                String iface = this.mTetherStates.keyAt(i);
                TetherState tetherState = this.mTetherStates.valueAt(i);
                pw.print(iface + " - ");
                switch (tetherState.lastState) {
                    case 0: {
                        pw.print("UnavailableState");
                        break;
                    }
                    case 1: {
                        pw.print("AvailableState");
                        break;
                    }
                    case 2: {
                        pw.print("TetheredState");
                        break;
                    }
                    case 3: {
                        pw.print("LocalHotspotState");
                        break;
                    }
                    default: {
                        pw.print("UnknownState");
                    }
                }
                pw.println(" - lastError = " + tetherState.lastError);
            }
            pw.println("Upstream wanted: " + this.upstreamWanted());
            pw.println("Current upstream interface: " + this.mCurrentUpstreamIface);
            pw.decreaseIndent();
        }
        pw.println("Hardware offload:");
        pw.increaseIndent();
        this.mOffloadController.dump(pw);
        pw.decreaseIndent();
        pw.println("Log:");
        pw.increaseIndent();
        if (Tethering.argsContain(args, "--short")) {
            pw.println("<log removed for brevity>");
        } else {
            this.mLog.dump(fd, pw, args);
        }
        pw.decreaseIndent();
        pw.decreaseIndent();
    }

    private static boolean argsContain(String[] args, String target) {
        for (String arg : args) {
            if (!target.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private IControlsTethering makeControlCallback(final String ifname) {
        return new IControlsTethering(){

            @Override
            public void updateInterfaceState(TetherInterfaceStateMachine who, int state, int lastError) {
                Tethering.this.notifyInterfaceStateChange(ifname, who, state, lastError);
            }

            @Override
            public void updateLinkProperties(TetherInterfaceStateMachine who, LinkProperties newLp) {
                Tethering.this.notifyLinkPropertiesChanged(ifname, who, newLp);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceStateChange(String iface, TetherInterfaceStateMachine who, int state, int error) {
        int which;
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState != null && tetherState.stateMachine.equals(who)) {
                tetherState.lastState = state;
                tetherState.lastError = error;
            }
        }
        this.mLog.log(String.format("OBSERVED iface=%s state=%s error=%s", iface, state, error));
        try {
            this.mPolicyManager.onTetheringChanged(iface, state == 2);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (error == 5) {
            this.mTetherMasterSM.sendMessage(327686, who);
        }
        switch (state) {
            case 0: 
            case 1: {
                which = 327682;
                break;
            }
            case 2: 
            case 3: {
                which = 327681;
                break;
            }
            default: {
                Log.wtf(TAG, "Unknown interface state: " + state);
                return;
            }
        }
        this.mTetherMasterSM.sendMessage(which, state, 0, who);
        this.sendTetherStateChangedBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLinkPropertiesChanged(String iface, TetherInterfaceStateMachine who, LinkProperties newLp) {
        int state;
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null || !tetherState.stateMachine.equals(who)) {
                this.mLog.log("got notification from stale iface " + iface);
                return;
            }
            state = tetherState.lastState;
        }
        this.mLog.log(String.format("OBSERVED LinkProperties update iface=%s state=%s lp=%s", iface, IControlsTethering.getStateString(state), newLp));
        int which = 327687;
        this.mTetherMasterSM.sendMessage(327687, state, 0, newLp);
    }

    private void maybeTrackNewInterfaceLocked(String iface) {
        int interfaceType = this.ifaceNameToType(iface);
        if (interfaceType == -1) {
            this.mLog.log(iface + " is not a tetherable iface, ignoring");
            return;
        }
        this.maybeTrackNewInterfaceLocked(iface, interfaceType);
    }

    private void maybeTrackNewInterfaceLocked(String iface, int interfaceType) {
        if (this.mTetherStates.containsKey(iface)) {
            this.mLog.log("active iface (" + iface + ") reported as added, ignoring");
            return;
        }
        this.mLog.log("adding TetheringInterfaceStateMachine for: " + iface);
        TetherState tetherState = new TetherState(new TetherInterfaceStateMachine(iface, this.mLooper, interfaceType, this.mLog, this.mNMService, this.mStatsService, this.makeControlCallback(iface)));
        this.mTetherStates.put(iface, tetherState);
        tetherState.stateMachine.start();
    }

    private void stopTrackingInterfaceLocked(String iface) {
        TetherState tetherState = this.mTetherStates.get(iface);
        if (tetherState == null) {
            this.mLog.log("attempting to remove unknown iface (" + iface + "), ignoring");
            return;
        }
        tetherState.stateMachine.stop();
        this.mLog.log("removing TetheringInterfaceStateMachine for: " + iface);
        this.mTetherStates.remove(iface);
    }

    private static String[] copy(String[] strarray) {
        return Arrays.copyOf(strarray, strarray.length);
    }

    class TetherMasterSM
    extends StateMachine {
        private static final int BASE_MASTER = 327680;
        static final int EVENT_IFACE_SERVING_STATE_ACTIVE = 327681;
        static final int EVENT_IFACE_SERVING_STATE_INACTIVE = 327682;
        static final int CMD_UPSTREAM_CHANGED = 327683;
        static final int CMD_RETRY_UPSTREAM = 327684;
        static final int EVENT_UPSTREAM_CALLBACK = 327685;
        static final int CMD_CLEAR_ERROR = 327686;
        static final int EVENT_IFACE_UPDATE_LINKPROPERTIES = 327687;
        private final State mInitialState;
        private final State mTetherModeAliveState;
        private final State mSetIpForwardingEnabledErrorState;
        private final State mSetIpForwardingDisabledErrorState;
        private final State mStartTetheringErrorState;
        private final State mStopTetheringErrorState;
        private final State mSetDnsForwardersErrorState;
        private final ArrayList<TetherInterfaceStateMachine> mNotifyList;
        private final IPv6TetheringCoordinator mIPv6TetheringCoordinator;
        private final OffloadWrapper mOffload;
        private static final int UPSTREAM_SETTLE_TIME_MS = 10000;

        TetherMasterSM(String name, Looper looper) {
            super(name, looper);
            this.mInitialState = new InitialState();
            this.mTetherModeAliveState = new TetherModeAliveState();
            this.mSetIpForwardingEnabledErrorState = new SetIpForwardingEnabledErrorState();
            this.mSetIpForwardingDisabledErrorState = new SetIpForwardingDisabledErrorState();
            this.mStartTetheringErrorState = new StartTetheringErrorState();
            this.mStopTetheringErrorState = new StopTetheringErrorState();
            this.mSetDnsForwardersErrorState = new SetDnsForwardersErrorState();
            this.addState(this.mInitialState);
            this.addState(this.mTetherModeAliveState);
            this.addState(this.mSetIpForwardingEnabledErrorState);
            this.addState(this.mSetIpForwardingDisabledErrorState);
            this.addState(this.mStartTetheringErrorState);
            this.addState(this.mStopTetheringErrorState);
            this.addState(this.mSetDnsForwardersErrorState);
            this.mNotifyList = new ArrayList();
            this.mIPv6TetheringCoordinator = new IPv6TetheringCoordinator(this.mNotifyList, Tethering.this.mLog);
            this.mOffload = new OffloadWrapper();
            this.setInitialState(this.mInitialState);
        }

        protected boolean turnOnMasterTetherSettings() {
            TetheringConfiguration cfg = Tethering.this.mConfig;
            try {
                Tethering.this.mNMService.setIpForwardingEnabled(true);
            }
            catch (Exception e) {
                Tethering.this.mLog.e(e);
                this.transitionTo(this.mSetIpForwardingEnabledErrorState);
                return false;
            }
            try {
                Tethering.this.mNMService.startTethering(cfg.dhcpRanges);
            }
            catch (Exception e) {
                try {
                    Tethering.this.mNMService.stopTethering();
                    Tethering.this.mNMService.startTethering(cfg.dhcpRanges);
                }
                catch (Exception ee) {
                    Tethering.this.mLog.e(ee);
                    this.transitionTo(this.mStartTetheringErrorState);
                    return false;
                }
            }
            Tethering.this.mLog.log("SET master tether settings: ON");
            return true;
        }

        protected boolean turnOffMasterTetherSettings() {
            try {
                Tethering.this.mNMService.stopTethering();
            }
            catch (Exception e) {
                Tethering.this.mLog.e(e);
                this.transitionTo(this.mStopTetheringErrorState);
                return false;
            }
            try {
                Tethering.this.mNMService.setIpForwardingEnabled(false);
            }
            catch (Exception e) {
                Tethering.this.mLog.e(e);
                this.transitionTo(this.mSetIpForwardingDisabledErrorState);
                return false;
            }
            this.transitionTo(this.mInitialState);
            Tethering.this.mLog.log("SET master tether settings: OFF");
            return true;
        }

        protected void chooseUpstreamType(boolean tryCell) {
            Tethering.this.maybeUpdateConfiguration();
            NetworkState ns = Tethering.this.mUpstreamNetworkMonitor.selectPreferredUpstreamType(((Tethering)Tethering.this).mConfig.preferredUpstreamIfaceTypes);
            if (ns == null) {
                if (tryCell) {
                    Tethering.this.mUpstreamNetworkMonitor.registerMobileNetworkRequest();
                } else {
                    this.sendMessageDelayed(327684, 10000L);
                }
            }
            Tethering.this.mUpstreamNetworkMonitor.setCurrentUpstream(ns != null ? ns.network : null);
            this.setUpstreamNetwork(ns);
        }

        protected void setUpstreamNetwork(NetworkState ns) {
            String iface = null;
            if (ns != null && ns.linkProperties != null) {
                Tethering.this.mLog.i("Finding IPv4 upstream interface on: " + ns.linkProperties);
                RouteInfo ipv4Default = RouteInfo.selectBestRoute(ns.linkProperties.getAllRoutes(), Inet4Address.ANY);
                if (ipv4Default != null) {
                    iface = ipv4Default.getInterface();
                    Tethering.this.mLog.i("Found interface " + ipv4Default.getInterface());
                } else {
                    Tethering.this.mLog.i("No IPv4 upstream interface, giving up.");
                }
            }
            if (iface != null) {
                this.setDnsForwarders(ns.network, ns.linkProperties);
            }
            this.notifyDownstreamsOfNewUpstreamIface(iface);
            if (ns != null && Tethering.this.pertainsToCurrentUpstream(ns)) {
                this.handleNewUpstreamNetworkState(ns);
            } else if (Tethering.this.mCurrentUpstreamIface == null) {
                this.handleNewUpstreamNetworkState(null);
            }
        }

        protected void setDnsForwarders(Network network, LinkProperties lp) {
            Object[] dnsServers = ((Tethering)Tethering.this).mConfig.defaultIPv4DNS;
            List<InetAddress> dnses = lp.getDnsServers();
            if (dnses != null && !dnses.isEmpty()) {
                dnsServers = NetworkUtils.makeStrings(dnses);
            }
            try {
                Tethering.this.mNMService.setDnsForwarders(network, (String[])dnsServers);
                Tethering.this.mLog.log(String.format("SET DNS forwarders: network=%s dnsServers=%s", network, Arrays.toString(dnsServers)));
            }
            catch (Exception e) {
                Tethering.this.mLog.e("setting DNS forwarders failed, " + e);
                this.transitionTo(this.mSetDnsForwardersErrorState);
            }
        }

        protected void notifyDownstreamsOfNewUpstreamIface(String ifaceName) {
            Tethering.this.mLog.log("Notifying downstreams of upstream=" + ifaceName);
            Tethering.this.mCurrentUpstreamIface = ifaceName;
            for (TetherInterfaceStateMachine sm : this.mNotifyList) {
                sm.sendMessage(327792, ifaceName);
            }
        }

        protected void handleNewUpstreamNetworkState(NetworkState ns) {
            this.mIPv6TetheringCoordinator.updateUpstreamNetworkState(ns);
            this.mOffload.updateUpstreamNetworkState(ns);
        }

        private void handleInterfaceServingStateActive(int mode, TetherInterfaceStateMachine who) {
            if (this.mNotifyList.indexOf(who) < 0) {
                this.mNotifyList.add(who);
                this.mIPv6TetheringCoordinator.addActiveDownstream(who, mode);
            }
            if (mode == 2) {
                Tethering.this.mForwardedDownstreams.add(who);
            } else {
                this.mOffload.excludeDownstreamInterface(who.interfaceName());
                Tethering.this.mForwardedDownstreams.remove(who);
            }
            if (who.interfaceType() == 0) {
                WifiManager mgr = Tethering.this.getWifiManager();
                String iface = who.interfaceName();
                switch (mode) {
                    case 2: {
                        mgr.updateInterfaceIpState(iface, 1);
                        break;
                    }
                    case 3: {
                        mgr.updateInterfaceIpState(iface, 2);
                        break;
                    }
                    default: {
                        Log.wtf(TAG, "Unknown active serving mode: " + mode);
                    }
                }
            }
        }

        private void handleInterfaceServingStateInactive(TetherInterfaceStateMachine who) {
            this.mNotifyList.remove(who);
            this.mIPv6TetheringCoordinator.removeActiveDownstream(who);
            this.mOffload.excludeDownstreamInterface(who.interfaceName());
            Tethering.this.mForwardedDownstreams.remove(who);
            if (who.interfaceType() == 0 && who.lastError() != 0) {
                Tethering.this.getWifiManager().updateInterfaceIpState(who.interfaceName(), 0);
            }
        }

        private void handleUpstreamNetworkMonitorCallback(int arg1, Object o) {
            if (arg1 == 10) {
                this.mOffload.sendOffloadExemptPrefixes((Set)o);
                return;
            }
            NetworkState ns = (NetworkState)o;
            if (ns == null || !Tethering.this.pertainsToCurrentUpstream(ns)) {
                if (Tethering.this.mCurrentUpstreamIface == null) {
                    this.chooseUpstreamType(false);
                }
                return;
            }
            switch (arg1) {
                case 1: {
                    break;
                }
                case 2: {
                    this.handleNewUpstreamNetworkState(ns);
                    break;
                }
                case 3: {
                    this.setDnsForwarders(ns.network, ns.linkProperties);
                    this.handleNewUpstreamNetworkState(ns);
                    break;
                }
                case 4: {
                    this.handleNewUpstreamNetworkState(null);
                    break;
                }
                default: {
                    Tethering.this.mLog.e("Unknown arg1 value: " + arg1);
                }
            }
        }

        class OffloadWrapper {
            OffloadWrapper() {
            }

            public void start() {
                Tethering.this.mOffloadController.start();
                this.sendOffloadExemptPrefixes();
            }

            public void stop() {
                Tethering.this.mOffloadController.stop();
            }

            public void updateUpstreamNetworkState(NetworkState ns) {
                Tethering.this.mOffloadController.setUpstreamLinkProperties(ns != null ? ns.linkProperties : null);
            }

            public void updateDownstreamLinkProperties(LinkProperties newLp) {
                this.sendOffloadExemptPrefixes();
                Tethering.this.mOffloadController.notifyDownstreamLinkProperties(newLp);
            }

            public void excludeDownstreamInterface(String ifname) {
                this.sendOffloadExemptPrefixes();
                Tethering.this.mOffloadController.removeDownstreamInterface(ifname);
            }

            public void sendOffloadExemptPrefixes() {
                this.sendOffloadExemptPrefixes(Tethering.this.mUpstreamNetworkMonitor.getLocalPrefixes());
            }

            public void sendOffloadExemptPrefixes(Set<IpPrefix> localPrefixes) {
                PrefixUtils.addNonForwardablePrefixes(localPrefixes);
                localPrefixes.add(PrefixUtils.DEFAULT_WIFI_P2P_PREFIX);
                for (TetherInterfaceStateMachine tism : TetherMasterSM.this.mNotifyList) {
                    LinkProperties lp = tism.linkProperties();
                    switch (tism.servingMode()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        case 2: {
                            for (LinkAddress addr : lp.getAllLinkAddresses()) {
                                InetAddress ip = addr.getAddress();
                                if (ip.isLinkLocalAddress()) continue;
                                localPrefixes.add(PrefixUtils.ipAddressAsPrefix(ip));
                            }
                            break;
                        }
                        case 3: {
                            localPrefixes.addAll(PrefixUtils.localPrefixesFrom(lp));
                        }
                    }
                }
                Tethering.this.mOffloadController.setLocalPrefixes(localPrefixes);
            }
        }

        class SetDnsForwardersErrorState
        extends ErrorState {
            SetDnsForwardersErrorState() {
            }

            @Override
            public void enter() {
                Log.e(TAG, "Error in setDnsForwarders");
                this.notify(327791);
                try {
                    Tethering.this.mNMService.stopTethering();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StopTetheringErrorState
        extends ErrorState {
            StopTetheringErrorState() {
            }

            @Override
            public void enter() {
                Log.e(TAG, "Error in stopTethering");
                this.notify(327790);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StartTetheringErrorState
        extends ErrorState {
            StartTetheringErrorState() {
            }

            @Override
            public void enter() {
                Log.e(TAG, "Error in startTethering");
                this.notify(327789);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class SetIpForwardingDisabledErrorState
        extends ErrorState {
            SetIpForwardingDisabledErrorState() {
            }

            @Override
            public void enter() {
                Log.e(TAG, "Error in setIpForwardingDisabled");
                this.notify(327788);
            }
        }

        class SetIpForwardingEnabledErrorState
        extends ErrorState {
            SetIpForwardingEnabledErrorState() {
            }

            @Override
            public void enter() {
                Log.e(TAG, "Error in setIpForwardingEnabled");
                this.notify(327787);
            }
        }

        class ErrorState
        extends State {
            private int mErrorNotification;

            ErrorState() {
            }

            @Override
            public boolean processMessage(Message message) {
                boolean retValue = true;
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        who.sendMessage(this.mErrorNotification);
                        break;
                    }
                    case 327686: {
                        this.mErrorNotification = 0;
                        TetherMasterSM.this.transitionTo(TetherMasterSM.this.mInitialState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }

            void notify(int msgType) {
                this.mErrorNotification = msgType;
                for (TetherInterfaceStateMachine sm : TetherMasterSM.this.mNotifyList) {
                    sm.sendMessage(msgType);
                }
            }
        }

        class TetherModeAliveState
        extends State {
            boolean mUpstreamWanted = false;
            boolean mTryCell = true;

            TetherModeAliveState() {
            }

            @Override
            public void enter() {
                if (!TetherMasterSM.this.turnOnMasterTetherSettings()) {
                    return;
                }
                Tethering.this.mSimChange.startListening();
                Tethering.this.mUpstreamNetworkMonitor.start();
                if (Tethering.this.upstreamWanted()) {
                    this.mUpstreamWanted = true;
                    TetherMasterSM.this.mOffload.start();
                    TetherMasterSM.this.chooseUpstreamType(true);
                    this.mTryCell = false;
                }
            }

            @Override
            public void exit() {
                TetherMasterSM.this.mOffload.stop();
                Tethering.this.mUpstreamNetworkMonitor.stop();
                Tethering.this.mSimChange.stopListening();
                TetherMasterSM.this.notifyDownstreamsOfNewUpstreamIface(null);
                TetherMasterSM.this.handleNewUpstreamNetworkState(null);
            }

            private boolean updateUpstreamWanted() {
                boolean previousUpstreamWanted = this.mUpstreamWanted;
                this.mUpstreamWanted = Tethering.this.upstreamWanted();
                if (this.mUpstreamWanted != previousUpstreamWanted) {
                    if (this.mUpstreamWanted) {
                        TetherMasterSM.this.mOffload.start();
                    } else {
                        TetherMasterSM.this.mOffload.stop();
                    }
                }
                return previousUpstreamWanted;
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.logMessage(this, message.what);
                boolean retValue = true;
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        TetherMasterSM.this.handleInterfaceServingStateActive(message.arg1, who);
                        who.sendMessage(327792, Tethering.this.mCurrentUpstreamIface);
                        boolean previousUpstreamWanted = this.updateUpstreamWanted();
                        if (previousUpstreamWanted || !this.mUpstreamWanted) break;
                        TetherMasterSM.this.chooseUpstreamType(true);
                        break;
                    }
                    case 327682: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        TetherMasterSM.this.handleInterfaceServingStateInactive(who);
                        if (TetherMasterSM.this.mNotifyList.isEmpty()) {
                            TetherMasterSM.this.turnOffMasterTetherSettings();
                            break;
                        }
                        boolean previousUpstreamWanted = this.updateUpstreamWanted();
                        if (!previousUpstreamWanted || this.mUpstreamWanted) break;
                        Tethering.this.mUpstreamNetworkMonitor.releaseMobileNetworkRequest();
                        break;
                    }
                    case 327687: {
                        LinkProperties newLp = (LinkProperties)message.obj;
                        if (message.arg1 == 2) {
                            TetherMasterSM.this.mOffload.updateDownstreamLinkProperties(newLp);
                            break;
                        }
                        TetherMasterSM.this.mOffload.excludeDownstreamInterface(newLp.getInterfaceName());
                        break;
                    }
                    case 327683: {
                        this.updateUpstreamWanted();
                        if (!this.mUpstreamWanted) break;
                        TetherMasterSM.this.chooseUpstreamType(true);
                        this.mTryCell = false;
                        break;
                    }
                    case 327684: {
                        this.updateUpstreamWanted();
                        if (!this.mUpstreamWanted) break;
                        TetherMasterSM.this.chooseUpstreamType(this.mTryCell);
                        this.mTryCell = !this.mTryCell;
                        break;
                    }
                    case 327685: {
                        this.updateUpstreamWanted();
                        if (!this.mUpstreamWanted) break;
                        TetherMasterSM.this.handleUpstreamNetworkMonitorCallback(message.arg1, message.obj);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class InitialState
        extends State {
            InitialState() {
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.logMessage(this, message.what);
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        TetherMasterSM.this.handleInterfaceServingStateActive(message.arg1, who);
                        TetherMasterSM.this.transitionTo(TetherMasterSM.this.mTetherModeAliveState);
                        break;
                    }
                    case 327682: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        TetherMasterSM.this.handleInterfaceServingStateInactive(who);
                        break;
                    }
                    case 327687: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }
    }

    private class StateReceiver
    extends BroadcastReceiver {
        private StateReceiver() {
        }

        @Override
        public void onReceive(Context content, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.hardware.usb.action.USB_STATE")) {
                this.handleUsbAction(intent);
            } else if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                this.handleConnectivityAction(intent);
            } else if (action.equals("android.net.wifi.WIFI_AP_STATE_CHANGED")) {
                this.handleWifiApAction(intent);
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                Tethering.this.updateConfiguration();
            }
        }

        private void handleConnectivityAction(Intent intent) {
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (networkInfo == null || networkInfo.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
                return;
            }
            Tethering.this.mTetherMasterSM.sendMessage(327683);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleUsbAction(Intent intent) {
            boolean usbConnected = intent.getBooleanExtra("connected", false);
            boolean usbConfigured = intent.getBooleanExtra("configured", false);
            boolean rndisEnabled = intent.getBooleanExtra("rndis", false);
            Tethering.this.mLog.log(String.format("USB bcast connected:%s configured:%s rndis:%s", usbConnected, usbConfigured, rndisEnabled));
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                Tethering.this.mRndisEnabled = rndisEnabled;
                if (usbConnected && !usbConfigured) {
                    return;
                }
                if (usbConfigured && Tethering.this.mRndisEnabled && Tethering.this.mUsbTetherRequested) {
                    Tethering.this.tetherMatchingInterfaces(2, 1);
                }
                Tethering.this.mUsbTetherRequested = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWifiApAction(Intent intent) {
            int curState = intent.getIntExtra("wifi_state", 11);
            String ifname = intent.getStringExtra("wifi_ap_interface_name");
            int ipmode = intent.getIntExtra("wifi_ap_mode", -1);
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                switch (curState) {
                    case 12: {
                        break;
                    }
                    case 13: {
                        Tethering.this.enableWifiIpServingLocked(ifname, ipmode);
                        break;
                    }
                    default: {
                        Tethering.this.disableWifiIpServingLocked(ifname, curState);
                    }
                }
            }
        }
    }

    private static class TetherState {
        public final TetherInterfaceStateMachine stateMachine;
        public int lastState;
        public int lastError;

        public TetherState(TetherInterfaceStateMachine sm) {
            this.stateMachine = sm;
            this.lastState = 1;
            this.lastError = 0;
        }

        public boolean isCurrentlyServing() {
            switch (this.lastState) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
    }
}

