/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.IpPrefix;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.NetworkState;
import android.net.util.PrefixUtils;
import android.net.util.SharedLog;
import android.os.Handler;
import android.util.Log;
import com.android.internal.util.StateMachine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class UpstreamNetworkMonitor {
    private static final String TAG = UpstreamNetworkMonitor.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final int EVENT_ON_AVAILABLE = 1;
    public static final int EVENT_ON_CAPABILITIES = 2;
    public static final int EVENT_ON_LINKPROPERTIES = 3;
    public static final int EVENT_ON_LOST = 4;
    public static final int NOTIFY_LOCAL_PREFIXES = 10;
    private static final int CALLBACK_LISTEN_ALL = 1;
    private static final int CALLBACK_TRACK_DEFAULT = 2;
    private static final int CALLBACK_MOBILE_REQUEST = 3;
    private final Context mContext;
    private final SharedLog mLog;
    private final StateMachine mTarget;
    private final Handler mHandler;
    private final int mWhat;
    private final HashMap<Network, NetworkState> mNetworkMap = new HashMap();
    private HashSet<IpPrefix> mLocalPrefixes;
    private ConnectivityManager mCM;
    private ConnectivityManager.NetworkCallback mListenAllCallback;
    private ConnectivityManager.NetworkCallback mDefaultNetworkCallback;
    private ConnectivityManager.NetworkCallback mMobileNetworkCallback;
    private boolean mDunRequired;
    private Network mDefaultInternetNetwork;
    private Network mTetheringUpstreamNetwork;

    public UpstreamNetworkMonitor(Context ctx, StateMachine tgt, SharedLog log, int what) {
        this.mContext = ctx;
        this.mTarget = tgt;
        this.mHandler = this.mTarget.getHandler();
        this.mLog = log.forSubComponent(TAG);
        this.mWhat = what;
        this.mLocalPrefixes = new HashSet();
    }

    public UpstreamNetworkMonitor(ConnectivityManager cm, StateMachine tgt, SharedLog log, int what) {
        this((Context)null, tgt, log, what);
        this.mCM = cm;
    }

    public void start() {
        this.stop();
        NetworkRequest listenAllRequest = new NetworkRequest.Builder().clearCapabilities().build();
        this.mListenAllCallback = new UpstreamNetworkCallback(1);
        this.cm().registerNetworkCallback(listenAllRequest, this.mListenAllCallback, this.mHandler);
        this.mDefaultNetworkCallback = new UpstreamNetworkCallback(2);
        this.cm().registerDefaultNetworkCallback(this.mDefaultNetworkCallback, this.mHandler);
    }

    public void stop() {
        this.releaseMobileNetworkRequest();
        this.releaseCallback(this.mDefaultNetworkCallback);
        this.mDefaultNetworkCallback = null;
        this.mDefaultInternetNetwork = null;
        this.releaseCallback(this.mListenAllCallback);
        this.mListenAllCallback = null;
        this.mTetheringUpstreamNetwork = null;
        this.mNetworkMap.clear();
    }

    public void updateMobileRequiresDun(boolean dunRequired) {
        boolean valueChanged = this.mDunRequired != dunRequired;
        this.mDunRequired = dunRequired;
        if (valueChanged && this.mobileNetworkRequested()) {
            this.releaseMobileNetworkRequest();
            this.registerMobileNetworkRequest();
        }
    }

    public boolean mobileNetworkRequested() {
        return this.mMobileNetworkCallback != null;
    }

    public void registerMobileNetworkRequest() {
        if (this.mMobileNetworkCallback != null) {
            this.mLog.e("registerMobileNetworkRequest() already registered");
            return;
        }
        int legacyType = this.mDunRequired ? 4 : 5;
        NetworkRequest mobileUpstreamRequest = new NetworkRequest.Builder().setCapabilities(ConnectivityManager.networkCapabilitiesForType(legacyType)).build();
        this.mMobileNetworkCallback = new UpstreamNetworkCallback(3);
        this.mLog.i("requesting mobile upstream network: " + mobileUpstreamRequest);
        this.cm().requestNetwork(mobileUpstreamRequest, this.mMobileNetworkCallback, 0, legacyType, this.mHandler);
    }

    public void releaseMobileNetworkRequest() {
        if (this.mMobileNetworkCallback == null) {
            return;
        }
        this.cm().unregisterNetworkCallback(this.mMobileNetworkCallback);
        this.mMobileNetworkCallback = null;
    }

    public NetworkState selectPreferredUpstreamType(Iterable<Integer> preferredTypes) {
        TypeStatePair typeStatePair = UpstreamNetworkMonitor.findFirstAvailableUpstreamByType(this.mNetworkMap.values(), preferredTypes);
        this.mLog.log("preferred upstream type: " + ConnectivityManager.getNetworkTypeName(typeStatePair.type));
        switch (typeStatePair.type) {
            case 4: 
            case 5: {
                this.registerMobileNetworkRequest();
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.releaseMobileNetworkRequest();
            }
        }
        return typeStatePair.ns;
    }

    public void setCurrentUpstream(Network upstream) {
        this.mTetheringUpstreamNetwork = upstream;
    }

    public Set<IpPrefix> getLocalPrefixes() {
        return (Set)this.mLocalPrefixes.clone();
    }

    private void handleAvailable(int callbackType, Network network) {
        if (!this.mNetworkMap.containsKey(network)) {
            this.mNetworkMap.put(network, new NetworkState(null, null, null, network, null, null));
        }
        switch (callbackType) {
            case 1: {
                break;
            }
            case 2: {
                if (this.mDefaultNetworkCallback == null) {
                    return;
                }
                this.mDefaultInternetNetwork = network;
                break;
            }
            case 3: {
                if (this.mMobileNetworkCallback != null) break;
                return;
            }
        }
        this.notifyTarget(1, network);
    }

    private void handleNetCap(Network network, NetworkCapabilities newNc) {
        NetworkState prev = this.mNetworkMap.get(network);
        if (prev == null || newNc.equals(prev.networkCapabilities)) {
            return;
        }
        if (network.equals(this.mTetheringUpstreamNetwork) && newNc.hasSignalStrength()) {
            int newSignal = newNc.getSignalStrength();
            String prevSignal = UpstreamNetworkMonitor.getSignalStrength(prev.networkCapabilities);
            this.mLog.logf("upstream network signal strength: %s -> %s", prevSignal, newSignal);
        }
        this.mNetworkMap.put(network, new NetworkState(null, prev.linkProperties, newNc, network, null, null));
        this.notifyTarget(2, network);
    }

    private void handleLinkProp(Network network, LinkProperties newLp) {
        NetworkState prev = this.mNetworkMap.get(network);
        if (prev == null || newLp.equals(prev.linkProperties)) {
            return;
        }
        this.mNetworkMap.put(network, new NetworkState(null, newLp, prev.networkCapabilities, network, null, null));
        this.notifyTarget(3, network);
    }

    private void handleSuspended(int callbackType, Network network) {
        if (callbackType != 1) {
            return;
        }
        if (!network.equals(this.mTetheringUpstreamNetwork)) {
            return;
        }
        this.mLog.log("SUSPENDED current upstream: " + network);
    }

    private void handleResumed(int callbackType, Network network) {
        if (callbackType != 1) {
            return;
        }
        if (!network.equals(this.mTetheringUpstreamNetwork)) {
            return;
        }
        this.mLog.log("RESUMED current upstream: " + network);
    }

    private void handleLost(int callbackType, Network network) {
        if (callbackType == 2) {
            this.mDefaultInternetNetwork = null;
            return;
        }
        if (!this.mNetworkMap.containsKey(network)) {
            return;
        }
        this.notifyTarget(4, this.mNetworkMap.remove(network));
    }

    private void recomputeLocalPrefixes() {
        HashSet<IpPrefix> localPrefixes = UpstreamNetworkMonitor.allLocalPrefixes(this.mNetworkMap.values());
        if (!this.mLocalPrefixes.equals(localPrefixes)) {
            this.mLocalPrefixes = localPrefixes;
            this.notifyTarget(10, localPrefixes.clone());
        }
    }

    private ConnectivityManager cm() {
        if (this.mCM == null) {
            this.mCM = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        return this.mCM;
    }

    private void releaseCallback(ConnectivityManager.NetworkCallback cb) {
        if (cb != null) {
            this.cm().unregisterNetworkCallback(cb);
        }
    }

    private void notifyTarget(int which, Network network) {
        this.notifyTarget(which, this.mNetworkMap.get(network));
    }

    private void notifyTarget(int which, Object obj) {
        this.mTarget.sendMessage(this.mWhat, which, 0, obj);
    }

    private static TypeStatePair findFirstAvailableUpstreamByType(Iterable<NetworkState> netStates, Iterable<Integer> preferredTypes) {
        TypeStatePair result = new TypeStatePair();
        for (int type : preferredTypes) {
            NetworkCapabilities nc;
            try {
                nc = ConnectivityManager.networkCapabilitiesForType(type);
            }
            catch (IllegalArgumentException iae) {
                Log.e(TAG, "No NetworkCapabilities mapping for legacy type: " + ConnectivityManager.getNetworkTypeName(type));
                continue;
            }
            for (NetworkState value : netStates) {
                if (!nc.satisfiedByNetworkCapabilities(value.networkCapabilities)) continue;
                result.type = type;
                result.ns = value;
                return result;
            }
        }
        return result;
    }

    private static HashSet<IpPrefix> allLocalPrefixes(Iterable<NetworkState> netStates) {
        HashSet<IpPrefix> prefixSet = new HashSet<IpPrefix>();
        for (NetworkState ns : netStates) {
            LinkProperties lp = ns.linkProperties;
            if (lp == null) continue;
            prefixSet.addAll(PrefixUtils.localPrefixesFrom(lp));
        }
        return prefixSet;
    }

    private static String getSignalStrength(NetworkCapabilities nc) {
        if (nc == null || !nc.hasSignalStrength()) {
            return "unknown";
        }
        return Integer.toString(nc.getSignalStrength());
    }

    private static class TypeStatePair {
        public int type = -1;
        public NetworkState ns = null;

        private TypeStatePair() {
        }
    }

    private class UpstreamNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private final int mCallbackType;

        UpstreamNetworkCallback(int callbackType) {
            this.mCallbackType = callbackType;
        }

        @Override
        public void onAvailable(Network network) {
            UpstreamNetworkMonitor.this.handleAvailable(this.mCallbackType, network);
        }

        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities newNc) {
            UpstreamNetworkMonitor.this.handleNetCap(network, newNc);
        }

        @Override
        public void onLinkPropertiesChanged(Network network, LinkProperties newLp) {
            UpstreamNetworkMonitor.this.handleLinkProp(network, newLp);
            UpstreamNetworkMonitor.this.recomputeLocalPrefixes();
        }

        @Override
        public void onNetworkSuspended(Network network) {
            UpstreamNetworkMonitor.this.handleSuspended(this.mCallbackType, network);
        }

        @Override
        public void onNetworkResumed(Network network) {
            UpstreamNetworkMonitor.this.handleResumed(this.mCallbackType, network);
        }

        @Override
        public void onLost(Network network) {
            UpstreamNetworkMonitor.this.handleLost(this.mCallbackType, network);
            UpstreamNetworkMonitor.this.recomputeLocalPrefixes();
        }
    }
}

