/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.AlarmManager;
import android.app.admin.NetworkEvent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.LongSparseArray;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.util.ArrayList;
import java.util.List;

final class NetworkLoggingHandler
extends Handler {
    private static final String TAG = NetworkLoggingHandler.class.getSimpleName();
    static final String NETWORK_EVENT_KEY = "network_event";
    private static final int MAX_EVENTS_PER_BATCH = 1200;
    private static final int MAX_BATCHES = 5;
    private static final long BATCH_FINALIZATION_TIMEOUT_MS = 5400000L;
    private static final long BATCH_FINALIZATION_TIMEOUT_ALARM_INTERVAL_MS = 1800000L;
    private static final String NETWORK_LOGGING_TIMEOUT_ALARM_TAG = "NetworkLogging.batchTimeout";
    private static final long RETRIEVED_BATCH_DISCARD_DELAY_MS = 300000L;
    private final DevicePolicyManagerService mDpm;
    private final AlarmManager mAlarmManager;
    private final AlarmManager.OnAlarmListener mBatchTimeoutAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            Slog.d(TAG, "Received a batch finalization timeout alarm, finalizing " + NetworkLoggingHandler.this.mNetworkEvents.size() + " pending events.");
            Bundle notificationExtras = null;
            NetworkLoggingHandler networkLoggingHandler = NetworkLoggingHandler.this;
            synchronized (networkLoggingHandler) {
                notificationExtras = NetworkLoggingHandler.this.finalizeBatchAndBuildDeviceOwnerMessageLocked();
            }
            if (notificationExtras != null) {
                NetworkLoggingHandler.this.notifyDeviceOwner(notificationExtras);
            }
        }
    };
    static final int LOG_NETWORK_EVENT_MSG = 1;
    @GuardedBy(value="this")
    private ArrayList<NetworkEvent> mNetworkEvents = new ArrayList();
    @GuardedBy(value="this")
    private final LongSparseArray<ArrayList<NetworkEvent>> mBatches = new LongSparseArray(5);
    @GuardedBy(value="this")
    private boolean mPaused = false;
    @GuardedBy(value="this")
    private long mCurrentBatchToken;
    @GuardedBy(value="this")
    private long mLastRetrievedBatchToken;

    NetworkLoggingHandler(Looper looper, DevicePolicyManagerService dpm) {
        super(looper);
        this.mDpm = dpm;
        this.mAlarmManager = this.mDpm.mInjector.getAlarmManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                NetworkEvent networkEvent = (NetworkEvent)msg.getData().getParcelable(NETWORK_EVENT_KEY);
                if (networkEvent == null) break;
                Bundle notificationExtras = null;
                NetworkLoggingHandler networkLoggingHandler = this;
                synchronized (networkLoggingHandler) {
                    this.mNetworkEvents.add(networkEvent);
                    if (this.mNetworkEvents.size() >= 1200) {
                        notificationExtras = this.finalizeBatchAndBuildDeviceOwnerMessageLocked();
                    }
                }
                if (notificationExtras == null) break;
                this.notifyDeviceOwner(notificationExtras);
                break;
            }
            default: {
                Slog.d(TAG, "NetworkLoggingHandler received an unknown of message.");
            }
        }
    }

    void scheduleBatchFinalization() {
        long when = SystemClock.elapsedRealtime() + 5400000L;
        this.mAlarmManager.setWindow(2, when, 1800000L, NETWORK_LOGGING_TIMEOUT_ALARM_TAG, this.mBatchTimeoutAlarmListener, this);
        Slog.d(TAG, "Scheduled a new batch finalization alarm 5400000ms from now.");
    }

    synchronized void pause() {
        Slog.d(TAG, "Paused network logging");
        this.mPaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Bundle notificationExtras = null;
        NetworkLoggingHandler networkLoggingHandler = this;
        synchronized (networkLoggingHandler) {
            if (!this.mPaused) {
                Slog.d(TAG, "Attempted to resume network logging, but logging is not paused.");
                return;
            }
            Slog.d(TAG, "Resumed network logging. Current batch=" + this.mCurrentBatchToken + ", LastRetrievedBatch=" + this.mLastRetrievedBatchToken);
            this.mPaused = false;
            if (this.mBatches.size() > 0 && this.mLastRetrievedBatchToken != this.mCurrentBatchToken) {
                this.scheduleBatchFinalization();
                notificationExtras = this.buildDeviceOwnerMessageLocked();
            }
        }
        if (notificationExtras != null) {
            this.notifyDeviceOwner(notificationExtras);
        }
    }

    synchronized void discardLogs() {
        this.mBatches.clear();
        this.mNetworkEvents = new ArrayList();
        Slog.d(TAG, "Discarded all network logs");
    }

    @GuardedBy(value="this")
    private Bundle finalizeBatchAndBuildDeviceOwnerMessageLocked() {
        Bundle notificationExtras = null;
        if (this.mNetworkEvents.size() > 0) {
            if (this.mBatches.size() >= 5) {
                this.mBatches.removeAt(0);
            }
            ++this.mCurrentBatchToken;
            this.mBatches.append(this.mCurrentBatchToken, this.mNetworkEvents);
            this.mNetworkEvents = new ArrayList();
            if (!this.mPaused) {
                notificationExtras = this.buildDeviceOwnerMessageLocked();
            }
        } else {
            Slog.d(TAG, "Was about to finalize the batch, but there were no events to send to the DPC, the batchToken of last available batch: " + this.mCurrentBatchToken);
        }
        this.scheduleBatchFinalization();
        return notificationExtras;
    }

    @GuardedBy(value="this")
    private Bundle buildDeviceOwnerMessageLocked() {
        Bundle extras = new Bundle();
        int lastBatchSize = this.mBatches.valueAt(this.mBatches.size() - 1).size();
        extras.putLong("android.app.extra.EXTRA_NETWORK_LOGS_TOKEN", this.mCurrentBatchToken);
        extras.putInt("android.app.extra.EXTRA_NETWORK_LOGS_COUNT", lastBatchSize);
        return extras;
    }

    private void notifyDeviceOwner(Bundle extras) {
        Slog.d(TAG, "Sending network logging batch broadcast to device owner, batchToken: " + extras.getLong("android.app.extra.EXTRA_NETWORK_LOGS_TOKEN", -1L));
        if (Thread.holdsLock(this)) {
            Slog.wtfStack(TAG, "Shouldn't be called with NetworkLoggingHandler lock held");
            return;
        }
        this.mDpm.sendDeviceOwnerCommand("android.app.action.NETWORK_LOGS_AVAILABLE", extras);
    }

    synchronized List<NetworkEvent> retrieveFullLogBatch(long batchToken) {
        int index = this.mBatches.indexOfKey(batchToken);
        if (index < 0) {
            return null;
        }
        this.postDelayed(() -> {
            NetworkLoggingHandler networkLoggingHandler = this;
            synchronized (networkLoggingHandler) {
                while (this.mBatches.size() > 0 && this.mBatches.keyAt(0) <= batchToken) {
                    this.mBatches.removeAt(0);
                }
            }
        }, 300000L);
        this.mLastRetrievedBatchToken = batchToken;
        return this.mBatches.valueAt(index);
    }
}

