/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiLogger;
import java.util.ArrayList;
import java.util.Iterator;

final class DelayedMessageBuffer {
    private final ArrayList<HdmiCecMessage> mBuffer = new ArrayList();
    private final HdmiCecLocalDevice mDevice;

    DelayedMessageBuffer(HdmiCecLocalDevice device) {
        this.mDevice = device;
    }

    void add(HdmiCecMessage message) {
        boolean buffered = true;
        switch (message.getOpcode()) {
            case 130: {
                this.removeActiveSource();
                this.mBuffer.add(message);
                break;
            }
            case 114: 
            case 192: {
                this.mBuffer.add(message);
                break;
            }
            default: {
                buffered = false;
            }
        }
        if (buffered) {
            HdmiLogger.debug("Buffering message:" + message, new Object[0]);
        }
    }

    private void removeActiveSource() {
        Iterator<HdmiCecMessage> iter = this.mBuffer.iterator();
        while (iter.hasNext()) {
            HdmiCecMessage message = iter.next();
            if (message.getOpcode() != 130) continue;
            iter.remove();
        }
    }

    boolean isBuffered(int opcode) {
        for (HdmiCecMessage message : this.mBuffer) {
            if (message.getOpcode() != opcode) continue;
            return true;
        }
        return false;
    }

    void processAllMessages() {
        ArrayList<HdmiCecMessage> copiedBuffer = new ArrayList<HdmiCecMessage>(this.mBuffer);
        this.mBuffer.clear();
        for (HdmiCecMessage message : copiedBuffer) {
            this.mDevice.onMessage(message);
            HdmiLogger.debug("Processing message:" + message, new Object[0]);
        }
    }

    void processMessagesForDevice(int address) {
        ArrayList<HdmiCecMessage> copiedBuffer = new ArrayList<HdmiCecMessage>(this.mBuffer);
        this.mBuffer.clear();
        HdmiLogger.debug("Checking message for address:" + address, new Object[0]);
        for (HdmiCecMessage message : copiedBuffer) {
            if (message.getSource() != address) {
                this.mBuffer.add(message);
                continue;
            }
            if (message.getOpcode() == 130 && !this.mDevice.isInputReady(HdmiDeviceInfo.idForCecDevice(address))) {
                this.mBuffer.add(message);
                continue;
            }
            this.mDevice.onMessage(message);
            HdmiLogger.debug("Processing message:" + message, new Object[0]);
        }
    }

    void processActiveSource(int address) {
        ArrayList<HdmiCecMessage> copiedBuffer = new ArrayList<HdmiCecMessage>(this.mBuffer);
        this.mBuffer.clear();
        for (HdmiCecMessage message : copiedBuffer) {
            if (message.getOpcode() == 130 && message.getSource() == address) {
                this.mDevice.onMessage(message);
                HdmiLogger.debug("Processing message:" + message, new Object[0]);
                continue;
            }
            this.mBuffer.add(message);
        }
    }
}

