/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiControlService;

public class SelectRequestBuffer {
    private static final String TAG = "SelectRequestBuffer";
    public static final SelectRequestBuffer EMPTY_BUFFER = new SelectRequestBuffer(){

        @Override
        public void process() {
        }
    };
    private SelectRequest mRequest;

    public static DeviceSelectRequest newDeviceSelect(HdmiControlService srv, int id2, IHdmiControlCallback callback) {
        return new DeviceSelectRequest(srv, id2, callback);
    }

    public static PortSelectRequest newPortSelect(HdmiControlService srv, int id2, IHdmiControlCallback callback) {
        return new PortSelectRequest(srv, id2, callback);
    }

    public void set(SelectRequest request) {
        this.mRequest = request;
    }

    public void process() {
        if (this.mRequest != null) {
            this.mRequest.process();
            this.clear();
        }
    }

    public void clear() {
        this.mRequest = null;
    }

    public static class PortSelectRequest
    extends SelectRequest {
        private PortSelectRequest(HdmiControlService srv, int id2, IHdmiControlCallback callback) {
            super(srv, id2, callback);
        }

        @Override
        public void process() {
            if (this.isLocalDeviceReady()) {
                Slog.v(SelectRequestBuffer.TAG, "calling delayed portSelect id:" + this.mId);
                this.tv().doManualPortSwitching(this.mId, this.mCallback);
            }
        }
    }

    public static class DeviceSelectRequest
    extends SelectRequest {
        private DeviceSelectRequest(HdmiControlService srv, int id2, IHdmiControlCallback callback) {
            super(srv, id2, callback);
        }

        @Override
        public void process() {
            if (this.isLocalDeviceReady()) {
                Slog.v(SelectRequestBuffer.TAG, "calling delayed deviceSelect id:" + this.mId);
                this.tv().deviceSelect(this.mId, this.mCallback);
            }
        }
    }

    public static abstract class SelectRequest {
        protected final HdmiControlService mService;
        protected final IHdmiControlCallback mCallback;
        protected final int mId;

        public SelectRequest(HdmiControlService service, int id2, IHdmiControlCallback callback) {
            this.mService = service;
            this.mId = id2;
            this.mCallback = callback;
        }

        protected HdmiCecLocalDeviceTv tv() {
            return this.mService.tv();
        }

        protected boolean isLocalDeviceReady() {
            if (this.tv() == null) {
                Slog.e(SelectRequestBuffer.TAG, "Local tv device not available");
                this.invokeCallback(2);
                return false;
            }
            return true;
        }

        private void invokeCallback(int reason) {
            try {
                if (this.mCallback != null) {
                    this.mCallback.onComplete(reason);
                }
            }
            catch (RemoteException e) {
                Slog.e(SelectRequestBuffer.TAG, "Invoking callback failed:" + e);
            }
        }

        public abstract void process();
    }
}

