/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.location.Country;
import android.location.CountryListener;
import android.location.Geocoder;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.server.location.CountryDetectorBase;
import com.android.server.location.LocationBasedCountryDetector;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ComprehensiveCountryDetector
extends CountryDetectorBase {
    private static final String TAG = "CountryDetector";
    static final boolean DEBUG = false;
    private static final int MAX_LENGTH_DEBUG_LOGS = 20;
    private static final long LOCATION_REFRESH_INTERVAL = 86400000L;
    protected CountryDetectorBase mLocationBasedCountryDetector;
    protected Timer mLocationRefreshTimer;
    private Country mCountry;
    private final TelephonyManager mTelephonyManager;
    private Country mCountryFromLocation;
    private boolean mStopped = false;
    private PhoneStateListener mPhoneStateListener;
    private final ConcurrentLinkedQueue<Country> mDebugLogs = new ConcurrentLinkedQueue();
    private Country mLastCountryAddedToLogs;
    private final Object mObject = new Object();
    private long mStartTime;
    private long mStopTime;
    private long mTotalTime;
    private int mCountServiceStateChanges;
    private int mTotalCountServiceStateChanges;
    private CountryListener mLocationBasedCountryDetectionListener = new CountryListener(){

        @Override
        public void onCountryDetected(Country country) {
            ComprehensiveCountryDetector.this.mCountryFromLocation = country;
            ComprehensiveCountryDetector.this.detectCountry(true, false);
            ComprehensiveCountryDetector.this.stopLocationBasedDetector();
        }
    };

    public ComprehensiveCountryDetector(Context context) {
        super(context);
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
    }

    @Override
    public Country detectCountry() {
        return this.detectCountry(false, !this.mStopped);
    }

    @Override
    public void stop() {
        Slog.i(TAG, "Stop the detector.");
        this.cancelLocationRefresh();
        this.removePhoneStateListener();
        this.stopLocationBasedDetector();
        this.mListener = null;
        this.mStopped = true;
    }

    private Country getCountry() {
        Country result = null;
        result = this.getNetworkBasedCountry();
        if (result == null) {
            result = this.getLastKnownLocationBasedCountry();
        }
        if (result == null) {
            result = this.getSimBasedCountry();
        }
        if (result == null) {
            result = this.getLocaleCountry();
        }
        this.addToLogs(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLogs(Country country) {
        if (country == null) {
            return;
        }
        Object object = this.mObject;
        synchronized (object) {
            if (this.mLastCountryAddedToLogs != null && this.mLastCountryAddedToLogs.equals(country)) {
                return;
            }
            this.mLastCountryAddedToLogs = country;
        }
        if (this.mDebugLogs.size() >= 20) {
            this.mDebugLogs.poll();
        }
        this.mDebugLogs.add(country);
    }

    private boolean isNetworkCountryCodeAvailable() {
        int phoneType = this.mTelephonyManager.getPhoneType();
        return phoneType == 1;
    }

    protected Country getNetworkBasedCountry() {
        String countryIso = null;
        if (this.isNetworkCountryCodeAvailable() && !TextUtils.isEmpty(countryIso = this.mTelephonyManager.getNetworkCountryIso())) {
            return new Country(countryIso, 0);
        }
        return null;
    }

    protected Country getLastKnownLocationBasedCountry() {
        return this.mCountryFromLocation;
    }

    protected Country getSimBasedCountry() {
        String countryIso = null;
        countryIso = this.mTelephonyManager.getSimCountryIso();
        if (!TextUtils.isEmpty(countryIso)) {
            return new Country(countryIso, 2);
        }
        return null;
    }

    protected Country getLocaleCountry() {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != null) {
            return new Country(defaultLocale.getCountry(), 3);
        }
        return null;
    }

    private Country detectCountry(boolean notifyChange, boolean startLocationBasedDetection) {
        Country country = this.getCountry();
        this.runAfterDetectionAsync(this.mCountry != null ? new Country(this.mCountry) : this.mCountry, country, notifyChange, startLocationBasedDetection);
        this.mCountry = country;
        return this.mCountry;
    }

    protected void runAfterDetectionAsync(final Country country, final Country detectedCountry, final boolean notifyChange, final boolean startLocationBasedDetection) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ComprehensiveCountryDetector.this.runAfterDetection(country, detectedCountry, notifyChange, startLocationBasedDetection);
            }
        });
    }

    @Override
    public void setCountryListener(CountryListener listener) {
        CountryListener prevListener = this.mListener;
        this.mListener = listener;
        if (this.mListener == null) {
            this.removePhoneStateListener();
            this.stopLocationBasedDetector();
            this.cancelLocationRefresh();
            this.mStopTime = SystemClock.elapsedRealtime();
            this.mTotalTime += this.mStopTime;
        } else if (prevListener == null) {
            this.addPhoneStateListener();
            this.detectCountry(false, true);
            this.mStartTime = SystemClock.elapsedRealtime();
            this.mStopTime = 0L;
            this.mCountServiceStateChanges = 0;
        }
    }

    void runAfterDetection(Country country, Country detectedCountry, boolean notifyChange, boolean startLocationBasedDetection) {
        if (notifyChange) {
            this.notifyIfCountryChanged(country, detectedCountry);
        }
        if (startLocationBasedDetection && (detectedCountry == null || detectedCountry.getSource() > 1) && this.isAirplaneModeOff() && this.mListener != null && this.isGeoCoderImplemented()) {
            this.startLocationBasedDetector(this.mLocationBasedCountryDetectionListener);
        }
        if (detectedCountry == null || detectedCountry.getSource() >= 1) {
            this.scheduleLocationRefresh();
        } else {
            this.cancelLocationRefresh();
            this.stopLocationBasedDetector();
        }
    }

    private synchronized void startLocationBasedDetector(CountryListener listener) {
        if (this.mLocationBasedCountryDetector != null) {
            return;
        }
        this.mLocationBasedCountryDetector = this.createLocationBasedCountryDetector();
        this.mLocationBasedCountryDetector.setCountryListener(listener);
        this.mLocationBasedCountryDetector.detectCountry();
    }

    private synchronized void stopLocationBasedDetector() {
        if (this.mLocationBasedCountryDetector != null) {
            this.mLocationBasedCountryDetector.stop();
            this.mLocationBasedCountryDetector = null;
        }
    }

    protected CountryDetectorBase createLocationBasedCountryDetector() {
        return new LocationBasedCountryDetector(this.mContext);
    }

    protected boolean isAirplaneModeOff() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 0;
    }

    private void notifyIfCountryChanged(Country country, Country detectedCountry) {
        if (!(detectedCountry == null || this.mListener == null || country != null && country.equals(detectedCountry))) {
            this.notifyListener(detectedCountry);
        }
    }

    private synchronized void scheduleLocationRefresh() {
        if (this.mLocationRefreshTimer != null) {
            return;
        }
        this.mLocationRefreshTimer = new Timer();
        this.mLocationRefreshTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ComprehensiveCountryDetector.this.mLocationRefreshTimer = null;
                ComprehensiveCountryDetector.this.detectCountry(false, true);
            }
        }, 86400000L);
    }

    private synchronized void cancelLocationRefresh() {
        if (this.mLocationRefreshTimer != null) {
            this.mLocationRefreshTimer.cancel();
            this.mLocationRefreshTimer = null;
        }
    }

    protected synchronized void addPhoneStateListener() {
        if (this.mPhoneStateListener == null) {
            this.mPhoneStateListener = new PhoneStateListener(){

                @Override
                public void onServiceStateChanged(ServiceState serviceState) {
                    ComprehensiveCountryDetector.this.mCountServiceStateChanges++;
                    ComprehensiveCountryDetector.this.mTotalCountServiceStateChanges++;
                    if (!ComprehensiveCountryDetector.this.isNetworkCountryCodeAvailable()) {
                        return;
                    }
                    ComprehensiveCountryDetector.this.detectCountry(true, true);
                }
            };
            this.mTelephonyManager.listen(this.mPhoneStateListener, 1);
        }
    }

    protected synchronized void removePhoneStateListener() {
        if (this.mPhoneStateListener != null) {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
            this.mPhoneStateListener = null;
        }
    }

    protected boolean isGeoCoderImplemented() {
        return Geocoder.isPresent();
    }

    public String toString() {
        long currentTime = SystemClock.elapsedRealtime();
        long currentSessionLength = 0L;
        StringBuilder sb = new StringBuilder();
        sb.append("ComprehensiveCountryDetector{");
        if (this.mStopTime == 0L) {
            currentSessionLength = currentTime - this.mStartTime;
            sb.append("timeRunning=" + currentSessionLength + ", ");
        } else {
            sb.append("lastRunTimeLength=" + (this.mStopTime - this.mStartTime) + ", ");
        }
        sb.append("totalCountServiceStateChanges=" + this.mTotalCountServiceStateChanges + ", ");
        sb.append("currentCountServiceStateChanges=" + this.mCountServiceStateChanges + ", ");
        sb.append("totalTime=" + (this.mTotalTime + currentSessionLength) + ", ");
        sb.append("currentTime=" + currentTime + ", ");
        sb.append("countries=");
        for (Country country : this.mDebugLogs) {
            sb.append("\n   " + country.toString());
        }
        sb.append("}");
        return sb.toString();
    }
}

