/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings;

import android.app.ActivityManager;
import android.content.Context;
import android.os.RemoteException;
import android.os.ShellCommand;
import com.android.internal.widget.LockPatternUtils;

class LockSettingsShellCommand
extends ShellCommand {
    private static final String COMMAND_SET_PATTERN = "set-pattern";
    private static final String COMMAND_SET_PIN = "set-pin";
    private static final String COMMAND_SET_PASSWORD = "set-password";
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_SP = "sp";
    private static final String COMMAND_SET_DISABLED = "set-disabled";
    private static final String COMMAND_VERIFY = "verify";
    private static final String COMMAND_GET_DISABLED = "get-disabled";
    private int mCurrentUserId;
    private final LockPatternUtils mLockPatternUtils;
    private final Context mContext;
    private String mOld = "";
    private String mNew = "";

    LockSettingsShellCommand(Context context, LockPatternUtils lockPatternUtils) {
        this.mContext = context;
        this.mLockPatternUtils = lockPatternUtils;
    }

    @Override
    public int onCommand(String cmd) {
        try {
            this.mCurrentUserId = ActivityManager.getService().getCurrentUser().id;
            this.parseArgs();
            if (!this.checkCredential()) {
                return -1;
            }
            switch (cmd) {
                case "set-pattern": {
                    this.runSetPattern();
                    break;
                }
                case "set-password": {
                    this.runSetPassword();
                    break;
                }
                case "set-pin": {
                    this.runSetPin();
                    break;
                }
                case "clear": {
                    this.runClear();
                    break;
                }
                case "sp": {
                    this.runChangeSp();
                    break;
                }
                case "set-disabled": {
                    this.runSetDisabled();
                    break;
                }
                case "verify": {
                    this.runVerify();
                    break;
                }
                case "get-disabled": {
                    this.runGetDisabled();
                    break;
                }
                default: {
                    this.getErrPrintWriter().println("Unknown command: " + cmd);
                }
            }
            return 0;
        }
        catch (Exception e) {
            this.getErrPrintWriter().println("Error while executing command: " + cmd);
            e.printStackTrace(this.getErrPrintWriter());
            return -1;
        }
    }

    private void runVerify() {
        this.getOutPrintWriter().println("Lock credential verified successfully");
    }

    @Override
    public void onHelp() {
    }

    private void parseArgs() {
        String opt;
        while ((opt = this.getNextOption()) != null) {
            if ("--old".equals(opt)) {
                this.mOld = this.getNextArgRequired();
                continue;
            }
            if ("--user".equals(opt)) {
                this.mCurrentUserId = Integer.parseInt(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Unknown option: " + opt);
            throw new IllegalArgumentException();
        }
        this.mNew = this.getNextArg();
    }

    private void runChangeSp() {
        if (this.mNew != null) {
            if ("1".equals(this.mNew)) {
                this.mLockPatternUtils.enableSyntheticPassword();
                this.getOutPrintWriter().println("Synthetic password enabled");
            } else if ("0".equals(this.mNew)) {
                this.mLockPatternUtils.disableSyntheticPassword();
                this.getOutPrintWriter().println("Synthetic password disabled");
            }
        }
        this.getOutPrintWriter().println(String.format("SP Enabled = %b", this.mLockPatternUtils.isSyntheticPasswordEnabled()));
    }

    private void runSetPattern() throws RemoteException {
        this.mLockPatternUtils.saveLockPattern(LockPatternUtils.stringToPattern(this.mNew), this.mOld, this.mCurrentUserId);
        this.getOutPrintWriter().println("Pattern set to '" + this.mNew + "'");
    }

    private void runSetPassword() throws RemoteException {
        this.mLockPatternUtils.saveLockPassword(this.mNew, this.mOld, 262144, this.mCurrentUserId);
        this.getOutPrintWriter().println("Password set to '" + this.mNew + "'");
    }

    private void runSetPin() throws RemoteException {
        this.mLockPatternUtils.saveLockPassword(this.mNew, this.mOld, 131072, this.mCurrentUserId);
        this.getOutPrintWriter().println("Pin set to '" + this.mNew + "'");
    }

    private void runClear() throws RemoteException {
        this.mLockPatternUtils.clearLock(this.mOld, this.mCurrentUserId);
        this.getOutPrintWriter().println("Lock credential cleared");
    }

    private void runSetDisabled() throws RemoteException {
        boolean disabled = Boolean.parseBoolean(this.mNew);
        this.mLockPatternUtils.setLockScreenDisabled(disabled, this.mCurrentUserId);
        this.getOutPrintWriter().println("Lock screen disabled set to " + disabled);
    }

    private void runGetDisabled() {
        boolean isLockScreenDisabled = this.mLockPatternUtils.isLockScreenDisabled(this.mCurrentUserId);
        this.getOutPrintWriter().println(isLockScreenDisabled);
    }

    private boolean checkCredential() throws RemoteException {
        boolean havePassword = this.mLockPatternUtils.isLockPasswordEnabled(this.mCurrentUserId);
        boolean havePattern = this.mLockPatternUtils.isLockPatternEnabled(this.mCurrentUserId);
        if (havePassword || havePattern) {
            if (this.mLockPatternUtils.isManagedProfileWithUnifiedChallenge(this.mCurrentUserId)) {
                this.getOutPrintWriter().println("Profile uses unified challenge");
                return false;
            }
            try {
                boolean result = havePassword ? this.mLockPatternUtils.checkPassword(this.mOld, this.mCurrentUserId) : this.mLockPatternUtils.checkPattern(LockPatternUtils.stringToPattern(this.mOld), this.mCurrentUserId);
                if (!result) {
                    if (!this.mLockPatternUtils.isManagedProfileWithUnifiedChallenge(this.mCurrentUserId)) {
                        this.mLockPatternUtils.reportFailedPasswordAttempt(this.mCurrentUserId);
                    }
                    this.getOutPrintWriter().println("Old password '" + this.mOld + "' didn't match");
                }
                return result;
            }
            catch (LockPatternUtils.RequestThrottledException e) {
                this.getOutPrintWriter().println("Request throttled");
                return false;
            }
        }
        return true;
    }
}

