/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.oemlock;

import android.content.Context;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.persistentdata.PersistentDataBlockManager;
import android.util.Slog;
import com.android.server.oemlock.OemLock;

class PersistentDataBlockLock
extends OemLock {
    private static final String TAG = "OemLock";
    private Context mContext;

    PersistentDataBlockLock(Context context) {
        this.mContext = context;
    }

    @Override
    void setOemUnlockAllowedByCarrier(boolean allowed, byte[] signature) {
        if (signature != null) {
            Slog.w(TAG, "Signature provided but is not being used");
        }
        UserManager.get(this.mContext).setUserRestriction("no_oem_unlock", !allowed, UserHandle.SYSTEM);
        if (!allowed) {
            this.disallowUnlockIfNotUnlocked();
        }
    }

    @Override
    boolean isOemUnlockAllowedByCarrier() {
        return !UserManager.get(this.mContext).hasUserRestriction("no_oem_unlock", UserHandle.SYSTEM);
    }

    @Override
    void setOemUnlockAllowedByDevice(boolean allowedByDevice) {
        PersistentDataBlockManager pdbm = (PersistentDataBlockManager)this.mContext.getSystemService("persistent_data_block");
        pdbm.setOemUnlockEnabled(allowedByDevice);
    }

    @Override
    boolean isOemUnlockAllowedByDevice() {
        PersistentDataBlockManager pdbm = (PersistentDataBlockManager)this.mContext.getSystemService("persistent_data_block");
        return pdbm.getOemUnlockEnabled();
    }

    private void disallowUnlockIfNotUnlocked() {
        PersistentDataBlockManager pdbm = (PersistentDataBlockManager)this.mContext.getSystemService("persistent_data_block");
        if (pdbm.getFlashLockState() != 0) {
            pdbm.setOemUnlockEnabled(false);
        }
    }
}

