/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Intent;
import android.content.pm.InstantAppInfo;
import android.content.pm.PackageParser;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.ByteStringUtils;
import android.util.PackageUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.BasePermission;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.UserManagerService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class InstantAppRegistry {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "InstantAppRegistry";
    static final long DEFAULT_INSTALLED_INSTANT_APP_MIN_CACHE_PERIOD = 604800000L;
    private static final long DEFAULT_INSTALLED_INSTANT_APP_MAX_CACHE_PERIOD = 15552000000L;
    static final long DEFAULT_UNINSTALLED_INSTANT_APP_MIN_CACHE_PERIOD = 604800000L;
    private static final long DEFAULT_UNINSTALLED_INSTANT_APP_MAX_CACHE_PERIOD = 15552000000L;
    private static final String INSTANT_APPS_FOLDER = "instant";
    private static final String INSTANT_APP_ICON_FILE = "icon.png";
    private static final String INSTANT_APP_COOKIE_FILE_PREFIX = "cookie_";
    private static final String INSTANT_APP_COOKIE_FILE_SIFFIX = ".dat";
    private static final String INSTANT_APP_METADATA_FILE = "metadata.xml";
    private static final String INSTANT_APP_ANDROID_ID_FILE = "android_id";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_PERMISSIONS = "permissions";
    private static final String TAG_PERMISSION = "permission";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_GRANTED = "granted";
    private final PackageManagerService mService;
    private final CookiePersistence mCookiePersistence;
    @GuardedBy(value="mService.mPackages")
    private SparseArray<List<UninstalledInstantAppState>> mUninstalledInstantApps;
    @GuardedBy(value="mService.mPackages")
    private SparseArray<SparseArray<SparseBooleanArray>> mInstantGrants;
    @GuardedBy(value="mService.mPackages")
    private SparseArray<SparseBooleanArray> mInstalledInstantAppUids;

    public InstantAppRegistry(PackageManagerService service) {
        this.mService = service;
        this.mCookiePersistence = new CookiePersistence(BackgroundThread.getHandler().getLooper());
    }

    public byte[] getInstantAppCookieLPw(String packageName, int userId) {
        PackageParser.Package pkg = this.mService.mPackages.get(packageName);
        if (pkg == null) {
            return null;
        }
        byte[] pendingCookie = this.mCookiePersistence.getPendingPersistCookieLPr(pkg, userId);
        if (pendingCookie != null) {
            return pendingCookie;
        }
        File cookieFile = InstantAppRegistry.peekInstantCookieFile(packageName, userId);
        if (cookieFile != null && cookieFile.exists()) {
            try {
                return IoUtils.readFileAsByteArray(cookieFile.toString());
            }
            catch (IOException e) {
                Slog.w(LOG_TAG, "Error reading cookie file: " + cookieFile);
            }
        }
        return null;
    }

    public boolean setInstantAppCookieLPw(String packageName, byte[] cookie, int userId) {
        int maxCookieSize;
        if (cookie != null && cookie.length > 0 && cookie.length > (maxCookieSize = this.mService.mContext.getPackageManager().getInstantAppCookieMaxBytes())) {
            Slog.e(LOG_TAG, "Instant app cookie for package " + packageName + " size " + cookie.length + " bytes while max size is " + maxCookieSize);
            return false;
        }
        PackageParser.Package pkg = this.mService.mPackages.get(packageName);
        if (pkg == null) {
            return false;
        }
        this.mCookiePersistence.schedulePersistLPw(userId, pkg, cookie);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistInstantApplicationCookie(byte[] cookie, String packageName, File cookieFile, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mService.mPackages;
        synchronized (arrayMap) {
            File appDir = InstantAppRegistry.getInstantApplicationDir(packageName, userId);
            if (!appDir.exists() && !appDir.mkdirs()) {
                Slog.e(LOG_TAG, "Cannot create instant app cookie directory");
                return;
            }
            if (cookieFile.exists() && !cookieFile.delete()) {
                Slog.e(LOG_TAG, "Cannot delete instant app cookie file");
            }
            if (cookie == null || cookie.length <= 0) {
                return;
            }
        }
        try (FileOutputStream fos = new FileOutputStream(cookieFile);){
            fos.write(cookie, 0, cookie.length);
        }
        catch (IOException e) {
            Slog.e(LOG_TAG, "Error writing instant app cookie file: " + cookieFile, e);
        }
    }

    public Bitmap getInstantAppIconLPw(String packageName, int userId) {
        File iconFile = new File(InstantAppRegistry.getInstantApplicationDir(packageName, userId), INSTANT_APP_ICON_FILE);
        if (iconFile.exists()) {
            return BitmapFactory.decodeFile(iconFile.toString());
        }
        return null;
    }

    public String getInstantAppAndroidIdLPw(String packageName, int userId) {
        File idFile = new File(InstantAppRegistry.getInstantApplicationDir(packageName, userId), INSTANT_APP_ANDROID_ID_FILE);
        if (idFile.exists()) {
            try {
                return IoUtils.readFileAsString(idFile.getAbsolutePath());
            }
            catch (IOException e) {
                Slog.e(LOG_TAG, "Failed to read instant app android id file: " + idFile, e);
            }
        }
        return this.generateInstantAppAndroidIdLPw(packageName, userId);
    }

    private String generateInstantAppAndroidIdLPw(String packageName, int userId) {
        byte[] randomBytes = new byte[8];
        new SecureRandom().nextBytes(randomBytes);
        String id2 = ByteStringUtils.toHexString(randomBytes).toLowerCase(Locale.US);
        File appDir = InstantAppRegistry.getInstantApplicationDir(packageName, userId);
        if (!appDir.exists() && !appDir.mkdirs()) {
            Slog.e(LOG_TAG, "Cannot create instant app cookie directory");
            return id2;
        }
        File idFile = new File(InstantAppRegistry.getInstantApplicationDir(packageName, userId), INSTANT_APP_ANDROID_ID_FILE);
        try (FileOutputStream fos = new FileOutputStream(idFile);){
            fos.write(id2.getBytes());
        }
        catch (IOException e) {
            Slog.e(LOG_TAG, "Error writing instant app android id file: " + idFile, e);
        }
        return id2;
    }

    public List<InstantAppInfo> getInstantAppsLPr(int userId) {
        List<InstantAppInfo> installedApps = this.getInstalledInstantApplicationsLPr(userId);
        List<InstantAppInfo> uninstalledApps = this.getUninstalledInstantApplicationsLPr(userId);
        if (installedApps != null) {
            if (uninstalledApps != null) {
                installedApps.addAll(uninstalledApps);
            }
            return installedApps;
        }
        return uninstalledApps;
    }

    public void onPackageInstalledLPw(PackageParser.Package pkg, int[] userIds) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        for (int userId : userIds) {
            if (this.mService.mPackages.get(pkg.packageName) == null || !ps.getInstalled(userId)) continue;
            this.propagateInstantAppPermissionsIfNeeded(pkg.packageName, userId);
            if (ps.getInstantApp(userId)) {
                this.addInstantAppLPw(userId, ps.appId);
            }
            this.removeUninstalledInstantAppStateLPw(state -> state.mInstantAppInfo.getPackageName().equals(pkg.packageName), userId);
            File instantAppDir = InstantAppRegistry.getInstantApplicationDir(pkg.packageName, userId);
            new File(instantAppDir, INSTANT_APP_METADATA_FILE).delete();
            new File(instantAppDir, INSTANT_APP_ICON_FILE).delete();
            File currentCookieFile = InstantAppRegistry.peekInstantCookieFile(pkg.packageName, userId);
            if (currentCookieFile == null) continue;
            String[] signaturesSha256Digests = PackageUtils.computeSignaturesSha256Digests(pkg.mSignatures);
            String signaturesSha256Digest = PackageUtils.computeSignaturesSha256Digest(signaturesSha256Digests);
            if (currentCookieFile.equals(InstantAppRegistry.computeInstantCookieFile(pkg.packageName, signaturesSha256Digest, userId))) {
                return;
            }
            if (pkg.mSignatures.length > 1 && currentCookieFile.equals(InstantAppRegistry.computeInstantCookieFile(pkg.packageName, signaturesSha256Digests[0], userId))) {
                return;
            }
            Slog.i(LOG_TAG, "Signature for package " + pkg.packageName + " changed - dropping cookie");
            this.mCookiePersistence.cancelPendingPersistLPw(pkg, userId);
            currentCookieFile.delete();
        }
    }

    public void onPackageUninstalledLPw(PackageParser.Package pkg, int[] userIds) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        for (int userId : userIds) {
            if (this.mService.mPackages.get(pkg.packageName) != null && ps.getInstalled(userId)) continue;
            if (ps.getInstantApp(userId)) {
                this.addUninstalledInstantAppLPw(pkg, userId);
                this.removeInstantAppLPw(userId, ps.appId);
                continue;
            }
            InstantAppRegistry.deleteDir(InstantAppRegistry.getInstantApplicationDir(pkg.packageName, userId));
            this.mCookiePersistence.cancelPendingPersistLPw(pkg, userId);
            this.removeAppLPw(userId, ps.appId);
        }
    }

    public void onUserRemovedLPw(int userId) {
        if (this.mUninstalledInstantApps != null) {
            this.mUninstalledInstantApps.remove(userId);
            if (this.mUninstalledInstantApps.size() <= 0) {
                this.mUninstalledInstantApps = null;
            }
        }
        if (this.mInstalledInstantAppUids != null) {
            this.mInstalledInstantAppUids.remove(userId);
            if (this.mInstalledInstantAppUids.size() <= 0) {
                this.mInstalledInstantAppUids = null;
            }
        }
        if (this.mInstantGrants != null) {
            this.mInstantGrants.remove(userId);
            if (this.mInstantGrants.size() <= 0) {
                this.mInstantGrants = null;
            }
        }
        InstantAppRegistry.deleteDir(InstantAppRegistry.getInstantApplicationsDir(userId));
    }

    public boolean isInstantAccessGranted(int userId, int targetAppId, int instantAppId) {
        if (this.mInstantGrants == null) {
            return false;
        }
        SparseArray<SparseBooleanArray> targetAppList = this.mInstantGrants.get(userId);
        if (targetAppList == null) {
            return false;
        }
        SparseBooleanArray instantGrantList = targetAppList.get(targetAppId);
        if (instantGrantList == null) {
            return false;
        }
        return instantGrantList.get(instantAppId);
    }

    public void grantInstantAccessLPw(int userId, Intent intent, int targetAppId, int instantAppId) {
        SparseBooleanArray instantGrantList;
        SparseArray<SparseBooleanArray> targetAppList;
        Set<String> categories;
        if (this.mInstalledInstantAppUids == null) {
            return;
        }
        SparseBooleanArray instantAppList = this.mInstalledInstantAppUids.get(userId);
        if (instantAppList == null || !instantAppList.get(instantAppId)) {
            return;
        }
        if (instantAppList.get(targetAppId)) {
            return;
        }
        if (intent != null && "android.intent.action.VIEW".equals(intent.getAction()) && (categories = intent.getCategories()) != null && categories.contains("android.intent.category.BROWSABLE")) {
            return;
        }
        if (this.mInstantGrants == null) {
            this.mInstantGrants = new SparseArray();
        }
        if ((targetAppList = this.mInstantGrants.get(userId)) == null) {
            targetAppList = new SparseArray();
            this.mInstantGrants.put(userId, targetAppList);
        }
        if ((instantGrantList = targetAppList.get(targetAppId)) == null) {
            instantGrantList = new SparseBooleanArray();
            targetAppList.put(targetAppId, instantGrantList);
        }
        instantGrantList.put(instantAppId, true);
    }

    public void addInstantAppLPw(int userId, int instantAppId) {
        SparseBooleanArray instantAppList;
        if (this.mInstalledInstantAppUids == null) {
            this.mInstalledInstantAppUids = new SparseArray();
        }
        if ((instantAppList = this.mInstalledInstantAppUids.get(userId)) == null) {
            instantAppList = new SparseBooleanArray();
            this.mInstalledInstantAppUids.put(userId, instantAppList);
        }
        instantAppList.put(instantAppId, true);
    }

    private void removeInstantAppLPw(int userId, int instantAppId) {
        if (this.mInstalledInstantAppUids == null) {
            return;
        }
        SparseBooleanArray instantAppList = this.mInstalledInstantAppUids.get(userId);
        if (instantAppList == null) {
            return;
        }
        instantAppList.delete(instantAppId);
        if (this.mInstantGrants == null) {
            return;
        }
        SparseArray<SparseBooleanArray> targetAppList = this.mInstantGrants.get(userId);
        if (targetAppList == null) {
            return;
        }
        for (int i = targetAppList.size() - 1; i >= 0; --i) {
            targetAppList.valueAt(i).delete(instantAppId);
        }
    }

    private void removeAppLPw(int userId, int targetAppId) {
        if (this.mInstantGrants == null) {
            return;
        }
        SparseArray<SparseBooleanArray> targetAppList = this.mInstantGrants.get(userId);
        if (targetAppList == null) {
            return;
        }
        targetAppList.delete(targetAppId);
    }

    private void addUninstalledInstantAppLPw(PackageParser.Package pkg, int userId) {
        List<UninstalledInstantAppState> uninstalledAppStates;
        InstantAppInfo uninstalledApp = this.createInstantAppInfoForPackage(pkg, userId, false);
        if (uninstalledApp == null) {
            return;
        }
        if (this.mUninstalledInstantApps == null) {
            this.mUninstalledInstantApps = new SparseArray();
        }
        if ((uninstalledAppStates = this.mUninstalledInstantApps.get(userId)) == null) {
            uninstalledAppStates = new ArrayList<UninstalledInstantAppState>();
            this.mUninstalledInstantApps.put(userId, uninstalledAppStates);
        }
        UninstalledInstantAppState uninstalledAppState = new UninstalledInstantAppState(uninstalledApp, System.currentTimeMillis());
        uninstalledAppStates.add(uninstalledAppState);
        this.writeUninstalledInstantAppMetadata(uninstalledApp, userId);
        this.writeInstantApplicationIconLPw(pkg, userId);
    }

    private void writeInstantApplicationIconLPw(PackageParser.Package pkg, int userId) {
        Bitmap bitmap;
        File appDir = InstantAppRegistry.getInstantApplicationDir(pkg.packageName, userId);
        if (!appDir.exists()) {
            return;
        }
        Drawable icon = pkg.applicationInfo.loadIcon(this.mService.mContext.getPackageManager());
        if (icon instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)icon).getBitmap();
        } else {
            bitmap = Bitmap.createBitmap(icon.getIntrinsicWidth(), icon.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            icon.setBounds(0, 0, icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
            icon.draw(canvas);
        }
        File iconFile = new File(InstantAppRegistry.getInstantApplicationDir(pkg.packageName, userId), INSTANT_APP_ICON_FILE);
        try (FileOutputStream out = new FileOutputStream(iconFile);){
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, out);
        }
        catch (Exception e) {
            Slog.e(LOG_TAG, "Error writing instant app icon", e);
        }
    }

    boolean hasInstantApplicationMetadataLPr(String packageName, int userId) {
        return this.hasUninstalledInstantAppStateLPr(packageName, userId) || this.hasInstantAppMetadataLPr(packageName, userId);
    }

    public void deleteInstantApplicationMetadataLPw(String packageName, int userId) {
        this.removeUninstalledInstantAppStateLPw(state -> state.mInstantAppInfo.getPackageName().equals(packageName), userId);
        File instantAppDir = InstantAppRegistry.getInstantApplicationDir(packageName, userId);
        new File(instantAppDir, INSTANT_APP_METADATA_FILE).delete();
        new File(instantAppDir, INSTANT_APP_ICON_FILE).delete();
        new File(instantAppDir, INSTANT_APP_ANDROID_ID_FILE).delete();
        File cookie = InstantAppRegistry.peekInstantCookieFile(packageName, userId);
        if (cookie != null) {
            cookie.delete();
        }
    }

    private void removeUninstalledInstantAppStateLPw(Predicate<UninstalledInstantAppState> criteria, int userId) {
        if (this.mUninstalledInstantApps == null) {
            return;
        }
        List<UninstalledInstantAppState> uninstalledAppStates = this.mUninstalledInstantApps.get(userId);
        if (uninstalledAppStates == null) {
            return;
        }
        int appCount = uninstalledAppStates.size();
        for (int i = appCount - 1; i >= 0; --i) {
            UninstalledInstantAppState uninstalledAppState = uninstalledAppStates.get(i);
            if (!criteria.test(uninstalledAppState)) continue;
            uninstalledAppStates.remove(i);
            if (!uninstalledAppStates.isEmpty()) continue;
            this.mUninstalledInstantApps.remove(userId);
            if (this.mUninstalledInstantApps.size() <= 0) {
                this.mUninstalledInstantApps = null;
            }
            return;
        }
    }

    private boolean hasUninstalledInstantAppStateLPr(String packageName, int userId) {
        if (this.mUninstalledInstantApps == null) {
            return false;
        }
        List<UninstalledInstantAppState> uninstalledAppStates = this.mUninstalledInstantApps.get(userId);
        if (uninstalledAppStates == null) {
            return false;
        }
        int appCount = uninstalledAppStates.size();
        for (int i = 0; i < appCount; ++i) {
            UninstalledInstantAppState uninstalledAppState = uninstalledAppStates.get(i);
            if (!packageName.equals(uninstalledAppState.mInstantAppInfo.getPackageName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasInstantAppMetadataLPr(String packageName, int userId) {
        File instantAppDir = InstantAppRegistry.getInstantApplicationDir(packageName, userId);
        return new File(instantAppDir, INSTANT_APP_METADATA_FILE).exists() || new File(instantAppDir, INSTANT_APP_ICON_FILE).exists() || new File(instantAppDir, INSTANT_APP_ANDROID_ID_FILE).exists() || InstantAppRegistry.peekInstantCookieFile(packageName, userId) != null;
    }

    void pruneInstantApps() {
        long maxInstalledCacheDuration = Settings.Global.getLong(this.mService.mContext.getContentResolver(), "installed_instant_app_max_cache_period", 15552000000L);
        long maxUninstalledCacheDuration = Settings.Global.getLong(this.mService.mContext.getContentResolver(), "uninstalled_instant_app_max_cache_period", 15552000000L);
        try {
            this.pruneInstantApps(Long.MAX_VALUE, maxInstalledCacheDuration, maxUninstalledCacheDuration);
        }
        catch (IOException e) {
            Slog.e(LOG_TAG, "Error pruning installed and uninstalled instant apps", e);
        }
    }

    boolean pruneInstalledInstantApps(long neededSpace, long maxInstalledCacheDuration) {
        try {
            return this.pruneInstantApps(neededSpace, maxInstalledCacheDuration, Long.MAX_VALUE);
        }
        catch (IOException e) {
            Slog.e(LOG_TAG, "Error pruning installed instant apps", e);
            return false;
        }
    }

    boolean pruneUninstalledInstantApps(long neededSpace, long maxUninstalledCacheDuration) {
        try {
            return this.pruneInstantApps(neededSpace, Long.MAX_VALUE, maxUninstalledCacheDuration);
        }
        catch (IOException e) {
            Slog.e(LOG_TAG, "Error pruning uninstalled instant apps", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneInstantApps(long neededSpace, long maxInstalledCacheDuration, long maxUninstalledCacheDuration) throws IOException {
        StorageManager storage = this.mService.mContext.getSystemService(StorageManager.class);
        File file = storage.findPathForUuid(StorageManager.UUID_PRIVATE_INTERNAL);
        if (file.getUsableSpace() >= neededSpace) {
            return true;
        }
        ArrayList<String> packagesToDelete = null;
        long now = System.currentTimeMillis();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mService.mPackages;
        synchronized (arrayMap) {
            int[] allUsers = PackageManagerService.sUserManager.getUserIds();
            int packageCount = this.mService.mPackages.size();
            for (int i = 0; i < packageCount; ++i) {
                PackageParser.Package pkg = this.mService.mPackages.valueAt(i);
                if (now - pkg.getLatestPackageUseTimeInMills() < maxInstalledCacheDuration || !(pkg.mExtras instanceof PackageSetting)) continue;
                PackageSetting ps = (PackageSetting)pkg.mExtras;
                boolean installedOnlyAsInstantApp = false;
                for (int userId : allUsers) {
                    if (!ps.getInstalled(userId)) continue;
                    if (ps.getInstantApp(userId)) {
                        installedOnlyAsInstantApp = true;
                        continue;
                    }
                    installedOnlyAsInstantApp = false;
                    break;
                }
                if (!installedOnlyAsInstantApp) continue;
                if (packagesToDelete == null) {
                    packagesToDelete = new ArrayList<String>();
                }
                packagesToDelete.add(pkg.packageName);
            }
            if (packagesToDelete != null) {
                packagesToDelete.sort((lhs, rhs) -> {
                    PackageParser.Package lhsPkg = this.mService.mPackages.get(lhs);
                    PackageParser.Package rhsPkg = this.mService.mPackages.get(rhs);
                    if (lhsPkg == null && rhsPkg == null) {
                        return 0;
                    }
                    if (lhsPkg == null) {
                        return -1;
                    }
                    if (rhsPkg == null) {
                        return 1;
                    }
                    if (lhsPkg.getLatestPackageUseTimeInMills() > rhsPkg.getLatestPackageUseTimeInMills()) {
                        return 1;
                    }
                    if (lhsPkg.getLatestPackageUseTimeInMills() < rhsPkg.getLatestPackageUseTimeInMills()) {
                        return -1;
                    }
                    if (lhsPkg.mExtras instanceof PackageSetting && rhsPkg.mExtras instanceof PackageSetting) {
                        PackageSetting lhsPs = (PackageSetting)lhsPkg.mExtras;
                        PackageSetting rhsPs = (PackageSetting)rhsPkg.mExtras;
                        if (lhsPs.firstInstallTime > rhsPs.firstInstallTime) {
                            return 1;
                        }
                        return -1;
                    }
                    return 0;
                });
            }
        }
        if (packagesToDelete != null) {
            int packageCount = packagesToDelete.size();
            for (int i = 0; i < packageCount; ++i) {
                String packageToDelete = (String)packagesToDelete.get(i);
                if (this.mService.deletePackageX(packageToDelete, -1, 0, 2) != 1 || file.getUsableSpace() < neededSpace) continue;
                return true;
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mService.mPackages;
        synchronized (arrayMap2) {
            for (int userId : UserManagerService.getInstance().getUserIds()) {
                File[] files;
                this.removeUninstalledInstantAppStateLPw(state -> {
                    long elapsedCachingMillis = System.currentTimeMillis() - state.mTimestamp;
                    return elapsedCachingMillis > maxUninstalledCacheDuration;
                }, userId);
                File instantAppsDir = InstantAppRegistry.getInstantApplicationsDir(userId);
                if (!instantAppsDir.exists() || (files = instantAppsDir.listFiles()) == null) continue;
                for (File instantDir : files) {
                    long elapsedCachingMillis;
                    File metadataFile;
                    if (!instantDir.isDirectory() || !(metadataFile = new File(instantDir, INSTANT_APP_METADATA_FILE)).exists() || (elapsedCachingMillis = System.currentTimeMillis() - metadataFile.lastModified()) <= maxUninstalledCacheDuration) continue;
                    InstantAppRegistry.deleteDir(instantDir);
                    if (file.getUsableSpace() < neededSpace) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<InstantAppInfo> getInstalledInstantApplicationsLPr(int userId) {
        ArrayList<InstantAppInfo> result = null;
        int packageCount = this.mService.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            InstantAppInfo info;
            PackageParser.Package pkg = this.mService.mPackages.valueAt(i);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null || !ps.getInstantApp(userId) || (info = this.createInstantAppInfoForPackage(pkg, userId, true)) == null) continue;
            if (result == null) {
                result = new ArrayList<InstantAppInfo>();
            }
            result.add(info);
        }
        return result;
    }

    private InstantAppInfo createInstantAppInfoForPackage(PackageParser.Package pkg, int userId, boolean addApplicationInfo) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return null;
        }
        if (!ps.getInstalled(userId)) {
            return null;
        }
        String[] requestedPermissions = new String[pkg.requestedPermissions.size()];
        pkg.requestedPermissions.toArray(requestedPermissions);
        Set<String> permissions = ps.getPermissionsState().getPermissions(userId);
        String[] grantedPermissions = new String[permissions.size()];
        permissions.toArray(grantedPermissions);
        if (addApplicationInfo) {
            return new InstantAppInfo(pkg.applicationInfo, requestedPermissions, grantedPermissions);
        }
        return new InstantAppInfo(pkg.applicationInfo.packageName, pkg.applicationInfo.loadLabel(this.mService.mContext.getPackageManager()), requestedPermissions, grantedPermissions);
    }

    private List<InstantAppInfo> getUninstalledInstantApplicationsLPr(int userId) {
        List<UninstalledInstantAppState> uninstalledAppStates = this.getUninstalledInstantAppStatesLPr(userId);
        if (uninstalledAppStates == null || uninstalledAppStates.isEmpty()) {
            return null;
        }
        ArrayList<InstantAppInfo> uninstalledApps = null;
        int stateCount = uninstalledAppStates.size();
        for (int i = 0; i < stateCount; ++i) {
            UninstalledInstantAppState uninstalledAppState = uninstalledAppStates.get(i);
            if (uninstalledApps == null) {
                uninstalledApps = new ArrayList<InstantAppInfo>();
            }
            uninstalledApps.add(uninstalledAppState.mInstantAppInfo);
        }
        return uninstalledApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateInstantAppPermissionsIfNeeded(String packageName, int userId) {
        InstantAppInfo appInfo = this.peekOrParseUninstalledInstantAppInfo(packageName, userId);
        if (appInfo == null) {
            return;
        }
        if (ArrayUtils.isEmpty(appInfo.getGrantedPermissions())) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            for (String grantedPermission : appInfo.getGrantedPermissions()) {
                BasePermission bp = this.mService.mSettings.mPermissions.get(grantedPermission);
                if (bp == null || !bp.isRuntime() && !bp.isDevelopment() || !bp.isInstant()) continue;
                this.mService.grantRuntimePermission(packageName, grantedPermission, userId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private InstantAppInfo peekOrParseUninstalledInstantAppInfo(String packageName, int userId) {
        File metadataFile;
        UninstalledInstantAppState uninstalledAppState;
        List<UninstalledInstantAppState> uninstalledAppStates;
        if (this.mUninstalledInstantApps != null && (uninstalledAppStates = this.mUninstalledInstantApps.get(userId)) != null) {
            int appCount = uninstalledAppStates.size();
            for (int i = 0; i < appCount; ++i) {
                UninstalledInstantAppState uninstalledAppState2 = uninstalledAppStates.get(i);
                if (!uninstalledAppState2.mInstantAppInfo.getPackageName().equals(packageName)) continue;
                return uninstalledAppState2.mInstantAppInfo;
            }
        }
        if ((uninstalledAppState = InstantAppRegistry.parseMetadataFile(metadataFile = new File(InstantAppRegistry.getInstantApplicationDir(packageName, userId), INSTANT_APP_METADATA_FILE))) == null) {
            return null;
        }
        return uninstalledAppState.mInstantAppInfo;
    }

    private List<UninstalledInstantAppState> getUninstalledInstantAppStatesLPr(int userId) {
        File[] files;
        List<UninstalledInstantAppState> uninstalledAppStates = null;
        if (this.mUninstalledInstantApps != null && (uninstalledAppStates = this.mUninstalledInstantApps.get(userId)) != null) {
            return uninstalledAppStates;
        }
        File instantAppsDir = InstantAppRegistry.getInstantApplicationsDir(userId);
        if (instantAppsDir.exists() && (files = instantAppsDir.listFiles()) != null) {
            for (File instantDir : files) {
                File metadataFile;
                UninstalledInstantAppState uninstalledAppState;
                if (!instantDir.isDirectory() || (uninstalledAppState = InstantAppRegistry.parseMetadataFile(metadataFile = new File(instantDir, INSTANT_APP_METADATA_FILE))) == null) continue;
                if (uninstalledAppStates == null) {
                    uninstalledAppStates = new ArrayList<UninstalledInstantAppState>();
                }
                uninstalledAppStates.add(uninstalledAppState);
            }
        }
        if (uninstalledAppStates != null) {
            if (this.mUninstalledInstantApps == null) {
                this.mUninstalledInstantApps = new SparseArray();
            }
            this.mUninstalledInstantApps.put(userId, uninstalledAppStates);
        }
        return uninstalledAppStates;
    }

    private static UninstalledInstantAppState parseMetadataFile(File metadataFile) {
        FileInputStream in;
        if (!metadataFile.exists()) {
            return null;
        }
        try {
            in = new AtomicFile(metadataFile).openRead();
        }
        catch (FileNotFoundException fnfe) {
            Slog.i(LOG_TAG, "No instant metadata file");
            return null;
        }
        File instantDir = metadataFile.getParentFile();
        long timestamp = metadataFile.lastModified();
        String packageName = instantDir.getName();
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, StandardCharsets.UTF_8.name());
            UninstalledInstantAppState uninstalledInstantAppState = new UninstalledInstantAppState(InstantAppRegistry.parseMetadata(parser, packageName), timestamp);
            return uninstalledInstantAppState;
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("Failed parsing instant metadata file: " + metadataFile, e);
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    private static File computeInstantCookieFile(String packageName, String sha256Digest, int userId) {
        File appDir = InstantAppRegistry.getInstantApplicationDir(packageName, userId);
        String cookieFile = INSTANT_APP_COOKIE_FILE_PREFIX + sha256Digest + INSTANT_APP_COOKIE_FILE_SIFFIX;
        return new File(appDir, cookieFile);
    }

    private static File peekInstantCookieFile(String packageName, int userId) {
        File appDir = InstantAppRegistry.getInstantApplicationDir(packageName, userId);
        if (!appDir.exists()) {
            return null;
        }
        File[] files = appDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().startsWith(INSTANT_APP_COOKIE_FILE_PREFIX) || !file.getName().endsWith(INSTANT_APP_COOKIE_FILE_SIFFIX)) continue;
            return file;
        }
        return null;
    }

    private static InstantAppInfo parseMetadata(XmlPullParser parser, String packageName) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!TAG_PACKAGE.equals(parser.getName())) continue;
            return InstantAppRegistry.parsePackage(parser, packageName);
        }
        return null;
    }

    private static InstantAppInfo parsePackage(XmlPullParser parser, String packageName) throws IOException, XmlPullParserException {
        String label = parser.getAttributeValue(null, ATTR_LABEL);
        ArrayList<String> outRequestedPermissions = new ArrayList<String>();
        ArrayList<String> outGrantedPermissions = new ArrayList<String>();
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!TAG_PERMISSIONS.equals(parser.getName())) continue;
            InstantAppRegistry.parsePermissions(parser, outRequestedPermissions, outGrantedPermissions);
        }
        String[] requestedPermissions = new String[outRequestedPermissions.size()];
        outRequestedPermissions.toArray(requestedPermissions);
        String[] grantedPermissions = new String[outGrantedPermissions.size()];
        outGrantedPermissions.toArray(grantedPermissions);
        return new InstantAppInfo(packageName, label, requestedPermissions, grantedPermissions);
    }

    private static void parsePermissions(XmlPullParser parser, List<String> outRequestedPermissions, List<String> outGrantedPermissions) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!TAG_PERMISSION.equals(parser.getName())) continue;
            String permission2 = XmlUtils.readStringAttribute(parser, ATTR_NAME);
            outRequestedPermissions.add(permission2);
            if (!XmlUtils.readBooleanAttribute(parser, ATTR_GRANTED)) continue;
            outGrantedPermissions.add(permission2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUninstalledInstantAppMetadata(InstantAppInfo instantApp, int userId) {
        File appDir = InstantAppRegistry.getInstantApplicationDir(instantApp.getPackageName(), userId);
        if (!appDir.exists() && !appDir.mkdirs()) {
            return;
        }
        File metadataFile = new File(appDir, INSTANT_APP_METADATA_FILE);
        AtomicFile destination = new AtomicFile(metadataFile);
        FileOutputStream out = null;
        try {
            out = destination.startWrite();
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(out, StandardCharsets.UTF_8.name());
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_PACKAGE);
            serializer.attribute(null, ATTR_LABEL, instantApp.loadLabel(this.mService.mContext.getPackageManager()).toString());
            serializer.startTag(null, TAG_PERMISSIONS);
            for (String permission2 : instantApp.getRequestedPermissions()) {
                serializer.startTag(null, TAG_PERMISSION);
                serializer.attribute(null, ATTR_NAME, permission2);
                if (ArrayUtils.contains(instantApp.getGrantedPermissions(), permission2)) {
                    serializer.attribute(null, ATTR_GRANTED, String.valueOf(true));
                }
                serializer.endTag(null, TAG_PERMISSION);
            }
            serializer.endTag(null, TAG_PERMISSIONS);
            serializer.endTag(null, TAG_PACKAGE);
            serializer.endDocument();
            destination.finishWrite(out);
        }
        catch (Throwable t) {
            Slog.wtf(LOG_TAG, "Failed to write instant state, restoring backup", t);
            destination.failWrite(out);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    private static File getInstantApplicationsDir(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), INSTANT_APPS_FOLDER);
    }

    private static File getInstantApplicationDir(String packageName, int userId) {
        return new File(InstantAppRegistry.getInstantApplicationsDir(userId), packageName);
    }

    private static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                InstantAppRegistry.deleteDir(file);
            }
        }
        dir.delete();
    }

    private final class CookiePersistence
    extends Handler {
        private static final long PERSIST_COOKIE_DELAY_MILLIS = 1000L;
        private final SparseArray<ArrayMap<PackageParser.Package, SomeArgs>> mPendingPersistCookies;

        public CookiePersistence(Looper looper) {
            super(looper);
            this.mPendingPersistCookies = new SparseArray();
        }

        public void schedulePersistLPw(int userId, PackageParser.Package pkg, byte[] cookie) {
            File oldCookieFile;
            File newCookieFile = InstantAppRegistry.computeInstantCookieFile(pkg.packageName, PackageUtils.computeSignaturesSha256Digest(pkg.mSignatures), userId);
            if (pkg.mSignatures.length > 0 && (oldCookieFile = InstantAppRegistry.peekInstantCookieFile(pkg.packageName, userId)) != null && !newCookieFile.equals(oldCookieFile)) {
                oldCookieFile.delete();
            }
            this.cancelPendingPersistLPw(pkg, userId);
            this.addPendingPersistCookieLPw(userId, pkg, cookie, newCookieFile);
            this.sendMessageDelayed(this.obtainMessage(userId, pkg), 1000L);
        }

        public byte[] getPendingPersistCookieLPr(PackageParser.Package pkg, int userId) {
            SomeArgs state;
            ArrayMap<PackageParser.Package, SomeArgs> pendingWorkForUser = this.mPendingPersistCookies.get(userId);
            if (pendingWorkForUser != null && (state = pendingWorkForUser.get(pkg)) != null) {
                return (byte[])state.arg1;
            }
            return null;
        }

        public void cancelPendingPersistLPw(PackageParser.Package pkg, int userId) {
            this.removeMessages(userId, pkg);
            SomeArgs state = this.removePendingPersistCookieLPr(pkg, userId);
            if (state != null) {
                state.recycle();
            }
        }

        private void addPendingPersistCookieLPw(int userId, PackageParser.Package pkg, byte[] cookie, File cookieFile) {
            ArrayMap<PackageParser.Package, SomeArgs> pendingWorkForUser = this.mPendingPersistCookies.get(userId);
            if (pendingWorkForUser == null) {
                pendingWorkForUser = new ArrayMap();
                this.mPendingPersistCookies.put(userId, pendingWorkForUser);
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = cookie;
            args.arg2 = cookieFile;
            pendingWorkForUser.put(pkg, args);
        }

        private SomeArgs removePendingPersistCookieLPr(PackageParser.Package pkg, int userId) {
            ArrayMap<PackageParser.Package, SomeArgs> pendingWorkForUser = this.mPendingPersistCookies.get(userId);
            SomeArgs state = null;
            if (pendingWorkForUser != null) {
                state = pendingWorkForUser.remove(pkg);
                if (pendingWorkForUser.isEmpty()) {
                    this.mPendingPersistCookies.remove(userId);
                }
            }
            return state;
        }

        @Override
        public void handleMessage(Message message) {
            PackageParser.Package pkg = (PackageParser.Package)message.obj;
            int userId = message.what;
            SomeArgs state = this.removePendingPersistCookieLPr(pkg, userId);
            if (state == null) {
                return;
            }
            byte[] cookie = (byte[])state.arg1;
            File cookieFile = (File)state.arg2;
            state.recycle();
            InstantAppRegistry.this.persistInstantApplicationCookie(cookie, pkg.packageName, cookieFile, userId);
        }
    }

    private static final class UninstalledInstantAppState {
        final InstantAppInfo mInstantAppInfo;
        final long mTimestamp;

        public UninstalledInstantAppState(InstantAppInfo instantApp, long timestamp) {
            this.mInstantAppInfo = instantApp;
            this.mTimestamp = timestamp;
        }
    }
}

