/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.AppGlobals;
import android.content.Intent;
import android.content.pm.PackageParser;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.util.ArraySet;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.dex.DexManager;
import com.android.server.pm.dex.PackageDexUsage;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import libcore.io.Libcore;

public class PackageManagerServiceUtils {
    private static final long SEVEN_DAYS_IN_MILLISECONDS = 604800000L;

    private static ArraySet<String> getPackageNamesForIntent(Intent intent, int userId) {
        List ris = null;
        try {
            ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, userId).getList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        ArraySet<String> pkgNames = new ArraySet<String>();
        if (ris != null) {
            for (ResolveInfo ri : ris) {
                pkgNames.add(ri.activityInfo.packageName);
            }
        }
        return pkgNames;
    }

    public static void sortPackagesByUsageDate(List<PackageParser.Package> pkgs, PackageManagerService packageManagerService) {
        if (!packageManagerService.isHistoricalPackageUsageAvailable()) {
            return;
        }
        Collections.sort(pkgs, (pkg1, pkg2) -> Long.compare(pkg2.getLatestForegroundPackageUseTimeInMills(), pkg1.getLatestForegroundPackageUseTimeInMills()));
    }

    private static void applyPackageFilter(Predicate<PackageParser.Package> filter, Collection<PackageParser.Package> result, Collection<PackageParser.Package> packages, List<PackageParser.Package> sortTemp, PackageManagerService packageManagerService) {
        for (PackageParser.Package pkg : packages) {
            if (!filter.test(pkg)) continue;
            sortTemp.add(pkg);
        }
        PackageManagerServiceUtils.sortPackagesByUsageDate(sortTemp, packageManagerService);
        packages.removeAll(sortTemp);
        for (PackageParser.Package pkg : sortTemp) {
            result.add(pkg);
            List<PackageParser.Package> deps = packageManagerService.findSharedNonSystemLibraries(pkg);
            if (deps.isEmpty()) continue;
            deps.removeAll(result);
            result.addAll(deps);
            packages.removeAll(deps);
        }
        sortTemp.clear();
    }

    public static List<PackageParser.Package> getPackagesForDexopt(Collection<PackageParser.Package> packages, PackageManagerService packageManagerService) {
        Predicate<PackageParser.Package> remainingPredicate;
        ArrayList<PackageParser.Package> remainingPkgs = new ArrayList<PackageParser.Package>(packages);
        LinkedList<PackageParser.Package> result = new LinkedList<PackageParser.Package>();
        ArrayList<PackageParser.Package> sortTemp = new ArrayList<PackageParser.Package>(remainingPkgs.size());
        PackageManagerServiceUtils.applyPackageFilter(pkg -> pkg.coreApp, result, remainingPkgs, sortTemp, packageManagerService);
        Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
        ArraySet<String> pkgNames = PackageManagerServiceUtils.getPackageNamesForIntent(intent, 0);
        PackageManagerServiceUtils.applyPackageFilter(pkg -> pkgNames.contains(pkg.packageName), result, remainingPkgs, sortTemp, packageManagerService);
        DexManager dexManager = packageManagerService.getDexManager();
        PackageManagerServiceUtils.applyPackageFilter(pkg -> dexManager.getPackageUseInfoOrDefault(pkg.packageName).isAnyCodePathUsedByOtherApps(), result, remainingPkgs, sortTemp, packageManagerService);
        if (!remainingPkgs.isEmpty() && packageManagerService.isHistoricalPackageUsageAvailable()) {
            PackageParser.Package lastUsed = Collections.max(remainingPkgs, (pkg1, pkg2) -> Long.compare(pkg1.getLatestForegroundPackageUseTimeInMills(), pkg2.getLatestForegroundPackageUseTimeInMills()));
            long estimatedPreviousSystemUseTime = lastUsed.getLatestForegroundPackageUseTimeInMills();
            if (estimatedPreviousSystemUseTime != 0L) {
                long cutoffTime = estimatedPreviousSystemUseTime - 604800000L;
                remainingPredicate = pkg -> pkg.getLatestForegroundPackageUseTimeInMills() >= cutoffTime;
            } else {
                remainingPredicate = pkg -> true;
            }
            PackageManagerServiceUtils.sortPackagesByUsageDate(remainingPkgs, packageManagerService);
        } else {
            remainingPredicate = pkg -> true;
        }
        PackageManagerServiceUtils.applyPackageFilter(remainingPredicate, result, remainingPkgs, sortTemp, packageManagerService);
        return result;
    }

    static boolean isUnusedSinceTimeInMillis(long firstInstallTime, long currentTimeInMillis, long thresholdTimeinMillis, PackageDexUsage.PackageUseInfo packageUseInfo, long latestPackageUseTimeInMillis, long latestForegroundPackageUseTimeInMillis) {
        boolean isActiveInForeground;
        if (currentTimeInMillis - firstInstallTime < thresholdTimeinMillis) {
            return false;
        }
        boolean bl = isActiveInForeground = currentTimeInMillis - latestForegroundPackageUseTimeInMillis < thresholdTimeinMillis;
        if (isActiveInForeground) {
            return false;
        }
        boolean isActiveInBackgroundAndUsedByOtherPackages = currentTimeInMillis - latestPackageUseTimeInMillis < thresholdTimeinMillis && packageUseInfo.isAnyCodePathUsedByOtherApps();
        return !isActiveInBackgroundAndUsedByOtherPackages;
    }

    public static String realpath(File path) throws IOException {
        try {
            return Libcore.os.realpath(path.getAbsolutePath());
        }
        catch (ErrnoException ee) {
            throw ee.rethrowAsIOException();
        }
    }

    public static String packagesToString(Collection<PackageParser.Package> c) {
        StringBuilder sb = new StringBuilder();
        for (PackageParser.Package pkg : c) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(pkg.packageName);
        }
        return sb.toString();
    }

    public static boolean checkISA(String isa) {
        for (String abi : Build.SUPPORTED_ABIS) {
            if (!VMRuntime.getInstructionSet(abi).equals(isa)) continue;
            return true;
        }
        return false;
    }
}

