/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.security;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Process;
import android.os.UserHandle;
import android.security.IKeyChainService;
import android.util.Slog;
import com.android.server.DeviceIdleController;
import com.android.server.LocalServices;
import com.android.server.SystemService;

public class KeyChainSystemService
extends SystemService {
    private static final String TAG = "KeyChainSystemService";
    private static final int KEYCHAIN_IDLE_WHITELIST_DURATION_MS = 30000;
    private final BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent broadcastIntent) {
            if (broadcastIntent.getPackage() != null) {
                return;
            }
            try {
                Intent intent = new Intent(IKeyChainService.class.getName());
                ComponentName service = intent.resolveSystemService(KeyChainSystemService.this.getContext().getPackageManager(), 0);
                if (service == null) {
                    return;
                }
                intent.setComponent(service);
                intent.setAction(broadcastIntent.getAction());
                KeyChainSystemService.this.startServiceInBackgroundAsUser(intent, UserHandle.of(this.getSendingUserId()));
            }
            catch (RuntimeException e) {
                Slog.e(KeyChainSystemService.TAG, "Unable to forward package removed broadcast to KeyChain", e);
            }
        }
    };

    public KeyChainSystemService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        IntentFilter packageFilter = new IntentFilter("android.intent.action.PACKAGE_REMOVED");
        packageFilter.addDataScheme("package");
        try {
            this.getContext().registerReceiverAsUser(this.mPackageReceiver, UserHandle.ALL, packageFilter, null, null);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Unable to register for package removed broadcast", e);
        }
    }

    private void startServiceInBackgroundAsUser(Intent intent, UserHandle user) {
        if (intent.getComponent() == null) {
            return;
        }
        String packageName = intent.getComponent().getPackageName();
        DeviceIdleController.LocalService idleController = LocalServices.getService(DeviceIdleController.LocalService.class);
        idleController.addPowerSaveTempWhitelistApp(Process.myUid(), packageName, 30000L, user.getIdentifier(), false, "keychain");
        this.getContext().startServiceAsUser(intent, user);
    }
}

