/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.updates;

import android.util.Slog;
import com.android.server.updates.ConfigUpdateInstallReceiver;
import com.android.timezone.distro.TimeZoneDistro;
import com.android.timezone.distro.installer.TimeZoneDistroInstaller;
import java.io.File;
import java.io.IOException;

public class TzDataInstallReceiver
extends ConfigUpdateInstallReceiver {
    private static final String TAG = "TZDataInstallReceiver";
    private static final File SYSTEM_TZ_DATA_FILE = new File("/system/usr/share/zoneinfo/tzdata");
    private static final File TZ_DATA_DIR = new File("/data/misc/zoneinfo");
    private static final String UPDATE_DIR_NAME = TZ_DATA_DIR.getPath() + "/updates/";
    private static final String UPDATE_METADATA_DIR_NAME = "metadata/";
    private static final String UPDATE_VERSION_FILE_NAME = "version";
    private static final String UPDATE_CONTENT_FILE_NAME = "tzdata_distro.zip";
    private final TimeZoneDistroInstaller installer = new TimeZoneDistroInstaller("TZDataInstallReceiver", SYSTEM_TZ_DATA_FILE, TZ_DATA_DIR);

    public TzDataInstallReceiver() {
        super(UPDATE_DIR_NAME, UPDATE_CONTENT_FILE_NAME, UPDATE_METADATA_DIR_NAME, UPDATE_VERSION_FILE_NAME);
    }

    @Override
    protected void install(byte[] content, int version) throws IOException {
        TimeZoneDistro distro = new TimeZoneDistro(content);
        boolean valid = this.installer.install(distro);
        Slog.i(TAG, "Timezone data install valid for this device: " + valid);
        super.install(content, version);
    }
}

