/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class UsbConfigDescriptor
extends UsbDescriptor {
    private static final String TAG = "UsbConfigDescriptor";
    private int mTotalLength;
    private byte mNumInterfaces;
    private byte mConfigValue;
    private byte mConfigIndex;
    private byte mAttribs;
    private byte mMaxPower;

    UsbConfigDescriptor(int length, byte type) {
        super(length, type);
        this.mHierarchyLevel = 2;
    }

    public int getTotalLength() {
        return this.mTotalLength;
    }

    public byte getNumInterfaces() {
        return this.mNumInterfaces;
    }

    public byte getConfigValue() {
        return this.mConfigValue;
    }

    public byte getConfigIndex() {
        return this.mConfigIndex;
    }

    public byte getAttribs() {
        return this.mAttribs;
    }

    public byte getMaxPower() {
        return this.mMaxPower;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mTotalLength = stream.unpackUsbShort();
        this.mNumInterfaces = stream.getByte();
        this.mConfigValue = stream.getByte();
        this.mConfigIndex = stream.getByte();
        this.mAttribs = stream.getByte();
        this.mMaxPower = stream.getByte();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        canvas.writeListItem("Config # " + this.getConfigValue());
        canvas.writeListItem(this.getNumInterfaces() + " Interfaces.");
        canvas.writeListItem("Attributes: " + ReportCanvas.getHexString(this.getAttribs()));
        canvas.closeList();
    }
}

