/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Trace;
import android.util.Slog;
import android.view.IApplicationToken;
import android.view.WindowManagerPolicy;
import com.android.internal.R;
import com.android.server.AttributeCache;
import com.android.server.wm.AppWindowContainerListener;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.SnapshotStartingData;
import com.android.server.wm.SplashScreenStartingData;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;

public class AppWindowContainerController
extends WindowContainerController<AppWindowToken, AppWindowContainerListener> {
    private static final int STARTING_WINDOW_TYPE_NONE = 0;
    private static final int STARTING_WINDOW_TYPE_SNAPSHOT = 1;
    private static final int STARTING_WINDOW_TYPE_SPLASH_SCREEN = 2;
    private final IApplicationToken mToken;
    private final Handler mHandler;
    private final Runnable mOnWindowsVisible = () -> {
        if (this.mListener == null) {
            return;
        }
        ((AppWindowContainerListener)this.mListener).onWindowsVisible();
    };
    private final Runnable mOnWindowsGone = () -> {
        if (this.mListener == null) {
            return;
        }
        ((AppWindowContainerListener)this.mListener).onWindowsGone();
    };
    private final Runnable mAddStartingWindow = () -> {
        AppWindowToken container;
        StartingData startingData;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 12] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                startingData = ((AppWindowToken)this.mContainer).startingData;
                container = (AppWindowToken)this.mContainer;
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        if (startingData == null) {
            return;
        }
        WindowManagerPolicy.StartingSurface surface = null;
        try {
            surface = startingData.createStartingSurface(container);
        }
        catch (Exception e) {
            Slog.w("WindowManager", "Exception when adding starting window", e);
        }
        if (surface != null) {
            boolean abort = false;
            WindowHashMap windowHashMap2 = this.mWindowMap;
            synchronized (windowHashMap2) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (container.removed || container.startingData == null) {
                        container.startingWindow = null;
                        container.startingData = null;
                        abort = true;
                    } else {
                        container.startingSurface = surface;
                    }
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 13] lbl39 : MonitorExitStatement: MONITOREXIT : var5_7
                    WindowManagerService.resetPriorityAfterLockedSection();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[4, 7, 13] lbl43 : MonitorExitStatement: MONITOREXIT : var5_7
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            if (abort) {
                surface.remove();
            }
        }
    };

    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos, Configuration overrideConfig, Rect bounds) {
        this(taskController, token, listener, index, requestedOrientation, fullscreen, showForAllUsers, configChanges, voiceInteraction, launchTaskBehind, alwaysFocusable, targetSdkVersion, rotationAnimationHint, inputDispatchingTimeoutNanos, WindowManagerService.getInstance(), overrideConfig, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos, WindowManagerService service, Configuration overrideConfig, Rect bounds) {
        super(listener, service);
        this.mHandler = new H(service.mH.getLooper());
        this.mToken = token;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                AppWindowToken atoken = this.mRoot.getAppWindowToken(this.mToken.asBinder());
                if (atoken != null) {
                    Slog.w("WindowManager", "Attempted to add existing app token: " + this.mToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var19_18
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                Task task = (Task)taskController.mContainer;
                if (task == null) {
                    throw new IllegalArgumentException("AppWindowContainerController: invalid  controller=" + taskController);
                }
                atoken = this.createAppWindow(this.mService, token, voiceInteraction, task.getDisplayContent(), inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdkVersion, requestedOrientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, this, overrideConfig, bounds);
                task.addChild(atoken, index);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl23 : MonitorExitStatement: MONITOREXIT : var19_18
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl27 : MonitorExitStatement: MONITOREXIT : var19_18
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    AppWindowToken createAppWindow(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, int configChanges, boolean launchTaskBehind, boolean alwaysFocusable, AppWindowContainerController controller, Configuration overrideConfig, Rect bounds) {
        return new AppWindowToken(service, token, voiceInteraction, dc, inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdk, orientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, controller, overrideConfig, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainer(int displayId) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent dc = this.mRoot.getDisplayContent(displayId);
                if (dc == null) {
                    Slog.w("WindowManager", "removeAppToken: Attempted to remove binder token: " + this.mToken + " from non-existing displayId=" + displayId);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                dc.removeAppToken(this.mToken.asBinder());
                super.removeContainer();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    @Override
    public void removeContainer() {
        throw new UnsupportedOperationException("Use removeContainer(displayId) instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(TaskWindowContainerController taskController, int position) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                Task task = (Task)taskController.mContainer;
                if (task == null) {
                    throw new IllegalArgumentException("reparent: could not find task=" + taskController);
                }
                ((AppWindowToken)this.mContainer).reparent(task, position);
                ((AppWindowToken)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration setOrientation(int requestedOrientation, int displayId, Configuration displayConfig, boolean freezeScreenIfNeeded) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    Slog.w("WindowManager", "Attempted to set orientation of non-existing app token: " + this.mToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var5_5
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return null;
                }
                ((AppWindowToken)this.mContainer).setOrientation(requestedOrientation);
                IBinder binder = freezeScreenIfNeeded ? this.mToken.asBinder() : null;
                Configuration configuration = this.mService.updateOrientationFromAppTokens(displayConfig, binder, displayId);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                return configuration;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrientation() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return -1;
                }
                int n = ((AppWindowToken)this.mContainer).getOrientationIgnoreVisibility();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                return n;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOverrideConfigurationChanged(Configuration overrideConfiguration, Rect bounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    ((AppWindowToken)this.mContainer).onOverrideConfigurationChanged(overrideConfiguration, bounds);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisablePreviewScreenshots(boolean disable) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    Slog.w("WindowManager", "Attempted to set disable screenshots of non-existing app token: " + this.mToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                ((AppWindowToken)this.mContainer).setDisablePreviewScreenshots(disable);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(boolean visible, boolean deferHidingClient) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    Slog.w("WindowManager", "Attempted to set visibility of non-existing app token: " + this.mToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 17] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                AppWindowToken wtoken = (AppWindowToken)this.mContainer;
                if (!visible && wtoken.hiddenRequested) {
                    if (!deferHidingClient && wtoken.mDeferHidingClient) {
                        wtoken.mDeferHidingClient = deferHidingClient;
                        wtoken.setClientHidden(true);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 16, 1] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                this.mService.mOpeningApps.remove(wtoken);
                this.mService.mClosingApps.remove(wtoken);
                wtoken.waitingToShow = false;
                wtoken.hiddenRequested = !visible;
                wtoken.mDeferHidingClient = deferHidingClient;
                if (!visible) {
                    wtoken.removeDeadWindows();
                    wtoken.setVisibleBeforeClientHidden();
                } else {
                    if (!this.mService.mAppTransition.isTransitionSet() && this.mService.mAppTransition.isReady()) {
                        this.mService.mOpeningApps.add(wtoken);
                    }
                    wtoken.startingMoved = false;
                    if (wtoken.hidden || wtoken.mAppStopped) {
                        wtoken.clearAllDrawn();
                        if (wtoken.hidden) {
                            wtoken.waitingToShow = true;
                        }
                        if (wtoken.isClientHidden()) {
                            wtoken.setClientHidden(false);
                        }
                    }
                    wtoken.requestUpdateWallpaperIfNeeded();
                    wtoken.mAppStopped = false;
                }
                if (wtoken.okToAnimate() && this.mService.mAppTransition.isTransitionSet()) {
                    AppWindowToken focusedToken;
                    WindowState win;
                    if (wtoken.mAppAnimator.usingTransferredAnimation && wtoken.mAppAnimator.animation == null) {
                        Slog.wtf("WindowManager", "Will NOT set dummy animation on: " + wtoken + ", using null transferred animation!");
                    }
                    if (!(wtoken.mAppAnimator.usingTransferredAnimation || wtoken.startingDisplayed && !this.mService.mSkipAppTransitionAnimation)) {
                        wtoken.mAppAnimator.setDummyAnimation();
                    }
                    wtoken.inPendingTransaction = true;
                    if (visible) {
                        this.mService.mOpeningApps.add(wtoken);
                        wtoken.mEnteringAnimation = true;
                    } else {
                        this.mService.mClosingApps.add(wtoken);
                        wtoken.mEnteringAnimation = false;
                    }
                    if (this.mService.mAppTransition.getAppTransition() == 16 && (win = this.mService.getDefaultDisplayContentLocked().findFocusedWindow()) != null && (focusedToken = win.mAppToken) != null) {
                        focusedToken.hidden = true;
                        this.mService.mOpeningApps.add(focusedToken);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl61 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                wtoken.setVisibility(null, visible, -1, true, wtoken.mVoiceInteraction);
                wtoken.updateReportedVisibilityLocked();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl67 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl71 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUnknownVisibilityLaunched() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    this.mService.mUnknownAppVisibilityController.notifyLaunched((AppWindowToken)this.mContainer);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStartingWindow(String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    Slog.w("WindowManager", "Attempted to set icon of non-existing app token: " + this.mToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 16, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var16_16
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return false;
                }
                if (!((AppWindowToken)this.mContainer).okToDisplay()) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 15] lbl12 : MonitorExitStatement: MONITOREXIT : var16_16
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return false;
                }
                if (((AppWindowToken)this.mContainer).startingData != null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 14] lbl16 : MonitorExitStatement: MONITOREXIT : var16_16
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return false;
                }
                WindowState mainWin = ((AppWindowToken)this.mContainer).findMainWindow();
                if (mainWin != null && mainWin.mWinAnimator.getShown()) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var16_16
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return false;
                }
                ActivityManager.TaskSnapshot snapshot = this.mService.mTaskSnapshotController.getSnapshot(((AppWindowToken)this.mContainer).getTask().mTaskId, ((AppWindowToken)this.mContainer).getTask().mUserId, false, false);
                int type = this.getStartingWindowType(newTask, taskSwitch, processRunning, allowTaskSnapshot, activityCreated, fromRecents, snapshot);
                if (type == 1) {
                    boolean bl = this.createSnapshot(snapshot);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 12] lbl28 : MonitorExitStatement: MONITOREXIT : var16_16
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return bl;
                }
                if (theme != 0) {
                    AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mService.mCurrentUserId);
                    if (ent == null) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 10, 11] lbl34 : MonitorExitStatement: MONITOREXIT : var16_16
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return false;
                    }
                    boolean windowIsTranslucent = ent.array.getBoolean(5, false);
                    boolean windowIsFloating = ent.array.getBoolean(4, false);
                    boolean windowShowWallpaper = ent.array.getBoolean(14, false);
                    boolean windowDisableStarting = ent.array.getBoolean(12, false);
                    if (windowIsTranslucent) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 9, 11] lbl42 : MonitorExitStatement: MONITOREXIT : var16_16
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return false;
                    }
                    if (windowIsFloating || windowDisableStarting) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 8, 11] lbl46 : MonitorExitStatement: MONITOREXIT : var16_16
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return false;
                    }
                    if (windowShowWallpaper) {
                        if (((AppWindowToken)this.mContainer).getDisplayContent().mWallpaperController.getWallpaperTarget() == null) {
                            windowFlags |= 0x100000;
                        } else {
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 7, 11] lbl53 : MonitorExitStatement: MONITOREXIT : var16_16
                            WindowManagerService.resetPriorityAfterLockedSection();
                            return false;
                        }
                    }
                }
                if (((AppWindowToken)this.mContainer).transferStartingWindow(transferFrom)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl57 : MonitorExitStatement: MONITOREXIT : var16_16
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return true;
                }
                if (type != 2) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl61 : MonitorExitStatement: MONITOREXIT : var16_16
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return false;
                }
                ((AppWindowToken)this.mContainer).startingData = new SplashScreenStartingData(this.mService, pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags, ((AppWindowToken)this.mContainer).getMergedOverrideConfiguration());
                this.scheduleAddStartingWindow();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl66 : MonitorExitStatement: MONITOREXIT : var16_16
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl70 : MonitorExitStatement: MONITOREXIT : var16_16
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        return true;
    }

    private int getStartingWindowType(boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents, ActivityManager.TaskSnapshot snapshot) {
        if (this.mService.mAppTransition.getAppTransition() == 19) {
            return 0;
        }
        if (newTask || !processRunning || taskSwitch && !activityCreated) {
            return 2;
        }
        if (taskSwitch && allowTaskSnapshot) {
            return snapshot == null ? 0 : (this.snapshotOrientationSameAsTask(snapshot) || fromRecents ? 1 : 2);
        }
        return 0;
    }

    void scheduleAddStartingWindow() {
        this.mService.mAnimationHandler.postAtFrontOfQueue(this.mAddStartingWindow);
    }

    private boolean createSnapshot(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        ((AppWindowToken)this.mContainer).startingData = new SnapshotStartingData(this.mService, snapshot);
        this.scheduleAddStartingWindow();
        return true;
    }

    private boolean snapshotOrientationSameAsTask(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        return ((AppWindowToken)this.mContainer).getTask().getConfiguration().orientation == snapshot.getOrientation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStartingWindow() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerPolicy.StartingSurface surface;
                WindowManagerService.boostPriorityForLockedSection();
                if (((AppWindowToken)this.mContainer).startingWindow == null) {
                    if (((AppWindowToken)this.mContainer).startingData != null) {
                        ((AppWindowToken)this.mContainer).startingData = null;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (((AppWindowToken)this.mContainer).startingData != null) {
                    surface = ((AppWindowToken)this.mContainer).startingSurface;
                    ((AppWindowToken)this.mContainer).startingData = null;
                    ((AppWindowToken)this.mContainer).startingSurface = null;
                    ((AppWindowToken)this.mContainer).startingWindow = null;
                    ((AppWindowToken)this.mContainer).startingDisplayed = false;
                    if (surface == null) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 7] lbl18 : MonitorExitStatement: MONITOREXIT : var1_1
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                } else {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl22 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                this.mService.mAnimationHandler.post(() -> {
                    try {
                        surface.remove();
                    }
                    catch (Exception e) {
                        Slog.w("WindowManager", "Exception when removing starting window", e);
                    }
                });
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl27 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl31 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseKeyDispatching() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    this.mService.mInputMonitor.pauseDispatchingLw((WindowToken)this.mContainer);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeKeyDispatching() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    this.mService.mInputMonitor.resumeDispatchingLw((WindowToken)this.mContainer);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppResumed(boolean wasStopped) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    Slog.w("WindowManager", "Attempted to notify resumed of non-existing app token: " + this.mToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                ((AppWindowToken)this.mContainer).notifyAppResumed(wasStopped);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppStopped() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    Slog.w("WindowManager", "Attempted to notify stopped of non-existing app token: " + this.mToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                ((AppWindowToken)this.mContainer).notifyAppStopped();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFreezingScreen(int configChanges) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    Slog.w("WindowManager", "Attempted to freeze screen with non-existing app token: " + this.mContainer);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (configChanges == 0 && ((AppWindowToken)this.mContainer).okToDisplay()) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                ((AppWindowToken)this.mContainer).startFreezingScreen();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFreezingScreen(boolean force) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                ((AppWindowToken)this.mContainer).stopFreezingScreen(true, force);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap screenshotApplications(int displayId, int width, int height, float frameScale) {
        try {
            DisplayContent dc;
            Trace.traceBegin(32L, "screenshotApplications");
            Object object = this.mWindowMap;
            synchronized (object) {
                block8: {
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        dc = this.mRoot.getDisplayContentOrCreate(displayId);
                        if (dc != null) break block8;
                        Bitmap bitmap = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var5_5
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return bitmap;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var5_5
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                // MONITOREXIT @DISABLED, blocks:[0, 3, 4] lbl14 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            object = dc.screenshotApplications(this.mToken.asBinder(), width, height, false, frameScale, Bitmap.Config.RGB_565, false, false);
            return object;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    void reportStartingWindowDrawn() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    void reportWindowsDrawn() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
    }

    void reportWindowsVisible() {
        this.mHandler.post(this.mOnWindowsVisible);
    }

    void reportWindowsGone() {
        this.mHandler.post(this.mOnWindowsGone);
    }

    boolean keyDispatchingTimedOut(String reason, int windowPid) {
        return this.mListener != null && ((AppWindowContainerListener)this.mListener).keyDispatchingTimedOut(reason, windowPid);
    }

    public String toString() {
        return "AppWindowContainerController{ token=" + this.mToken + " mContainer=" + this.mContainer + " mListener=" + this.mListener + "}";
    }

    private final class H
    extends Handler {
        public static final int NOTIFY_WINDOWS_DRAWN = 1;
        public static final int NOTIFY_STARTING_WINDOW_DRAWN = 2;

        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (AppWindowContainerController.this.mListener == null) {
                        return;
                    }
                    ((AppWindowContainerListener)AppWindowContainerController.this.mListener).onWindowsDrawn(msg.getWhen());
                    break;
                }
                case 2: {
                    if (AppWindowContainerController.this.mListener == null) {
                        return;
                    }
                    ((AppWindowContainerListener)AppWindowContainerController.this.mListener).onStartingWindowDrawn(msg.getWhen());
                    break;
                }
            }
        }
    }
}

