/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.RemoteException;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayInfo;
import com.android.internal.policy.DividerSnapAlgorithm;
import com.android.internal.policy.DockedDividerUtils;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationTarget;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.PinnedStackWindowController;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.Task;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;

public class TaskStack
extends WindowContainer<Task>
implements DimLayer.DimLayerUser,
BoundsAnimationTarget {
    private static final float ADJUSTED_STACK_FRACTION_MIN = 0.3f;
    private static final float IME_ADJUST_DIM_AMOUNT = 0.25f;
    final int mStackId;
    private final WindowManagerService mService;
    private DisplayContent mDisplayContent;
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private Rect mTmpRect3 = new Rect();
    private Rect mBounds = new Rect();
    private final Rect mAdjustedBounds = new Rect();
    private final Rect mFullyAdjustedImeBounds = new Rect();
    private boolean mFillsParent = true;
    private int mRotation;
    private int mDensity;
    private DimLayer mAnimationBackgroundSurface;
    private WindowStateAnimator mAnimationBackgroundAnimator;
    final AppTokenList mExitingAppTokens = new AppTokenList();
    final AppTokenList mTmpAppTokens = new AppTokenList();
    boolean mDeferRemoval;
    private final Rect mTmpAdjustedBounds = new Rect();
    private boolean mAdjustedForIme;
    private boolean mImeGoingAway;
    private WindowState mImeWin;
    private float mMinimizeAmount;
    private float mAdjustImeAmount;
    private float mAdjustDividerAmount;
    private final int mDockedStackMinimizeThickness;
    private boolean mBoundsAnimating = false;
    private boolean mBoundsAnimatingRequested = false;
    private boolean mBoundsAnimatingToFullscreen = false;
    private boolean mCancelCurrentBoundsAnimation = false;
    private Rect mBoundsAnimationTarget = new Rect();
    private Rect mBoundsAnimationSourceHintBounds = new Rect();
    private final Rect mBoundsAfterRotation = new Rect();
    Rect mPreAnimationBounds = new Rect();

    TaskStack(WindowManagerService service, int stackId) {
        this.mService = service;
        this.mStackId = stackId;
        this.mDockedStackMinimizeThickness = service.mContext.getResources().getDimensionPixelSize(17105020);
        EventLog.writeEvent(31004, stackId);
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    Task findHomeTask() {
        if (this.mStackId != 0) {
            return null;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (!((Task)this.mChildren.get(i)).isHomeTask()) continue;
            return (Task)this.mChildren.get(i);
        }
        return null;
    }

    boolean hasMultipleTaskWithHomeTaskNotTop() {
        return this.mChildren.size() > 1 && !((Task)this.mChildren.get(this.mChildren.size() - 1)).isHomeTask();
    }

    boolean setBounds(Rect stackBounds, SparseArray<Configuration> configs, SparseArray<Rect> taskBounds, SparseArray<Rect> taskTempInsetBounds) {
        this.setBounds(stackBounds);
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            Configuration config = configs.get(task.mTaskId);
            if (config != null) {
                Rect bounds = taskBounds.get(task.mTaskId);
                task.resizeLocked(bounds, config, false);
                task.setTempInsetBounds(taskTempInsetBounds != null ? taskTempInsetBounds.get(task.mTaskId) : null);
                continue;
            }
            Slog.wtf("WindowManager", "No config for task: " + task + ", is there a mismatch with AM?");
        }
        return true;
    }

    void prepareFreezingTaskBounds() {
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            task.prepareFreezingBounds();
        }
    }

    private void setAdjustedBounds(Rect bounds) {
        if (this.mAdjustedBounds.equals(bounds) && !this.isAnimatingForIme()) {
            return;
        }
        this.mAdjustedBounds.set(bounds);
        boolean adjusted = !this.mAdjustedBounds.isEmpty();
        Rect insetBounds = null;
        if (adjusted && this.isAdjustedForMinimizedDockedStack()) {
            insetBounds = this.mBounds;
        } else if (adjusted && this.mAdjustedForIme) {
            insetBounds = this.mImeGoingAway ? this.mBounds : this.mFullyAdjustedImeBounds;
        }
        this.alignTasksToAdjustedBounds(adjusted ? this.mAdjustedBounds : this.mBounds, insetBounds);
        this.mDisplayContent.setLayoutNeeded();
    }

    private void alignTasksToAdjustedBounds(Rect adjustedBounds, Rect tempInsetBounds) {
        if (this.mFillsParent) {
            return;
        }
        boolean alignBottom = this.mAdjustedForIme && this.getDockSide() == 2;
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            task.alignToAdjustedBounds(adjustedBounds, tempInsetBounds, alignBottom);
        }
    }

    private boolean setBounds(Rect bounds) {
        boolean oldFullscreen = this.mFillsParent;
        int rotation = 0;
        int density = 0;
        if (this.mDisplayContent != null) {
            this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
            rotation = this.mDisplayContent.getDisplayInfo().rotation;
            density = this.mDisplayContent.getDisplayInfo().logicalDensityDpi;
            boolean bl = this.mFillsParent = bounds == null;
            if (this.mFillsParent) {
                bounds = this.mTmpRect;
            }
        }
        if (bounds == null) {
            return false;
        }
        if (this.mBounds.equals(bounds) && oldFullscreen == this.mFillsParent && this.mRotation == rotation) {
            return false;
        }
        if (this.mDisplayContent != null) {
            this.mDisplayContent.mDimLayerController.updateDimLayer(this);
            this.mAnimationBackgroundSurface.setBounds(bounds);
        }
        this.mBounds.set(bounds);
        this.mRotation = rotation;
        this.mDensity = density;
        this.updateAdjustedBounds();
        return true;
    }

    void getRawBounds(Rect out) {
        out.set(this.mBounds);
    }

    private boolean useCurrentBounds() {
        return this.mFillsParent || !ActivityManager.StackId.isResizeableByDockedStack(this.mStackId) || this.mDisplayContent == null || this.mDisplayContent.getDockedStackLocked() != null;
    }

    public void getBounds(Rect out) {
        if (this.useCurrentBounds()) {
            if (!this.mAdjustedBounds.isEmpty()) {
                out.set(this.mAdjustedBounds);
            } else {
                out.set(this.mBounds);
            }
            return;
        }
        this.mDisplayContent.getLogicalDisplayRect(out);
    }

    void setAnimationFinalBounds(Rect sourceHintBounds, Rect destBounds, boolean toFullscreen) {
        this.mBoundsAnimatingRequested = true;
        this.mBoundsAnimatingToFullscreen = toFullscreen;
        if (destBounds != null) {
            this.mBoundsAnimationTarget.set(destBounds);
        } else {
            this.mBoundsAnimationTarget.setEmpty();
        }
        if (sourceHintBounds != null) {
            this.mBoundsAnimationSourceHintBounds.set(sourceHintBounds);
        } else {
            this.mBoundsAnimationSourceHintBounds.setEmpty();
        }
        this.mPreAnimationBounds.set(this.mBounds);
    }

    void getFinalAnimationBounds(Rect outBounds) {
        outBounds.set(this.mBoundsAnimationTarget);
    }

    void getFinalAnimationSourceHintBounds(Rect outBounds) {
        outBounds.set(this.mBoundsAnimationSourceHintBounds);
    }

    void getAnimationOrCurrentBounds(Rect outBounds) {
        if ((this.mBoundsAnimatingRequested || this.mBoundsAnimating) && !this.mBoundsAnimationTarget.isEmpty()) {
            this.getFinalAnimationBounds(outBounds);
            return;
        }
        this.getBounds(outBounds);
    }

    @Override
    public void getDimBounds(Rect out) {
        this.getBounds(out);
    }

    void updateDisplayInfo(Rect bounds) {
        if (this.mDisplayContent == null) {
            return;
        }
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            ((Task)this.mChildren.get(taskNdx)).updateDisplayInfo(this.mDisplayContent);
        }
        if (bounds != null) {
            this.setBounds(bounds);
            return;
        }
        if (this.mFillsParent) {
            this.setBounds(null);
            return;
        }
        this.mTmpRect2.set(this.mBounds);
        int newRotation = this.mDisplayContent.getDisplayInfo().rotation;
        int newDensity = this.mDisplayContent.getDisplayInfo().logicalDensityDpi;
        if (this.mRotation == newRotation && this.mDensity == newDensity) {
            this.setBounds(this.mTmpRect2);
        }
    }

    boolean updateBoundsAfterConfigChange() {
        if (this.mDisplayContent == null) {
            return false;
        }
        if (this.mStackId == 4) {
            this.getAnimationOrCurrentBounds(this.mTmpRect2);
            boolean updated = this.mDisplayContent.mPinnedStackControllerLocked.onTaskStackBoundsChanged(this.mTmpRect2, this.mTmpRect3);
            if (updated) {
                this.mBoundsAfterRotation.set(this.mTmpRect3);
                this.mBoundsAnimationTarget.setEmpty();
                this.mBoundsAnimationSourceHintBounds.setEmpty();
                this.mCancelCurrentBoundsAnimation = true;
                return true;
            }
        }
        int newRotation = this.getDisplayInfo().rotation;
        int newDensity = this.getDisplayInfo().logicalDensityDpi;
        if (this.mRotation == newRotation && this.mDensity == newDensity) {
            return false;
        }
        if (this.mFillsParent) {
            this.setBounds(null);
            return false;
        }
        this.mTmpRect2.set(this.mBounds);
        this.mDisplayContent.rotateBounds(this.mRotation, newRotation, this.mTmpRect2);
        switch (this.mStackId) {
            case 3: {
                this.repositionDockedStackAfterRotation(this.mTmpRect2);
                this.snapDockedStackAfterRotation(this.mTmpRect2);
                int newDockSide = this.getDockSide(this.mTmpRect2);
                this.mService.setDockedStackCreateStateLocked(newDockSide == 1 || newDockSide == 2 ? 0 : 1, null);
                this.mDisplayContent.getDockedDividerController().notifyDockSideChanged(newDockSide);
            }
        }
        this.mBoundsAfterRotation.set(this.mTmpRect2);
        return true;
    }

    void getBoundsForNewConfiguration(Rect outBounds) {
        outBounds.set(this.mBoundsAfterRotation);
        this.mBoundsAfterRotation.setEmpty();
    }

    private void repositionDockedStackAfterRotation(Rect inOutBounds) {
        int dockSide = this.getDockSide(inOutBounds);
        if (this.mService.mPolicy.isDockSideAllowed(dockSide)) {
            return;
        }
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
        dockSide = DockedDividerUtils.invertDockSide(dockSide);
        switch (dockSide) {
            case 1: {
                int movement = inOutBounds.left;
                inOutBounds.left -= movement;
                inOutBounds.right -= movement;
                break;
            }
            case 3: {
                int movement = this.mTmpRect.right - inOutBounds.right;
                inOutBounds.left += movement;
                inOutBounds.right += movement;
                break;
            }
            case 2: {
                int movement = inOutBounds.top;
                inOutBounds.top -= movement;
                inOutBounds.bottom -= movement;
                break;
            }
            case 4: {
                int movement = this.mTmpRect.bottom - inOutBounds.bottom;
                inOutBounds.top += movement;
                inOutBounds.bottom += movement;
            }
        }
    }

    private void snapDockedStackAfterRotation(Rect outBounds) {
        DisplayInfo displayInfo = this.mDisplayContent.getDisplayInfo();
        int dividerSize = this.mDisplayContent.getDockedDividerController().getContentWidth();
        int dockSide = this.getDockSide(outBounds);
        int dividerPosition = DockedDividerUtils.calculatePositionForBounds(outBounds, dockSide, dividerSize);
        int displayWidth = this.mDisplayContent.getDisplayInfo().logicalWidth;
        int displayHeight = this.mDisplayContent.getDisplayInfo().logicalHeight;
        int rotation = displayInfo.rotation;
        int orientation = this.mDisplayContent.getConfiguration().orientation;
        this.mService.mPolicy.getStableInsetsLw(rotation, displayWidth, displayHeight, outBounds);
        DividerSnapAlgorithm algorithm = new DividerSnapAlgorithm(this.mService.mContext.getResources(), displayWidth, displayHeight, dividerSize, orientation == 1, outBounds, this.isMinimizedDockAndHomeStackResizable());
        DividerSnapAlgorithm.SnapTarget target = algorithm.calculateNonDismissingSnapTarget(dividerPosition);
        DockedDividerUtils.calculateBoundsForPosition(target.position, dockSide, outBounds, displayInfo.logicalWidth, displayInfo.logicalHeight, dividerSize);
    }

    void addTask(Task task, int position) {
        this.addTask(task, position, task.showForAllUsers(), true);
    }

    void addTask(Task task, int position, boolean showForAllUsers, boolean moveParents) {
        TaskStack currentStack = task.mStack;
        if (currentStack != null && currentStack.mStackId != this.mStackId) {
            throw new IllegalStateException("Trying to add taskId=" + task.mTaskId + " to stackId=" + this.mStackId + ", but it is already attached to stackId=" + task.mStack.mStackId);
        }
        task.mStack = this;
        this.addChild(task, null);
        this.positionChildAt(position, task, moveParents, showForAllUsers);
    }

    @Override
    void positionChildAt(int position, Task child, boolean includingParents) {
        this.positionChildAt(position, child, includingParents, child.showForAllUsers());
    }

    private void positionChildAt(int position, Task child, boolean includingParents, boolean showForAllUsers) {
        int targetPosition = this.findPositionForTask(child, position, showForAllUsers, false);
        super.positionChildAt(targetPosition, child, includingParents);
        int toTop = targetPosition == this.mChildren.size() - 1 ? 1 : 0;
        EventLog.writeEvent(31002, child.mTaskId, toTop, targetPosition);
    }

    private int findPositionForTask(Task task, int targetPosition, boolean showForAllUsers, boolean addingNew) {
        int maxPosition;
        boolean canShowTask = showForAllUsers || this.mService.isCurrentProfileLocked(task.mUserId);
        int stackSize = this.mChildren.size();
        int minPosition = 0;
        int n = maxPosition = addingNew ? stackSize : stackSize - 1;
        if (canShowTask) {
            minPosition = this.computeMinPosition(minPosition, stackSize);
        } else {
            maxPosition = this.computeMaxPosition(maxPosition);
        }
        return Math.min(Math.max(targetPosition, minPosition), maxPosition);
    }

    private int computeMinPosition(int minPosition, int size) {
        while (minPosition < size) {
            boolean canShowTmpTask;
            Task tmpTask = (Task)this.mChildren.get(minPosition);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mService.isCurrentProfileLocked(tmpTask.mUserId);
            if (canShowTmpTask) break;
            ++minPosition;
        }
        return minPosition;
    }

    private int computeMaxPosition(int maxPosition) {
        while (maxPosition > 0) {
            boolean canShowTmpTask;
            Task tmpTask = (Task)this.mChildren.get(maxPosition);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mService.isCurrentProfileLocked(tmpTask.mUserId);
            if (!canShowTmpTask) break;
            --maxPosition;
        }
        return maxPosition;
    }

    @Override
    void removeChild(Task task) {
        super.removeChild(task);
        task.mStack = null;
        if (this.mDisplayContent != null) {
            if (this.mChildren.isEmpty()) {
                this.getParent().positionChildAt(Integer.MIN_VALUE, this, false);
            }
            this.mDisplayContent.setLayoutNeeded();
        }
        for (int appNdx = this.mExitingAppTokens.size() - 1; appNdx >= 0; --appNdx) {
            AppWindowToken wtoken = (AppWindowToken)this.mExitingAppTokens.get(appNdx);
            if (wtoken.getTask() != task) continue;
            wtoken.mIsExiting = false;
            this.mExitingAppTokens.remove(appNdx);
        }
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        if (this.mDisplayContent != null) {
            throw new IllegalStateException("onDisplayChanged: Already attached");
        }
        this.mDisplayContent = dc;
        this.mAnimationBackgroundSurface = new DimLayer(this.mService, this, this.mDisplayContent.getDisplayId(), "animation background stackId=" + this.mStackId);
        Rect bounds = null;
        TaskStack dockedStack = dc.getDockedStackIgnoringVisibility();
        if (this.mStackId == 3 || dockedStack != null && ActivityManager.StackId.isResizeableByDockedStack(this.mStackId) && !dockedStack.fillsParent()) {
            bounds = new Rect();
            dc.getLogicalDisplayRect(this.mTmpRect);
            this.mTmpRect2.setEmpty();
            if (dockedStack != null) {
                dockedStack.getRawBounds(this.mTmpRect2);
            }
            boolean dockedOnTopOrLeft = this.mService.mDockedStackCreateMode == 0;
            this.getStackDockedModeBounds(this.mTmpRect, bounds, this.mStackId, this.mTmpRect2, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
        } else if (this.mStackId == 4) {
            this.getAnimationOrCurrentBounds(this.mTmpRect2);
            boolean updated = this.mDisplayContent.mPinnedStackControllerLocked.onTaskStackBoundsChanged(this.mTmpRect2, this.mTmpRect3);
            if (updated) {
                bounds = new Rect(this.mTmpRect3);
            }
        }
        this.updateDisplayInfo(bounds);
        super.onDisplayChanged(dc);
    }

    void getStackDockedModeBoundsLocked(Rect currentTempTaskBounds, Rect outStackBounds, Rect outTempTaskBounds, boolean ignoreVisibility) {
        outTempTaskBounds.setEmpty();
        if (this.mStackId == 0) {
            Task homeTask = this.findHomeTask();
            if (homeTask != null && homeTask.isResizeable()) {
                this.getDisplayContent().mDividerControllerLocked.getHomeStackBoundsInDockedMode(outStackBounds);
            } else {
                outStackBounds.setEmpty();
            }
            outTempTaskBounds.set(outStackBounds);
            return;
        }
        if (this.isMinimizedDockAndHomeStackResizable() && currentTempTaskBounds != null) {
            outStackBounds.set(currentTempTaskBounds);
            return;
        }
        if (this.mStackId != 3 && !ActivityManager.StackId.isResizeableByDockedStack(this.mStackId) || this.mDisplayContent == null) {
            outStackBounds.set(this.mBounds);
            return;
        }
        TaskStack dockedStack = this.mDisplayContent.getDockedStackIgnoringVisibility();
        if (dockedStack == null) {
            throw new IllegalStateException("Calling getStackDockedModeBoundsLocked() when there is no docked stack.");
        }
        if (!ignoreVisibility && !dockedStack.isVisible()) {
            this.mDisplayContent.getLogicalDisplayRect(outStackBounds);
            return;
        }
        int dockedSide = dockedStack.getDockSide();
        if (dockedSide == -1) {
            Slog.e("WindowManager", "Failed to get valid docked side for docked stack=" + dockedStack);
            outStackBounds.set(this.mBounds);
            return;
        }
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
        dockedStack.getRawBounds(this.mTmpRect2);
        boolean dockedOnTopOrLeft = dockedSide == 2 || dockedSide == 1;
        this.getStackDockedModeBounds(this.mTmpRect, outStackBounds, this.mStackId, this.mTmpRect2, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
    }

    private void getStackDockedModeBounds(Rect displayRect, Rect outBounds, int stackId, Rect dockedBounds, int dockDividerWidth, boolean dockOnTopOrLeft) {
        boolean dockedStack = stackId == 3;
        boolean splitHorizontally = displayRect.width() > displayRect.height();
        outBounds.set(displayRect);
        if (dockedStack) {
            if (this.mService.mDockedStackCreateBounds != null) {
                outBounds.set(this.mService.mDockedStackCreateBounds);
                return;
            }
            DisplayInfo di = this.mDisplayContent.getDisplayInfo();
            this.mService.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, this.mTmpRect2);
            int position = new DividerSnapAlgorithm((Resources)this.mService.mContext.getResources(), (int)di.logicalWidth, (int)di.logicalHeight, (int)dockDividerWidth, (boolean)(this.mDisplayContent.getConfiguration().orientation == 1 ? true : false), (Rect)this.mTmpRect2).getMiddleTarget().position;
            if (dockOnTopOrLeft) {
                if (splitHorizontally) {
                    outBounds.right = position;
                } else {
                    outBounds.bottom = position;
                }
            } else if (splitHorizontally) {
                outBounds.left = position + dockDividerWidth;
            } else {
                outBounds.top = position + dockDividerWidth;
            }
            return;
        }
        if (!dockOnTopOrLeft) {
            if (splitHorizontally) {
                outBounds.right = dockedBounds.left - dockDividerWidth;
            } else {
                outBounds.bottom = dockedBounds.top - dockDividerWidth;
            }
        } else if (splitHorizontally) {
            outBounds.left = dockedBounds.right + dockDividerWidth;
        } else {
            outBounds.top = dockedBounds.bottom + dockDividerWidth;
        }
        DockedDividerUtils.sanitizeStackBounds(outBounds, !dockOnTopOrLeft);
    }

    void resetDockedStackToMiddle() {
        if (this.mStackId != 3) {
            throw new IllegalStateException("Not a docked stack=" + this);
        }
        this.mService.mDockedStackCreateBounds = null;
        Rect bounds = new Rect();
        Rect tempBounds = new Rect();
        this.getStackDockedModeBoundsLocked(null, bounds, tempBounds, true);
        this.getController().requestResize(bounds);
    }

    @Override
    StackWindowController getController() {
        return (StackWindowController)super.getController();
    }

    @Override
    void removeIfPossible() {
        if (this.isAnimating()) {
            this.mDeferRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        super.removeImmediately();
        this.onRemovedFromDisplay();
    }

    void onRemovedFromDisplay() {
        this.mDisplayContent.mDimLayerController.removeDimLayerUser(this);
        EventLog.writeEvent(31006, this.mStackId);
        if (this.mAnimationBackgroundSurface != null) {
            this.mAnimationBackgroundSurface.destroySurface();
            this.mAnimationBackgroundSurface = null;
        }
        if (this.mStackId == 3) {
            this.mDisplayContent.mDividerControllerLocked.notifyDockedStackExistsChanged(false);
        }
        this.mDisplayContent = null;
        this.mService.mWindowPlacerLocked.requestTraversal();
    }

    void resetAnimationBackgroundAnimator() {
        this.mAnimationBackgroundAnimator = null;
        this.mAnimationBackgroundSurface.hide();
    }

    void setAnimationBackground(WindowStateAnimator winAnimator, int color2) {
        int animLayer = winAnimator.mAnimLayer;
        if (this.mAnimationBackgroundAnimator == null || animLayer < this.mAnimationBackgroundAnimator.mAnimLayer) {
            this.mAnimationBackgroundAnimator = winAnimator;
            animLayer = this.mDisplayContent.getLayerForAnimationBackground(winAnimator);
            this.mAnimationBackgroundSurface.show(animLayer - 1, (float)(color2 >> 24 & 0xFF) / 255.0f, 0L);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        int top = this.mChildren.size();
        for (int taskNdx = 0; taskNdx < top; ++taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            if (!this.mService.isCurrentProfileLocked(task.mUserId) && !task.showForAllUsers()) continue;
            this.mChildren.remove(taskNdx);
            this.mChildren.add(task);
            --top;
        }
    }

    void setAdjustedForIme(WindowState imeWin, boolean forceUpdate) {
        this.mImeWin = imeWin;
        this.mImeGoingAway = false;
        if (!this.mAdjustedForIme || forceUpdate) {
            this.mAdjustedForIme = true;
            this.mAdjustImeAmount = 0.0f;
            this.mAdjustDividerAmount = 0.0f;
            this.updateAdjustForIme(0.0f, 0.0f, true);
        }
    }

    boolean isAdjustedForIme() {
        return this.mAdjustedForIme;
    }

    boolean isAnimatingForIme() {
        return this.mImeWin != null && this.mImeWin.isAnimatingLw();
    }

    boolean updateAdjustForIme(float adjustAmount, float adjustDividerAmount, boolean force) {
        if (adjustAmount != this.mAdjustImeAmount || adjustDividerAmount != this.mAdjustDividerAmount || force) {
            this.mAdjustImeAmount = adjustAmount;
            this.mAdjustDividerAmount = adjustDividerAmount;
            this.updateAdjustedBounds();
            return this.isVisible();
        }
        return false;
    }

    void resetAdjustedForIme(boolean adjustBoundsNow) {
        if (adjustBoundsNow) {
            this.mImeWin = null;
            this.mAdjustedForIme = false;
            this.mImeGoingAway = false;
            this.mAdjustImeAmount = 0.0f;
            this.mAdjustDividerAmount = 0.0f;
            this.updateAdjustedBounds();
            this.mService.setResizeDimLayer(false, this.mStackId, 1.0f);
        } else {
            this.mImeGoingAway |= this.mAdjustedForIme;
        }
    }

    boolean setAdjustedForMinimizedDock(float minimizeAmount) {
        if (minimizeAmount != this.mMinimizeAmount) {
            this.mMinimizeAmount = minimizeAmount;
            this.updateAdjustedBounds();
            return this.isVisible();
        }
        return false;
    }

    boolean shouldIgnoreInput() {
        return this.isAdjustedForMinimizedDockedStack() || this.mStackId == 3 && this.isMinimizedDockAndHomeStackResizable();
    }

    void beginImeAdjustAnimation() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            Task task = (Task)this.mChildren.get(j);
            if (!task.hasContentToDisplay()) continue;
            task.setDragResizing(true, 1);
            task.setWaitingForDrawnIfResizingChanged();
        }
    }

    void endImeAdjustAnimation() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            ((Task)this.mChildren.get(j)).setDragResizing(false, 1);
        }
    }

    int getMinTopStackBottom(Rect displayContentRect, int originalStackBottom) {
        return displayContentRect.top + (int)((float)(originalStackBottom - displayContentRect.top) * 0.3f);
    }

    private boolean adjustForIME(WindowState imeWin) {
        boolean dockedTopOrBottom;
        int dockedSide = this.getDockSide();
        boolean bl = dockedTopOrBottom = dockedSide == 2 || dockedSide == 4;
        if (imeWin == null || !dockedTopOrBottom) {
            return false;
        }
        Rect displayContentRect = this.mTmpRect;
        Rect contentBounds = this.mTmpRect2;
        this.getDisplayContent().getContentRect(displayContentRect);
        contentBounds.set(displayContentRect);
        int imeTop = Math.max(imeWin.getFrameLw().top, contentBounds.top);
        if (contentBounds.bottom > (imeTop += imeWin.getGivenContentInsetsLw().top)) {
            contentBounds.bottom = imeTop;
        }
        int yOffset = displayContentRect.bottom - contentBounds.bottom;
        int dividerWidth = this.getDisplayContent().mDividerControllerLocked.getContentWidth();
        int dividerWidthInactive = this.getDisplayContent().mDividerControllerLocked.getContentWidthInactive();
        if (dockedSide == 2) {
            int minTopStackBottom = this.getMinTopStackBottom(displayContentRect, this.mBounds.bottom);
            int bottom = Math.max(this.mBounds.bottom - yOffset + dividerWidth - dividerWidthInactive, minTopStackBottom);
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.bottom = (int)(this.mAdjustImeAmount * (float)bottom + (1.0f - this.mAdjustImeAmount) * (float)this.mBounds.bottom);
            this.mFullyAdjustedImeBounds.set(this.mBounds);
        } else {
            int dividerWidthDelta = dividerWidthInactive - dividerWidth;
            int topBeforeImeAdjust = this.mBounds.top - dividerWidth + dividerWidthInactive;
            int minTopStackBottom = this.getMinTopStackBottom(displayContentRect, this.mBounds.top - dividerWidth);
            int top = Math.max(this.mBounds.top - yOffset, minTopStackBottom + dividerWidthInactive);
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.top = this.mBounds.top + (int)(this.mAdjustImeAmount * (float)(top - topBeforeImeAdjust) + this.mAdjustDividerAmount * (float)dividerWidthDelta);
            this.mFullyAdjustedImeBounds.set(this.mBounds);
            this.mFullyAdjustedImeBounds.top = top;
            this.mFullyAdjustedImeBounds.bottom = top + this.mBounds.height();
        }
        return true;
    }

    private boolean adjustForMinimizedDockedStack(float minimizeAmount) {
        int dockSide = this.getDockSide();
        if (dockSide == -1 && !this.mTmpAdjustedBounds.isEmpty()) {
            return false;
        }
        if (dockSide == 2) {
            this.mService.getStableInsetsLocked(0, this.mTmpRect);
            int topInset = this.mTmpRect.top;
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.bottom = (int)(minimizeAmount * (float)topInset + (1.0f - minimizeAmount) * (float)this.mBounds.bottom);
        } else if (dockSide == 1) {
            this.mTmpAdjustedBounds.set(this.mBounds);
            int width = this.mBounds.width();
            this.mTmpAdjustedBounds.right = (int)(minimizeAmount * (float)this.mDockedStackMinimizeThickness + (1.0f - minimizeAmount) * (float)this.mBounds.right);
            this.mTmpAdjustedBounds.left = this.mTmpAdjustedBounds.right - width;
        } else if (dockSide == 3) {
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.left = (int)(minimizeAmount * (float)(this.mBounds.right - this.mDockedStackMinimizeThickness) + (1.0f - minimizeAmount) * (float)this.mBounds.left);
        }
        return true;
    }

    private boolean isMinimizedDockAndHomeStackResizable() {
        return this.mDisplayContent.mDividerControllerLocked.isMinimizedDock() && this.mDisplayContent.mDividerControllerLocked.isHomeStackResizable();
    }

    int getMinimizeDistance() {
        int dockSide = this.getDockSide();
        if (dockSide == -1) {
            return 0;
        }
        if (dockSide == 2) {
            this.mService.getStableInsetsLocked(0, this.mTmpRect);
            int topInset = this.mTmpRect.top;
            return this.mBounds.bottom - topInset;
        }
        if (dockSide == 1 || dockSide == 3) {
            return this.mBounds.width() - this.mDockedStackMinimizeThickness;
        }
        return 0;
    }

    private void updateAdjustedBounds() {
        boolean isImeTarget;
        boolean adjust = false;
        if (this.mMinimizeAmount != 0.0f) {
            adjust = this.adjustForMinimizedDockedStack(this.mMinimizeAmount);
        } else if (this.mAdjustedForIme) {
            adjust = this.adjustForIME(this.mImeWin);
        }
        if (!adjust) {
            this.mTmpAdjustedBounds.setEmpty();
        }
        this.setAdjustedBounds(this.mTmpAdjustedBounds);
        boolean bl = isImeTarget = this.mService.getImeFocusStackLocked() == this;
        if (this.mAdjustedForIme && adjust && !isImeTarget) {
            float alpha = Math.max(this.mAdjustImeAmount, this.mAdjustDividerAmount) * 0.25f;
            this.mService.setResizeDimLayer(true, this.mStackId, alpha);
        }
    }

    void applyAdjustForImeIfNeeded(Task task) {
        if (this.mMinimizeAmount != 0.0f || !this.mAdjustedForIme || this.mAdjustedBounds.isEmpty()) {
            return;
        }
        Rect insetBounds = this.mImeGoingAway ? this.mBounds : this.mFullyAdjustedImeBounds;
        task.alignToAdjustedBounds(this.mAdjustedBounds, insetBounds, this.getDockSide() == 2);
        this.mDisplayContent.setLayoutNeeded();
    }

    boolean isAdjustedForMinimizedDockedStack() {
        return this.mMinimizeAmount != 0.0f;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "mStackId=" + this.mStackId);
        pw.println(prefix + "mDeferRemoval=" + this.mDeferRemoval);
        pw.println(prefix + "mFillsParent=" + this.mFillsParent);
        pw.println(prefix + "mBounds=" + this.mBounds.toShortString());
        if (this.mMinimizeAmount != 0.0f) {
            pw.println(prefix + "mMinimizeAmount=" + this.mMinimizeAmount);
        }
        if (this.mAdjustedForIme) {
            pw.println(prefix + "mAdjustedForIme=true");
            pw.println(prefix + "mAdjustImeAmount=" + this.mAdjustImeAmount);
            pw.println(prefix + "mAdjustDividerAmount=" + this.mAdjustDividerAmount);
        }
        if (!this.mAdjustedBounds.isEmpty()) {
            pw.println(prefix + "mAdjustedBounds=" + this.mAdjustedBounds.toShortString());
        }
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            ((Task)this.mChildren.get(taskNdx)).dump(prefix + "  ", pw);
        }
        if (this.mAnimationBackgroundSurface.isDimming()) {
            pw.println(prefix + "mWindowAnimationBackgroundSurface:");
            this.mAnimationBackgroundSurface.printTo(prefix + "  ", pw);
        }
        if (!this.mExitingAppTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (int i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                WindowToken token = (WindowToken)this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
    }

    boolean getRawFullscreen() {
        return this.mFillsParent;
    }

    @Override
    public boolean dimFullscreen() {
        return ActivityManager.StackId.isHomeOrRecentsStack(this.mStackId) || this.fillsParent();
    }

    @Override
    boolean fillsParent() {
        if (this.useCurrentBounds()) {
            return this.mFillsParent;
        }
        return true;
    }

    @Override
    public DisplayInfo getDisplayInfo() {
        return this.mDisplayContent.getDisplayInfo();
    }

    @Override
    public boolean isAttachedToDisplay() {
        return this.mDisplayContent != null;
    }

    public String toString() {
        return "{stackId=" + this.mStackId + " tasks=" + this.mChildren + "}";
    }

    @Override
    String getName() {
        return this.toShortString();
    }

    @Override
    public String toShortString() {
        return "Stack=" + this.mStackId;
    }

    int getDockSide() {
        return this.getDockSide(this.mBounds);
    }

    int getDockSide(Rect bounds) {
        if (this.mStackId != 3 && !ActivityManager.StackId.isResizeableByDockedStack(this.mStackId)) {
            return -1;
        }
        if (this.mDisplayContent == null) {
            return -1;
        }
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
        int orientation = this.mDisplayContent.getConfiguration().orientation;
        return TaskStack.getDockSideUnchecked(bounds, this.mTmpRect, orientation);
    }

    static int getDockSideUnchecked(Rect bounds, Rect displayRect, int orientation) {
        if (orientation == 1) {
            if (bounds.top - displayRect.top <= displayRect.bottom - bounds.bottom) {
                return 2;
            }
            return 4;
        }
        if (orientation == 2) {
            if (bounds.left - displayRect.left <= displayRect.right - bounds.right) {
                return 1;
            }
            return 3;
        }
        return -1;
    }

    boolean hasTaskForUser(int userId) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            if (task.mUserId != userId) continue;
            return true;
        }
        return false;
    }

    int taskIdFromPoint(int x, int y) {
        this.getBounds(this.mTmpRect);
        if (!this.mTmpRect.contains(x, y) || this.isAdjustedForMinimizedDockedStack()) {
            return -1;
        }
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            WindowState win = task.getTopVisibleAppMainWindow();
            if (win == null) continue;
            task.getDimBounds(this.mTmpRect);
            if (!this.mTmpRect.contains(x, y)) continue;
            return task.mTaskId;
        }
        return -1;
    }

    void findTaskForResizePoint(int x, int y, int delta, DisplayContent.TaskForResizePointSearchResult results) {
        if (!ActivityManager.StackId.isTaskResizeAllowed(this.mStackId)) {
            results.searchDone = true;
            return;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            if (task.isFullscreen()) {
                results.searchDone = true;
                return;
            }
            task.getDimBounds(this.mTmpRect);
            this.mTmpRect.inset(-delta, -delta);
            if (!this.mTmpRect.contains(x, y)) continue;
            this.mTmpRect.inset(delta, delta);
            results.searchDone = true;
            if (!this.mTmpRect.contains(x, y)) {
                results.taskForResize = task;
                return;
            }
            return;
        }
    }

    void setTouchExcludeRegion(Task focusedTask, int delta, Region touchExcludeRegion, Rect contentRect, Rect postExclude) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            AppWindowToken token = task.getTopVisibleAppToken();
            if (token == null || !token.hasContentToDisplay()) continue;
            if (task.isHomeTask() && this.isMinimizedDockAndHomeStackResizable()) {
                this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
            } else {
                task.getDimBounds(this.mTmpRect);
            }
            if (task == focusedTask) {
                postExclude.set(this.mTmpRect);
            }
            boolean isFreeformed = task.inFreeformWorkspace();
            if (task == focusedTask && !isFreeformed) continue;
            if (isFreeformed) {
                this.mTmpRect.inset(-delta, -delta);
                this.mTmpRect.intersect(contentRect);
            }
            touchExcludeRegion.op(this.mTmpRect, Region.Op.DIFFERENCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPinnedStackSize(Rect stackBounds, Rect tempTaskBounds) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            WindowManagerService.boostPriorityForLockedSection();
            if (this.mCancelCurrentBoundsAnimation) {
                // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                return false;
            }
            try {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[0, 3, 4] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        try {
            this.mService.mActivityManager.resizePinnedStack(stackBounds, tempTaskBounds);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    void onAllWindowsDrawn() {
        if (!this.mBoundsAnimating && !this.mBoundsAnimatingRequested) {
            return;
        }
        this.mService.mBoundsAnimationController.onAllWindowsDrawn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnimationStart(boolean schedulePipModeChangedCallback, boolean forceUpdate) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mBoundsAnimatingRequested = false;
                this.mBoundsAnimating = true;
                this.mCancelCurrentBoundsAnimation = false;
                if (schedulePipModeChangedCallback) {
                    this.forAllWindows((WindowState w) -> w.mWinAnimator.resetDrawState(), false);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        if (this.mStackId == 4) {
            try {
                this.mService.mActivityManager.notifyPinnedStackAnimationStarted();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            PinnedStackWindowController controller = (PinnedStackWindowController)this.getController();
            if (schedulePipModeChangedCallback && controller != null) {
                controller.updatePictureInPictureModeForPinnedStackAnimation(null, forceUpdate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnimationEnd(boolean schedulePipModeChangedCallback, Rect finalStackSize, boolean moveToFullscreen) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mBoundsAnimating = false;
                for (int i = 0; i < this.mChildren.size(); ++i) {
                    Task t = (Task)this.mChildren.get(i);
                    t.clearPreserveNonFloatingState();
                }
                this.mService.requestTraversal();
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        if (this.mStackId == 4) {
            PinnedStackWindowController controller = (PinnedStackWindowController)this.getController();
            if (schedulePipModeChangedCallback && controller != null) {
                controller.updatePictureInPictureModeForPinnedStackAnimation(this.mBoundsAnimationTarget, false);
            }
            if (finalStackSize != null) {
                this.setPinnedStackSize(finalStackSize, null);
            }
            try {
                this.mService.mActivityManager.notifyPinnedStackAnimationEnded();
                if (moveToFullscreen) {
                    this.mService.mActivityManager.moveTasksToFullscreenStack(this.mStackId, true);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public boolean deferScheduleMultiWindowModeChanged() {
        if (this.mStackId == 4) {
            return this.mBoundsAnimatingRequested || this.mBoundsAnimating;
        }
        return false;
    }

    public boolean hasMovementAnimations() {
        return ActivityManager.StackId.hasMovementAnimations(this.mStackId);
    }

    public boolean isForceScaled() {
        return this.mBoundsAnimating;
    }

    public boolean isAnimatingBounds() {
        return this.mBoundsAnimating;
    }

    public boolean lastAnimatingBoundsWasToFullscreen() {
        return this.mBoundsAnimatingToFullscreen;
    }

    public boolean isAnimatingBoundsToFullscreen() {
        return this.isAnimatingBounds() && this.lastAnimatingBoundsWasToFullscreen();
    }

    public boolean pinnedStackResizeDisallowed() {
        return this.mBoundsAnimating && this.mCancelCurrentBoundsAnimation;
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        if (this.isAnimating()) {
            return true;
        }
        if (this.mDeferRemoval) {
            this.removeImmediately();
        }
        return super.checkCompleteDeferredRemoval();
    }

    @Override
    void stepAppWindowsAnimation(long currentTime) {
        super.stepAppWindowsAnimation(currentTime);
        this.mTmpAppTokens.clear();
        this.mTmpAppTokens.addAll(this.mExitingAppTokens);
        for (int i = 0; i < this.mTmpAppTokens.size(); ++i) {
            AppWindowAnimator appAnimator = ((AppWindowToken)this.mTmpAppTokens.get((int)i)).mAppAnimator;
            appAnimator.wasAnimating = appAnimator.animating;
            if (appAnimator.stepAnimationLocked(currentTime)) {
                this.mService.mAnimator.setAnimating(true);
                this.mService.mAnimator.mAppWindowAnimating = true;
                continue;
            }
            if (!appAnimator.wasAnimating) continue;
            appAnimator.mAppToken.setAppLayoutChanges(4, "exiting appToken " + appAnimator.mAppToken + " done");
        }
        this.mTmpAppTokens.clear();
    }

    @Override
    int getOrientation() {
        return ActivityManager.StackId.canSpecifyOrientation(this.mStackId) ? super.getOrientation() : -2;
    }
}

