/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.util.Slog;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import java.util.ArrayDeque;
import java.util.function.Consumer;

class WindowLayersController {
    private final WindowManagerService mService;
    private ArrayDeque<WindowState> mPinnedWindows = new ArrayDeque();
    private ArrayDeque<WindowState> mDockedWindows = new ArrayDeque();
    private ArrayDeque<WindowState> mAssistantWindows = new ArrayDeque();
    private ArrayDeque<WindowState> mInputMethodWindows = new ArrayDeque();
    private WindowState mDockDivider = null;
    private ArrayDeque<WindowState> mReplacingWindows = new ArrayDeque();
    private int mCurBaseLayer;
    private int mCurLayer;
    private boolean mAnyLayerChanged;
    private int mHighestApplicationLayer;
    private int mHighestDockedAffectedLayer;
    private int mHighestLayerInImeTargetBaseLayer;
    private WindowState mImeTarget;
    private boolean mAboveImeTarget;
    private ArrayDeque<WindowState> mAboveImeTargetAppWindows = new ArrayDeque();
    private final Consumer<WindowState> mAssignWindowLayersConsumer = w -> {
        boolean layerChanged = false;
        int oldLayer = w.mLayer;
        if (w.mBaseLayer == this.mCurBaseLayer) {
            this.mCurLayer += 5;
        } else {
            this.mCurBaseLayer = this.mCurLayer = w.mBaseLayer;
        }
        this.assignAnimLayer((WindowState)w, this.mCurLayer);
        if (w.mLayer != oldLayer || w.mWinAnimator.mAnimLayer != oldLayer) {
            layerChanged = true;
            this.mAnyLayerChanged = true;
        }
        if (w.mAppToken != null) {
            this.mHighestApplicationLayer = Math.max(this.mHighestApplicationLayer, w.mWinAnimator.mAnimLayer);
        }
        if (this.mImeTarget != null && w.mBaseLayer == this.mImeTarget.mBaseLayer) {
            this.mHighestLayerInImeTargetBaseLayer = Math.max(this.mHighestLayerInImeTargetBaseLayer, w.mWinAnimator.mAnimLayer);
        }
        if (w.getAppToken() != null && ActivityManager.StackId.isResizeableByDockedStack(w.getStackId())) {
            this.mHighestDockedAffectedLayer = Math.max(this.mHighestDockedAffectedLayer, w.mWinAnimator.mAnimLayer);
        }
        this.collectSpecialWindows((WindowState)w);
        if (layerChanged) {
            w.scheduleAnimationIfDimming();
        }
    };

    WindowLayersController(WindowManagerService service) {
        this.mService = service;
    }

    final void assignWindowLayers(DisplayContent dc) {
        this.reset();
        dc.forAllWindows(this.mAssignWindowLayersConsumer, false);
        this.adjustSpecialWindows();
        if (this.mService.mAccessibilityController != null && this.mAnyLayerChanged && dc.getDisplayId() == 0) {
            this.mService.mAccessibilityController.onWindowLayersChangedLocked();
        }
    }

    private void logDebugLayers(DisplayContent dc) {
        dc.forAllWindows(w -> {
            WindowStateAnimator winAnimator = w.mWinAnimator;
            Slog.v("WindowManager", "Assign layer " + w + ": mBase=" + w.mBaseLayer + " mLayer=" + w.mLayer + (w.mAppToken == null ? "" : " mAppLayer=" + w.mAppToken.getAnimLayerAdjustment()) + " =mAnimLayer=" + winAnimator.mAnimLayer);
        }, false);
    }

    private void reset() {
        this.mPinnedWindows.clear();
        this.mInputMethodWindows.clear();
        this.mDockedWindows.clear();
        this.mAssistantWindows.clear();
        this.mReplacingWindows.clear();
        this.mDockDivider = null;
        this.mCurBaseLayer = 0;
        this.mCurLayer = 0;
        this.mAnyLayerChanged = false;
        this.mHighestApplicationLayer = 0;
        this.mHighestDockedAffectedLayer = 0;
        this.mHighestLayerInImeTargetBaseLayer = this.mImeTarget != null ? this.mImeTarget.mBaseLayer : 0;
        this.mImeTarget = this.mService.mInputMethodTarget;
        this.mAboveImeTarget = false;
        this.mAboveImeTargetAppWindows.clear();
    }

    private void collectSpecialWindows(WindowState w) {
        int stackId;
        if (w.mAttrs.type == 2034) {
            this.mDockDivider = w;
            return;
        }
        if (w.mWillReplaceWindow) {
            this.mReplacingWindows.add(w);
        }
        if (w.mIsImWindow) {
            this.mInputMethodWindows.add(w);
            return;
        }
        if (this.mImeTarget != null) {
            if (w.getParentWindow() == this.mImeTarget && w.mSubLayer > 0) {
                this.mAboveImeTargetAppWindows.add(w);
            } else if (this.mAboveImeTarget && w.mAppToken != null) {
                this.mAboveImeTargetAppWindows.add(w);
            }
            if (w == this.mImeTarget) {
                this.mAboveImeTarget = true;
            }
        }
        int n = stackId = w.getAppToken() != null ? w.getStackId() : -1;
        if (stackId == 4) {
            this.mPinnedWindows.add(w);
        } else if (stackId == 3) {
            this.mDockedWindows.add(w);
        } else if (stackId == 6) {
            this.mAssistantWindows.add(w);
        }
    }

    private void adjustSpecialWindows() {
        int layer = this.mHighestDockedAffectedLayer + 1000;
        if (!this.mDockedWindows.isEmpty() && this.mHighestDockedAffectedLayer > 0) {
            WindowState window;
            while (!this.mDockedWindows.isEmpty()) {
                window = this.mDockedWindows.remove();
                layer = this.assignAndIncreaseLayerIfNeeded(window, layer);
            }
            layer = this.assignAndIncreaseLayerIfNeeded(this.mDockDivider, layer);
            while (!this.mAssistantWindows.isEmpty()) {
                window = this.mAssistantWindows.remove();
                if (window.mLayer <= this.mHighestDockedAffectedLayer) continue;
                layer = this.assignAndIncreaseLayerIfNeeded(window, layer);
            }
        }
        layer = Math.max(layer, this.mHighestApplicationLayer + 5);
        while (!this.mReplacingWindows.isEmpty()) {
            layer = this.assignAndIncreaseLayerIfNeeded(this.mReplacingWindows.remove(), layer);
        }
        while (!this.mPinnedWindows.isEmpty()) {
            layer = this.assignAndIncreaseLayerIfNeeded(this.mPinnedWindows.remove(), layer);
        }
        if (this.mImeTarget != null) {
            if (this.mImeTarget.mAppToken == null) {
                layer = this.mHighestLayerInImeTargetBaseLayer + 5;
            }
            while (!this.mInputMethodWindows.isEmpty()) {
                layer = this.assignAndIncreaseLayerIfNeeded(this.mInputMethodWindows.remove(), layer);
            }
            while (!this.mAboveImeTargetAppWindows.isEmpty()) {
                layer = this.assignAndIncreaseLayerIfNeeded(this.mAboveImeTargetAppWindows.remove(), layer);
            }
        }
    }

    private int assignAndIncreaseLayerIfNeeded(WindowState win, int layer) {
        if (win != null) {
            this.assignAnimLayer(win, layer);
            layer += 5;
        }
        return layer;
    }

    private void assignAnimLayer(WindowState w, int layer) {
        w.mLayer = layer;
        w.mWinAnimator.mAnimLayer = w.getAnimLayerAdjustment() + w.getSpecialWindowAnimLayerAdjustment();
        if (w.mAppToken != null && w.mAppToken.mAppAnimator.thumbnailForceAboveLayer > 0) {
            int highestLayer;
            if (w.mWinAnimator.mAnimLayer > w.mAppToken.mAppAnimator.thumbnailForceAboveLayer) {
                w.mAppToken.mAppAnimator.thumbnailForceAboveLayer = w.mWinAnimator.mAnimLayer;
            }
            if ((highestLayer = w.mAppToken.getHighestAnimLayer()) > 0 && w.mAppToken.mAppAnimator.thumbnail != null && w.mAppToken.mAppAnimator.thumbnailForceAboveLayer != highestLayer) {
                w.mAppToken.mAppAnimator.thumbnailForceAboveLayer = highestLayer;
                w.mAppToken.mAppAnimator.thumbnail.setLayer(highestLayer + 1);
            }
        }
    }
}

