/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import android.system.OsConstants;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.channels.FileChannel;
import sun.nio.ch.FileChannelImpl;

public final class NioUtils {
    private NioUtils() {
    }

    public static void freeDirectBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        DirectByteBuffer dbb = (DirectByteBuffer)buffer;
        if (dbb.cleaner != null) {
            dbb.cleaner.clean();
        }
        dbb.memoryRef.free();
    }

    public static FileDescriptor getFD(FileChannel fc) {
        return ((FileChannelImpl)fc).fd;
    }

    public static FileChannel newFileChannel(Closeable ioObject, FileDescriptor fd, int mode) {
        boolean readable = (mode & (OsConstants.O_RDONLY | OsConstants.O_RDWR | OsConstants.O_SYNC)) != 0;
        boolean writable = (mode & (OsConstants.O_WRONLY | OsConstants.O_RDWR | OsConstants.O_SYNC)) != 0;
        boolean append = (mode & OsConstants.O_APPEND) != 0;
        return FileChannelImpl.open((FileDescriptor)fd, null, (boolean)readable, (boolean)writable, (boolean)append, (Object)ioObject);
    }

    public static byte[] unsafeArray(ByteBuffer b) {
        return b.array();
    }

    public static int unsafeArrayOffset(ByteBuffer b) {
        return b.arrayOffset();
    }
}

