/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.util.Base64;

public final class DropBox {
    private static volatile Reporter REPORTER = new DefaultReporter();

    public static void setReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter == null");
        }
        REPORTER = reporter;
    }

    public static Reporter getReporter() {
        return REPORTER;
    }

    public static void addData(String tag, byte[] data, int flags) {
        DropBox.getReporter().addData(tag, data, flags);
    }

    public static void addText(String tag, String data) {
        DropBox.getReporter().addText(tag, data);
    }

    private static final class DefaultReporter
    implements Reporter {
        private DefaultReporter() {
        }

        @Override
        public void addData(String tag, byte[] data, int flags) {
            System.out.println(tag + ": " + Base64.getEncoder().encodeToString(data));
        }

        @Override
        public void addText(String tag, String data) {
            System.out.println(tag + ": " + data);
        }
    }

    public static interface Reporter {
        public void addData(String var1, byte[] var2, int var3);

        public void addText(String var1, String var2);
    }
}

