/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerResponse;
import android.accounts.AuthenticatorDescription;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import java.util.HashMap;

public class ChooseAccountActivity
extends Activity {
    private static final String TAG = "AccountManager";
    private Parcelable[] mAccounts = null;
    private AccountManagerResponse mAccountManagerResponse = null;
    private Bundle mResult;
    private int mCallingUid;
    private String mCallingPackage;
    private HashMap<String, AuthenticatorDescription> mTypeToAuthDescription = new HashMap();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAccounts = this.getIntent().getParcelableArrayExtra("accounts");
        this.mAccountManagerResponse = (AccountManagerResponse)this.getIntent().getParcelableExtra("accountManagerResponse");
        if (this.mAccounts == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        try {
            IBinder activityToken = this.getActivityToken();
            this.mCallingUid = ActivityManager.getService().getLaunchedFromUid(activityToken);
            this.mCallingPackage = ActivityManager.getService().getLaunchedFromPackage(activityToken);
        }
        catch (RemoteException re) {
            Log.w(this.getClass().getSimpleName(), "Unable to get caller identity \n" + re);
        }
        if (UserHandle.isSameApp(this.mCallingUid, 1000) && this.getIntent().getStringExtra("androidPackageName") != null) {
            this.mCallingPackage = this.getIntent().getStringExtra("androidPackageName");
        }
        if (!UserHandle.isSameApp(this.mCallingUid, 1000) && this.getIntent().getStringExtra("androidPackageName") != null) {
            Log.w(this.getClass().getSimpleName(), "Non-system Uid: " + this.mCallingUid + " tried to override packageName \n");
        }
        this.getAuthDescriptions();
        AccountInfo[] mAccountInfos = new AccountInfo[this.mAccounts.length];
        for (int i = 0; i < this.mAccounts.length; ++i) {
            mAccountInfos[i] = new AccountInfo(((Account)this.mAccounts[i]).name, this.getDrawableForType(((Account)this.mAccounts[i]).type));
        }
        this.setContentView(17367107);
        ListView list = (ListView)this.findViewById(16908298);
        list.setAdapter(new AccountArrayAdapter((Context)this, 17367043, mAccountInfos));
        list.setChoiceMode(1);
        list.setTextFilterEnabled(true);
        list.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                ChooseAccountActivity.this.onListItemClick((ListView)parent, v, position, id2);
            }
        });
    }

    private void getAuthDescriptions() {
        for (AuthenticatorDescription desc : AccountManager.get(this).getAuthenticatorTypes()) {
            this.mTypeToAuthDescription.put(desc.type, desc);
        }
    }

    private Drawable getDrawableForType(String accountType) {
        Drawable icon;
        block5: {
            icon = null;
            if (this.mTypeToAuthDescription.containsKey(accountType)) {
                try {
                    AuthenticatorDescription desc = this.mTypeToAuthDescription.get(accountType);
                    Context authContext = this.createPackageContext(desc.packageName, 0);
                    icon = authContext.getDrawable(desc.iconId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    if (Log.isLoggable(TAG, 5)) {
                        Log.w(TAG, "No icon name for account type " + accountType);
                    }
                }
                catch (Resources.NotFoundException e) {
                    if (!Log.isLoggable(TAG, 5)) break block5;
                    Log.w(TAG, "No icon resource for account type " + accountType);
                }
            }
        }
        return icon;
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Account account = (Account)this.mAccounts[position];
        AccountManager am = AccountManager.get(this);
        Integer oldVisibility = am.getAccountVisibility(account, this.mCallingPackage);
        if (oldVisibility != null && oldVisibility == 4) {
            am.setAccountVisibility(account, this.mCallingPackage, 2);
        }
        Log.d(TAG, "selected account " + account);
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", account.name);
        bundle.putString("accountType", account.type);
        this.mResult = bundle;
        this.finish();
    }

    @Override
    public void finish() {
        if (this.mAccountManagerResponse != null) {
            if (this.mResult != null) {
                this.mAccountManagerResponse.onResult(this.mResult);
            } else {
                this.mAccountManagerResponse.onError(4, "canceled");
            }
        }
        super.finish();
    }

    private static class AccountArrayAdapter
    extends ArrayAdapter<AccountInfo> {
        private LayoutInflater mLayoutInflater;
        private AccountInfo[] mInfos;

        public AccountArrayAdapter(Context context, int textViewResourceId, AccountInfo[] infos) {
            super(context, textViewResourceId, infos);
            this.mInfos = infos;
            this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(17367108, null);
                holder = new ViewHolder();
                holder.text = (TextView)convertView.findViewById(16908659);
                holder.icon = (ImageView)convertView.findViewById(16908658);
                convertView.setTag(holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.text.setText(this.mInfos[position].name);
            holder.icon.setImageDrawable(this.mInfos[position].drawable);
            return convertView;
        }
    }

    private static class ViewHolder {
        ImageView icon;
        TextView text;

        private ViewHolder() {
        }
    }

    private static class AccountInfo {
        final String name;
        final Drawable drawable;

        AccountInfo(String name, Drawable drawable2) {
            this.name = name;
            this.drawable = drawable2;
        }
    }
}

