/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.RemoteException;

public interface IInstantAppResolver
extends IInterface {
    public void getInstantAppResolveInfoList(Intent var1, int[] var2, String var3, int var4, IRemoteCallback var5) throws RemoteException;

    public void getInstantAppIntentFilterList(Intent var1, int[] var2, String var3, IRemoteCallback var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInstantAppResolver {
        private static final String DESCRIPTOR = "android.app.IInstantAppResolver";
        static final int TRANSACTION_getInstantAppResolveInfoList = 1;
        static final int TRANSACTION_getInstantAppIntentFilterList = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInstantAppResolver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInstantAppResolver) {
                return (IInstantAppResolver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    int[] _arg1 = data.createIntArray();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    IRemoteCallback _arg4 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    this.getInstantAppResolveInfoList(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    Intent _arg0 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    int[] _arg1 = data.createIntArray();
                    String _arg2 = data.readString();
                    IRemoteCallback _arg3 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    this.getInstantAppIntentFilterList(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IInstantAppResolver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getInstantAppResolveInfoList(Intent sanitizedIntent, int[] hostDigestPrefix, String token, int sequence, IRemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sanitizedIntent != null) {
                        _data.writeInt(1);
                        sanitizedIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeIntArray(hostDigestPrefix);
                    _data.writeString(token);
                    _data.writeInt(sequence);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getInstantAppIntentFilterList(Intent sanitizedIntent, int[] hostDigestPrefix, String token, IRemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sanitizedIntent != null) {
                        _data.writeInt(1);
                        sanitizedIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeIntArray(hostDigestPrefix);
                    _data.writeString(token);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

