/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.IBinder;
import android.os.IStatsManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;

@SystemApi
public final class StatsManager
extends android.util.StatsManager {
    IStatsManager mService;
    private static final String TAG = "StatsManager";
    public static final String EXTRA_STATS_CONFIG_UID = "android.app.extra.STATS_CONFIG_UID";
    public static final String EXTRA_STATS_CONFIG_KEY = "android.app.extra.STATS_CONFIG_KEY";
    public static final String EXTRA_STATS_SUBSCRIPTION_ID = "android.app.extra.STATS_SUBSCRIPTION_ID";
    public static final String EXTRA_STATS_SUBSCRIPTION_RULE_ID = "android.app.extra.STATS_SUBSCRIPTION_RULE_ID";
    public static final String EXTRA_STATS_DIMENSIONS_VALUE = "android.app.extra.STATS_DIMENSIONS_VALUE";
    public static final String ACTION_STATSD_STARTED = "android.app.action.STATSD_STARTED";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConfiguration(long configKey, byte[] config, String pkg, String cls) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when adding configuration");
                    return false;
                }
                return service.addConfiguration(configKey, config, pkg, cls);
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connect to statsd when adding configuration");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeConfiguration(long configKey) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when removing configuration");
                    return false;
                }
                return service.removeConfiguration(configKey);
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connect to statsd when removing configuration");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.w(TAG, "Failed to find statsd when adding broadcast subscriber");
                    return false;
                }
                if (pendingIntent != null) {
                    IBinder intentSender = pendingIntent.getTarget().asBinder();
                    return service.setBroadcastSubscriber(configKey, subscriberId, intentSender);
                }
                return service.unsetBroadcastSubscriber(configKey, subscriberId);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to connect to statsd when adding broadcast subscriber", e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getData(long configKey) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when getting data");
                    return null;
                }
                return service.getData(configKey);
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connecto statsd when getting data");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMetadata() {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when getting metadata");
                    return null;
                }
                return service.getMetadata();
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connecto statsd when getting metadata");
                return null;
            }
        }
    }

    private IStatsManager getIStatsManagerLocked() throws RemoteException {
        if (this.mService != null) {
            return this.mService;
        }
        this.mService = IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
        if (this.mService != null) {
            this.mService.asBinder().linkToDeath(new StatsdDeathRecipient(), 0);
        }
        return this.mService;
    }

    private class StatsdDeathRecipient
    implements IBinder.DeathRecipient {
        private StatsdDeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            StatsdDeathRecipient statsdDeathRecipient = this;
            synchronized (statsdDeathRecipient) {
                StatsManager.this.mService = null;
            }
        }
    }
}

