/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.SystemUpdatePolicy;
import android.util.Log;
import android.util.Pair;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class FreezeInterval {
    private static final String TAG = "FreezeInterval";
    private static final int DUMMY_YEAR = 2001;
    static final int DAYS_IN_YEAR = 365;
    final int mStartDay;
    final int mEndDay;

    FreezeInterval(int startDay, int endDay) {
        if (startDay < 1 || startDay > 365 || endDay < 1 || endDay > 365) {
            throw new RuntimeException("Bad dates for Interval: " + startDay + "," + endDay);
        }
        this.mStartDay = startDay;
        this.mEndDay = endDay;
    }

    int getLength() {
        return this.getEffectiveEndDay() - this.mStartDay + 1;
    }

    boolean isWrapped() {
        return this.mEndDay < this.mStartDay;
    }

    int getEffectiveEndDay() {
        if (!this.isWrapped()) {
            return this.mEndDay;
        }
        return this.mEndDay + 365;
    }

    boolean contains(LocalDate localDate) {
        int daysOfYear = FreezeInterval.dayOfYearDisregardLeapYear(localDate);
        if (!this.isWrapped()) {
            return this.mStartDay <= daysOfYear && daysOfYear <= this.mEndDay;
        }
        return this.mStartDay <= daysOfYear || daysOfYear <= this.mEndDay;
    }

    Pair<LocalDate, LocalDate> toCurrentOrFutureRealDates(LocalDate now) {
        int endYearAdjustment;
        int startYearAdjustment;
        int nowDays = FreezeInterval.dayOfYearDisregardLeapYear(now);
        if (this.contains(now)) {
            if (this.mStartDay <= nowDays) {
                startYearAdjustment = 0;
                endYearAdjustment = this.isWrapped() ? 1 : 0;
            } else {
                startYearAdjustment = -1;
                endYearAdjustment = 0;
            }
        } else if (this.mStartDay > nowDays) {
            startYearAdjustment = 0;
            endYearAdjustment = this.isWrapped() ? 1 : 0;
        } else {
            startYearAdjustment = 1;
            endYearAdjustment = 1;
        }
        LocalDate startDate = LocalDate.ofYearDay(2001, this.mStartDay).withYear(now.getYear() + startYearAdjustment);
        LocalDate endDate = LocalDate.ofYearDay(2001, this.mEndDay).withYear(now.getYear() + endYearAdjustment);
        return new Pair<LocalDate, LocalDate>(startDate, endDate);
    }

    public String toString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd");
        return LocalDate.ofYearDay(2001, this.mStartDay).format(formatter) + " - " + LocalDate.ofYearDay(2001, this.mEndDay).format(formatter);
    }

    static int dayOfYearDisregardLeapYear(LocalDate date) {
        return date.withYear(2001).getDayOfYear();
    }

    public static int distanceWithoutLeapYear(LocalDate first, LocalDate second) {
        return FreezeInterval.dayOfYearDisregardLeapYear(first) - FreezeInterval.dayOfYearDisregardLeapYear(second) + 365 * (first.getYear() - second.getYear());
    }

    private static List<FreezeInterval> canonicalizeIntervals(List<FreezeInterval> intervals) {
        boolean[] taken = new boolean[365];
        for (FreezeInterval interval : intervals) {
            for (int i = interval.mStartDay; i <= interval.getEffectiveEndDay(); ++i) {
                taken[(i - 1) % 365] = true;
            }
        }
        ArrayList<FreezeInterval> result = new ArrayList<FreezeInterval>();
        int i = 0;
        while (i < 365) {
            if (!taken[i]) {
                ++i;
                continue;
            }
            int intervalStart = i + 1;
            while (i < 365 && taken[i]) {
                ++i;
            }
            result.add(new FreezeInterval(intervalStart, i));
        }
        int lastIndex = result.size() - 1;
        if (lastIndex > 0 && ((FreezeInterval)result.get((int)lastIndex)).mEndDay == 365 && ((FreezeInterval)result.get((int)0)).mStartDay == 1) {
            FreezeInterval wrappedInterval = new FreezeInterval(((FreezeInterval)result.get((int)lastIndex)).mStartDay, ((FreezeInterval)result.get((int)0)).mEndDay);
            result.set(lastIndex, wrappedInterval);
            result.remove(0);
        }
        return result;
    }

    protected static void validatePeriods(List<FreezeInterval> periods) {
        List<FreezeInterval> allPeriods = FreezeInterval.canonicalizeIntervals(periods);
        if (allPeriods.size() != periods.size()) {
            throw SystemUpdatePolicy.ValidationFailedException.duplicateOrOverlapPeriods();
        }
        for (int i = 0; i < allPeriods.size(); ++i) {
            int separation;
            FreezeInterval previous;
            FreezeInterval current = allPeriods.get(i);
            if (current.getLength() > 90) {
                throw SystemUpdatePolicy.ValidationFailedException.freezePeriodTooLong("Freeze period " + current + " is too long: " + current.getLength() + " days");
            }
            FreezeInterval freezeInterval = previous = i > 0 ? allPeriods.get(i - 1) : allPeriods.get(allPeriods.size() - 1);
            if (previous == current || (separation = i == 0 && !previous.isWrapped() ? current.mStartDay + (365 - previous.mEndDay) - 1 : current.mStartDay - previous.mEndDay - 1) >= 60) continue;
            throw SystemUpdatePolicy.ValidationFailedException.freezePeriodTooClose("Freeze periods " + previous + " and " + current + " are too close together: " + separation + " days apart");
        }
    }

    protected static void validateAgainstPreviousFreezePeriod(List<FreezeInterval> periods, LocalDate prevPeriodStart, LocalDate prevPeriodEnd, LocalDate now) {
        if (periods.size() == 0 || prevPeriodStart == null || prevPeriodEnd == null) {
            return;
        }
        if (prevPeriodStart.isAfter(now) || prevPeriodEnd.isAfter(now)) {
            Log.w(TAG, "Previous period (" + prevPeriodStart + "," + prevPeriodEnd + ") is after current date " + now);
        }
        List<FreezeInterval> allPeriods = FreezeInterval.canonicalizeIntervals(periods);
        FreezeInterval curOrNextFreezePeriod = allPeriods.get(0);
        for (FreezeInterval interval : allPeriods) {
            if (!interval.contains(now) && interval.mStartDay <= FreezeInterval.dayOfYearDisregardLeapYear(now)) continue;
            curOrNextFreezePeriod = interval;
            break;
        }
        Pair<LocalDate, LocalDate> curOrNextFreezeDates = curOrNextFreezePeriod.toCurrentOrFutureRealDates(now);
        if (now.isAfter((ChronoLocalDate)curOrNextFreezeDates.first)) {
            curOrNextFreezeDates = new Pair<LocalDate, LocalDate>(now, (LocalDate)curOrNextFreezeDates.second);
        }
        if (((LocalDate)curOrNextFreezeDates.first).isAfter((ChronoLocalDate)curOrNextFreezeDates.second)) {
            throw new IllegalStateException("Current freeze dates inverted: " + curOrNextFreezeDates.first + "-" + curOrNextFreezeDates.second);
        }
        String periodsDescription = "Prev: " + prevPeriodStart + "," + prevPeriodEnd + "; cur: " + curOrNextFreezeDates.first + "," + curOrNextFreezeDates.second;
        long separation = FreezeInterval.distanceWithoutLeapYear((LocalDate)curOrNextFreezeDates.first, prevPeriodEnd) - 1;
        if (separation > 0L) {
            if (separation < 60L) {
                throw SystemUpdatePolicy.ValidationFailedException.combinedPeriodTooClose("Previous freeze period too close to new period: " + separation + ", " + periodsDescription);
            }
        } else {
            long length = FreezeInterval.distanceWithoutLeapYear((LocalDate)curOrNextFreezeDates.second, prevPeriodStart) + 1;
            if (length > 90L) {
                throw SystemUpdatePolicy.ValidationFailedException.combinedPeriodTooLong("Combined freeze period exceeds maximum days: " + length + ", " + periodsDescription);
            }
        }
    }
}

