/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.os.ParcelFileDescriptor;
import android.util.ArrayMap;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public abstract class BlobBackupHelper
implements BackupHelper {
    private static final String TAG = "BlobBackupHelper";
    private static final boolean DEBUG = false;
    private final int mCurrentBlobVersion;
    private final String[] mKeys;

    public BlobBackupHelper(int currentBlobVersion, String ... keys) {
        this.mCurrentBlobVersion = currentBlobVersion;
        this.mKeys = keys;
    }

    protected abstract byte[] getBackupPayload(String var1);

    protected abstract void applyRestoredPayload(String var1, byte[] var2);

    private ArrayMap<String, Long> readOldState(ParcelFileDescriptor oldStateFd) {
        ArrayMap<String, Long> state = new ArrayMap<String, Long>();
        FileInputStream fis = new FileInputStream(oldStateFd.getFileDescriptor());
        DataInputStream in = new DataInputStream(fis);
        try {
            int version = in.readInt();
            if (version <= this.mCurrentBlobVersion) {
                int numKeys = in.readInt();
                for (int i = 0; i < numKeys; ++i) {
                    String key = in.readUTF();
                    long checksum = in.readLong();
                    state.put(key, checksum);
                }
            } else {
                Log.w(TAG, "Prior state from unrecognized version " + version);
            }
        }
        catch (EOFException e) {
            state.clear();
        }
        catch (Exception e) {
            Log.e(TAG, "Error examining prior backup state " + e.getMessage());
            state.clear();
        }
        return state;
    }

    private void writeBackupState(ArrayMap<String, Long> state, ParcelFileDescriptor stateFile) {
        try {
            FileOutputStream fos = new FileOutputStream(stateFile.getFileDescriptor());
            DataOutputStream out = new DataOutputStream(fos);
            out.writeInt(this.mCurrentBlobVersion);
            int N = state != null ? state.size() : 0;
            out.writeInt(N);
            for (int i = 0; i < N; ++i) {
                String key = state.keyAt(i);
                long checksum = state.valueAt(i);
                out.writeUTF(key);
                out.writeLong(checksum);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to write updated state", e);
        }
    }

    private byte[] deflate(byte[] data) {
        byte[] result = null;
        if (data != null) {
            try {
                ByteArrayOutputStream sink = new ByteArrayOutputStream();
                DataOutputStream headerOut = new DataOutputStream(sink);
                headerOut.writeInt(this.mCurrentBlobVersion);
                DeflaterOutputStream out = new DeflaterOutputStream(sink);
                out.write(data);
                out.close();
                result = sink.toByteArray();
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to process payload: " + e.getMessage());
            }
        }
        return result;
    }

    private byte[] inflate(byte[] compressedData) {
        byte[] result = null;
        if (compressedData != null) {
            try {
                int nRead;
                ByteArrayInputStream source = new ByteArrayInputStream(compressedData);
                DataInputStream headerIn = new DataInputStream(source);
                int version = headerIn.readInt();
                if (version > this.mCurrentBlobVersion) {
                    Log.w(TAG, "Saved payload from unrecognized version " + version);
                    return null;
                }
                InflaterInputStream in = new InflaterInputStream(source);
                ByteArrayOutputStream inflated = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((nRead = in.read(buffer)) > 0) {
                    inflated.write(buffer, 0, nRead);
                }
                in.close();
                inflated.flush();
                result = inflated.toByteArray();
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to process restored payload: " + e.getMessage());
            }
        }
        return result;
    }

    private long checksum(byte[] buffer) {
        if (buffer != null) {
            try {
                CRC32 crc = new CRC32();
                ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
                byte[] buf = new byte[4096];
                int nRead = 0;
                while ((nRead = bis.read(buf)) >= 0) {
                    crc.update(buf, 0, nRead);
                }
                return crc.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBackup(ParcelFileDescriptor oldStateFd, BackupDataOutput data, ParcelFileDescriptor newStateFd) {
        ArrayMap<String, Long> oldState = this.readOldState(oldStateFd);
        ArrayMap<String, Long> newState = new ArrayMap<String, Long>();
        try {
            for (String key : this.mKeys) {
                byte[] payload = this.deflate(this.getBackupPayload(key));
                long checksum = this.checksum(payload);
                newState.put(key, checksum);
                Long oldChecksum = oldState.get(key);
                if (oldChecksum != null && checksum == oldChecksum) continue;
                if (payload != null) {
                    data.writeEntityHeader(key, payload.length);
                    data.writeEntityData(payload, payload.length);
                    continue;
                }
                data.writeEntityHeader(key, -1);
            }
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to record notification state: " + e.getMessage());
            newState.clear();
        }
        finally {
            this.writeBackupState(newState, newStateFd);
        }
    }

    @Override
    public void restoreEntity(BackupDataInputStream data) {
        String key = data.getKey();
        try {
            int which;
            for (which = 0; which < this.mKeys.length && !key.equals(this.mKeys[which]); ++which) {
            }
            if (which >= this.mKeys.length) {
                Log.e(TAG, "Unrecognized key " + key + ", ignoring");
                return;
            }
            byte[] compressed = new byte[data.size()];
            data.read(compressed);
            byte[] payload = this.inflate(compressed);
            this.applyRestoredPayload(key, payload);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception restoring entity " + key + " : " + e.getMessage());
        }
    }

    @Override
    public void writeNewStateDescription(ParcelFileDescriptor newState) {
        this.writeBackupState(null, newState);
    }
}

