/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.WallpaperManager;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Slog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class WallpaperBackupHelper
extends FileBackupHelperBase
implements BackupHelper {
    private static final String TAG = "WallpaperBackupHelper";
    private static final boolean DEBUG = false;
    public static final String WALLPAPER_IMAGE_KEY = "/data/data/com.android.settings/files/wallpaper";
    public static final String WALLPAPER_INFO_KEY = "/data/system/wallpaper_info.xml";
    private static final String STAGE_FILE = new File(Environment.getUserSystemDirectory(0), "wallpaper-tmp").getAbsolutePath();
    private final String[] mKeys;
    private final WallpaperManager mWpm;

    public WallpaperBackupHelper(Context context, String[] keys) {
        super(context);
        this.mContext = context;
        this.mKeys = keys;
        this.mWpm = (WallpaperManager)context.getSystemService("wallpaper");
    }

    @Override
    public void performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreEntity(BackupDataInputStream data) {
        block18: {
            String key = data.getKey();
            if (this.isKeyInList(key, this.mKeys) && key.equals(WALLPAPER_IMAGE_KEY)) {
                File stage = new File(STAGE_FILE);
                try {
                    if (this.writeFile(stage, data)) {
                        try (FileInputStream in = new FileInputStream(stage);){
                            this.mWpm.setStream(in);
                            break block18;
                        }
                        catch (IOException e) {
                            Slog.e(TAG, "Unable to set restored wallpaper: " + e.getMessage());
                        }
                        break block18;
                    }
                    Slog.e(TAG, "Unable to save restored wallpaper");
                }
                finally {
                    stage.delete();
                }
            }
        }
    }
}

