/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ClientTransactionHandler;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.ObjectPool;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;
import com.android.internal.content.ReferrerIntent;
import java.util.List;
import java.util.Objects;

public class NewIntentItem
extends ClientTransactionItem {
    private List<ReferrerIntent> mIntents;
    private boolean mPause;
    public static final Parcelable.Creator<NewIntentItem> CREATOR = new Parcelable.Creator<NewIntentItem>(){

        @Override
        public NewIntentItem createFromParcel(Parcel in) {
            return new NewIntentItem(in);
        }

        public NewIntentItem[] newArray(int size) {
            return new NewIntentItem[size];
        }
    };

    @Override
    public void execute(ClientTransactionHandler client, IBinder token, PendingTransactionActions pendingActions) {
        Trace.traceBegin(64L, "activityNewIntent");
        client.handleNewIntent(token, this.mIntents, this.mPause);
        Trace.traceEnd(64L);
    }

    private NewIntentItem() {
    }

    public static NewIntentItem obtain(List<ReferrerIntent> intents, boolean pause) {
        NewIntentItem instance = ObjectPool.obtain(NewIntentItem.class);
        if (instance == null) {
            instance = new NewIntentItem();
        }
        instance.mIntents = intents;
        instance.mPause = pause;
        return instance;
    }

    @Override
    public void recycle() {
        this.mIntents = null;
        this.mPause = false;
        ObjectPool.recycle(this);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mPause);
        dest.writeTypedList(this.mIntents, flags);
    }

    private NewIntentItem(Parcel in) {
        this.mPause = in.readBoolean();
        this.mIntents = in.createTypedArrayList(ReferrerIntent.CREATOR);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewIntentItem other = (NewIntentItem)o;
        return this.mPause == other.mPause && Objects.equals(this.mIntents, other.mIntents);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.mPause ? 1 : 0);
        result = 31 * result + this.mIntents.hashCode();
        return result;
    }

    public String toString() {
        return "NewIntentItem{pause=" + this.mPause + ",intents=" + this.mIntents + "}";
    }
}

