/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import android.util.IntArray;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class TransactionExecutor {
    private static final boolean DEBUG_RESOLVER = false;
    private static final String TAG = "TransactionExecutor";
    private ClientTransactionHandler mTransactionHandler;
    private PendingTransactionActions mPendingActions = new PendingTransactionActions();
    private IntArray mLifecycleSequence = new IntArray(6);

    public TransactionExecutor(ClientTransactionHandler clientTransactionHandler) {
        this.mTransactionHandler = clientTransactionHandler;
    }

    public void execute(ClientTransaction transaction) {
        IBinder token = transaction.getActivityToken();
        TransactionExecutor.log("Start resolving transaction for client: " + this.mTransactionHandler + ", token: " + token);
        this.executeCallbacks(transaction);
        this.executeLifecycleState(transaction);
        this.mPendingActions.clear();
        TransactionExecutor.log("End resolving transaction");
    }

    @VisibleForTesting
    public void executeCallbacks(ClientTransaction transaction) {
        List<ClientTransactionItem> callbacks = transaction.getCallbacks();
        if (callbacks == null) {
            return;
        }
        TransactionExecutor.log("Resolving callbacks");
        IBinder token = transaction.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        int size = callbacks.size();
        for (int i = 0; i < size; ++i) {
            int postExecutionState;
            ClientTransactionItem item = callbacks.get(i);
            TransactionExecutor.log("Resolving callback: " + item);
            int preExecutionState = item.getPreExecutionState();
            if (preExecutionState != -1) {
                this.cycleToPath(r, preExecutionState);
            }
            item.execute(this.mTransactionHandler, token, this.mPendingActions);
            item.postExecute(this.mTransactionHandler, token, this.mPendingActions);
            if (r == null) {
                r = this.mTransactionHandler.getActivityClient(token);
            }
            if ((postExecutionState = item.getPostExecutionState()) == -1) continue;
            this.cycleToPath(r, postExecutionState);
        }
    }

    private void executeLifecycleState(ClientTransaction transaction) {
        ActivityLifecycleItem lifecycleItem = transaction.getLifecycleStateRequest();
        if (lifecycleItem == null) {
            return;
        }
        TransactionExecutor.log("Resolving lifecycle state: " + lifecycleItem);
        IBinder token = transaction.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        if (r == null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            String prefix = "  ";
            pw.println("Lifecycle transaction does not have valid ActivityClientRecord.");
            pw.println("Transaction:");
            transaction.dump(pw, "  ");
            pw.println("Executor:");
            this.dump(pw, "  ");
            Slog.wtf(TAG, stringWriter.toString());
        }
        this.cycleToPath(r, lifecycleItem.getTargetState(), true);
        lifecycleItem.execute(this.mTransactionHandler, token, this.mPendingActions);
        lifecycleItem.postExecute(this.mTransactionHandler, token, this.mPendingActions);
    }

    @VisibleForTesting
    public void cycleToPath(ActivityThread.ActivityClientRecord r, int finish) {
        this.cycleToPath(r, finish, false);
    }

    private void cycleToPath(ActivityThread.ActivityClientRecord r, int finish, boolean excludeLastState) {
        int start = r.getLifecycleState();
        TransactionExecutor.log("Cycle from: " + start + " to: " + finish + " excludeLastState:" + excludeLastState);
        this.initLifecyclePath(start, finish, excludeLastState);
        this.performLifecycleSequence(r);
    }

    private void performLifecycleSequence(ActivityThread.ActivityClientRecord r) {
        int size = this.mLifecycleSequence.size();
        block9: for (int i = 0; i < size; ++i) {
            int state = this.mLifecycleSequence.get(i);
            TransactionExecutor.log("Transitioning to state: " + state);
            switch (state) {
                case 1: {
                    this.mTransactionHandler.handleLaunchActivity(r, this.mPendingActions);
                    continue block9;
                }
                case 2: {
                    this.mTransactionHandler.handleStartActivity(r, this.mPendingActions);
                    continue block9;
                }
                case 3: {
                    this.mTransactionHandler.handleResumeActivity(r.token, false, r.isForward, "LIFECYCLER_RESUME_ACTIVITY");
                    continue block9;
                }
                case 4: {
                    this.mTransactionHandler.handlePauseActivity(r.token, false, false, 0, true, this.mPendingActions);
                    continue block9;
                }
                case 5: {
                    this.mTransactionHandler.handleStopActivity(r.token, false, 0, this.mPendingActions);
                    continue block9;
                }
                case 6: {
                    this.mTransactionHandler.handleDestroyActivity(r.token, false, 0, false);
                    continue block9;
                }
                case 7: {
                    this.mTransactionHandler.performRestartActivity(r.token, false);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected lifecycle state: " + state);
                }
            }
        }
    }

    public void initLifecyclePath(int start, int finish, boolean excludeLastState) {
        this.mLifecycleSequence.clear();
        if (finish >= start) {
            for (int i = start + 1; i <= finish; ++i) {
                this.mLifecycleSequence.add(i);
            }
        } else if (start == 4 && finish == 3) {
            this.mLifecycleSequence.add(3);
        } else if (start <= 5 && finish >= 2) {
            int i;
            for (i = start + 1; i <= 5; ++i) {
                this.mLifecycleSequence.add(i);
            }
            this.mLifecycleSequence.add(7);
            for (i = 2; i <= finish; ++i) {
                this.mLifecycleSequence.add(i);
            }
        } else {
            int i;
            for (i = start + 1; i <= 6; ++i) {
                this.mLifecycleSequence.add(i);
            }
            for (i = 1; i <= finish; ++i) {
                this.mLifecycleSequence.add(i);
            }
        }
        if (excludeLastState && this.mLifecycleSequence.size() != 0) {
            this.mLifecycleSequence.remove(this.mLifecycleSequence.size() - 1);
        }
    }

    @VisibleForTesting
    public int[] getLifecycleSequence() {
        return this.mLifecycleSequence.toArray();
    }

    private static void log(String message) {
    }

    private void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mTransactionHandler:");
        this.mTransactionHandler.dump(pw, prefix + "  ");
    }
}

