/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.app.slice.Slice;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import android.widget.RemoteViews;
import com.android.internal.util.ArrayUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public final class SliceItem
implements Parcelable {
    private static final String TAG = "SliceItem";
    public static final String FORMAT_SLICE = "slice";
    public static final String FORMAT_TEXT = "text";
    public static final String FORMAT_IMAGE = "image";
    public static final String FORMAT_ACTION = "action";
    public static final String FORMAT_INT = "int";
    public static final String FORMAT_TIMESTAMP = "timestamp";
    public static final String FORMAT_REMOTE_INPUT = "input";
    public static final String FORMAT_BUNDLE = "bundle";
    protected String[] mHints;
    private final String mFormat;
    private final String mSubType;
    private final Object mObj;
    public static final Parcelable.Creator<SliceItem> CREATOR = new Parcelable.Creator<SliceItem>(){

        @Override
        public SliceItem createFromParcel(Parcel in) {
            return new SliceItem(in);
        }

        public SliceItem[] newArray(int size) {
            return new SliceItem[size];
        }
    };

    public SliceItem(Object obj, String format, String subType, String[] hints) {
        this.mHints = hints;
        this.mFormat = format;
        this.mSubType = subType;
        this.mObj = obj;
    }

    public SliceItem(PendingIntent intent, Slice slice, String format, String subType, String[] hints) {
        this(new Pair<PendingIntent, Slice>(intent, slice), format, subType, hints);
    }

    public List<String> getHints() {
        return Arrays.asList(this.mHints);
    }

    public String getFormat() {
        return this.mFormat;
    }

    public String getSubType() {
        return this.mSubType;
    }

    public CharSequence getText() {
        return (CharSequence)this.mObj;
    }

    public Bundle getBundle() {
        return (Bundle)this.mObj;
    }

    public Icon getIcon() {
        return (Icon)this.mObj;
    }

    public PendingIntent getAction() {
        return (PendingIntent)((Pair)this.mObj).first;
    }

    public RemoteViews getRemoteView() {
        return (RemoteViews)this.mObj;
    }

    public RemoteInput getRemoteInput() {
        return (RemoteInput)this.mObj;
    }

    public int getInt() {
        return (Integer)this.mObj;
    }

    public Slice getSlice() {
        if (FORMAT_ACTION.equals(this.getFormat())) {
            return (Slice)((Pair)this.mObj).second;
        }
        return (Slice)this.mObj;
    }

    public long getTimestamp() {
        return (Long)this.mObj;
    }

    public boolean hasHint(String hint) {
        return ArrayUtils.contains(this.mHints, hint);
    }

    public SliceItem(Parcel in) {
        this.mHints = in.readStringArray();
        this.mFormat = in.readString();
        this.mSubType = in.readString();
        this.mObj = SliceItem.readObj(this.mFormat, in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(this.mHints);
        dest.writeString(this.mFormat);
        dest.writeString(this.mSubType);
        SliceItem.writeObj(dest, flags, this.mObj, this.mFormat);
    }

    public boolean hasHints(String[] hints) {
        if (hints == null) {
            return true;
        }
        for (String hint : hints) {
            if (TextUtils.isEmpty(hint) || ArrayUtils.contains(this.mHints, hint)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyHints(String[] hints) {
        if (hints == null) {
            return false;
        }
        for (String hint : hints) {
            if (!ArrayUtils.contains(this.mHints, hint)) continue;
            return true;
        }
        return false;
    }

    private static String getBaseType(String type) {
        int index = type.indexOf(47);
        if (index >= 0) {
            return type.substring(0, index);
        }
        return type;
    }

    private static void writeObj(Parcel dest, int flags, Object obj, String type) {
        switch (SliceItem.getBaseType(type)) {
            case "slice": 
            case "image": 
            case "input": 
            case "bundle": {
                ((Parcelable)obj).writeToParcel(dest, flags);
                break;
            }
            case "action": {
                ((PendingIntent)((Pair)obj).first).writeToParcel(dest, flags);
                ((Slice)((Pair)obj).second).writeToParcel(dest, flags);
                break;
            }
            case "text": {
                TextUtils.writeToParcel((CharSequence)obj, dest, flags);
                break;
            }
            case "int": {
                dest.writeInt((Integer)obj);
                break;
            }
            case "timestamp": {
                dest.writeLong((Long)obj);
            }
        }
    }

    private static Object readObj(String type, Parcel in) {
        switch (SliceItem.getBaseType(type)) {
            case "slice": {
                return Slice.CREATOR.createFromParcel(in);
            }
            case "text": {
                return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
            case "image": {
                return Icon.CREATOR.createFromParcel(in);
            }
            case "action": {
                return new Pair<PendingIntent, Slice>(PendingIntent.CREATOR.createFromParcel(in), Slice.CREATOR.createFromParcel(in));
            }
            case "int": {
                return in.readInt();
            }
            case "timestamp": {
                return in.readLong();
            }
            case "input": {
                return RemoteInput.CREATOR.createFromParcel(in);
            }
            case "bundle": {
                return Bundle.CREATOR.createFromParcel(in);
            }
        }
        throw new RuntimeException("Unsupported type " + type);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SliceType {
    }
}

