/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.slice.ISliceListener;
import android.app.slice.ISliceManager;
import android.app.slice.Slice;
import android.app.slice.SliceSpec;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public class SliceManager {
    private static final String TAG = "SliceManager";
    public static final String ACTION_REQUEST_SLICE_PERMISSION = "android.intent.action.REQUEST_SLICE_PERMISSION";
    private final ISliceManager mService;
    private final Context mContext;
    private final ArrayMap<Pair<Uri, SliceCallback>, ISliceListener> mListenerLookup = new ArrayMap();
    public static final int PERMISSION_DENIED = -1;
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_USER_GRANTED = 1;

    public SliceManager(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = ISliceManager.Stub.asInterface(ServiceManager.getServiceOrThrow("slice"));
    }

    @Deprecated
    public void registerSliceCallback(Uri uri, SliceCallback callback, List<SliceSpec> specs) {
        this.registerSliceCallback(uri, specs, this.mContext.getMainExecutor(), callback);
    }

    @Deprecated
    public void registerSliceCallback(Uri uri, SliceCallback callback, List<SliceSpec> specs, Executor executor) {
        this.registerSliceCallback(uri, specs, executor, callback);
    }

    public void registerSliceCallback(Uri uri, List<SliceSpec> specs, SliceCallback callback) {
        this.registerSliceCallback(uri, specs, this.mContext.getMainExecutor(), callback);
    }

    public void registerSliceCallback(Uri uri, List<SliceSpec> specs, final Executor executor, final SliceCallback callback) {
        try {
            this.mService.addSliceListener(uri, this.mContext.getPackageName(), this.getListener(uri, callback, new ISliceListener.Stub(){

                @Override
                public void onSliceUpdated(Slice s) throws RemoteException {
                    executor.execute(() -> callback.onSliceUpdated(s));
                }
            }), specs.toArray(new SliceSpec[specs.size()]));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private ISliceListener getListener(Uri uri, SliceCallback callback, ISliceListener listener) {
        Pair<Uri, SliceCallback> key = new Pair<Uri, SliceCallback>(uri, callback);
        if (this.mListenerLookup.containsKey(key)) {
            try {
                this.mService.removeSliceListener(uri, this.mContext.getPackageName(), this.mListenerLookup.get(key));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.mListenerLookup.put(key, listener);
        return listener;
    }

    public void unregisterSliceCallback(Uri uri, SliceCallback callback) {
        try {
            this.mService.removeSliceListener(uri, this.mContext.getPackageName(), this.mListenerLookup.remove(new Pair<Uri, SliceCallback>(uri, callback)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void pinSlice(Uri uri, List<SliceSpec> specs) {
        try {
            this.mService.pinSlice(this.mContext.getPackageName(), uri, specs.toArray(new SliceSpec[specs.size()]));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unpinSlice(Uri uri) {
        try {
            this.mService.unpinSlice(this.mContext.getPackageName(), uri);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasSliceAccess() {
        try {
            return this.mService.hasSliceAccess(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SliceSpec> getPinnedSpecs(Uri uri) {
        try {
            return Arrays.asList(this.mService.getPinnedSpecs(uri, this.mContext.getPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Collection<Uri> getSliceDescendants(Uri uri) {
        ArrayList<Uri> arrayList;
        block8: {
            ContentResolver resolver = this.mContext.getContentResolver();
            ContentProviderClient provider = resolver.acquireContentProviderClient(uri);
            Throwable throwable = null;
            try {
                Bundle extras = new Bundle();
                extras.putParcelable("slice_uri", uri);
                Bundle res = provider.call("get_descendants", null, extras);
                arrayList = res.getParcelableArrayList("slice_descendants");
                if (provider == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (provider != null) {
                            SliceManager.$closeResource(throwable, provider);
                        }
                        throw throwable3;
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to get slice descendants", e);
                    return Collections.emptyList();
                }
            }
            SliceManager.$closeResource(throwable, provider);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Slice bindSlice(Uri uri, List<SliceSpec> supportedSpecs) {
        Preconditions.checkNotNull(uri, "uri");
        ContentResolver resolver = this.mContext.getContentResolver();
        try (ContentProviderClient provider = resolver.acquireContentProviderClient(uri);){
            if (provider == null) {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_uri", uri);
            extras.putParcelableArrayList("supported_specs", new ArrayList<SliceSpec>(supportedSpecs));
            Bundle res = provider.call("bind_slice", null, extras);
            Bundle.setDefusable(res, true);
            if (res == null) {
                Slice slice2 = null;
                return slice2;
            }
            Slice slice = (Slice)res.getParcelable("slice");
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Uri mapIntentToUri(Intent intent) {
        Preconditions.checkNotNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null, "Slice intent must be explicit %s", intent);
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri intentData = intent.getData();
        if (intentData != null && "vnd.android.slice".equals(resolver.getType(intentData))) {
            return intentData;
        }
        List<ResolveInfo> providers = this.mContext.getPackageManager().queryIntentContentProviders(intent, 0);
        if (providers == null) throw new IllegalArgumentException("Unable to resolve intent " + intent);
        if (providers.isEmpty()) {
            throw new IllegalArgumentException("Unable to resolve intent " + intent);
        }
        String authority = providers.get((int)0).providerInfo.authority;
        Uri uri3 = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireContentProviderClient(uri3);){
            if (provider == null) {
                throw new IllegalArgumentException("Unknown URI " + uri3);
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            Bundle res = provider.call("map_only", null, extras);
            if (res == null) {
                Uri uri2 = null;
                return uri2;
            }
            Uri uri = (Uri)res.getParcelable("slice");
            return uri;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Slice bindSlice(Intent intent, List<SliceSpec> supportedSpecs) {
        Preconditions.checkNotNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null, "Slice intent must be explicit %s", intent);
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri intentData = intent.getData();
        if (intentData != null && "vnd.android.slice".equals(resolver.getType(intentData))) {
            return this.bindSlice(intentData, supportedSpecs);
        }
        List<ResolveInfo> providers = this.mContext.getPackageManager().queryIntentContentProviders(intent, 0);
        if (providers == null) throw new IllegalArgumentException("Unable to resolve intent " + intent);
        if (providers.isEmpty()) {
            throw new IllegalArgumentException("Unable to resolve intent " + intent);
        }
        String authority = providers.get((int)0).providerInfo.authority;
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireContentProviderClient(uri);){
            if (provider == null) {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            extras.putParcelableArrayList("supported_specs", new ArrayList<SliceSpec>(supportedSpecs));
            Bundle res = provider.call("map_slice", null, extras);
            if (res == null) {
                Slice slice2 = null;
                return slice2;
            }
            Slice slice = (Slice)res.getParcelable("slice");
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void enforceSlicePermission(Uri uri, String pkg, int pid, int uid) {
        try {
            if (pkg == null) {
                throw new SecurityException("No pkg specified");
            }
            int result = this.mService.checkSlicePermission(uri, pkg, pid, uid);
            if (result == -1) {
                throw new SecurityException("User " + uid + " does not have slice permission for " + uri + ".");
            }
            if (result == 1) {
                this.mContext.grantUriPermission(pkg, uri.buildUpon().path("").build(), 194);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void grantPermissionFromUser(Uri uri, String pkg, boolean allSlices) {
        try {
            this.mService.grantPermissionFromUser(uri, pkg, this.mContext.getPackageName(), allSlices);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface SliceCallback {
        public void onSliceUpdated(Slice var1);
    }
}

