/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.PendingIntent;
import android.app.slice.Slice;
import android.app.slice.SliceManager;
import android.app.slice.SliceSpec;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.StrictMode;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public abstract class SliceProvider
extends ContentProvider {
    public static final String SLICE_TYPE = "vnd.android.slice";
    private static final String TAG = "SliceProvider";
    public static final String EXTRA_BIND_URI = "slice_uri";
    public static final String EXTRA_SUPPORTED_SPECS = "supported_specs";
    public static final String METHOD_SLICE = "bind_slice";
    public static final String METHOD_MAP_INTENT = "map_slice";
    public static final String METHOD_MAP_ONLY_INTENT = "map_only";
    public static final String METHOD_PIN = "pin";
    public static final String METHOD_UNPIN = "unpin";
    public static final String METHOD_GET_DESCENDANTS = "get_descendants";
    public static final String EXTRA_INTENT = "slice_intent";
    public static final String EXTRA_SLICE = "slice";
    public static final String EXTRA_SLICE_DESCENDANTS = "slice_descendants";
    public static final String EXTRA_PKG = "pkg";
    public static final String EXTRA_PROVIDER_PKG = "provider_pkg";
    public static final String EXTRA_OVERRIDE_PKG = "override_pkg";
    public static final String EXTRA_OVERRIDE_UID = "override_uid";
    public static final String EXTRA_OVERRIDE_PID = "override_pid";
    private static final boolean DEBUG = false;
    private String mBindingPkg;
    private SliceManager mSliceManager;

    public final String getBindingPackage() {
        return this.mBindingPkg;
    }

    @Override
    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        this.mSliceManager = context.getSystemService(SliceManager.class);
    }

    public Slice onBindSlice(Uri sliceUri, List<SliceSpec> supportedSpecs) {
        return null;
    }

    public void onSlicePinned(Uri sliceUri) {
    }

    public void onSliceUnpinned(Uri sliceUri) {
    }

    public Collection<Uri> onGetSliceDescendants(Uri uri) {
        return Collections.emptyList();
    }

    public Uri onMapIntentToUri(Intent intent) {
        throw new UnsupportedOperationException("This provider has not implemented intent to uri mapping");
    }

    @Override
    public final int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public final int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        return null;
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        return null;
    }

    @Override
    public final Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public final String getType(Uri uri) {
        return SLICE_TYPE;
    }

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        if (method.equals(METHOD_SLICE)) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
            ArrayList<SliceSpec> supportedSpecs = extras.getParcelableArrayList(EXTRA_SUPPORTED_SPECS);
            String callingPackage = this.getCallingPackage();
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            if (extras.containsKey(EXTRA_OVERRIDE_PKG)) {
                if (Binder.getCallingUid() != 1000) {
                    throw new SecurityException("Only the system can override calling pkg");
                }
                callingPackage = extras.getString(EXTRA_OVERRIDE_PKG);
                callingUid = extras.getInt(EXTRA_OVERRIDE_UID);
                callingPid = extras.getInt(EXTRA_OVERRIDE_PID);
            }
            Slice s = this.handleBindSlice(uri, supportedSpecs, callingPackage, callingUid, callingPid);
            Bundle b = new Bundle();
            b.putParcelable(EXTRA_SLICE, s);
            return b;
        }
        if (method.equals(METHOD_MAP_INTENT)) {
            Intent intent = (Intent)extras.getParcelable(EXTRA_INTENT);
            if (intent == null) {
                return null;
            }
            Uri uri = this.onMapIntentToUri(intent);
            ArrayList<SliceSpec> supportedSpecs = extras.getParcelableArrayList(EXTRA_SUPPORTED_SPECS);
            Bundle b = new Bundle();
            if (uri != null) {
                Slice s = this.handleBindSlice(uri, supportedSpecs, this.getCallingPackage(), Binder.getCallingUid(), Binder.getCallingPid());
                b.putParcelable(EXTRA_SLICE, s);
            } else {
                b.putParcelable(EXTRA_SLICE, null);
            }
            return b;
        }
        if (method.equals(METHOD_MAP_ONLY_INTENT)) {
            Intent intent = (Intent)extras.getParcelable(EXTRA_INTENT);
            if (intent == null) {
                return null;
            }
            Uri uri = this.onMapIntentToUri(intent);
            Bundle b = new Bundle();
            b.putParcelable(EXTRA_SLICE, uri);
            return b;
        }
        if (method.equals(METHOD_PIN)) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can pin/unpin slices");
            }
            this.handlePinSlice(uri);
        } else if (method.equals(METHOD_UNPIN)) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can pin/unpin slices");
            }
            this.handleUnpinSlice(uri);
        } else if (method.equals(METHOD_GET_DESCENDANTS)) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
            Bundle b = new Bundle();
            b.putParcelableArrayList(EXTRA_SLICE_DESCENDANTS, new ArrayList<Uri>(this.handleGetDescendants(uri)));
            return b;
        }
        return super.call(method, arg, extras);
    }

    private Collection<Uri> handleGetDescendants(Uri uri) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            return this.onGetSliceDescendants(uri);
        }
        CountDownLatch latch = new CountDownLatch(1);
        Collection[] output = new Collection[1];
        Handler.getMain().post(() -> {
            output[0] = this.onGetSliceDescendants(uri);
            latch.countDown();
        });
        try {
            latch.await();
            return output[0];
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void handlePinSlice(Uri sliceUri) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onSlicePinned(sliceUri);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            Handler.getMain().post(() -> {
                this.onSlicePinned(sliceUri);
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void handleUnpinSlice(Uri sliceUri) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onSliceUnpinned(sliceUri);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            Handler.getMain().post(() -> {
                this.onSliceUnpinned(sliceUri);
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Slice handleBindSlice(Uri sliceUri, List<SliceSpec> supportedSpecs, String callingPkg, int callingUid, int callingPid) {
        String pkg;
        String string2 = pkg = callingPkg != null ? callingPkg : this.getContext().getPackageManager().getNameForUid(callingUid);
        if (!UserHandle.isSameApp(callingUid, Process.myUid())) {
            try {
                this.mSliceManager.enforceSlicePermission(sliceUri, pkg, callingPid, callingUid);
            }
            catch (SecurityException e) {
                return SliceProvider.createPermissionSlice(this.getContext(), sliceUri, pkg);
            }
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            return this.onBindSliceStrict(sliceUri, supportedSpecs, pkg);
        }
        CountDownLatch latch = new CountDownLatch(1);
        Slice[] output = new Slice[1];
        Handler.getMain().post(() -> {
            output[0] = this.onBindSliceStrict(sliceUri, supportedSpecs, pkg);
            latch.countDown();
        });
        try {
            latch.await();
            return output[0];
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Slice createPermissionSlice(Context context, Uri sliceUri, String callingPackage) {
        return new Slice.Builder(sliceUri).addAction(SliceProvider.createPermissionIntent(context, sliceUri, callingPackage), new Slice.Builder(sliceUri.buildUpon().appendPath("permission").build()).addText(SliceProvider.getPermissionString(context, callingPackage), null, new String[0]).build()).addHints("list_item").build();
    }

    public static PendingIntent createPermissionIntent(Context context, Uri sliceUri, String callingPackage) {
        Intent intent = new Intent("android.intent.action.REQUEST_SLICE_PERMISSION");
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SlicePermissionActivity"));
        intent.putExtra(EXTRA_BIND_URI, sliceUri);
        intent.putExtra(EXTRA_PKG, callingPackage);
        intent.putExtra(EXTRA_PROVIDER_PKG, context.getPackageName());
        intent.setData(sliceUri.buildUpon().appendQueryParameter("package", callingPackage).build());
        return PendingIntent.getActivity(context, 0, intent, 0);
    }

    public static CharSequence getPermissionString(Context context, String callingPackage) {
        PackageManager pm = context.getPackageManager();
        try {
            return context.getString(17040846, pm.getApplicationInfo(callingPackage, 0).loadLabel(pm), context.getApplicationInfo().loadLabel(pm));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unknown calling app", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slice onBindSliceStrict(Uri sliceUri, List<SliceSpec> supportedSpecs, String callingPackage) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        try {
            StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder().detectAll().penaltyDeath().build());
            this.mBindingPkg = callingPackage;
            Slice slice = this.onBindSlice(sliceUri, supportedSpecs);
            return slice;
        }
        finally {
            this.mBindingPkg = null;
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }
}

