/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.content.Context;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.IntArray;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class NetworkStats
implements AutoCloseable {
    private static final String TAG = "NetworkStats";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final long mStartTimeStamp;
    private final long mEndTimeStamp;
    private int[] mUids;
    private int mUidOrUidIndex;
    private int mTag = 0;
    private INetworkStatsSession mSession;
    private NetworkTemplate mTemplate;
    private android.net.NetworkStats mSummary = null;
    private NetworkStatsHistory mHistory = null;
    private int mEnumerationIndex = 0;
    private NetworkStats.Entry mRecycledSummaryEntry = null;
    private NetworkStatsHistory.Entry mRecycledHistoryEntry = null;

    NetworkStats(Context context, NetworkTemplate template, int flags, long startTimestamp, long endTimestamp) throws RemoteException, SecurityException {
        INetworkStatsService statsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        this.mSession = statsService.openSessionForUsageStats(flags, context.getOpPackageName());
        this.mCloseGuard.open("close");
        this.mTemplate = template;
        this.mStartTimeStamp = startTimestamp;
        this.mEndTimeStamp = endTimestamp;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public boolean getNextBucket(Bucket bucketOut) {
        if (this.mSummary != null) {
            return this.getNextSummaryBucket(bucketOut);
        }
        return this.getNextHistoryBucket(bucketOut);
    }

    public boolean hasNextBucket() {
        if (this.mSummary != null) {
            return this.mEnumerationIndex < this.mSummary.size();
        }
        if (this.mHistory != null) {
            return this.mEnumerationIndex < this.mHistory.size() || this.hasNextUid();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.mSession != null) {
            try {
                this.mSession.close();
            }
            catch (RemoteException e) {
                Log.w(TAG, e);
            }
        }
        this.mSession = null;
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
    }

    Bucket getDeviceSummaryForNetwork() throws RemoteException {
        this.mSummary = this.mSession.getDeviceSummaryForNetwork(this.mTemplate, this.mStartTimeStamp, this.mEndTimeStamp);
        this.mEnumerationIndex = this.mSummary.size();
        return this.getSummaryAggregate();
    }

    void startSummaryEnumeration() throws RemoteException {
        this.mSummary = this.mSession.getSummaryForAllUid(this.mTemplate, this.mStartTimeStamp, this.mEndTimeStamp, false);
        this.mEnumerationIndex = 0;
    }

    void startHistoryEnumeration(int uid) {
        this.startHistoryEnumeration(uid, 0);
    }

    void startHistoryEnumeration(int uid, int tag) {
        this.mHistory = null;
        try {
            this.mHistory = this.mSession.getHistoryIntervalForUid(this.mTemplate, uid, -1, tag, -1, this.mStartTimeStamp, this.mEndTimeStamp);
            this.setSingleUidTag(uid, tag);
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
        this.mEnumerationIndex = 0;
    }

    void startUserUidEnumeration() throws RemoteException {
        int[] uids = this.mSession.getRelevantUids();
        IntArray filteredUids = new IntArray(uids.length);
        for (int uid : uids) {
            try {
                NetworkStatsHistory history = this.mSession.getHistoryIntervalForUid(this.mTemplate, uid, -1, 0, -1, this.mStartTimeStamp, this.mEndTimeStamp);
                if (history == null || history.size() <= 0) continue;
                filteredUids.add(uid);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error while getting history of uid " + uid, e);
            }
        }
        this.mUids = filteredUids.toArray();
        this.mUidOrUidIndex = -1;
        this.stepHistory();
    }

    private void stepHistory() {
        if (this.hasNextUid()) {
            this.stepUid();
            this.mHistory = null;
            try {
                this.mHistory = this.mSession.getHistoryIntervalForUid(this.mTemplate, this.getUid(), -1, 0, -1, this.mStartTimeStamp, this.mEndTimeStamp);
            }
            catch (RemoteException e) {
                Log.w(TAG, e);
            }
            this.mEnumerationIndex = 0;
        }
    }

    private void fillBucketFromSummaryEntry(Bucket bucketOut) {
        bucketOut.mUid = Bucket.convertUid(this.mRecycledSummaryEntry.uid);
        bucketOut.mTag = Bucket.convertTag(this.mRecycledSummaryEntry.tag);
        bucketOut.mState = Bucket.convertState(this.mRecycledSummaryEntry.set);
        bucketOut.mDefaultNetwork = Bucket.convertDefaultNetwork(this.mRecycledSummaryEntry.defaultNetwork);
        bucketOut.mMetered = Bucket.convertMetered(this.mRecycledSummaryEntry.metered);
        bucketOut.mRoaming = Bucket.convertRoaming(this.mRecycledSummaryEntry.roaming);
        bucketOut.mBeginTimeStamp = this.mStartTimeStamp;
        bucketOut.mEndTimeStamp = this.mEndTimeStamp;
        bucketOut.mRxBytes = this.mRecycledSummaryEntry.rxBytes;
        bucketOut.mRxPackets = this.mRecycledSummaryEntry.rxPackets;
        bucketOut.mTxBytes = this.mRecycledSummaryEntry.txBytes;
        bucketOut.mTxPackets = this.mRecycledSummaryEntry.txPackets;
    }

    private boolean getNextSummaryBucket(Bucket bucketOut) {
        if (bucketOut != null && this.mEnumerationIndex < this.mSummary.size()) {
            this.mRecycledSummaryEntry = this.mSummary.getValues(this.mEnumerationIndex++, this.mRecycledSummaryEntry);
            this.fillBucketFromSummaryEntry(bucketOut);
            return true;
        }
        return false;
    }

    Bucket getSummaryAggregate() {
        if (this.mSummary == null) {
            return null;
        }
        Bucket bucket = new Bucket();
        if (this.mRecycledSummaryEntry == null) {
            this.mRecycledSummaryEntry = new NetworkStats.Entry();
        }
        this.mSummary.getTotal(this.mRecycledSummaryEntry);
        this.fillBucketFromSummaryEntry(bucket);
        return bucket;
    }

    private boolean getNextHistoryBucket(Bucket bucketOut) {
        if (bucketOut != null && this.mHistory != null) {
            if (this.mEnumerationIndex < this.mHistory.size()) {
                this.mRecycledHistoryEntry = this.mHistory.getValues(this.mEnumerationIndex++, this.mRecycledHistoryEntry);
                bucketOut.mUid = Bucket.convertUid(this.getUid());
                bucketOut.mTag = Bucket.convertTag(this.mTag);
                bucketOut.mState = -1;
                bucketOut.mDefaultNetwork = -1;
                bucketOut.mMetered = -1;
                bucketOut.mRoaming = -1;
                bucketOut.mBeginTimeStamp = this.mRecycledHistoryEntry.bucketStart;
                bucketOut.mEndTimeStamp = this.mRecycledHistoryEntry.bucketStart + this.mRecycledHistoryEntry.bucketDuration;
                bucketOut.mRxBytes = this.mRecycledHistoryEntry.rxBytes;
                bucketOut.mRxPackets = this.mRecycledHistoryEntry.rxPackets;
                bucketOut.mTxBytes = this.mRecycledHistoryEntry.txBytes;
                bucketOut.mTxPackets = this.mRecycledHistoryEntry.txPackets;
                return true;
            }
            if (this.hasNextUid()) {
                this.stepHistory();
                return this.getNextHistoryBucket(bucketOut);
            }
        }
        return false;
    }

    private boolean isUidEnumeration() {
        return this.mUids != null;
    }

    private boolean hasNextUid() {
        return this.isUidEnumeration() && this.mUidOrUidIndex + 1 < this.mUids.length;
    }

    private int getUid() {
        if (this.isUidEnumeration()) {
            if (this.mUidOrUidIndex < 0 || this.mUidOrUidIndex >= this.mUids.length) {
                throw new IndexOutOfBoundsException("Index=" + this.mUidOrUidIndex + " mUids.length=" + this.mUids.length);
            }
            return this.mUids[this.mUidOrUidIndex];
        }
        return this.mUidOrUidIndex;
    }

    private void setSingleUidTag(int uid, int tag) {
        this.mUidOrUidIndex = uid;
        this.mTag = tag;
    }

    private void stepUid() {
        if (this.mUids != null) {
            ++this.mUidOrUidIndex;
        }
    }

    public static class Bucket {
        public static final int STATE_ALL = -1;
        public static final int STATE_DEFAULT = 1;
        public static final int STATE_FOREGROUND = 2;
        public static final int UID_ALL = -1;
        public static final int UID_REMOVED = -4;
        public static final int UID_TETHERING = -5;
        public static final int METERED_ALL = -1;
        public static final int METERED_NO = 1;
        public static final int METERED_YES = 2;
        public static final int ROAMING_ALL = -1;
        public static final int ROAMING_NO = 1;
        public static final int ROAMING_YES = 2;
        public static final int DEFAULT_NETWORK_ALL = -1;
        public static final int DEFAULT_NETWORK_NO = 1;
        public static final int DEFAULT_NETWORK_YES = 2;
        public static final int TAG_NONE = 0;
        private int mUid;
        private int mTag;
        private int mState;
        private int mDefaultNetwork;
        private int mMetered;
        private int mRoaming;
        private long mBeginTimeStamp;
        private long mEndTimeStamp;
        private long mRxBytes;
        private long mRxPackets;
        private long mTxBytes;
        private long mTxPackets;

        private static int convertState(int networkStatsSet) {
            switch (networkStatsSet) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        private static int convertUid(int uid) {
            switch (uid) {
                case -4: {
                    return -4;
                }
                case -5: {
                    return -5;
                }
            }
            return uid;
        }

        private static int convertTag(int tag) {
            switch (tag) {
                case 0: {
                    return 0;
                }
            }
            return tag;
        }

        private static int convertMetered(int metered) {
            switch (metered) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        private static int convertRoaming(int roaming) {
            switch (roaming) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        private static int convertDefaultNetwork(int defaultNetwork) {
            switch (defaultNetwork) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        public int getUid() {
            return this.mUid;
        }

        public int getTag() {
            return this.mTag;
        }

        public int getState() {
            return this.mState;
        }

        public int getMetered() {
            return this.mMetered;
        }

        public int getRoaming() {
            return this.mRoaming;
        }

        public int getDefaultNetwork() {
            return this.mDefaultNetwork;
        }

        public long getStartTimeStamp() {
            return this.mBeginTimeStamp;
        }

        public long getEndTimeStamp() {
            return this.mEndTimeStamp;
        }

        public long getRxBytes() {
            return this.mRxBytes;
        }

        public long getTxBytes() {
            return this.mTxBytes;
        }

        public long getRxPackets() {
            return this.mRxPackets;
        }

        public long getTxPackets() {
            return this.mTxPackets;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DefaultNetwork {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Roaming {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Metered {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }
    }
}

