/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.NetworkStats;
import android.content.Context;
import android.net.DataUsageRequest;
import android.net.INetworkStatsService;
import android.net.NetworkIdentity;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.Preconditions;

public class NetworkStatsManager {
    private static final String TAG = "NetworkStatsManager";
    private static final boolean DBG = false;
    public static final int CALLBACK_LIMIT_REACHED = 0;
    public static final int CALLBACK_RELEASED = 1;
    private final Context mContext;
    private final INetworkStatsService mService;
    public static final int FLAG_POLL_ON_OPEN = 1;
    public static final int FLAG_AUGMENT_WITH_SUBSCRIPTION_PLAN = 2;
    private int mFlags;

    public NetworkStatsManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = INetworkStatsService.Stub.asInterface(ServiceManager.getServiceOrThrow("netstats"));
        this.setPollOnOpen(true);
    }

    public void setPollOnOpen(boolean pollOnOpen) {
        this.mFlags = pollOnOpen ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    public void setAugmentWithSubscriptionPlan(boolean augmentWithSubscriptionPlan) {
        this.mFlags = augmentWithSubscriptionPlan ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
    }

    public NetworkStats.Bucket querySummaryForDevice(NetworkTemplate template, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkStats.Bucket bucket = null;
        NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime);
        bucket = stats.getDeviceSummaryForNetwork();
        stats.close();
        return bucket;
    }

    public NetworkStats.Bucket querySummaryForDevice(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.querySummaryForDevice(template, startTime, endTime);
    }

    public NetworkStats.Bucket querySummaryForUser(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime);
        stats.startSummaryEnumeration();
        stats.close();
        return stats.getSummaryAggregate();
    }

    public NetworkStats querySummary(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime);
        result.startSummaryEnumeration();
        return result;
    }

    public NetworkStats queryDetailsForUid(int networkType, String subscriberId, long startTime, long endTime, int uid) throws SecurityException, RemoteException {
        return this.queryDetailsForUidTag(networkType, subscriberId, startTime, endTime, uid, 0);
    }

    public NetworkStats queryDetailsForUidTag(int networkType, String subscriberId, long startTime, long endTime, int uid, int tag) throws SecurityException {
        NetworkStats result;
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        try {
            result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime);
            result.startHistoryEnumeration(uid, tag);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error while querying stats for uid=" + uid + " tag=" + tag, e);
            return null;
        }
        return result;
    }

    public NetworkStats queryDetails(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime);
        result.startUserUidEnumeration();
        return result;
    }

    public void registerUsageCallback(NetworkTemplate template, int networkType, long thresholdBytes, UsageCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback, "UsageCallback cannot be null");
        Looper looper = handler == null ? Looper.myLooper() : handler.getLooper();
        DataUsageRequest request = new DataUsageRequest(0, template, thresholdBytes);
        try {
            CallbackHandler callbackHandler = new CallbackHandler(looper, networkType, template.getSubscriberId(), callback);
            callback.request = this.mService.registerUsageCallback(this.mContext.getOpPackageName(), request, new Messenger(callbackHandler), new Binder());
            if (callback.request == null) {
                Log.e(TAG, "Request from callback is null; should not happen");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback) {
        this.registerUsageCallback(networkType, subscriberId, thresholdBytes, callback, null);
    }

    public void registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback, Handler handler) {
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        this.registerUsageCallback(template, networkType, thresholdBytes, callback, handler);
    }

    public void unregisterUsageCallback(UsageCallback callback) {
        if (callback == null || callback.request == null || ((UsageCallback)callback).request.requestId == 0) {
            throw new IllegalArgumentException("Invalid UsageCallback");
        }
        try {
            this.mService.unregisterUsageRequest(callback.request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static NetworkTemplate createTemplate(int networkType, String subscriberId) {
        NetworkTemplate template = null;
        switch (networkType) {
            case 0: {
                template = NetworkTemplate.buildTemplateMobileAll(subscriberId);
                break;
            }
            case 1: {
                template = NetworkTemplate.buildTemplateWifiWildcard();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create template for network type " + networkType + ", subscriberId '" + NetworkIdentity.scrubSubscriberId(subscriberId) + "'.");
            }
        }
        return template;
    }

    private static class CallbackHandler
    extends Handler {
        private final int mNetworkType;
        private final String mSubscriberId;
        private UsageCallback mCallback;

        CallbackHandler(Looper looper, int networkType, String subscriberId, UsageCallback callback) {
            super(looper);
            this.mNetworkType = networkType;
            this.mSubscriberId = subscriberId;
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message message) {
            DataUsageRequest request = (DataUsageRequest)CallbackHandler.getObject(message, "DataUsageRequest");
            switch (message.what) {
                case 0: {
                    if (this.mCallback != null) {
                        this.mCallback.onThresholdReached(this.mNetworkType, this.mSubscriberId);
                        break;
                    }
                    Log.e(NetworkStatsManager.TAG, "limit reached with released callback for " + request);
                    break;
                }
                case 1: {
                    this.mCallback = null;
                }
            }
        }

        private static Object getObject(Message msg, String key) {
            return msg.getData().getParcelable(key);
        }
    }

    public static abstract class UsageCallback {
        private DataUsageRequest request;

        public abstract void onThresholdReached(int var1, String var2);
    }
}

