/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;

public final class UsageStats
implements Parcelable {
    public String mPackageName;
    public long mBeginTimeStamp;
    public long mEndTimeStamp;
    public long mLastTimeUsed;
    public long mTotalTimeInForeground;
    public int mLaunchCount;
    public int mLastEvent;
    public ArrayMap<String, ArrayMap<String, Integer>> mChooserCounts;
    public static final Parcelable.Creator<UsageStats> CREATOR = new Parcelable.Creator<UsageStats>(){

        @Override
        public UsageStats createFromParcel(Parcel in) {
            UsageStats stats = new UsageStats();
            stats.mPackageName = in.readString();
            stats.mBeginTimeStamp = in.readLong();
            stats.mEndTimeStamp = in.readLong();
            stats.mLastTimeUsed = in.readLong();
            stats.mTotalTimeInForeground = in.readLong();
            stats.mLaunchCount = in.readInt();
            stats.mLastEvent = in.readInt();
            Bundle allCounts = in.readBundle();
            if (allCounts != null) {
                stats.mChooserCounts = new ArrayMap();
                for (String action : allCounts.keySet()) {
                    Bundle currentCounts;
                    if (!stats.mChooserCounts.containsKey(action)) {
                        ArrayMap newCounts = new ArrayMap();
                        stats.mChooserCounts.put(action, newCounts);
                    }
                    if ((currentCounts = allCounts.getBundle(action)) == null) continue;
                    for (String key : currentCounts.keySet()) {
                        int value = currentCounts.getInt(key);
                        if (value <= 0) continue;
                        stats.mChooserCounts.get(action).put(key, value);
                    }
                }
            }
            return stats;
        }

        public UsageStats[] newArray(int size) {
            return new UsageStats[size];
        }
    };

    public UsageStats() {
    }

    public UsageStats(UsageStats stats) {
        this.mPackageName = stats.mPackageName;
        this.mBeginTimeStamp = stats.mBeginTimeStamp;
        this.mEndTimeStamp = stats.mEndTimeStamp;
        this.mLastTimeUsed = stats.mLastTimeUsed;
        this.mTotalTimeInForeground = stats.mTotalTimeInForeground;
        this.mLaunchCount = stats.mLaunchCount;
        this.mLastEvent = stats.mLastEvent;
        this.mChooserCounts = stats.mChooserCounts;
    }

    public UsageStats getObfuscatedForInstantApp() {
        UsageStats ret = new UsageStats(this);
        ret.mPackageName = "android.instant_app";
        return ret;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public long getFirstTimeStamp() {
        return this.mBeginTimeStamp;
    }

    public long getLastTimeStamp() {
        return this.mEndTimeStamp;
    }

    public long getLastTimeUsed() {
        return this.mLastTimeUsed;
    }

    public long getTotalTimeInForeground() {
        return this.mTotalTimeInForeground;
    }

    public void add(UsageStats right) {
        if (!this.mPackageName.equals(right.mPackageName)) {
            throw new IllegalArgumentException("Can't merge UsageStats for package '" + this.mPackageName + "' with UsageStats for package '" + right.mPackageName + "'.");
        }
        if (right.mBeginTimeStamp > this.mBeginTimeStamp) {
            this.mLastEvent = Math.max(this.mLastEvent, right.mLastEvent);
            this.mLastTimeUsed = Math.max(this.mLastTimeUsed, right.mLastTimeUsed);
        }
        this.mBeginTimeStamp = Math.min(this.mBeginTimeStamp, right.mBeginTimeStamp);
        this.mEndTimeStamp = Math.max(this.mEndTimeStamp, right.mEndTimeStamp);
        this.mTotalTimeInForeground += right.mTotalTimeInForeground;
        this.mLaunchCount += right.mLaunchCount;
        if (this.mChooserCounts == null) {
            this.mChooserCounts = right.mChooserCounts;
        } else if (right.mChooserCounts != null) {
            int chooserCountsSize = right.mChooserCounts.size();
            for (int i = 0; i < chooserCountsSize; ++i) {
                String action = right.mChooserCounts.keyAt(i);
                ArrayMap<String, Integer> counts = right.mChooserCounts.valueAt(i);
                if (!this.mChooserCounts.containsKey(action) || this.mChooserCounts.get(action) == null) {
                    this.mChooserCounts.put(action, counts);
                    continue;
                }
                int annotationSize = counts.size();
                for (int j = 0; j < annotationSize; ++j) {
                    String key = counts.keyAt(j);
                    int rightValue = counts.valueAt(j);
                    int leftValue = this.mChooserCounts.get(action).getOrDefault(key, 0);
                    this.mChooserCounts.get(action).put(key, leftValue + rightValue);
                }
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mPackageName);
        dest.writeLong(this.mBeginTimeStamp);
        dest.writeLong(this.mEndTimeStamp);
        dest.writeLong(this.mLastTimeUsed);
        dest.writeLong(this.mTotalTimeInForeground);
        dest.writeInt(this.mLaunchCount);
        dest.writeInt(this.mLastEvent);
        Bundle allCounts = new Bundle();
        if (this.mChooserCounts != null) {
            int chooserCountSize = this.mChooserCounts.size();
            for (int i = 0; i < chooserCountSize; ++i) {
                String action = this.mChooserCounts.keyAt(i);
                ArrayMap<String, Integer> counts = this.mChooserCounts.valueAt(i);
                Bundle currentCounts = new Bundle();
                int annotationSize = counts.size();
                for (int j = 0; j < annotationSize; ++j) {
                    currentCounts.putInt(counts.keyAt(j), counts.valueAt(j));
                }
                allCounts.putBundle(action, currentCounts);
            }
        }
        dest.writeBundle(allCounts);
    }
}

