/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.SystemApi;
import android.app.usage.ConfigurationStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class UsageStatsManager {
    public static final int INTERVAL_DAILY = 0;
    public static final int INTERVAL_WEEKLY = 1;
    public static final int INTERVAL_MONTHLY = 2;
    public static final int INTERVAL_YEARLY = 3;
    public static final int INTERVAL_BEST = 4;
    public static final int INTERVAL_COUNT = 4;
    @SystemApi
    public static final int STANDBY_BUCKET_EXEMPTED = 5;
    public static final int STANDBY_BUCKET_ACTIVE = 10;
    public static final int STANDBY_BUCKET_WORKING_SET = 20;
    public static final int STANDBY_BUCKET_FREQUENT = 30;
    public static final int STANDBY_BUCKET_RARE = 40;
    @SystemApi
    public static final int STANDBY_BUCKET_NEVER = 50;
    public static final String REASON_DEFAULT = "default";
    public static final String REASON_TIMEOUT = "timeout";
    public static final String REASON_USAGE = "usage";
    public static final String REASON_FORCED = "forced";
    public static final String REASON_PREDICTED = "predicted";
    private static final UsageEvents sEmptyResults = new UsageEvents();
    private final Context mContext;
    private final IUsageStatsManager mService;

    public UsageStatsManager(Context context, IUsageStatsManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public List<UsageStats> queryUsageStats(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryUsageStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public List<ConfigurationStats> queryConfigurations(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryConfigurationStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public UsageEvents queryEvents(long beginTime, long endTime) {
        try {
            UsageEvents iter = this.mService.queryEvents(beginTime, endTime, this.mContext.getOpPackageName());
            if (iter != null) {
                return iter;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    public Map<String, UsageStats> queryAndAggregateUsageStats(long beginTime, long endTime) {
        List<UsageStats> stats = this.queryUsageStats(4, beginTime, endTime);
        if (stats.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayMap<String, UsageStats> aggregatedStats = new ArrayMap<String, UsageStats>();
        int statCount = stats.size();
        for (int i = 0; i < statCount; ++i) {
            UsageStats newStat = stats.get(i);
            UsageStats existingStat = aggregatedStats.get(newStat.getPackageName());
            if (existingStat == null) {
                aggregatedStats.put(newStat.mPackageName, newStat);
                continue;
            }
            existingStat.add(newStat);
        }
        return aggregatedStats;
    }

    public boolean isAppInactive(String packageName) {
        try {
            return this.mService.isAppInactive(packageName, this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setAppInactive(String packageName, boolean inactive) {
        try {
            this.mService.setAppInactive(packageName, inactive, this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getAppStandbyBucket() {
        try {
            return this.mService.getAppStandbyBucket(this.mContext.getOpPackageName(), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return 10;
        }
    }

    @SystemApi
    public int getAppStandbyBucket(String packageName) {
        try {
            return this.mService.getAppStandbyBucket(packageName, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return 10;
        }
    }

    @SystemApi
    public void setAppStandbyBucket(String packageName, int bucket) {
        try {
            this.mService.setAppStandbyBucket(packageName, bucket, this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    public Map<String, Integer> getAppStandbyBuckets() {
        try {
            return this.mService.getAppStandbyBuckets(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return Collections.EMPTY_MAP;
        }
    }

    @SystemApi
    public void setAppStandbyBuckets(Map<String, Integer> appBuckets) {
        try {
            this.mService.setAppStandbyBuckets(appBuckets, this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    public void whitelistAppTemporarily(String packageName, long duration, UserHandle user) {
        try {
            this.mService.whitelistAppTemporarily(packageName, duration, user.getIdentifier());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onCarrierPrivilegedAppsChanged() {
        try {
            this.mService.onCarrierPrivilegedAppsChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void reportChooserSelection(String packageName, int userId, String contentType, String[] annotations, String action) {
        try {
            this.mService.reportChooserSelection(packageName, userId, contentType, annotations, action);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StandbyBuckets {
    }
}

