/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;

public final class BluetoothHidDeviceAppQosSettings
implements Parcelable {
    public final int serviceType;
    public final int tokenRate;
    public final int tokenBucketSize;
    public final int peakBandwidth;
    public final int latency;
    public final int delayVariation;
    public static final int SERVICE_NO_TRAFFIC = 0;
    public static final int SERVICE_BEST_EFFORT = 1;
    public static final int SERVICE_GUARANTEED = 2;
    public static final int MAX = -1;
    public static final Parcelable.Creator<BluetoothHidDeviceAppQosSettings> CREATOR = new Parcelable.Creator<BluetoothHidDeviceAppQosSettings>(){

        @Override
        public BluetoothHidDeviceAppQosSettings createFromParcel(Parcel in) {
            return new BluetoothHidDeviceAppQosSettings(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }

        public BluetoothHidDeviceAppQosSettings[] newArray(int size) {
            return new BluetoothHidDeviceAppQosSettings[size];
        }
    };

    public BluetoothHidDeviceAppQosSettings(int serviceType, int tokenRate, int tokenBucketSize, int peakBandwidth, int latency, int delayVariation) {
        this.serviceType = serviceType;
        this.tokenRate = tokenRate;
        this.tokenBucketSize = tokenBucketSize;
        this.peakBandwidth = peakBandwidth;
        this.latency = latency;
        this.delayVariation = delayVariation;
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothHidDeviceAppQosSettings) {
            BluetoothHidDeviceAppQosSettings qos = (BluetoothHidDeviceAppQosSettings)o;
            return this.serviceType == qos.serviceType && this.tokenRate == qos.tokenRate && this.tokenBucketSize == qos.tokenBucketSize && this.peakBandwidth == qos.peakBandwidth && this.latency == qos.latency && this.delayVariation == qos.delayVariation;
        }
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.serviceType);
        out.writeInt(this.tokenRate);
        out.writeInt(this.tokenBucketSize);
        out.writeInt(this.peakBandwidth);
        out.writeInt(this.latency);
        out.writeInt(this.delayVariation);
    }

    public int[] toArray() {
        return new int[]{this.serviceType, this.tokenRate, this.tokenBucketSize, this.peakBandwidth, this.latency, this.delayVariation};
    }

    public static class Builder {
        private int mServiceType = 1;
        private int mTokenRate = 0;
        private int mTokenBucketSize = 0;
        private int mPeakBandwidth = 0;
        private int mLatency = -1;
        private int mDelayVariation = -1;

        public Builder serviceType(int val) {
            this.mServiceType = val;
            return this;
        }

        public Builder tokenRate(int val) {
            this.mTokenRate = val;
            return this;
        }

        public Builder tokenBucketSize(int val) {
            this.mTokenBucketSize = val;
            return this;
        }

        public Builder peakBandwidth(int val) {
            this.mPeakBandwidth = val;
            return this;
        }

        public Builder latency(int val) {
            this.mLatency = val;
            return this;
        }

        public Builder delayVariation(int val) {
            this.mDelayVariation = val;
            return this;
        }

        public BluetoothHidDeviceAppQosSettings build() {
            return new BluetoothHidDeviceAppQosSettings(this.mServiceType, this.mTokenRate, this.mTokenBucketSize, this.mPeakBandwidth, this.mLatency, this.mDelayVariation);
        }
    }
}

