/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanFilter;
import android.net.wifi.ScanResult;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class BluetoothDeviceFilterUtils {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "BluetoothDeviceFilterUtils";

    private BluetoothDeviceFilterUtils() {
    }

    static String patternToString(Pattern p) {
        return p == null ? null : p.pattern();
    }

    static Pattern patternFromString(String s) {
        return s == null ? null : Pattern.compile(s);
    }

    static boolean matches(ScanFilter filter, BluetoothDevice device) {
        boolean result = BluetoothDeviceFilterUtils.matchesAddress(filter.getDeviceAddress(), device) && BluetoothDeviceFilterUtils.matchesServiceUuid(filter.getServiceUuid(), filter.getServiceUuidMask(), device);
        return result;
    }

    static boolean matchesAddress(String deviceAddress, BluetoothDevice device) {
        boolean result = deviceAddress == null || device != null && deviceAddress.equals(device.getAddress());
        return result;
    }

    static boolean matchesServiceUuids(List<ParcelUuid> serviceUuids, List<ParcelUuid> serviceUuidMasks, BluetoothDevice device) {
        for (int i = 0; i < serviceUuids.size(); ++i) {
            ParcelUuid uuidMask;
            ParcelUuid uuid = serviceUuids.get(i);
            if (BluetoothDeviceFilterUtils.matchesServiceUuid(uuid, uuidMask = serviceUuidMasks.get(i), device)) continue;
            return false;
        }
        return true;
    }

    static boolean matchesServiceUuid(ParcelUuid serviceUuid, ParcelUuid serviceUuidMask, BluetoothDevice device) {
        boolean result = serviceUuid == null || ScanFilter.matchesServiceUuids(serviceUuid, serviceUuidMask, Arrays.asList(device.getUuids()));
        return result;
    }

    static boolean matchesName(Pattern namePattern, BluetoothDevice device) {
        String name;
        boolean result = namePattern == null ? true : (device == null ? false : (name = device.getName()) != null && namePattern.matcher(name).find());
        return result;
    }

    static boolean matchesName(Pattern namePattern, ScanResult device) {
        String name;
        boolean result = namePattern == null ? true : (device == null ? false : (name = device.SSID) != null && namePattern.matcher(name).find());
        return result;
    }

    private static void debugLogMatchResult(boolean result, BluetoothDevice device, Object criteria) {
        Log.i(LOG_TAG, BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(device) + (result ? " ~ " : " !~ ") + criteria);
    }

    private static void debugLogMatchResult(boolean result, ScanResult device, Object criteria) {
        Log.i(LOG_TAG, BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(device) + (result ? " ~ " : " !~ ") + criteria);
    }

    public static String getDeviceDisplayNameInternal(BluetoothDevice device) {
        return TextUtils.firstNotEmpty(device.getAliasName(), device.getAddress());
    }

    public static String getDeviceDisplayNameInternal(ScanResult device) {
        return TextUtils.firstNotEmpty(device.SSID, device.BSSID);
    }

    public static String getDeviceMacAddress(Parcelable device) {
        if (device instanceof BluetoothDevice) {
            return ((BluetoothDevice)device).getAddress();
        }
        if (device instanceof ScanResult) {
            return ((ScanResult)device).BSSID;
        }
        if (device instanceof android.bluetooth.le.ScanResult) {
            return BluetoothDeviceFilterUtils.getDeviceMacAddress(((android.bluetooth.le.ScanResult)device).getDevice());
        }
        throw new IllegalArgumentException("Unknown device type: " + device);
    }
}

