/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.SuppressLint;
import android.companion.BluetoothDeviceFilterUtils;
import android.companion.DeviceFilter;
import android.net.wifi.ScanResult;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import java.util.Objects;
import java.util.regex.Pattern;

public final class WifiDeviceFilter
implements DeviceFilter<ScanResult> {
    private final Pattern mNamePattern;
    public static final Parcelable.Creator<WifiDeviceFilter> CREATOR = new Parcelable.Creator<WifiDeviceFilter>(){

        @Override
        public WifiDeviceFilter createFromParcel(Parcel in) {
            return new WifiDeviceFilter(in);
        }

        public WifiDeviceFilter[] newArray(int size) {
            return new WifiDeviceFilter[size];
        }
    };

    private WifiDeviceFilter(Pattern namePattern) {
        this.mNamePattern = namePattern;
    }

    @SuppressLint(value={"ParcelClassLoader"})
    private WifiDeviceFilter(Parcel in) {
        this(BluetoothDeviceFilterUtils.patternFromString(in.readString()));
    }

    public Pattern getNamePattern() {
        return this.mNamePattern;
    }

    @Override
    public boolean matches(ScanResult device) {
        return BluetoothDeviceFilterUtils.matchesName(this.getNamePattern(), device);
    }

    @Override
    public String getDeviceDisplayName(ScanResult device) {
        return BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(device);
    }

    @Override
    public int getMediumType() {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WifiDeviceFilter that = (WifiDeviceFilter)o;
        return Objects.equals(this.mNamePattern, that.mNamePattern);
    }

    public int hashCode() {
        return Objects.hash(this.mNamePattern);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(BluetoothDeviceFilterUtils.patternToString(this.getNamePattern()));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final class Builder
    extends OneTimeUseBuilder<WifiDeviceFilter> {
        private Pattern mNamePattern;

        public Builder setNamePattern(Pattern regex) {
            this.checkNotUsed();
            this.mNamePattern = regex;
            return this;
        }

        @Override
        public WifiDeviceFilter build() {
            this.markUsed();
            return new WifiDeviceFilter(this.mNamePattern);
        }
    }
}

